<?php

namespace Drupal\openlayers\Plugin\OpenlayersStyle;

use Drupal\Component\Utility\Color;
use Drupal\Component\Utility\Rectangle;
use Drupal\Core\Form\FormStateInterface;
use Drupal\openlayers\OpenlayersConfigurablePluginBase;

/**
 * Defines the Fill style for Openlayers features.
 *
 * @OpenlayersStyle(
 *   id = "ol_style_fill",
 *   label = @Translation("Fill"),
 *   description = @Translation("Define the fill style for map features."),
 *   type = "style",
 *   ol_id = "Fill"
 * )
 */
class Fill extends OpenlayersConfigurablePluginBase {

  /**
   * {@inheritdoc}
   */
  public function getSummary() {
    $summary = [
      '#theme' => 'openlayers_style_summary',
      '#data' => $this->configuration,
    ];
    $summary += parent::getSummary();

    return $summary;
  }

  /**
   * {@inheritdoc}
   */
  public function defaultConfiguration() {
    return [
      'color' => NULL,
    ];
  }

  /**
   * {@inheritdoc}
   */
  public function buildConfigurationForm(array $form, FormStateInterface $form_state) {
    $form['color'] = [
      '#type' => 'textfield',
      '#default_value' => $this->configuration['color'],
      '#title' => t('Fill color'),
      //  TODO - improve description to recognise other valid color formats.
      '#description' => t('The color to be used for filling polygon features on the map. Use web-style hex colors (#FFFFFF for white, #000000 for black).'),
      '#size' => 20,
      '#maxlength' => 20,
      '#required' => FALSE,
    ];

    return $form;
  }

  /**
   * {@inheritdoc}
   */
  public function validateConfigurationForm(array &$form, FormStateInterface $form_state) {
/*
    if (!$form_state->isValueEmpty('color') && !Color::validateHex($form_state->getValue('color'))) {
      $form_state->setErrorByName('color', $this->t('Color must be a hexadecimal color value.'));
    }
*/
  }

  /**
   * {@inheritdoc}
   */
  public function submitConfigurationForm(array &$form, FormStateInterface $form_state) {
    parent::submitConfigurationForm($form, $form_state);

    $this->configuration['color'] = $form_state->getValue('color');
  }

}
