<?php

namespace Drupal\timefield\Plugin\Field\FieldFormatter;

use Drupal\Core\Field\FormatterBase;
use Drupal\Core\Field\FieldItemListInterface;
use Drupal\Core\Form\FormStateInterface;
use Drupal\Core\Template\Attribute;

/**
 * Plugin for the 'timefield_default_formatter' field formatter.
 *
 * @FieldFormatter(
 *  id = "timefield_default_formatter",
 *  label = @Translation("Timefield formatter"),
 *  field_types = {"timefield"}
 * )
 */
class TimeFieldDefaultFormatter extends FormatterBase {

  /**
   * {@inheritdoc}
   */
  public static function defaultSettings() {

    return [
      'display_format' => [
        'hour' => 'g',
        'minute' => 'i',
        'separator' => ':',
        'period' => 'a',
        'periodSeparator' => '',
      ],
    ] + parent::defaultSettings();
  }

  /**
   * {@inheritdoc}
   */
  public function settingsForm(array $form, FormStateInterface $form_state) {
    // @todo Change the autogenerated stub
    $element = parent::settingsForm($form, $form_state);
    $settings = $this->getSettings();
    $element += _timefield_display_format_form('display_format', "Individual Time Display Settings", $settings);
    return $element;
  }

  /**
   * {@inheritdoc}
   */
  public function settingsSummary() {
    // @todo Change the autogenerated stub
    $summary = parent::settingsSummary();
    $settings = $this->getSettings();
    $current_time = timefield_time_to_integer(date('g:ia', strtotime("now")));
    $summary[] = $this->t('Current Format: @format', [
      '@format' => timefield_integer_to_time($settings['display_format'], $current_time),
    ]);
    return $summary;
  }

  /**
   * {@inheritdoc}
   */
  public function viewElements(FieldItemListInterface $items, $langcode) {
    $settings = $this->getSettings();
    $field_settings = $this->getFieldSettings();
    $label_hidden = ($this->label == 'hidden');
    foreach ($items as $delta => $item) {
      $item = $items->get($delta);
      if (!empty($item->value)) {
        $value = $item->getValue('value');
        $value['value'] = trim(timefield_integer_to_time($settings['display_format'], $item->value));
        $value['value2'] = trim(timefield_integer_to_time($settings['display_format'], $item->value2));
        $days = isset($items[$delta]->value) ? _timefield_weekly_summary_days_map($items[$delta]) : [];
        $value['days'] = array_intersect_key(_timefield_weekly_summary_days(), array_filter($days));
        $item->setValue($value);
        $items->set($delta, $value);
      }
    }

    $element = [
      '#theme' => 'timefield_formatter',
      '#label' => $this->fieldDefinition->get('label'),
      '#label_display' => $this->label,
      '#label_hidden' => $label_hidden,
      '#items' => $items,
      '#settings' => $field_settings,
      '#format' => 'default',
      '#attributes' => new Attribute(
          [
            'class' => 'timefield',
          ]
      ),
    ];

    return $element;
  }

}
