(function ($) {
	/**
	 * Intial call to the parking.json and creating the parking facilities DOM elements
	 */
	$.ajax({
		url: '/sites/files/1/json/parking.json',
		cache: false,
		dataType: 'json',
		success: function (json) {
			$('#pagestats').empty();

			json.forEach(function (facility) {
				var item = $("<li>", { "class": "pagestats-item col-1-3" });
				item.append(getItemWrapper(facility));

				$('#pagestats').append(item);
			});
		}
	});

	/**
	 * Setting an interval to update the parking facilities DOM elements from parking.json
	 */
	setInterval(function () {
		$.ajax({
			url: '/sites/files/1/json/parking.json',
			cache: false,
			dataType: 'json',
			success: function (json) {
				$('#pagestats > li').empty();

				json.forEach(function (facility, index) {
					var item = $('#pagestats > li').get(index);
					$(item).append(getItemWrapper(facility));
				});
			}
		});
	}, 60000);

	/**
	 * Helper function to get the current occupancy of a facility
	 * @param {*} occupied current spaces occupied
	 * @param {*} capacity capacity capacity of the facility
	 * @returns an object of filled spaces and progress bar color
	 */
	function getCurrentOccupancy(occupied, capacity) {
		var currentOccupancy = { filled: 0, progressLevel: "" };
		var occupiedInt = parseInt(occupied);
		var capacityInt = parseInt(capacity);

		if (occupiedInt && capacityInt) {
			currentOccupancy.filled = occupiedInt / capacityInt;

			if (currentOccupancy.filled < .82) {
				currentOccupancy.progressLevel = "light"; // Green
			} else if (currentOccupancy.filled >= .82 && currentOccupancy.filled < 1) {
				currentOccupancy.progressLevel = "warn"; // Yellow
			} else if (currentOccupancy.filled >= 1) {
				currentOccupancy.progressLevel = "danger"; // Red
			}
		}

		return currentOccupancy;
	}

	/**
	 * Helper function to get the item's DOM wrapper
	 * @param {*} facility parkade facility
	 * @returns the DOM wrapper element
	 */
	function getItemWrapper(facility) {
		var wrapper = $("<div>", { "class": "pagestats-wrapper" });
		var wrapper2 = $("<div>", { "class": "pagestats-wrapper2" });

		wrapper.append($("<div>", { "class": "pagestats-title" })
			.append($("<a>", { "href": "/roads-transportation/parking/find-parking/" + facility.name.toLowerCase().replace(/\s/g, '-') }).text(facility.name)));
		wrapper2.append($("<div>", { "class": "pagestats-number" }).text(((facility.available - facility.threshold) < 1) ? "Full" : facility.available));
		wrapper2.append($("<div>", { "class": "pagestats-body" }).append(facility.message));

		var currentOccupancy = getCurrentOccupancy(facility.occupied, facility.capacity);
		wrapper2.append($("<div>", { "class": "pagestats-progress" })
			.append("<progress class='progress-" +
				currentOccupancy.progressLevel +
				"'  max='" + facility.capacity +
				"' value='" + facility.occupied +
				"' title='" +
				Math.round(currentOccupancy.filled * 100) +
				"% Capacity'></progress>"));

		wrapper.append(wrapper2);

		return wrapper;
	}
})(jQuery);
