# CiviCRM 5.52.0

Released August 3, 2022

- **[Synopsis](#synopsis)**
- **[Features](#features)**
- **[Bugs resolved](#bugs)**
- **[Miscellany](#misc)**
- **[Credits](#credits)**
- **[Feedback](#feedback)**

## <a name="synopsis"></a>Synopsis

| *Does this version...?*                                         |         |
|:--------------------------------------------------------------- |:-------:|
| Fix security vulnerabilities?                                   |   no    |
| **Change the database schema?**                                 | **yes** |
| **Alter the API?**                                              | **yes** |
| Require attention to configuration options?                     |   no    |
| Fix problems installing or upgrading to a previous version?     |   no    |
| **Introduce features?**                                         | **yes** |
| **Fix bugs?**                                                   | **yes** |

## <a name="features"></a>Features

### Core CiviCRM

- **Allow UFMatch to be used in SearchKit - this allows you to filter by eg.
  'has a CMS account'
  ([23723](https://github.com/civicrm/civicrm-core/pull/23723))**

  Makes the UFMatch entity available in SearchKit.

- **message_admin - Enable another preview mode ("HTML (Raw)")
  ([23810](https://github.com/civicrm/civicrm-core/pull/23810))**

  Adds another preview mode to message_admin. This is similar to the "HTML"
  preview, except it shows the raw HTML (with syntax highlighting) which may
  help debugging fiddly edits to the markup.

- **Start phasing out 'preferred_mail_format'
  (Work Towards [dev/core#2866](https://lab.civicrm.org/dev/core/-/issues/2866):
  [23856](https://github.com/civicrm/civicrm-core/pull/23856))**

  Ignores preferred_mail_format, sends both mail formats instead of just
  preferred.

- **End of life planning for MySQL server 5.0 - 5.6
  ([dev/core#1681](https://lab.civicrm.org/dev/core/-/issues/1681):
  [23615](https://github.com/civicrm/civicrm-core/pull/23615))**

  Update requirements to MySQL 5.7+ and MariaDB 10.2+.

- **navigation: cleanup less frequently used New items
  ([23831](https://github.com/civicrm/civicrm-core/pull/23831))**

  Improves user experience by removing some less frequently used menu items
  (only impacts new installations).

- **Add crmRegions to contact headers and associated inline forms
  ([23419](https://github.com/civicrm/civicrm-core/pull/23419))**

  Improve consistency of regions on CiviCRM pages and forms.

- **Angular - Support popping up an afform or other ang module via ajax modal
  ([23924](https://github.com/civicrm/civicrm-core/pull/23924))**

  Allows Afforms to work as modal dialogs.

- **Afform - Allow picking icon for tab, add CrmUiIconPicker widget
  ([23919](https://github.com/civicrm/civicrm-core/pull/23919))**

  Allows users to configure an Icon for their Afform Tab.

- **APIv4 - Enable exporting profiles with custom fields
  ([23825](https://github.com/civicrm/civicrm-core/pull/23825))**

  Improves APIv4 by enabling exporting profiles with custom fields.

- **New domain token base_url
  ([23852](https://github.com/civicrm/civicrm-core/pull/23852))**

  Adds a new domain token `base_url`.

- **Add second currency example
  ([23889](https://github.com/civicrm/civicrm-core/pull/23889))**

  Adds an example for the message admin ui.

- **Upgrader - Apply extension updates after core updates (Work towards
  [dev/core#3490](https://lab.civicrm.org/dev/core/-/issues/3490):
  [24040](https://github.com/civicrm/civicrm-core/pull/24040))**

  Shows additional notice about running extension upgrades.

- **Lack of hooks to detect when a "CustomOption" is deleted
  ([dev/core#3668](https://lab.civicrm.org/dev/core/-/issues/3668):
  [23834](https://github.com/civicrm/civicrm-core/pull/23834))**

  Calls hooks when deleting an option value from CustomOption.

### CiviCase

- **Feature request - Filter case activities to only activity types in civicase
  ([dev/core#3709](https://lab.civicrm.org/dev/core/-/issues/3709):
  [23937](https://github.com/civicrm/civicrm-core/pull/23937))**

  Makes the activity search filter on manage case less unwieldy.

### CiviContribute

- **Add hook to modify 'contribution payment links'
  ([23790](https://github.com/civicrm/civicrm-core/pull/23790))**

  Makes it so one can modify 'contribution payment links' via
  hook_civicrm_links.

- **Invoice Workflow template - add domain tokens
  ([23806](https://github.com/civicrm/civicrm-core/pull/23806))**

  Adds domain tokens to the Invoice workflow template.

- **Make it clear what "record refund" form does
  ([23792](https://github.com/civicrm/civicrm-core/pull/23792))**

  Adds more help text to the Record Refund form.

### CiviGrant

- **Grants appear in afform
  ([23899](https://github.com/civicrm/civicrm-core/pull/23899))**

  Adds the Grant entity to Afform.

### Drupal Integration

- **Allow installing on drupal 10
  ([73](https://github.com/civicrm/civicrm-drupal-8/pull/73))**

  Lists CiviCRM as Drupal 10 compatible.

### WordPress Integration

- **Introduce "Permissions and Capabilities" metabox and functionality
  ([279](https://github.com/civicrm/civicrm-wordpress/pull/279))**

  Makes it so all CiviCRM permissions can be exposed as capabilities in
  WordPress via an optional custom role called "CiviCRM Admin".

## <a name="bugs"></a>Bugs resolved

### Core CiviCRM

- **HTML entities in iCalendar export
  ([dev/core#1541](https://lab.civicrm.org/dev/core/-/issues/1541):
  [23638](https://github.com/civicrm/civicrm-core/pull/23638),
  [23855](https://github.com/civicrm/civicrm-core/pull/23855) and
  [23840](https://github.com/civicrm/civicrm-core/pull/23840))**

  Fixes random invalid utf8 issues when exporting iCalendar files.

- **ical/ics files generated by Civi are not compatible with Outlook during
  Daylight Savings
  ([dev/core#2887](https://lab.civicrm.org/dev/core/-/issues/2887):
  [23808](https://github.com/civicrm/civicrm-core/pull/23808))**

- **PHP 8.1 (Work Towards
  [dev/core#3181](https://lab.civicrm.org/dev/core/-/issues/3181):
  [23947](https://github.com/civicrm/civicrm-core/pull/23947))**

  Compatibility fixes for GLOBALS in PHP 8.1.

- **Greenwich theme: transparent background on pop-ups
  ([dev/core#3432](https://lab.civicrm.org/dev/core/-/issues/3432):
  [23873](https://github.com/civicrm/civicrm-core/pull/23873))**

- **Sorting/paging Advanced Search results corrupts search criteria
  ([dev/core#3495](https://lab.civicrm.org/dev/core/-/issues/3495):
  [23697](https://github.com/civicrm/civicrm-core/pull/23697))**

  Fixes fields with wildcards in Advanced Search.

- **Fix sorting by mapping type
  ([dev/core#3717](https://lab.civicrm.org/dev/core/-/issues/3717):
  [23942](https://github.com/civicrm/civicrm-core/pull/23942))**

  Fixes sorting on import/export Mapping page so that it is sorted by mapping
  type.

- **CRM_Report_Form: set _from and _where as public for the alterReportVar hook
  ([23912](https://github.com/civicrm/civicrm-core/pull/23912))**

- **Avoid multiple log files in multi-language environments
  ([23722](https://github.com/civicrm/civicrm-core/pull/23722))**

- **Reset smarty-security after an exception
  ([23891](https://github.com/civicrm/civicrm-core/pull/23891))**

  Stops tests from getting befuddled.

- **Fix import falling over when a note is included
  ([23968](https://github.com/civicrm/civicrm-core/pull/23968))**

- **Always return boolean from initialize method
  ([278](https://github.com/civicrm/civicrm-wordpress/pull/278))**

- **Smarty notice fix
  ([23963](https://github.com/civicrm/civicrm-core/pull/23963))**

- **Enotice fix
  ([23945](https://github.com/civicrm/civicrm-core/pull/23945))**

- **Do not escape error message
  ([23964](https://github.com/civicrm/civicrm-core/pull/23964))**

- **hook_civicrm_geocoderFormat does not alter address components
  ([dev/core#3756](https://lab.civicrm.org/dev/core/-/issues/3756):
  [24067](https://github.com/civicrm/civicrm-core/pull/24067))**

- **Scheduled Reminders: Some tokens defined by extensions may not evaluate 
  ([24115](https://github.com/civicrm/civicrm-core/pull/24115))**

  This resolves a problem where certain tokens would work when sending an
  email activity but not in scheduled reminders. Originally observed with
  the membership tokens in `nz.co.fuzion.civitoken`.

### CiviCase

- **On "My Contact Dashboard", what is the Manage Case link in the relationships
  section supposed to do?
  (Work Towards [dev/core#2983](https://lab.civicrm.org/dev/core/-/issues/2983):
  [23832](https://github.com/civicrm/civicrm-core/pull/23832))**

  Make static function static - AJAX::caseDetails().

- **Fixed fatal error on update multiple case
  ([23853](https://github.com/civicrm/civicrm-core/pull/23853))**

### CiviContribute

- **Contacts with "Access CiviContribute" but not "edit contributions" can no
  longer view contributions
  ([dev/core#3725](https://lab.civicrm.org/dev/core/-/issues/3725):
  [23965](https://github.com/civicrm/civicrm-core/pull/23965))**

- **Additional Details section on Recurring Contribution template edit screen
  doesn't load anymore
  ([dev/financial#199](https://lab.civicrm.org/dev/financial/-/issues/199):
  [23774](https://github.com/civicrm/civicrm-core/pull/23774))**

- **Ensure apiv3 params are converted at the line item level
  ([23892](https://github.com/civicrm/civicrm-core/pull/23892))**

- **Unassigned variable in invoice message template
  ([23872](https://github.com/civicrm/civicrm-core/pull/23872))**

- **Fix double organization name in invoice, use token
  ([23816](https://github.com/civicrm/civicrm-core/pull/23816))**

- **Personal Campaign Pages (PCP) incorrectly displays "Don't list my
  contribution in the honour roll"
  ([23871](https://github.com/civicrm/civicrm-core/pull/23871))**

- **Fix calculation and assignment of taxAmount on contribution page
  confirmation ([23346](https://github.com/civicrm/civicrm-core/pull/23346))**

- **Subscription Amount change not respected in Paypal
  ([23084](https://github.com/civicrm/civicrm-core/pull/23084))**

- **Remove another instance of pledges using contribution option group
  ([23962](https://github.com/civicrm/civicrm-core/pull/23962))**

- **only check batch currency match when adding a financial_trxn
  ([23741](https://github.com/civicrm/civicrm-core/pull/23741))**

- **Upgrade script for contribution_recur amount, fix loading
  ([23929](https://github.com/civicrm/civicrm-core/pull/23929))**

- **Fix bug whereby editing contribution_recur.amount was not updating
  single-line-item-template-contributions
  ([23809](https://github.com/civicrm/civicrm-core/pull/23809))**

- **Cannot submit credit cards via backend form (on certain configurations)
  ([dev/core#3774](https://lab.civicrm.org/dev/core/-/issues/3774):
  [#24144](https://github.com/civicrm/civicrm-core/pull/24144))**

### CiviEvent

- **Scheduled Reminder limited by Participant Role fails if any participant has
  multiple roles
  ([dev/core#3369](https://lab.civicrm.org/dev/core/-/issues/3369):
  [23602](https://github.com/civicrm/civicrm-core/pull/23602))**

- **Alternate to 23826 - Events RSS feed does not output a pubDate for each
  Event ([23850](https://github.com/civicrm/civicrm-core/pull/23850))**

### CiviMail

- **CiviMail "DB error": suspected core bug relating to attachment replace api
  ([dev/core#2198](https://lab.civicrm.org/dev/core/-/issues/2198):
  [23776](https://github.com/civicrm/civicrm-core/pull/23776))**

  Fixes "Error - DB error - unknown error" error when trying to send a test
  mailing.

### Drupal Integration

- **Drupal service 'site.path' is deprecated in drupal 9 and will be removed in
  drupal 10 ([dev/drupal#167](https://lab.civicrm.org/dev/drupal/-/issues/167):
  [21809](https://github.com/civicrm/civicrm-core/pull/21809))**

### WordPress Integration

- **Enable the 'notify' parameter for WordPress user creation
  ([23879](https://github.com/civicrm/civicrm-core/pull/23879))**

  Ensures that Wordpress respects the user creation `notify` parameter which
  says whether or not to notify the user that an account has been created.

- **Add missing template file
  ([280](https://github.com/civicrm/civicrm-wordpress/pull/280))**

## <a name="misc"></a>Miscellany

- **_Importer_: Increase size of queue batches
  ([#24152](https://github.com/civicrm/civicrm-core/pull/24152))**

- **RepeatTransaction - separate out repeat pledge handling from completeOrder
  ([23931](https://github.com/civicrm/civicrm-core/pull/23931))**

- **Cleanup repeattransaction
  ([23928](https://github.com/civicrm/civicrm-core/pull/23928))**

- **chore: Set permissions for GitHub actions
  ([23799](https://github.com/civicrm/civicrm-core/pull/23799))**

- **Move the cache for `CRM_Extension_Browser` out of the filesystem and use a
  `SqlGroup` instead
  ([dev/core#3542](https://lab.civicrm.org/dev/core/-/issues/3542):
  [23768](https://github.com/civicrm/civicrm-core/pull/23768))**

- **Exceptions - What could possibly go wrong?
  ([23471](https://github.com/civicrm/civicrm-core/pull/23471))**

- **Replace more assigns with tokens in invoice, add tests
  ([23829](https://github.com/civicrm/civicrm-core/pull/23829))**

- **Improve code comments for Activity: parent_id and source_record_id
  ([dev/core#3691](https://lab.civicrm.org/dev/core/-/issues/3691):
  [23878](https://github.com/civicrm/civicrm-core/pull/23878)
  and [23886](https://github.com/civicrm/civicrm-core/pull/23886))**

- **Attempt to make function more readable by extracting in-line function
  ([23847](https://github.com/civicrm/civicrm-core/pull/23847))**

- **AngularJS - Remove UI-Utils library
  ([23749](https://github.com/civicrm/civicrm-core/pull/23749))**

- **Upgrader - Add snapshots for 5.52's data modifications
  ([24039](https://github.com/civicrm/civicrm-core/pull/24039))**

- **[REF] Upgrade DOMPDF to 2.x branch
  ([24038](https://github.com/civicrm/civicrm-core/pull/24038))**

- **[REF] Replace packages/html2txt with Composer package
  ([dev/core#3676](https://lab.civicrm.org/dev/core/-/issues/3676):
  [23971](https://github.com/civicrm/civicrm-core/pull/23971))**

- **REF - Remove unneeded return from private fn, add comments
  ([23967](https://github.com/civicrm/civicrm-core/pull/23967))**

- **[REF] Follow on from #23749 and remove refernece to ui-utils from karama
  conf ([23846](https://github.com/civicrm/civicrm-core/pull/23846))**

- **(REF) TokenProcessor - Tweak error message
  ([23813](https://github.com/civicrm/civicrm-core/pull/23813))**

- **[REF] Remove param that has a set value
  ([23797](https://github.com/civicrm/civicrm-core/pull/23797))**

- **[REF][PHP8.1] Fix default values which triggeres deprecation notices in
  php8.1 ([23926](https://github.com/civicrm/civicrm-core/pull/23926))**

- **[REF][PHP8.1] Add in type hints to fix deprecations and add in
  #[\ReturnTypeWillChange] where type hint would be transversable or mixed for
  php7 compatability
  ([23925](https://github.com/civicrm/civicrm-core/pull/23925))**

- **[REF][PHP8.1] Fix deprecations where by calling trait static functions when
  not from a class that implements the trait is deprecated
  ([23960](https://github.com/civicrm/civicrm-core/pull/23960))**

- **[REF][PHP8.1] Another set of fixes for passing in NULL values to php string
  or preg replace functions
  ([23935](https://github.com/civicrm/civicrm-core/pull/23935))**

- **[REF][PHP8.1] Update Brick/Math to a version that works with php8.1
  ([23938](https://github.com/civicrm/civicrm-core/pull/23938))**

- **[REF][PHP8.1] Upgrade Symfony to 4.x for WP, Drupal7, Backdrop, Joomla
  ([23913](https://github.com/civicrm/civicrm-core/pull/23913))**

- **[REF][PHP8.1] Stop Passing NULL values into mb_strlen in DAO and strpos in
  API validate string function
  ([23922](https://github.com/civicrm/civicrm-core/pull/23922))**

- **[REF] [PHP8.1] Replace usage of smarty's date_filter to ensure we don't call
  strftime which is deprecated in php8.1
  ([23800](https://github.com/civicrm/civicrm-core/pull/23800))**

- **[REF][PHP8.1] Upgrade Pear/mail_mime package to support php8.1
  ([23923](https://github.com/civicrm/civicrm-core/pull/23923))**

- **[REF][PHP8.1] Ensure that NULL is not passed to substr in
  CRM_Utils_File::addTrailingSlash
  ([23914](https://github.com/civicrm/civicrm-core/pull/23914))**

- **[REF][PHP8.1] Fix issue where  is meant to be a string in preg_match_all
  ([345](https://github.com/civicrm/civicrm-packages/pull/345))**

- **[REF][PHP8.1] Replace a couple of calls in Smarty code to strftime to the
  equivilant using date to fix deprecation notices
  ([344](https://github.com/civicrm/civicrm-packages/pull/344))**

- **(NFC) mgd-php@1 - Add example+assertions for new case-type  
  ([23961](https://github.com/civicrm/civicrm-core/pull/23961))**

- **(NFC) case-xml@1 - Add example+assertions of new activity-type
  ([23959](https://github.com/civicrm/civicrm-core/pull/23959))**

- **[NFC] Restore handling for deprecations in phpunit test runs
  ([23988](https://github.com/civicrm/civicrm-core/pull/23988))**

- **(NFC) SoapTest - Skip this test on Drupal8+ and Backdrop
  ([23975](https://github.com/civicrm/civicrm-core/pull/23975))**

- **(NFC) Expand docblocks for hook_install and hook_postInstall
  ([23901](https://github.com/civicrm/civicrm-core/pull/23901))**

- **NFC: Fix PHP notice on ContributionRecurSelector.tpl
  ([23791](https://github.com/civicrm/civicrm-core/pull/23791))**

- **[NFC] Add code comment about triggerinfo "variables"
  ([23930](https://github.com/civicrm/civicrm-core/pull/23930))**

- **Remove another no-run test from SyntaxConformance
  ([23738](https://github.com/civicrm/civicrm-core/pull/23738))**

- **Civi\Test - Fix leak in active module-list for headless test
  ([23991](https://github.com/civicrm/civicrm-core/pull/23991))**

- **Minor test cleanup
  ([23894](https://github.com/civicrm/civicrm-core/pull/23894))**

- **(REF) WorkflowMessageTest - Use dataProvider
  ([23811](https://github.com/civicrm/civicrm-core/pull/23811))**

- **WorkflowMessageTest - Fix weird inconsistency in resolving `@dataProvider`
  ([23916](https://github.com/civicrm/civicrm-core/pull/23916))**

- **WorkflowMessageTest - Re-enable skipped test
  ([23885](https://github.com/civicrm/civicrm-core/pull/23885))**

## <a name="credits"></a>Credits

This release was developed by the following code authors:

AGH Strategies - Alice Frumin, Andie Hunt; Agileware - Francis Whittle, Justin
Freeman; Benjamin W; Business & Code - Alain Benbassat; Christian Wach; Circle
Interactive - Pradeep Nayak; CiviCoop - Klaas Eikelboom; CiviCRM - Coleman
Watts, Tim Otten; Coop SymbioTIC - Mathieu Lutfy; Dave D; Davis Media Access -
Darrick Servis; Freeform Solutions - Herb van den Dool; Fuzion - Luke Stewart;
IProSoft; Jens Schuppe; JMA Consulting - Monish Deb, Seamus Lee; Megaphone
Technology Consulting - Jon Goldberg; MJW Consulting - Matthew Wire;
nathannaveen; Oxfam Germany - Thomas Schüttler; Wikimedia Foundation - Eileen
McNaughton

Most authors also reviewed code for this release; in addition, the following
reviewers contributed their comments:

AGH Strategies - Chris Garaffa; Artful Robot - Rich Lott; Betty Dolfing;
Blackfly Solutions - Alan Dixon; CiviCoop - Jaap Jansma; CiviDesk - Yashodha
Chaku; DevApp - Adam Kwiatkowski; Fuzion - Peter Davis; iXiam - Luciano Spiegel;
JMA Consulting - Joe Murray; Lighthouse Consulting and Design - Brian
Shaughnessy; MC3 - Graham Mitchell; Nicol Wistreich; Squiffle Consulting - Aidan
Saunders; Tadpole Collective - Kevin Cristiano; Third Sector Design - Kurund
Jalmi

## <a name="feedback"></a>Feedback

These release notes are edited by Alice Frumin and Andie Hunt.  If you'd like
to provide feedback on them, please log in to https://chat.civicrm.org/civicrm
and contact `@agh1`.
