<?php
/*
 +--------------------------------------------------------------------+
 | Copyright CiviCRM LLC. All rights reserved.                        |
 |                                                                    |
 | This work is published under the GNU AGPLv3 license with some      |
 | permitted exceptions and without any warranty. For full license    |
 | and copyright information, see https://civicrm.org/licensing       |
 +--------------------------------------------------------------------+
 */

/**
 * @package CRM
 * @copyright CiviCRM LLC https://civicrm.org/licensing
 *
 * Generated from xml/schema/CRM/Omnimail/MailingProviderData.xml
 * DO NOT EDIT.  Generated by CRM_Core_CodeGen
 * (GenCodeChecksum:a204d62995809fae79a76799b88a69f8)
 */

/**
 * CRM_Omnimail_DAO_MailingProviderData constructor.
 */
class CRM_Omnimail_DAO_MailingProviderData extends CRM_Core_DAO {
  /**
   * Static instance to hold the table name.
   *
   * @var string
   */
  protected static $_tableName = 'civicrm_mailing_provider_data';
  /**
   * Should CiviCRM log any modifications to this table in the civicrm_log table.
   *
   * @var bool
   */
  protected static $_log = FALSE;
  /**
   * External reference for the contact
   *
   * @var string
   */
  public $contact_identifier;
  /**
   * External Reference for the mailing
   *
   * @var string
   */
  public $mailing_identifier;
  /**
   * Email Address
   *
   * @var string
   */
  public $email;
  /**
   * Type of action
   *
   * @var string
   */
  public $event_type;
  /**
   * When the action happened
   *
   * @var timestamp
   */
  public $recipient_action_datetime;
  /**
   * Contact in CiviCRM
   *
   * @var int
   */
  public $contact_id;
  /**
   * Has the action been synchronised through to CiviCRM
   *
   * @var bool
   */
  public $is_civicrm_updated;

  /**
   * Class constructor.
   */
  public function __construct() {
    $this->__table = 'civicrm_mailing_provider_data';
    parent::__construct();
  }

  /**
   * Returns all the column names of this table
   *
   * @return array
   */
  public static function &fields() {
    if (!isset(Civi::$statics[__CLASS__]['fields'])) {
      Civi::$statics[__CLASS__]['fields'] = [
        'contact_identifier' => [
          'name' => 'contact_identifier',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Contact Identifier') ,
          'description' => 'External reference for the contact',
          'maxlength' => 255,
          'size' => CRM_Utils_Type::HUGE,
          'table_name' => 'civicrm_mailing_provider_data',
          'entity' => 'MailingProviderData',
          'bao' => 'CRM_Omnimail_DAO_MailingProviderData',
          'localizable' => 0,
        ] ,
        'mailing_identifier' => [
          'name' => 'mailing_identifier',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Mailing Identifier') ,
          'description' => 'External Referencefor the mailing',
          'maxlength' => 255,
          'size' => CRM_Utils_Type::HUGE,
          'table_name' => 'civicrm_mailing_provider_data',
          'entity' => 'MailingProviderData',
          'bao' => 'CRM_Omnimail_DAO_MailingProviderData',
          'localizable' => 0,
        ] ,
        'email' => [
          'name' => 'email',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Email') ,
          'description' => 'Email Address',
          'maxlength' => 255,
          'size' => CRM_Utils_Type::HUGE,
          'table_name' => 'civicrm_mailing_provider_data',
          'entity' => 'MailingProviderData',
          'bao' => 'CRM_Omnimail_DAO_MailingProviderData',
          'localizable' => 0,
        ] ,
        'event_type' => [
          'name' => 'event_type',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Recipient Action Type') ,
          'description' => 'Type of action',
          'maxlength' => 255,
          'size' => CRM_Utils_Type::HUGE,
          'table_name' => 'civicrm_mailing_provider_data',
          'entity' => 'MailingProviderData',
          'bao' => 'CRM_Omnimail_DAO_MailingProviderData',
          'localizable' => 0,
        ] ,
        'recipient_action_datetime' => [
          'name' => 'recipient_action_datetime',
          'type' => CRM_Utils_Type::T_TIMESTAMP,
          'title' => ts('Recipient Action Datetime') ,
          'description' => 'When the action happened',
          'table_name' => 'civicrm_mailing_provider_data',
          'entity' => 'MailingProviderData',
          'bao' => 'CRM_Omnimail_DAO_MailingProviderData',
          'localizable' => 0,
        ],
        'contact_id' => [
          'name' => 'contact_id',
          'type' => CRM_Utils_Type::T_INT,
          'description' => 'Contact in CiviCRM',
          'table_name' => 'civicrm_mailing_provider_data',
          'entity' => 'MailingProviderData',
          'bao' => 'CRM_Omnimail_DAO_MailingProviderData',
          'localizable' => 0,
        ] ,
        'is_civicrm_updated' => [
          'name' => 'is_civicrm_updated',
          'type' => CRM_Utils_Type::T_BOOLEAN,
          'description' => 'Has the action been synchronised through to CiviCRM',
          'table_name' => 'civicrm_mailing_provider_data',
          'entity' => 'MailingProviderData',
          'bao' => 'CRM_Omnimail_DAO_MailingProviderData',
          'localizable' => 0,
        ] ,
      ];
      CRM_Core_DAO_AllCoreTables::invoke(__CLASS__, 'fields_callback', Civi::$statics[__CLASS__]['fields']);
    }
    return Civi::$statics[__CLASS__]['fields'];
  }

  /**
   * Return a mapping from field-name to the corresponding key (as used in fields()).
   *
   * @return array
   *   Array(string $name => string $uniqueName).
   */
  public static function &fieldKeys() {
    if (!isset(Civi::$statics[__CLASS__]['fieldKeys'])) {
      Civi::$statics[__CLASS__]['fieldKeys'] = array_flip(CRM_Utils_Array::collect('name', self::fields()));
    }
    return Civi::$statics[__CLASS__]['fieldKeys'];
  }

  /**
   * Returns the names of this table
   *
   * @return string
   */
  public static function getTableName() {
    return self::$_tableName;
  }

  /**
   * Returns if this table needs to be logged
   *
   * @return bool
   */
  public function getLog() {
    return self::$_log;
  }

  /**
   * Returns the list of fields that can be imported
   *
   * @param bool $prefix
   *
   * @return array
   */
  public static function &import($prefix = FALSE) {
    $r = CRM_Core_DAO_AllCoreTables::getImports(__CLASS__, 'mailing_provider_data', $prefix, []);
    return $r;
  }

  /**
   * Returns the list of fields that can be exported
   *
   * @param bool $prefix
   *
   * @return array
   */
  public static function &export($prefix = FALSE) {
    $r = CRM_Core_DAO_AllCoreTables::getExports(__CLASS__, 'mailing_provider_data', $prefix, []);
    return $r;
  }

  /**
   * Returns the list of indices
   */
  public static function indices($localize = TRUE) {
    $indices = [];
    return ($localize && !empty($indices)) ? CRM_Core_DAO_AllCoreTables::multilingualize(__CLASS__, $indices) : $indices;
  }

}

/**
 * CRM_Omnimail_BAO_MailingProviderData constructor.
 */
class CRM_Omnimail_BAO_MailingProviderData extends CRM_Omnimail_DAO_MailingProviderData {

}

/**
 * MailingProviderData.get API
 *
 * @param array $params
 * @return array API result descriptor
 * @throws API_Exception
 */
function civicrm_api3_mailing_provider_data_get($params) {
  $sql = CRM_Utils_SQL_Select::fragment();
  $sql->select('CONCAT(contact_identifier, mailing_identifier, recipient_action_datetime) as id');
  return civicrm_api3_create_success(_civicrm_api3_basic_get('CRM_Omnimail_BAO_MailingProviderData', $params, FALSE, 'MailingProviderData', $sql, FALSE));
}

/**
 * Metadata for MailingProviderData.get API
 *
 * @param array $params
 *
 * @throws API_Exception
 */
function _civicrm_api3_mailing_provider_data_get_spec(&$params) {
  $params['mailing_identifier']['FKClassName'] = 'CRM_Mailing_BAO_Mailing';
  $params['mailing_identifier']['FKApiName'] = 'Mailing';
  $params['mailing_identifier']['FKKeyColumn'] = 'hash';
}

/**
 * MailingProviderData.create API
 *
 * @param array $params
 * @return array API result descriptor
 * @throws API_Exception
 */
function civicrm_api3_mailing_provider_data_create($params) {
  return _civicrm_api3_basic_create(_civicrm_api3_get_BAO(__FUNCTION__), $params);
}
