/**
 * @file
 * Copied from jquery-validation additional-methods.
 *
 * Adapted to Drupal js coding standards. This allows using a regex pattern
 * for the validation without having to load the 40+ KB of js in
 * additional-methods.js.
 */
(function ($) {
  $.validator.addMethod('pattern', function (value, element, param) {
    if (this.optional(element)) {
      return true;
    }
    if (typeof param === 'string') {
      param = new RegExp('^(?:' + param + ')$');
    }
    return param.test(value);
  }, 'Invalid format.');
})(jQuery);
