<?php

namespace Drupal\openlayers\Entity;

use Drupal\Core\Config\Entity\ConfigEntityBase;
use Drupal\openlayers\OpenlayersControlInterface;

/**
 * Defines the Openlayers Control entity.
 *
 * @ConfigEntityType(
 *   id = "openlayers_control",
 *   label = @Translation("Openlayers Control"),
 *   handlers = {
 *     "list_builder" = "Drupal\openlayers\Controller\OpenlayersControlListBuilder",
 *     "form" = {
 *       "add" = "Drupal\openlayers\Form\OpenlayersControlAddForm",
 *       "edit" = "Drupal\openlayers\Form\OpenlayersControlEditForm",
 *       "delete" = "Drupal\openlayers\Form\OpenlayersControlDeleteForm",
 *     }
 *   },
 *   config_prefix = "control",
 *   admin_permission = "administer openlayers",
 *   entity_keys = {
 *     "id" = "id",
 *     "label" = "label",
 *   },
 *   config_export = {
 *     "id",
 *     "label",
 *     "control_type",
 *     "is_configurable"
 *   },
 *   links = {
 *     "edit-form" = "/admin/config/system/openlayers/control/{openlayers_control}/edit",
 *     "delete-form" = "/admin/config/system/openlayers/control/{openlayers_control}/delete",
 *   }
 * )
 */
class OpenlayersControl extends ConfigEntityBase implements OpenlayersControlInterface {

  /**
   * The Example ID.
   *
   * @var string
   */
  public $id;

  /**
   * The Example label.
   *
   * @var string
   */
  public $label;

  // Your specific configuration property get/set methods go here,
  // implementing the interface.
}
