<?php

namespace Drupal\openlayers\Form;

use Drupal\Core\Form\FormStateInterface;
use Drupal\openlayers\OpenlayersMapInterface;

//use Drupal\image\ImageEffectManager;
//use Drupal\openlayers\ImageStyleInterface;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * Provides an add form for image effects.
 *
 * @internal
 */
class MapLayerAddForm extends MapLayerFormBase {

  /**
   * The image effect manager.
   *
   * @var \Drupal\image\ImageEffectManager
   */
//  protected $effectManager;

  /**
   * Constructs a new ImageEffectAddForm.
   *
   * @param \Drupal\image\ImageEffectManager $effect_manager
   *   The image effect manager.
   */
//  public function __construct(ImageEffectManager $effect_manager) {
//    $this->effectManager = $effect_manager;
//  }

  /**
   * {@inheritdoc}
   */
//  public static function create(ContainerInterface $container) {
//    return new static(
//      $container->get('plugin.manager.image.effect')
//    );
//  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state, OpenlayersMapInterface $map = NULL, $layer = NULL) {
    $form = parent::buildForm($form, $form_state, $map, $layer);
    $form['#title'] = $this->t('Add %label layer to map', ['%label' => $this->mapLayer->label()]);   
    $form['actions']['submit']['#value'] = $this->t('Add layer');

    return $form;
  }

  /**
   * {@inheritdoc}
   */
  protected function prepareOpenlayersLayer($layer) {
/*    
    $image_effect = $this->effectManager->createInstance($image_effect);
    // Set the initial weight so this effect comes last.
    $image_effect->setWeight(count($this->imageStyle->getEffects()));
*/
    return $layer;
  }

}
