<?php

namespace Drupal\openlayers\Form;

use Drupal\Core\Form\FormStateInterface;
use Drupal\openlayers\OpenlayersMapInterface;
use Drupal\openlayers\Form\OpenlayersPluginFormBase;

/**
 * Provides an edit form for the settings for Openlayers plugins.
 *
 * @internal
 */
class OpenlayersPluginEditForm extends OpenlayersPluginFormBase {

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state, OpenlayersMapInterface $map = NULL, $plugin_type = NULL, $plugin = NULL) {

    $form = parent::buildForm($form, $form_state, $map, $plugin_type, $plugin);

    $form['#title'] = $this->t('Edit %label %type', ['%label' => $this->olPlugin->label(), '%type' => $plugin_type]);
    $form['actions']['submit']['#value'] = $this->t('Update settings');

    return $form;
  }

  /**
   * {@inheritdoc}
   */
  protected function preparePlugin($plugin_type, $plugin) {
    return $this->olMap->{'get' . ucwords($plugin_type)}($plugin);
  }

}
