<?php

namespace Drupal\openlayers;

/**
 * Generates the complete settings for the selected map, together with all the related layers / sources / interactions / etc.
 */
class MapSettings {

  /**
   * The settings for the selected map.  These settings will be passed to the javascript file that generates the map. 
   *
   * @var array
   */
  public $settings;

  public function __construct($map_id) {
    $this->settings = $this->getSettings($map_id, 'map');
  }
  
  /**
   * {@inheritdoc}
   */
  public function getSettings($id, $type) {
    $id = 'openlayers.' . $type . '.' . $id;

    $config = \Drupal::config($id)->get();
    if ($type == 'map') {

      $this->cacheTags = ['config:' . $id];
    }
    $settings = [];

    foreach ($config as $key => $item) {
      if (in_array($key, ['uuid', 'langcode', 'status', 'dependencies', '_core', 'id', 'label', 'is_configurable'])) {
        continue;
      }

      switch ($key) {
        case 'layers':

          if (count($item) > 0) {
            $layers = [];
            foreach ($item as $layer_item) {

              $layer = $this->getSettings($layer_item['id'], 'layer');

              foreach($layer_item['data'] as $key_data => $item_data) {

                $layer[$key_data] = $item_data;

              }

              $settings['layers'][] = $layer;
            }
            //$settings['layers'] = $layers;
            // TODO
          }

          break;
        case 'source':

          $source = $this->getSettings($item, 'source');

          $settings['source'] = $source;
          break;          
        case 'styles':

          // TODO
          $styles = [];
          foreach ($item as $style_item) {

            $style = [];

            foreach($style_item['data'] as $key_data => $item_data) {

              if (!is_null($item_data) && $item_data != '') {
                $style[$key_data] = $item_data;
              }
            }

            if (isset($style_item['ol_id']) && $style_item['ol_id'] != '???') {
  
              $settings['styles'][$style_item['ol_id']] = $style;
            }
          }

          break;
        case 'controls':

          // TODO
          $controls = [];
          foreach ($item as $control_item) {

            $control = $this->getSettings($control_item['id'], 'control');

            foreach($control_item['data'] as $key_data => $item_data) {

              if (!is_null($item_data)) {
                $control[$key_data] = $item_data;
              }
            }

            if (isset($control_item['ol_id']) && $control_item['ol_id'] != '???') {
   
              $settings['controls'][$control_item['ol_id']] = $control;
            }
          } 
          break;
        case 'interactions':

          // TODO
          $interactions = [];
          foreach ($item as $interaction_item) {

            $interaction = $this->getSettings($interaction_item['id'], 'interaction');

            foreach($interaction_item['data'] as $key_data => $item_data) {

              if (!is_null($item_data) && $item_data != '') {

                $interaction[$key_data] = $item_data;
              }
            }

            if (isset($interaction_item['ol_id']) && $interaction_item['ol_id'] != '???') {
  
              $settings['interactions'][$interaction_item['ol_id']] = $interaction;
            }
          }
          break;
        default:
          $settings[$key] = $item;
      }

    }

    return $settings;
  } 
  
}