<?php

namespace Drupal\openlayers\Plugin\OpenlayersInteraction;

use Drupal\Component\Utility\Color;
use Drupal\Component\Utility\Rectangle;
use Drupal\Core\Form\FormStateInterface;
use Drupal\openlayers\OpenlayersConfigurablePluginBase;

/**
 * Defines the Drag Pan interaction for an Openlayers map.
 *
 * @OpenlayersInteraction(
 *   id = "ol_interaction_dragpan",
 *   label = @Translation("Drag pan"),
 *   description = @Translation("Define a drag pan interaction."),
 *   type = "interaction",
 *   ol_id = "DragPan"
 * )
 */
class DragPan extends OpenlayersConfigurablePluginBase {

  /**
   * {@inheritdoc}
   */
  public function getSummary() {
    $summary = [
      '#theme' => 'openlayers_interaction_summary',
      '#data' => $this->configuration,
    ];
    $summary += parent::getSummary();

    return $summary;
  }

  /**
   * {@inheritdoc}
   */
  public function defaultConfiguration() {
    return [
//      'color' => NULL,
    ];
  }

  /**
   * {@inheritdoc}
   */
  public function buildConfigurationForm(array $form, FormStateInterface $form_state) {
/*
    $form['color'] = [
      '#type' => 'textfield',
      '#default_value' => $this->configuration['color'],
      '#title' => t('Fill color'),
      '#description' => t('The color to be used for filling polygon features on the map. Use web-style hex colors (#FFFFFF for white, #000000 for black).'),
      '#size' => 7,
      '#maxlength' => 7,
      '#required' => FALSE,
    ];
*/
    return $form;
  }

  /**
   * {@inheritdoc}
   */
  public function validateConfigurationForm(array &$form, FormStateInterface $form_state) {

  }

  /**
   * {@inheritdoc}
   */
  public function submitConfigurationForm(array &$form, FormStateInterface $form_state) {
    parent::submitConfigurationForm($form, $form_state);

//    $this->configuration['color'] = $form_state->getValue('color');
  }

}
