<?php

namespace Drupal\openlayers\Plugin\OpenlayersStyle;

use Drupal\Component\Utility\Color;
use Drupal\Component\Utility\Rectangle;
use Drupal\Core\Form\FormStateInterface;
use Drupal\openlayers\OpenlayersConfigurablePluginBase;

/**
 * Defines the Icon style for Openlayers features.
 *
 * @OpenlayersStyle(
 *   id = "ol_style_icon",
 *   label = @Translation("Icon"),
 *   description = @Translation("Define the icon style for map features."),
 *   type = "style",
 *   ol_id = "Icon"
 * )
 */
class Icon extends OpenlayersConfigurablePluginBase {

  /**
   * {@inheritdoc}
   */
  public function getSummary() {
    $summary = [
      '#theme' => 'openlayers_style_summary',
      '#data' => $this->configuration,
    ];
    $summary += parent::getSummary();

    return $summary;
  }

  /**
   * {@inheritdoc}
   */
  public function defaultConfiguration() {
    return [
      'anchor' => '0.5, 0.5',
      'anchorOrigin' => 'top-left',
      'anchorXUnits' => 'fraction',
      'anchorYUnits' => 'fraction',
      'color' => NULL,
      'crossOrigin' => NULL,
      'img' => NULL,
      'offset' => NULL,
      'displacement' => NULL,
      'offsetOrigin' => 'top-left',
      'opacity' => 1,
      'scale' => 1,
      'size' => NULL,
      'imgSize' => NULL,
      'src' => NULL,
    ];
  }

  /**
   * {@inheritdoc}
   */
  public function buildConfigurationForm(array $form, FormStateInterface $form_state) {
    $form['anchor'] = [
      '#type' => 'textfield',
      '#default_value' => $this->configuration['anchor'],
      '#title' => t('Anchor'),
      '#description' => t("Anchor. Enter this in the form 'x, y'. Default value is the icon center '0, 0'."),
            //  "Anchor. Default value is the icon center."
          //  . Enter this in the form 'x, y'.
      '#size' => 10,
      '#maxlength' => 10,
      '#required' => FALSE,
    ];
    $form['anchorOrigin'] = [
      '#type' => 'select',
      '#default_value' => $this->configuration['anchorOrigin'],
      '#title' => t('Anchor origin'),
      '#description' => t("Origin of the anchor. Defaults to 'top-left'"),
      '#options' => [
        'top-left' => 'Top left',
        'top-right' => 'Top right',
        'bottom-left' => 'Bottom left',
        'bottom-right' => 'Bottom right',
      ],
//      '#size' => 20,
//      '#maxlength' => 20,
      '#required' => TRUE,
    ];
    $form['anchorXUnits'] = [
      '#type' => 'select',
      '#default_value' => $this->configuration['anchorXUnits'],
      '#title' => t('Anchor X units'),
      '#description' => t("Units in which the anchor x value is specified. Defaults to 'fraction'"),
      '#options' => [
        'fraction' => 'Fraction',
        'pixels' => 'Pixels',
      ],
      '#required' => TRUE,
    ];
    $form['anchorYUnits'] = [
      '#type' => 'select',
      '#default_value' => $this->configuration['anchorYUnits'],
      '#title' => t('Anchor Y units'),
      '#description' => t("Units in which the anchor y value is specified. Defaults to 'fraction'"),
      '#options' => [
        'fraction' => 'Fraction',
        'pixels' => 'Pixels',
      ],
      '#required' => TRUE,
    ];
    $form['color'] = [
      '#type' => 'textfield',
      '#default_value' => $this->configuration['color'],
      '#title' => t('Color'),
      //  TODO - improve description to recognise other valid color formats.
      '#description' => t('The color to be used for icon markers on the map. Use web-style hex colors (#FFFFFF for white, #000000 for black).'),
      '#size' => 20,
      '#maxlength' => 20,
      '#required' => FALSE,
    ];
    $form['crossOrigin'] = [
      '#type' => 'textfield',
      '#default_value' => $this->configuration['crossOrigin'],
      '#title' => t('Cross origin'),
      '#description' => t('The crossOrigin attribute for loaded images.'),
      '#size' => 20,
      '#maxlength' => 20,
      '#required' => FALSE,
    ];  
    $form['img'] = [
      '#type' => 'textfield',
      '#default_value' => $this->configuration['img'],
      '#title' => t('img'),
      '#description' => t('Image object for the icon. If the src option is not provided then the provided image must already be loaded. And in that case,' . 
        ' it is required to provide the size of the image, with the imgSize option.'),
      '#size' => 20,
      '#maxlength' => 20,
      '#required' => FALSE,
    ];
    $form['offset'] = [
      '#type' => 'textfield',
      '#default_value' => $this->configuration['offset'],
      '#title' => t('Offset'),
      '#description' => t("Offset, together with the size and the offset origin, defines the sub-rectangle to use from the original icon image." . 
        " Enter this in the form 'x, y'. Defaults to '0,0'."),
      '#size' => 10,
      '#maxlength' => 10,
      '#required' => FALSE,
    ];
    $form['displacement'] = [
      '#type' => 'textfield',
      '#default_value' => $this->configuration['displacement'],
      '#title' => t('Displacement'),
      '#description' => t("Displacement of the icon. Enter this in the form 'x, y'. Defaults to '0,0'."),
      '#size' => 10,
      '#maxlength' => 10,
      '#required' => FALSE,
    ];
    $form['offsetOrigin'] = [
      '#type' => 'select',
      '#default_value' => $this->configuration['offsetOrigin'],
      '#title' => t('Offset origin'),
      '#description' => t("Origin of the offset. Defaults to 'top-left'"),
      '#options' => [
        'top-left' => 'Top left',
        'top-right' => 'Top right',
        'bottom-left' => 'Bottom left',
        'bottom-right' => 'Bottom right',
      ],
      '#required' => TRUE,
    ];
    $form['opacity'] = [
      '#type' => 'number',
      '#step' => 0.1,
      '#max'=> 1,
      '#min'=> 0,
      '#default_value' => $this->configuration['opacity'],
      '#title' => t('Opacity'),
      '#description' => t('The opacity to be used for icon markers on the map. Defaults to 1.'),
      '#required' => TRUE,
    ];
    $form['scale'] = [
      '#type' => 'number',
      '#step' => 1,
      '#max'=> 10,
      '#min'=> 1,
      '#default_value' => $this->configuration['scale'],
      '#title' => t('Scale'),
      '#description' => t('The scale to be used for icon markers on the map. Defaults to 1.'),
      '#required' => TRUE,
    ];
    $form['size'] = [
      '#type' => 'number',
      '#default_value' => $this->configuration['size'],
      '#title' => t('Icon size in pixels'),
      '#description' => t('The icon size (in pixels) to be used for icon markers on the map.'),
      '#required' => FALSE,
    ];
    $form['imgSize'] = [
      '#type' => 'number',
      '#default_value' => $this->configuration['imgSize'],
      '#title' => t('Image size in pixels'),
      '#description' => t('The image size (in pixels) to be used for icon markers on the map.'),
      '#required' => FALSE,
    ];
    $form['src'] = [
      '#type' => 'textfield',
      '#default_value' => $this->configuration['src'],
      '#title' => t('Source URI'),
      '#description' => t('Image source URI.'),
      '#size' => 150,
      '#maxlength' => 255,
      '#required' => FALSE,
    ];

    return $form;
  }

  /**
   * {@inheritdoc}
   */
  public function validateConfigurationForm(array &$form, FormStateInterface $form_state) {
/*
    if (!$form_state->isValueEmpty('color') && !Color::validateHex($form_state->getValue('color'))) {
      $form_state->setErrorByName('color', $this->t('Color must be a hexadecimal color value.'));
    }
*/
  }

  /**
   * {@inheritdoc}
   */
  public function submitConfigurationForm(array &$form, FormStateInterface $form_state) {
    parent::submitConfigurationForm($form, $form_state);

    $this->configuration['anchor'] = $form_state->getValue('anchor');
    $this->configuration['anchorOrigin'] = $form_state->getValue('anchorOrigin');
    $this->configuration['anchorXUnits'] = $form_state->getValue('anchorXUnits');
    $this->configuration['anchorYUnits'] = $form_state->getValue('anchorYUnits');
    $this->configuration['color'] = $form_state->getValue('color');
    $this->configuration['crossOrigin'] = $form_state->getValue('crossOrigin');
    $this->configuration['img'] = $form_state->getValue('img');
    $this->configuration['offset'] = $form_state->getValue('offset');
    $this->configuration['displacement'] = $form_state->getValue('displacement');
    $this->configuration['offsetOrigin'] = $form_state->getValue('offsetOrigin');
    $this->configuration['opacity'] = $form_state->getValue('opacity');
    $this->configuration['scale'] = $form_state->getValue('scale');
    $this->configuration['size'] = $form_state->getValue('size');
    $this->configuration['imgSize'] = $form_state->getValue('imgSize');
    $this->configuration['src'] = $form_state->getValue('src');
  }

}
