<?php

/**
 * @file
 * Definition of Drupal\my_scroller\Plugin\views\style\Scroller.
 */

namespace Drupal\openlayers\Plugin\views\style;

use Drupal\core\form\FormStateInterface;
use Drupal\views\Plugin\views\style\StylePluginBase;

/**
 * Style plugin to render listing.
 *
 * @ingroup views_style_plugins
 *
 * @ViewsStyle(
 *   id = "scroller",
 *   title = @Translation("Scroller"),
 *   help = @Translation("Render a listing of view data."),
 *   theme = "views_view_scroller",
 *   display_types = { "normal" }
 * )
 *
 */
class Scroller extends StylePluginBase {
  /**
   * Set default options
   */
  protected function defineOptions() {
    $options = parent::defineOptions();
    $options['height'] = array('default' => '354');
    return $options;
  }

  /**
   * {@inheritdoc}
   */
  public function buildOptionsForm(&$form, FormStateInterface $form_state) {
    parent::buildOptionsForm($form, $form_state);

    $form['height'] = array(
      '#type' => 'textfield',
      '#title' => $this->t('Height'),
      '#description' => $this->t('Default height of header.'),
      '#size' => '6',
      '#default_value' => $this->options['height'],
      '#required' => TRUE,
      '#field_suffix' => 'px',
    );
  }
}