<?php

namespace Drupal\openlayers\Plugin\Field\FieldFormatter;

use Drupal\Core\Field\FieldItemListInterface;
use Drupal\Core\Field\FieldDefinitionInterface;

use Drupal\openlayers\OpenlayersService;
use Drupal\openlayers\MapSettings;

/**
 * Plugin implementation for an Openlayers Geofield field formatter.
 *
 * @FieldFormatter(
 *   id = "openlayers_geofield_formatter",
 *   label = @Translation("Openlayers Map"),
 *   field_types = {
 *     "geofield"
 *   }
 * )
 */
class OpenlayersGeofieldFormatter extends OpenlayersFormatterBase {

  /**
   * {@inheritdoc}
   */
  public function viewElements(FieldItemListInterface $items, $langcode) {
    $entity = $items->getEntity();

    if ($entity->hasTranslation($langcode)) {
      $entity = $entity->getTranslation($langcode);
    }

    $entity_type = $entity->getEntityTypeId();
    $bundle = $entity->bundle();
    $entity_id = $entity->id();
    /* @var \Drupal\Core\Field\FieldDefinitionInterface $field */
    $field = $items->getFieldDefinition();
    $settings = $this->getSettings();
    $map = new MapSettings($settings['map']);
    $cache_tags = $map->cacheTags;
    $map = $map->settings;

    $results = [];
    $features = [];
    foreach ($items as $delta => $item) {
      if ($settings['multiple_map']) {
        $features = [];
      }

      $features[] = [
        'type' => 'wkt',
        'value' => $item->value,
        'style' => [
          'fill' => [
            'color' => 'red',
          ],
          'stroke' => [
            'color' => 'black',
            'width' => 3,
          ],
        ],
      ];
    }
   
    // Add a specific map id.
    $map['id'] = 'openlayers-map';

    $js_settings = [
      'map' => $map,
      'features' => $features,
      'settings' => [
        'zoom' => $settings['zoom'],
      ],
    ];
    
    $results[] = $this->openlayersService->openlayersRenderMap($js_settings, $settings['height'] . $settings['height_unit'], $cache_tags); 
    
    return $results;
  }

}
