<?php

namespace Drupal\openlayers\Form;

use Drupal\Core\Form\FormStateInterface;
use Drupal\openlayers\OpenlayersMapInterface;
use Drupal\openlayers\OpenlayersControlInterface;

/**
 * Provides an edit form for image effects.
 *
 * @internal
 */
class MapControlEditForm extends MapControlFormBase {

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state, OpenlayersMapInterface $map = NULL, $layer = NULL) {
    $form = parent::buildForm($form, $form_state, $map, $layer);
    $form['#title'] = $this->t('Edit %label layer', ['%label' => $this->mapLayer->label()]);
    $form['actions']['submit']['#value'] = $this->t('Update layer');

    return $form;
  }

  /**
   * {@inheritdoc}
   */
  protected function prepareOpenlayersLayer($layer) {
/*
    return $this->imageStyle->getEffect($image_effect);       //  EDIT FORM
*/
/*    
    $image_effect = $this->effectManager->createInstance($image_effect);      //  ADD FORM ?
    // Set the initial weight so this effect comes last.
    $image_effect->setWeight(count($this->imageStyle->getEffects()));
*/
    return $layer;
  }
}
