<?php

namespace Drupal\openlayers\Form;

use Drupal\Core\Form\ConfirmFormBase;
use Drupal\Core\Form\FormStateInterface;
use Drupal\openlayers\OpenlayersMapInterface;
use Drupal\openlayers\MapStyle;

/**
 * Form for deleting a map style.
 *
 * @internal
 */
class MapStyleDeleteForm extends ConfirmFormBase {

  /**
   * The map containing the style to be deleted.
   *
   * @var \Drupal\image\ImageStyleInterface
   */
  protected $olMap;

  /**
   * The map style to be deleted.
   *
   * @var \Drupal\image\ImageEffectInterface
   */
  protected $mapStyle;

  /**
   * {@inheritdoc}
   */
  public function getQuestion() {
    return $this->t('Are you sure you want to delete the %style style from the %map map?',
      ['%map' => $this->olMap->label(), '%style' => $this->mapStyle->label()]);
  }

  /**
   * {@inheritdoc}
   */
  public function getConfirmText() {
    return $this->t('Delete');
  }

  /**
   * {@inheritdoc}
   */
  public function getCancelUrl() {
    return $this->olMap->toUrl('edit-form');
  }

  /**
   * {@inheritdoc}
   */
  public function getFormId() {
    return 'ol_style_delete_form';
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state, OpenlayersMapInterface $map = NULL, $style = NULL) {
    $this->olMap = $map;
    $this->mapStyle = new MapStyle($this->olMap->styles[$style], 'delete');
    
    return parent::buildForm($form, $form_state);
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state) {
    $this->olMap->deleteMapStyle($this->mapStyle);
    $this->olMap->save();
    $this->messenger()->addStatus($this->t('The style %name has been deleted from the map.', ['%name' => $this->mapStyle->label()]));
    $form_state->setRedirectUrl($this->olMap->toUrl('edit-form'));
  }

}
