<?php

namespace Drupal\Tests\openlayers\Functional;

use Drupal\Tests\BrowserTestBase;

/**
 * Tests that the Openlayers Admin page is reachable.
 *
 * @group OpenlayersAdmin
 */
class AdminTest extends BrowserTestBase {

  /**
   * Default theme.
   *
   * @var string
   */
  protected $defaultTheme = 'stark';

  /**
   * Modules to enable.
   *
   * @var array
   */
  protected static $modules = ['openlayers'];

  /**
   * We use the minimal profile because we want to test local action links.
   *
   * @var string
   */
  protected $profile = 'minimal';

  /**
   * Tests that the reaction rule listing page works.
   */
  public function testAdminPage() {

    $account = $this->drupalCreateUser(['administer openlayers']);
    $assert = $this->assertSession();

    // Test that admin screen cannot be accessed by an anonymous user.
    $this->drupalGet('admin/structure/openlayers');
    $assert->statusCodeEquals(403);

    // Test that admin screen cannot be accessed by logged-in user with
    // no Openlayers admin permisions.
    $basic_account = $this->drupalCreateUser(['access content']);
    $this->drupalLogin($basic_account);
    $this->drupalGet('admin/structure/openlayers');
    $assert->statusCodeEquals(403);

    // Test that admin screen can be accessed by logged-in user with
    // Openlayers admin permisions.
    $admin_account = $this->drupalCreateUser(['administer openlayers']);
    $this->drupalLogin($admin_account);
    $this->drupalGet('admin/structure/openlayers');
    $assert->statusCodeEquals(200);
  }

}
