<?php

/**
 * Page callback: Election system settings
 *
 * @see airport_chatbot_menu()
 */
function airport_chatbot_form($form, &$form_state)
{
 
    $form = array();
    $form['airport_chatbot_markup']['text'] = array(
        '#markup' => '<div class="info">General settings for the YLW Watson Chatbot.</div>'
    );
    $form['airport_chatbot_threat_emails_from'] = array(
        '#type' => 'textfield',
        '#title' => t('From email address'),
        '#default_value' => variable_get('airport_chatbot_threat_emails_from', ''),
        '#description' => t('From Email address'),
        '#required' => TRUE
    );
	
    $form['airport_chatbot_threat_emails'] = array(
        '#type' => 'textfield',
        '#title' => t('Threat emails'),
        '#default_value' => variable_get('airport_chatbot_threat_emails', ''),
        '#description' => t('Email addresses to send threat emails to'),
        '#required' => TRUE
    );
	$form['airport_chatbot_threat_subject'] = array(
        '#type' => 'textfield',
        '#title' => t('Subject'),
        '#default_value' => variable_get('airport_chatbot_threat_subject', ''),
        '#description' => t('Threat email subject'),
        '#required' => TRUE
    );
	$form['airport_chatbot_threat_body'] = array(
        '#type' => 'textfield',
        '#title' => t('Body'),
        '#default_value' => variable_get('airport_chatbot_threat_body', ''),
        '#description' => t('Threat email body'),
        '#required' => TRUE
    );
    $form['airport_chatbot_manifest_location'] = array(
        '#type' => 'textfield',
        '#title' => t('Manifest location path'),
        '#default_value' => variable_get('airport_chatbot_manifest_location', '/srv/nodejs/chatbot/build/asset-manifest.json'),
        '#description' => t('Manifest location path'),
        '#required' => TRUE
    );
    $form['airport_chatbot_smtp_location'] = array(
        '#type' => 'textfield',
        '#title' => t('SMTP URI'),
        '#default_value' => variable_get('airport_chatbot_smtp_location', 'smtp.kelowna.ca'),
        '#description' => t('SMTP location'),
        '#required' => TRUE
    );
	$form['airport_chatbot_smtp_port'] = array(
        '#type' => 'textfield',
        '#title' => t('SMTP port'),
        '#default_value' => variable_get('airport_chatbot_smtp_port', '25'),
        '#description' => t('SMTP port'),
        '#required' => TRUE
    );
    
    
    $form['airport_chatbot_active'] = array(
        '#type' => 'checkbox',
        '#title' => t('Active'),
        '#default_value' => variable_get('airport_chatbot_active', true),
        '#description' => t('Active'),
        '#required' => FALSE
    );
    
    
    return system_settings_form($form);
}