<?php
class Parkade
{
	private $_ids;
	private $_name;
	private $_threshold;
	private $_parkadeCounters;
	private $_message = "Spaces available";

	function __construct($name, $ids, $threshold = 0, $overrideMessage = null)
	{
		$this->_ids = $ids;
		$this->_name = $name;
		$this->_threshold = $threshold;
		$this->_parkadeCounters = [];

		if (isset($overrideMessage)) {
			$this->_message = $overrideMessage;
		}
	}

	function addCounter($counter)
	{
		array_push($this->_parkadeCounters, $counter);
	}

	function getName()
	{
		return $this->_name;
	}

	function getIds()
	{
		return $this->_ids;
	}

	function getThreshold()
	{
		return $this->_threshold;
	}

	function hasLocation($id)
	{
		$hasId = false;

		foreach ($this->_ids as $location) {
			if ($id == $location) {
				$hasId = true;
				break;
			}
		}

		return $hasId;
	}

	function getAvailability()
	{
		$available = 0;

		foreach ($this->_parkadeCounters as $counter) {
			if (strcmp($counter->getAvailability(), "n/a") !==  0) {
				$available += $counter->getAvailability();
			} else {
				$available = $counter->getAvailability();
				break;
			}
		}

		return $available;
	}

	function getOccupied()
	{
		$occupied = 0;
		$capacity = $this->getCapacity();

		foreach ($this->_parkadeCounters as $counter) {
			if (strcmp($counter->getOccupied(), "n/a") !==  0) {
				$occupied += $counter->getOccupied();
			} else {
				$occupied = $counter->getOccupied();
				break;
			}
		}

		return $capacity < $occupied ? $capacity : $occupied;
	}

	function getCapacity()
	{
		$capacity = 0;

		foreach ($this->_parkadeCounters as $counter) {
			if (strcmp($counter->getCapacity(), "n/a") !==  0) {
				$capacity += $counter->getCapacity();
			} else {
				$capacity = $counter->getCapacity();
				break;
			}
		}

		if (strcmp($capacity, "n/a") !== 0) {
			$capacity -= $this->getThreshold();
		}

		return $capacity;
	}

	function getMessage()
	{
		$message = "";

		if (strcmp($this->getAvailability(), "n/a") === 0 && strcmp($this->getCapacity(), "n/a") === 0) {
			$message = $this->_message;
		} else if (($this->getAvailability() - $this->getThreshold()) > 0) {
			$message = $this->_message;
		}

		return $message;
	}
}
