<?php
class ParkadeCounter
{
	private $_id;
	private $_name;
	protected $_available;
	protected $_capacity;
	protected $_occupied;

	function __construct($parkadeJson)
	{
		$this->_id = $parkadeJson->lotID;
		$this->_name = $parkadeJson->lotName;
		$this->_available = $parkadeJson->curEmpty;
		$this->_capacity = $parkadeJson->curTotal;
		$this->_occupied = $parkadeJson->curOccupied;
	}

	function getAvailability()
	{
		if (isset($this->_available)) {
			return $this->_available > 0 ? $this->_available : 0;
		} else {
			return "n/a";
		}
	}

	function getOccupied()
	{
		if (isset($this->_occupied)) {
			return $this->_occupied > 0 ? $this->_occupied : 0;
		} else {
			return "n/a";
		}
	}

	function getCapacity()
	{
		if (isset($this->_capacity)) {
			return $this->_capacity > 0 ? $this->_capacity : 0;
		} else {
			return "n/a";
		}
	}

	function setAvailability($available)
	{
		$this->_available = $available;
	}

	function setCapacity($capacity)
	{
		$this->_capacity = $capacity;
	}

	function getName()
	{
		return $this->_name;
	}

	function getId()
	{
		return $this->_id;
	}

	function getMessage()
	{
		return "Spaces open";
	}
}
