<?php
require_once('ParkadeCounterFactory.php');
require_once('Parkade.php');

class Parkades
{
	private $_parkades = array();
	private $_isStatHoliday = false;

	function __construct()
	{
		$this->_parkades = array(
			new Parkade("Library Parkade", array(5169), 15),
			new Parkade("Memorial Parkade", array(5171, 5172), 15),
			new Parkade("Chapman Parkade", array(5173), 15)
		);
	}

	function isStatHoliday($url)
	{
		// Incase the url is not set
		if (!isset($url)) {
			return false;
		}

		// Create a cURL session
		$curl = curl_init($url);

		// Define cURL transfer options
		curl_setopt($curl, CURLOPT_HTTPHEADER, array(
			"Content-Type: application/json",
			"Accept: application/json",
		));
		curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);

		// Preform cURL session
		$response = curl_exec($curl);

		// Close cURL session
		curl_close($curl);

		// Decode JSON string
		$json = json_decode($response);

		// Get the current date formated as '2021-03-18'
		$currentDate = date("Y-m-d");

		// Loop through each holiday and check if the date matches today
		foreach ($json->province->holidays as $holiday) {
			if (strcmp($holiday->date, $currentDate) == 0) {
				$this->_isStatHoliday = true;
				break;
			}
		}
	}

	function loadParkades($url, $username, $password, $xFunctionsKey, $statHolidaysUrl)
	{
		// Check if it is a stat holiday to add to each parkade object
		$this->isStatHoliday($statHolidaysUrl);

		// Create a cURL session
		$curl = curl_init($url);

		// Define cURL transfer options
		curl_setopt($curl, CURLOPT_USERPWD, $username . ":" . $password);
		curl_setopt($curl, CURLOPT_HTTPHEADER, array(
			"Content-Type: application/json",
			"Accept: application/json",
			"X-FUNCTIONS-KEY:" . $xFunctionsKey
		));
		curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);

		// Preform cURL session
		$response = curl_exec($curl);

		// Close cURL session
		curl_close($curl);

		// Decode the response
		$parkadesJson = json_decode($response);

		foreach ($parkadesJson as $facility) {
			foreach ($this->_parkades as $i => $parkade) {
				$parkadeCounter = ParkadeCounterFactory::create($facility, $this->_isStatHoliday);
				if ($parkade->hasLocation($parkadeCounter->getId())) {
					$this->_parkades[$i]->addCounter($parkadeCounter);
					break;
				}
			}
		}
	}

	function writeParkades($filename)
	{
		$parkingFacilities = array();
		foreach ($this->_parkades as $parkade) {
			$facility = new stdClass();
			$facility->name = $parkade->getName();
			$facility->capacity = $parkade->getCapacity();
			$facility->available = $parkade->getAvailability();
			$facility->threshold = $parkade->getThreshold();
			$facility->occupied = $parkade->getOccupied();
			$facility->message = $parkade->getMessage();
			$facility->isStatHoliday = $this->_isStatHoliday;

			$lotIDs = $parkade->getIds();

			if (count($lotIDs) > 0) {
				$query = new EntityFieldQuery();
				$query->entityCondition('entity_type', 'node')
					->entityCondition('bundle', 'parking')
					->fieldCondition('field_lot_uid', 'value', $lotIDs[0], '=');
				$results = $query->execute();

				if (isset($results['node'])) {
					$nids = array_keys($results['node']);
					if (count($nids) > 0) {
						$node = node_load($nids[0]);
						$node_wrapper = entity_metadata_wrapper('node', $node);
						$node_wrapper->field_stalls_available->set($parkade->getAvailability());
						$node_wrapper->save();
					}
				}
			}

			array_push($parkingFacilities, $facility);
		}

		// Overwrite the data in parking.json
		file_put_contents($filename, json_encode($parkingFacilities));
	}

	function readParkades($filename)
	{
		$parkades = file_get_contents($filename);

		return json_decode($parkades);
	}

	function getNotifications($filename)
	{
		// Read previous values
		$hadAvailability = array();
		$facilities = $this->readParkades($filename);

		foreach ($facilities as $facility) {
			$hadAvailability[(string)$facility->name] = ((int)$facility->available - (int)$facility->threshold) > 0;
		}

		// Read current values
		$message = '';
		foreach ($this->_parkades as $parkade) {
			$hasAvailability = ($parkade->getAvailability() - $parkade->getThreshold()) > 0;
			if ($hadAvailability[$parkade->getName()] != $hasAvailability) {

				if (!$hasAvailability) {
					$message .= '<li>' . $parkade->getName() . ' is now full.</li>';
				} else {
					$message .= '<li>' . $parkade->getName() . ' is no longer full. There are now ' . $parkade->getAvailability() . ' stalls available.</li>';
				}
			}
		}

		if ($message != '') {
			$message = '<ul>' . $message . '</ul>';
		}

		return $message;
	}
}
