<?php
require_once('ParkadeCounter.php');

class ReservedParkadeCounter extends ParkadeCounter
{
	private $_isStatHoliday = false;

	function __construct($parkadeJson, $isStatHoliday)
	{
		$this->_isStatHoliday = $isStatHoliday;

		parent::__construct($parkadeJson);
	}

	function getAvailability()
	{
		if ($this->isAvailable()) {
			return parent::getAvailability();
		} else {
			return 0;
		}
	}

	function getOccupied()
	{
		if ($this->isAvailable()) {
			return parent::getOccupied();
		} else {
			return 0;
		}
	}

	function getCapacity()
	{
		if ($this->isAvailable()) {
			return parent::getCapacity();
		} else {
			return 0;
		}
	}

	private function isAvailable()
	{
		if ($this->_isStatHoliday) {
			return true;
		}

		$currentTime = getdate();
		if ($currentTime["wday"] < 1 || $currentTime["wday"] > 5) {
			return true;
		} else if ($currentTime["hours"] < 6 || $currentTime["hours"] >= 18) {
			return true;
		} else {
			return false;
		}
	}
}
