<?php

/**
 * @file
 * meetings_feature.views_default.inc
 */

/**
 * Implements hook_views_default_views().
 */
function meetings_feature_views_default_views() {
  $export = array();

  $view = new view();
  $view->name = 'meetings';
  $view->description = '';
  $view->tag = 'default';
  $view->base_table = 'node';
  $view->human_name = 'Meetings';
  $view->core = 7;
  $view->api_version = '3.0';
  $view->disabled = FALSE; /* Edit this to true to make a default view disabled initially */

  /* Display: Master */
  $handler = $view->new_display('default', 'Master', 'default');
  $handler->display->display_options['title'] = 'Meetings';
  $handler->display->display_options['use_more_always'] = FALSE;
  $handler->display->display_options['access']['type'] = 'perm';
  $handler->display->display_options['cache']['type'] = 'none';
  $handler->display->display_options['query']['type'] = 'views_query';
  $handler->display->display_options['exposed_form']['type'] = 'basic';
  $handler->display->display_options['pager']['type'] = 'full';
  $handler->display->display_options['pager']['options']['items_per_page'] = '10';
  $handler->display->display_options['style_plugin'] = 'table';
  /* Field: Content: Title */
  $handler->display->display_options['fields']['title']['id'] = 'title';
  $handler->display->display_options['fields']['title']['table'] = 'node';
  $handler->display->display_options['fields']['title']['field'] = 'title';
  $handler->display->display_options['fields']['title']['label'] = '';
  $handler->display->display_options['fields']['title']['alter']['word_boundary'] = FALSE;
  $handler->display->display_options['fields']['title']['alter']['ellipsis'] = FALSE;
  $handler->display->display_options['fields']['title']['element_label_colon'] = FALSE;
  /* Sort criterion: Content: Post date */
  $handler->display->display_options['sorts']['created']['id'] = 'created';
  $handler->display->display_options['sorts']['created']['table'] = 'node';
  $handler->display->display_options['sorts']['created']['field'] = 'created';
  $handler->display->display_options['sorts']['created']['order'] = 'DESC';
  /* Filter criterion: Content: Published status */
  $handler->display->display_options['filters']['status']['id'] = 'status';
  $handler->display->display_options['filters']['status']['table'] = 'node';
  $handler->display->display_options['filters']['status']['field'] = 'status';
  $handler->display->display_options['filters']['status']['value'] = 1;
  $handler->display->display_options['filters']['status']['group'] = 1;
  $handler->display->display_options['filters']['status']['expose']['operator'] = FALSE;
  /* Filter criterion: Content: Type */
  $handler->display->display_options['filters']['type']['id'] = 'type';
  $handler->display->display_options['filters']['type']['table'] = 'node';
  $handler->display->display_options['filters']['type']['field'] = 'type';
  $handler->display->display_options['filters']['type']['value'] = array(
    'meeting' => 'meeting',
  );
  /* Filter criterion: Content: Date -  start date (field_date) */
  $handler->display->display_options['filters']['field_date_value']['id'] = 'field_date_value';
  $handler->display->display_options['filters']['field_date_value']['table'] = 'field_data_field_date';
  $handler->display->display_options['filters']['field_date_value']['field'] = 'field_date_value';
  $handler->display->display_options['filters']['field_date_value']['operator'] = '>=';
  $handler->display->display_options['filters']['field_date_value']['default_date'] = 'now';

  /* Display: Page */
  $handler = $view->new_display('page', 'Page', 'page');
  $handler->display->display_options['path'] = 'rest/meetings';

  /* Display: Feed */
  $handler = $view->new_display('feed', 'Feed', 'feed');
  $handler->display->display_options['pager']['type'] = 'some';
  $handler->display->display_options['pager']['options']['items_per_page'] = '5';
  $handler->display->display_options['pager']['options']['offset'] = '0';
  $handler->display->display_options['style_plugin'] = 'rss';
  $handler->display->display_options['row_plugin'] = 'node_rss';
  $handler->display->display_options['defaults']['filter_groups'] = FALSE;
  $handler->display->display_options['defaults']['filters'] = FALSE;
  /* Filter criterion: Content: Published status */
  $handler->display->display_options['filters']['status']['id'] = 'status';
  $handler->display->display_options['filters']['status']['table'] = 'node';
  $handler->display->display_options['filters']['status']['field'] = 'status';
  $handler->display->display_options['filters']['status']['value'] = 1;
  $handler->display->display_options['filters']['status']['group'] = 1;
  $handler->display->display_options['filters']['status']['expose']['operator'] = FALSE;
  /* Filter criterion: Content: Type */
  $handler->display->display_options['filters']['type']['id'] = 'type';
  $handler->display->display_options['filters']['type']['table'] = 'node';
  $handler->display->display_options['filters']['type']['field'] = 'type';
  $handler->display->display_options['filters']['type']['value'] = array(
    'meeting' => 'meeting',
  );
  $handler->display->display_options['path'] = 'rss/meetings.xml';
  $handler->display->display_options['displays'] = array(
    'default' => 'default',
    'page' => 'page',
  );

  /* Display: Block */
  $handler = $view->new_display('block', 'Block', 'block');
  $handler->display->display_options['defaults']['title'] = FALSE;
  $handler->display->display_options['title'] = 'Meetings - Upcoming';
  $handler->display->display_options['defaults']['pager'] = FALSE;
  $handler->display->display_options['pager']['type'] = 'some';
  $handler->display->display_options['pager']['options']['items_per_page'] = '10';
  $handler->display->display_options['defaults']['style_plugin'] = FALSE;
  $handler->display->display_options['style_plugin'] = 'table';
  $handler->display->display_options['style_options']['columns'] = array(
    'title' => 'title',
    'field_date' => 'field_date',
    'field_meeting_location' => 'field_meeting_location',
  );
  $handler->display->display_options['style_options']['default'] = '-1';
  $handler->display->display_options['style_options']['info'] = array(
    'title' => array(
      'sortable' => 0,
      'default_sort_order' => 'asc',
      'align' => '',
      'separator' => '',
      'empty_column' => 0,
    ),
    'field_date' => array(
      'align' => '',
      'separator' => '',
      'empty_column' => 0,
    ),
    'field_meeting_location' => array(
      'sortable' => 0,
      'default_sort_order' => 'asc',
      'align' => '',
      'separator' => '',
      'empty_column' => 0,
    ),
  );
  $handler->display->display_options['defaults']['style_options'] = FALSE;
  $handler->display->display_options['defaults']['row_plugin'] = FALSE;
  $handler->display->display_options['defaults']['row_options'] = FALSE;
  $handler->display->display_options['defaults']['empty'] = FALSE;
  /* No results behavior: Global: Text area */
  $handler->display->display_options['empty']['area']['id'] = 'area';
  $handler->display->display_options['empty']['area']['table'] = 'views';
  $handler->display->display_options['empty']['area']['field'] = 'area';
  $handler->display->display_options['empty']['area']['empty'] = TRUE;
  $handler->display->display_options['empty']['area']['content'] = '<p>There are no upcoming meetings posted at this time. Please check back or subscribe to our <a href="/rss/meetings.xml">RSS feed</a> for notification.</p>';
  $handler->display->display_options['empty']['area']['format'] = 'full_html';
  $handler->display->display_options['defaults']['fields'] = FALSE;
  /* Field: Content: Title */
  $handler->display->display_options['fields']['title']['id'] = 'title';
  $handler->display->display_options['fields']['title']['table'] = 'node';
  $handler->display->display_options['fields']['title']['field'] = 'title';
  $handler->display->display_options['fields']['title']['label'] = 'Meeting';
  $handler->display->display_options['fields']['title']['alter']['word_boundary'] = FALSE;
  $handler->display->display_options['fields']['title']['alter']['ellipsis'] = FALSE;
  $handler->display->display_options['fields']['title']['element_label_colon'] = FALSE;
  $handler->display->display_options['fields']['title']['link_to_node'] = FALSE;
  /* Field: Content: Date */
  $handler->display->display_options['fields']['field_date']['id'] = 'field_date';
  $handler->display->display_options['fields']['field_date']['table'] = 'field_data_field_date';
  $handler->display->display_options['fields']['field_date']['field'] = 'field_date';
  $handler->display->display_options['fields']['field_date']['element_label_colon'] = FALSE;
  $handler->display->display_options['fields']['field_date']['settings'] = array(
    'format_type' => 'month_day_year_time',
    'fromto' => 'both',
    'multiple_number' => '',
    'multiple_from' => '',
    'multiple_to' => '',
    'show_remaining_days' => 0,
    'show_repeat_rule' => 'show',
    'linked_field' => array(
      'linked' => 0,
      'destination' => '',
      'advanced' => array(
        'title' => '',
        'target' => '',
        'class' => '',
        'rel' => '',
        'text' => '',
      ),
    ),
  );
  $handler->display->display_options['fields']['field_date']['delta_offset'] = '0';
  /* Field: Content: Meeting Address */
  $handler->display->display_options['fields']['field_meeting_address']['id'] = 'field_meeting_address';
  $handler->display->display_options['fields']['field_meeting_address']['table'] = 'field_data_field_meeting_address';
  $handler->display->display_options['fields']['field_meeting_address']['field'] = 'field_meeting_address';
  $handler->display->display_options['fields']['field_meeting_address']['label'] = '';
  $handler->display->display_options['fields']['field_meeting_address']['exclude'] = TRUE;
  $handler->display->display_options['fields']['field_meeting_address']['element_label_colon'] = FALSE;
  $handler->display->display_options['fields']['field_meeting_address']['type'] = 'text_plain';
  $handler->display->display_options['fields']['field_meeting_address']['settings'] = array(
    'linked_field' => array(
      'linked' => 0,
      'destination' => '',
      'advanced' => array(
        'title' => '',
        'target' => '',
        'class' => '',
        'rel' => '',
        'text' => '',
      ),
    ),
  );
  /* Field: Content: Meeting Location */
  $handler->display->display_options['fields']['field_meeting_location']['id'] = 'field_meeting_location';
  $handler->display->display_options['fields']['field_meeting_location']['table'] = 'field_data_field_meeting_location';
  $handler->display->display_options['fields']['field_meeting_location']['field'] = 'field_meeting_location';
  $handler->display->display_options['fields']['field_meeting_location']['label'] = 'Location';
  $handler->display->display_options['fields']['field_meeting_location']['alter']['alter_text'] = TRUE;
  $handler->display->display_options['fields']['field_meeting_location']['alter']['text'] = '[field_meeting_location]<br>
[field_meeting_address]';
  $handler->display->display_options['fields']['field_meeting_location']['element_label_colon'] = FALSE;
  $handler->display->display_options['fields']['field_meeting_location']['settings'] = array(
    'linked_field' => array(
      'linked' => 0,
      'destination' => '',
      'advanced' => array(
        'title' => '',
        'target' => '',
        'class' => '',
        'rel' => '',
        'text' => '',
      ),
    ),
  );
  /* Field: Content: Meeting Agenda HTML */
  $handler->display->display_options['fields']['field_meeting_agenda_html']['id'] = 'field_meeting_agenda_html';
  $handler->display->display_options['fields']['field_meeting_agenda_html']['table'] = 'field_data_field_meeting_agenda_html';
  $handler->display->display_options['fields']['field_meeting_agenda_html']['field'] = 'field_meeting_agenda_html';
  $handler->display->display_options['fields']['field_meeting_agenda_html']['label'] = '';
  $handler->display->display_options['fields']['field_meeting_agenda_html']['exclude'] = TRUE;
  $handler->display->display_options['fields']['field_meeting_agenda_html']['alter']['alter_text'] = TRUE;
  $handler->display->display_options['fields']['field_meeting_agenda_html']['alter']['text'] = '<a href="[field_meeting_agenda_html]" target="_blank">HTML</a>';
  $handler->display->display_options['fields']['field_meeting_agenda_html']['element_label_colon'] = FALSE;
  $handler->display->display_options['fields']['field_meeting_agenda_html']['settings'] = array(
    'linked_field' => array(
      'linked' => 0,
      'destination' => '',
      'advanced' => array(
        'title' => '',
        'target' => '',
        'class' => '',
        'rel' => '',
        'text' => '',
      ),
    ),
  );
  /* Field: Content: Meeting Agenda PDF */
  $handler->display->display_options['fields']['field_meeting_agenda_pdf']['id'] = 'field_meeting_agenda_pdf';
  $handler->display->display_options['fields']['field_meeting_agenda_pdf']['table'] = 'field_data_field_meeting_agenda_pdf';
  $handler->display->display_options['fields']['field_meeting_agenda_pdf']['field'] = 'field_meeting_agenda_pdf';
  $handler->display->display_options['fields']['field_meeting_agenda_pdf']['label'] = '';
  $handler->display->display_options['fields']['field_meeting_agenda_pdf']['exclude'] = TRUE;
  $handler->display->display_options['fields']['field_meeting_agenda_pdf']['alter']['alter_text'] = TRUE;
  $handler->display->display_options['fields']['field_meeting_agenda_pdf']['alter']['text'] = '<a href="[field_meeting_agenda_pdf]" target="_blank">PDF</a>';
  $handler->display->display_options['fields']['field_meeting_agenda_pdf']['element_label_colon'] = FALSE;
  $handler->display->display_options['fields']['field_meeting_agenda_pdf']['settings'] = array(
    'linked_field' => array(
      'linked' => 0,
      'destination' => '',
      'advanced' => array(
        'title' => '',
        'target' => '',
        'class' => '',
        'rel' => '',
        'text' => '',
      ),
    ),
  );
  /* Field: Global: Custom text */
  $handler->display->display_options['fields']['nothing']['id'] = 'nothing';
  $handler->display->display_options['fields']['nothing']['table'] = 'views';
  $handler->display->display_options['fields']['nothing']['field'] = 'nothing';
  $handler->display->display_options['fields']['nothing']['label'] = 'Agenda';
  $handler->display->display_options['fields']['nothing']['alter']['text'] = '[field_meeting_agenda_html] | [field_meeting_agenda_pdf]';
  $handler->display->display_options['fields']['nothing']['element_label_colon'] = FALSE;
  $handler->display->display_options['defaults']['sorts'] = FALSE;
  /* Sort criterion: Content: Date -  start date (field_date) */
  $handler->display->display_options['sorts']['field_date_value']['id'] = 'field_date_value';
  $handler->display->display_options['sorts']['field_date_value']['table'] = 'field_data_field_date';
  $handler->display->display_options['sorts']['field_date_value']['field'] = 'field_date_value';
  $handler->display->display_options['defaults']['filter_groups'] = FALSE;
  $handler->display->display_options['defaults']['filters'] = FALSE;
  /* Filter criterion: Content: Published status */
  $handler->display->display_options['filters']['status']['id'] = 'status';
  $handler->display->display_options['filters']['status']['table'] = 'node';
  $handler->display->display_options['filters']['status']['field'] = 'status';
  $handler->display->display_options['filters']['status']['value'] = 1;
  $handler->display->display_options['filters']['status']['group'] = 1;
  $handler->display->display_options['filters']['status']['expose']['operator'] = FALSE;
  /* Filter criterion: Content: Type */
  $handler->display->display_options['filters']['type']['id'] = 'type';
  $handler->display->display_options['filters']['type']['table'] = 'node';
  $handler->display->display_options['filters']['type']['field'] = 'type';
  $handler->display->display_options['filters']['type']['value'] = array(
    'meeting' => 'meeting',
  );
  /* Filter criterion: Content: Date -  start date (field_date) */
  $handler->display->display_options['filters']['field_date_value']['id'] = 'field_date_value';
  $handler->display->display_options['filters']['field_date_value']['table'] = 'field_data_field_date';
  $handler->display->display_options['filters']['field_date_value']['field'] = 'field_date_value';
  $handler->display->display_options['filters']['field_date_value']['operator'] = '>=';
  $handler->display->display_options['filters']['field_date_value']['default_date'] = 'now';
  /* Filter criterion: Content: Meeting Type (field_meeting_type) */
  $handler->display->display_options['filters']['field_meeting_type_tid']['id'] = 'field_meeting_type_tid';
  $handler->display->display_options['filters']['field_meeting_type_tid']['table'] = 'field_data_field_meeting_type';
  $handler->display->display_options['filters']['field_meeting_type_tid']['field'] = 'field_meeting_type_tid';
  $handler->display->display_options['filters']['field_meeting_type_tid']['value'] = array(
    1006 => '1006',
    2346 => '2346',
    1009 => '1009',
    2379 => '2379',
    1007 => '1007',
    913 => '913',
    912 => '912',
    2384 => '2384',
    1008 => '1008',
  );
  $handler->display->display_options['filters']['field_meeting_type_tid']['type'] = 'select';
  $handler->display->display_options['filters']['field_meeting_type_tid']['vocabulary'] = 'meeting_type';
  $handler->display->display_options['block_description'] = 'Meetings - Upcoming';

  /* Display: Block */
  $handler = $view->new_display('block', 'Block', 'block_1');
  $handler->display->display_options['defaults']['title'] = FALSE;
  $handler->display->display_options['title'] = 'Meetings - Past';
  $handler->display->display_options['defaults']['pager'] = FALSE;
  $handler->display->display_options['pager']['type'] = 'none';
  $handler->display->display_options['pager']['options']['offset'] = '0';
  $handler->display->display_options['defaults']['style_plugin'] = FALSE;
  $handler->display->display_options['style_plugin'] = 'table';
  $handler->display->display_options['style_options']['grouping'] = array(
    0 => array(
      'field' => 'field_meeting_type',
      'rendered' => 1,
      'rendered_strip' => 0,
    ),
  );
  $handler->display->display_options['style_options']['columns'] = array(
    'title' => 'title',
    'field_date' => 'field_date',
    'field_meeting_location' => 'field_meeting_location',
    'field_meeting_agenda_html' => 'field_meeting_agenda_html',
    'field_meeting_agenda_pdf' => 'field_meeting_agenda_pdf',
    'nothing' => 'nothing',
    'field_meeting_type' => 'field_meeting_type',
  );
  $handler->display->display_options['style_options']['default'] = '-1';
  $handler->display->display_options['style_options']['info'] = array(
    'title' => array(
      'sortable' => 0,
      'default_sort_order' => 'asc',
      'align' => '',
      'separator' => '',
      'empty_column' => 0,
    ),
    'field_date' => array(
      'align' => '',
      'separator' => '',
      'empty_column' => 0,
    ),
    'field_meeting_location' => array(
      'sortable' => 0,
      'default_sort_order' => 'asc',
      'align' => '',
      'separator' => '',
      'empty_column' => 0,
    ),
    'field_meeting_agenda_html' => array(
      'sortable' => 0,
      'default_sort_order' => 'asc',
      'align' => '',
      'separator' => '',
      'empty_column' => 0,
    ),
    'field_meeting_agenda_pdf' => array(
      'sortable' => 0,
      'default_sort_order' => 'asc',
      'align' => '',
      'separator' => '',
      'empty_column' => 0,
    ),
    'nothing' => array(
      'align' => '',
      'separator' => '',
      'empty_column' => 0,
    ),
    'field_meeting_type' => array(
      'sortable' => 0,
      'default_sort_order' => 'asc',
      'align' => '',
      'separator' => '',
      'empty_column' => 0,
    ),
  );
  $handler->display->display_options['defaults']['style_options'] = FALSE;
  $handler->display->display_options['defaults']['row_plugin'] = FALSE;
  $handler->display->display_options['defaults']['row_options'] = FALSE;
  $handler->display->display_options['defaults']['fields'] = FALSE;
  /* Field: Content: Meeting Type */
  $handler->display->display_options['fields']['field_meeting_type']['id'] = 'field_meeting_type';
  $handler->display->display_options['fields']['field_meeting_type']['table'] = 'field_data_field_meeting_type';
  $handler->display->display_options['fields']['field_meeting_type']['field'] = 'field_meeting_type';
  $handler->display->display_options['fields']['field_meeting_type']['label'] = '';
  $handler->display->display_options['fields']['field_meeting_type']['exclude'] = TRUE;
  $handler->display->display_options['fields']['field_meeting_type']['element_label_colon'] = FALSE;
  $handler->display->display_options['fields']['field_meeting_type']['type'] = 'taxonomy_term_reference_plain';
  $handler->display->display_options['fields']['field_meeting_type']['settings'] = array(
    'linked_field' => array(
      'linked' => 0,
      'destination' => '',
      'advanced' => array(
        'title' => '',
        'target' => '',
        'class' => '',
        'rel' => '',
        'text' => '',
      ),
    ),
  );
  /* Field: Content: Date */
  $handler->display->display_options['fields']['field_date']['id'] = 'field_date';
  $handler->display->display_options['fields']['field_date']['table'] = 'field_data_field_date';
  $handler->display->display_options['fields']['field_date']['field'] = 'field_date';
  $handler->display->display_options['fields']['field_date']['element_label_colon'] = FALSE;
  $handler->display->display_options['fields']['field_date']['settings'] = array(
    'format_type' => 'month_day_year_time',
    'fromto' => 'value',
    'multiple_number' => '',
    'multiple_from' => '',
    'multiple_to' => '',
    'show_remaining_days' => 0,
    'show_repeat_rule' => 'show',
    'linked_field' => array(
      'linked' => 0,
      'destination' => '',
      'advanced' => array(
        'title' => '',
        'target' => '',
        'class' => '',
        'rel' => '',
        'text' => '',
      ),
    ),
  );
  $handler->display->display_options['fields']['field_date']['delta_offset'] = '0';
  /* Field: Content: Meeting Address */
  $handler->display->display_options['fields']['field_meeting_address']['id'] = 'field_meeting_address';
  $handler->display->display_options['fields']['field_meeting_address']['table'] = 'field_data_field_meeting_address';
  $handler->display->display_options['fields']['field_meeting_address']['field'] = 'field_meeting_address';
  $handler->display->display_options['fields']['field_meeting_address']['label'] = '';
  $handler->display->display_options['fields']['field_meeting_address']['exclude'] = TRUE;
  $handler->display->display_options['fields']['field_meeting_address']['element_label_colon'] = FALSE;
  $handler->display->display_options['fields']['field_meeting_address']['type'] = 'text_plain';
  $handler->display->display_options['fields']['field_meeting_address']['settings'] = array(
    'linked_field' => array(
      'linked' => 0,
      'destination' => '',
      'advanced' => array(
        'title' => '',
        'target' => '',
        'class' => '',
        'rel' => '',
        'text' => '',
      ),
    ),
  );
  /* Field: Content: Meeting Location */
  $handler->display->display_options['fields']['field_meeting_location']['id'] = 'field_meeting_location';
  $handler->display->display_options['fields']['field_meeting_location']['table'] = 'field_data_field_meeting_location';
  $handler->display->display_options['fields']['field_meeting_location']['field'] = 'field_meeting_location';
  $handler->display->display_options['fields']['field_meeting_location']['label'] = 'Location';
  $handler->display->display_options['fields']['field_meeting_location']['alter']['alter_text'] = TRUE;
  $handler->display->display_options['fields']['field_meeting_location']['alter']['text'] = '[field_meeting_location]<br>
[field_meeting_address]
';
  $handler->display->display_options['fields']['field_meeting_location']['element_label_colon'] = FALSE;
  $handler->display->display_options['fields']['field_meeting_location']['type'] = 'text_plain';
  $handler->display->display_options['fields']['field_meeting_location']['settings'] = array(
    'linked_field' => array(
      'linked' => 0,
      'destination' => '',
      'advanced' => array(
        'title' => '',
        'target' => '',
        'class' => '',
        'rel' => '',
        'text' => '',
      ),
    ),
  );
  /* Field: Content: Meeting Agenda HTML */
  $handler->display->display_options['fields']['field_meeting_agenda_html']['id'] = 'field_meeting_agenda_html';
  $handler->display->display_options['fields']['field_meeting_agenda_html']['table'] = 'field_data_field_meeting_agenda_html';
  $handler->display->display_options['fields']['field_meeting_agenda_html']['field'] = 'field_meeting_agenda_html';
  $handler->display->display_options['fields']['field_meeting_agenda_html']['label'] = '';
  $handler->display->display_options['fields']['field_meeting_agenda_html']['exclude'] = TRUE;
  $handler->display->display_options['fields']['field_meeting_agenda_html']['alter']['alter_text'] = TRUE;
  $handler->display->display_options['fields']['field_meeting_agenda_html']['alter']['text'] = '<a href="[field_meeting_agenda_html]" target="_blank">HTML</a>';
  $handler->display->display_options['fields']['field_meeting_agenda_html']['element_label_colon'] = FALSE;
  $handler->display->display_options['fields']['field_meeting_agenda_html']['settings'] = array(
    'linked_field' => array(
      'linked' => 0,
      'destination' => '',
      'advanced' => array(
        'title' => '',
        'target' => '',
        'class' => '',
        'rel' => '',
        'text' => '',
      ),
    ),
  );
  /* Field: Content: Meeting Agenda PDF */
  $handler->display->display_options['fields']['field_meeting_agenda_pdf']['id'] = 'field_meeting_agenda_pdf';
  $handler->display->display_options['fields']['field_meeting_agenda_pdf']['table'] = 'field_data_field_meeting_agenda_pdf';
  $handler->display->display_options['fields']['field_meeting_agenda_pdf']['field'] = 'field_meeting_agenda_pdf';
  $handler->display->display_options['fields']['field_meeting_agenda_pdf']['label'] = '';
  $handler->display->display_options['fields']['field_meeting_agenda_pdf']['exclude'] = TRUE;
  $handler->display->display_options['fields']['field_meeting_agenda_pdf']['alter']['alter_text'] = TRUE;
  $handler->display->display_options['fields']['field_meeting_agenda_pdf']['alter']['text'] = '<a href="[field_meeting_agenda_pdf]" target="_blank">PDF</a>';
  $handler->display->display_options['fields']['field_meeting_agenda_pdf']['element_label_colon'] = FALSE;
  $handler->display->display_options['fields']['field_meeting_agenda_pdf']['settings'] = array(
    'linked_field' => array(
      'linked' => 0,
      'destination' => '',
      'advanced' => array(
        'title' => '',
        'target' => '',
        'class' => '',
        'rel' => '',
        'text' => '',
      ),
    ),
  );
  /* Field: Global: Custom text */
  $handler->display->display_options['fields']['nothing']['id'] = 'nothing';
  $handler->display->display_options['fields']['nothing']['table'] = 'views';
  $handler->display->display_options['fields']['nothing']['field'] = 'nothing';
  $handler->display->display_options['fields']['nothing']['label'] = 'Agenda';
  $handler->display->display_options['fields']['nothing']['alter']['text'] = '[field_meeting_agenda_html] | [field_meeting_agenda_pdf]';
  $handler->display->display_options['fields']['nothing']['element_label_colon'] = FALSE;
  /* Field: Content: Meeting Minutes PDF */
  $handler->display->display_options['fields']['field_meeting_minutes_pdf']['id'] = 'field_meeting_minutes_pdf';
  $handler->display->display_options['fields']['field_meeting_minutes_pdf']['table'] = 'field_data_field_meeting_minutes_pdf';
  $handler->display->display_options['fields']['field_meeting_minutes_pdf']['field'] = 'field_meeting_minutes_pdf';
  $handler->display->display_options['fields']['field_meeting_minutes_pdf']['label'] = 'Minutes';
  $handler->display->display_options['fields']['field_meeting_minutes_pdf']['alter']['alter_text'] = TRUE;
  $handler->display->display_options['fields']['field_meeting_minutes_pdf']['alter']['text'] = '<a href="[field_meeting_minutes_pdf]" target="_blank">PDF</a>';
  $handler->display->display_options['fields']['field_meeting_minutes_pdf']['element_label_colon'] = FALSE;
  $handler->display->display_options['fields']['field_meeting_minutes_pdf']['settings'] = array(
    'linked_field' => array(
      'linked' => 0,
      'destination' => '',
      'advanced' => array(
        'title' => '',
        'target' => '',
        'class' => '',
        'rel' => '',
        'text' => '',
      ),
    ),
  );
  $handler->display->display_options['defaults']['sorts'] = FALSE;
  /* Sort criterion: Content: Date -  start date (field_date) */
  $handler->display->display_options['sorts']['field_date_value']['id'] = 'field_date_value';
  $handler->display->display_options['sorts']['field_date_value']['table'] = 'field_data_field_date';
  $handler->display->display_options['sorts']['field_date_value']['field'] = 'field_date_value';
  $handler->display->display_options['sorts']['field_date_value']['order'] = 'DESC';
  $handler->display->display_options['defaults']['filter_groups'] = FALSE;
  $handler->display->display_options['defaults']['filters'] = FALSE;
  /* Filter criterion: Content: Published status */
  $handler->display->display_options['filters']['status']['id'] = 'status';
  $handler->display->display_options['filters']['status']['table'] = 'node';
  $handler->display->display_options['filters']['status']['field'] = 'status';
  $handler->display->display_options['filters']['status']['value'] = 1;
  $handler->display->display_options['filters']['status']['group'] = 1;
  $handler->display->display_options['filters']['status']['expose']['operator'] = FALSE;
  /* Filter criterion: Content: Type */
  $handler->display->display_options['filters']['type']['id'] = 'type';
  $handler->display->display_options['filters']['type']['table'] = 'node';
  $handler->display->display_options['filters']['type']['field'] = 'type';
  $handler->display->display_options['filters']['type']['value'] = array(
    'meeting' => 'meeting',
  );
  $handler->display->display_options['filters']['type']['group'] = 1;
  /* Filter criterion: Content: Date -  start date (field_date) */
  $handler->display->display_options['filters']['field_date_value_1']['id'] = 'field_date_value_1';
  $handler->display->display_options['filters']['field_date_value_1']['table'] = 'field_data_field_date';
  $handler->display->display_options['filters']['field_date_value_1']['field'] = 'field_date_value';
  $handler->display->display_options['filters']['field_date_value_1']['operator'] = '<=';
  $handler->display->display_options['filters']['field_date_value_1']['group'] = 1;
  $handler->display->display_options['filters']['field_date_value_1']['default_date'] = 'now';
  /* Filter criterion: Content: Meeting Type (field_meeting_type) */
  $handler->display->display_options['filters']['field_meeting_type_tid']['id'] = 'field_meeting_type_tid';
  $handler->display->display_options['filters']['field_meeting_type_tid']['table'] = 'field_data_field_meeting_type';
  $handler->display->display_options['filters']['field_meeting_type_tid']['field'] = 'field_meeting_type_tid';
  $handler->display->display_options['filters']['field_meeting_type_tid']['value'] = array(
    1006 => '1006',
    2346 => '2346',
    1009 => '1009',
    2379 => '2379',
    1007 => '1007',
    913 => '913',
    912 => '912',
    1008 => '1008',
  );
  $handler->display->display_options['filters']['field_meeting_type_tid']['group'] = 1;
  $handler->display->display_options['filters']['field_meeting_type_tid']['type'] = 'select';
  $handler->display->display_options['filters']['field_meeting_type_tid']['vocabulary'] = 'meeting_type';
  /* Filter criterion: Content: Date -  start date (field_date) */
  $handler->display->display_options['filters']['field_date_value']['id'] = 'field_date_value';
  $handler->display->display_options['filters']['field_date_value']['table'] = 'field_data_field_date';
  $handler->display->display_options['filters']['field_date_value']['field'] = 'field_date_value';
  $handler->display->display_options['filters']['field_date_value']['operator'] = '>=';
  $handler->display->display_options['filters']['field_date_value']['granularity'] = 'year';
  $handler->display->display_options['filters']['field_date_value']['default_date'] = 'now - 1 year';
  $handler->display->display_options['block_description'] = 'Meetings - Past';

  /* Display: Detail View */
  $handler = $view->new_display('block', 'Detail View', 'block_2');
  $handler->display->display_options['defaults']['pager'] = FALSE;
  $handler->display->display_options['pager']['type'] = 'none';
  $handler->display->display_options['pager']['options']['offset'] = '0';
  $handler->display->display_options['defaults']['style_plugin'] = FALSE;
  $handler->display->display_options['style_plugin'] = 'default';
  $handler->display->display_options['defaults']['style_options'] = FALSE;
  $handler->display->display_options['defaults']['row_plugin'] = FALSE;
  $handler->display->display_options['row_plugin'] = 'fields';
  $handler->display->display_options['defaults']['row_options'] = FALSE;
  $handler->display->display_options['defaults']['fields'] = FALSE;
  /* Field: Content: Meeting Type */
  $handler->display->display_options['fields']['field_meeting_type']['id'] = 'field_meeting_type';
  $handler->display->display_options['fields']['field_meeting_type']['table'] = 'field_data_field_meeting_type';
  $handler->display->display_options['fields']['field_meeting_type']['field'] = 'field_meeting_type';
  $handler->display->display_options['fields']['field_meeting_type']['label'] = '';
  $handler->display->display_options['fields']['field_meeting_type']['exclude'] = TRUE;
  $handler->display->display_options['fields']['field_meeting_type']['element_label_colon'] = FALSE;
  $handler->display->display_options['fields']['field_meeting_type']['type'] = 'taxonomy_term_reference_plain';
  $handler->display->display_options['fields']['field_meeting_type']['settings'] = array(
    'linked_field' => array(
      'linked' => 0,
      'destination' => '',
      'advanced' => array(
        'title' => '',
        'target' => '',
        'class' => '',
        'rel' => '',
        'text' => '',
      ),
    ),
  );
  /* Field: Content: Date */
  $handler->display->display_options['fields']['field_date']['id'] = 'field_date';
  $handler->display->display_options['fields']['field_date']['table'] = 'field_data_field_date';
  $handler->display->display_options['fields']['field_date']['field'] = 'field_date';
  $handler->display->display_options['fields']['field_date']['label'] = '';
  $handler->display->display_options['fields']['field_date']['alter']['alter_text'] = TRUE;
  $handler->display->display_options['fields']['field_date']['alter']['text'] = '[field_date] - [field_meeting_type]';
  $handler->display->display_options['fields']['field_date']['element_type'] = 'h2';
  $handler->display->display_options['fields']['field_date']['element_label_colon'] = FALSE;
  $handler->display->display_options['fields']['field_date']['settings'] = array(
    'format_type' => 'month_day_year',
    'fromto' => 'value',
    'multiple_number' => '',
    'multiple_from' => '',
    'multiple_to' => '',
    'show_remaining_days' => 0,
    'show_repeat_rule' => 'show',
    'linked_field' => array(
      'linked' => 0,
      'destination' => '',
      'advanced' => array(
        'title' => '',
        'target' => '',
        'class' => '',
        'rel' => '',
        'text' => '',
      ),
    ),
  );
  $handler->display->display_options['fields']['field_date']['delta_offset'] = '0';
  /* Field: Content: Meeting Address */
  $handler->display->display_options['fields']['field_meeting_address']['id'] = 'field_meeting_address';
  $handler->display->display_options['fields']['field_meeting_address']['table'] = 'field_data_field_meeting_address';
  $handler->display->display_options['fields']['field_meeting_address']['field'] = 'field_meeting_address';
  $handler->display->display_options['fields']['field_meeting_address']['label'] = 'Address';
  $handler->display->display_options['fields']['field_meeting_address']['alter']['strip_tags'] = TRUE;
  $handler->display->display_options['fields']['field_meeting_address']['element_label_type'] = 'strong';
  $handler->display->display_options['fields']['field_meeting_address']['element_label_colon'] = FALSE;
  $handler->display->display_options['fields']['field_meeting_address']['hide_empty'] = TRUE;
  $handler->display->display_options['fields']['field_meeting_address']['settings'] = array(
    'linked_field' => array(
      'linked' => 0,
      'destination' => '',
      'advanced' => array(
        'title' => '',
        'target' => '',
        'class' => '',
        'rel' => '',
        'text' => '',
      ),
    ),
  );
  /* Field: Content: Meeting Agenda HTML */
  $handler->display->display_options['fields']['field_meeting_agenda_html']['id'] = 'field_meeting_agenda_html';
  $handler->display->display_options['fields']['field_meeting_agenda_html']['table'] = 'field_data_field_meeting_agenda_html';
  $handler->display->display_options['fields']['field_meeting_agenda_html']['field'] = 'field_meeting_agenda_html';
  $handler->display->display_options['fields']['field_meeting_agenda_html']['label'] = '';
  $handler->display->display_options['fields']['field_meeting_agenda_html']['exclude'] = TRUE;
  $handler->display->display_options['fields']['field_meeting_agenda_html']['alter']['alter_text'] = TRUE;
  $handler->display->display_options['fields']['field_meeting_agenda_html']['alter']['text'] = '<a href="[field_meeting_agenda_html]">Agenda HTML</a>';
  $handler->display->display_options['fields']['field_meeting_agenda_html']['element_label_colon'] = FALSE;
  $handler->display->display_options['fields']['field_meeting_agenda_html']['settings'] = array(
    'linked_field' => array(
      'linked' => 0,
      'destination' => '',
      'advanced' => array(
        'title' => '',
        'target' => '',
        'class' => '',
        'rel' => '',
        'text' => '',
      ),
    ),
  );
  /* Field: Content: Meeting Agenda PDF */
  $handler->display->display_options['fields']['field_meeting_agenda_pdf']['id'] = 'field_meeting_agenda_pdf';
  $handler->display->display_options['fields']['field_meeting_agenda_pdf']['table'] = 'field_data_field_meeting_agenda_pdf';
  $handler->display->display_options['fields']['field_meeting_agenda_pdf']['field'] = 'field_meeting_agenda_pdf';
  $handler->display->display_options['fields']['field_meeting_agenda_pdf']['label'] = '';
  $handler->display->display_options['fields']['field_meeting_agenda_pdf']['exclude'] = TRUE;
  $handler->display->display_options['fields']['field_meeting_agenda_pdf']['alter']['alter_text'] = TRUE;
  $handler->display->display_options['fields']['field_meeting_agenda_pdf']['alter']['text'] = '<a href="[field_meeting_agenda_pdf]">Agenda PDF</a>';
  $handler->display->display_options['fields']['field_meeting_agenda_pdf']['element_label_colon'] = FALSE;
  $handler->display->display_options['fields']['field_meeting_agenda_pdf']['settings'] = array(
    'linked_field' => array(
      'linked' => 0,
      'destination' => '',
      'advanced' => array(
        'title' => '',
        'target' => '',
        'class' => '',
        'rel' => '',
        'text' => '',
      ),
    ),
  );
  /* Field: Content: Meeting Location */
  $handler->display->display_options['fields']['field_meeting_location']['id'] = 'field_meeting_location';
  $handler->display->display_options['fields']['field_meeting_location']['table'] = 'field_data_field_meeting_location';
  $handler->display->display_options['fields']['field_meeting_location']['field'] = 'field_meeting_location';
  $handler->display->display_options['fields']['field_meeting_location']['label'] = 'Location';
  $handler->display->display_options['fields']['field_meeting_location']['element_label_type'] = 'strong';
  $handler->display->display_options['fields']['field_meeting_location']['element_label_colon'] = FALSE;
  $handler->display->display_options['fields']['field_meeting_location']['hide_empty'] = TRUE;
  $handler->display->display_options['fields']['field_meeting_location']['settings'] = array(
    'linked_field' => array(
      'linked' => 0,
      'destination' => '',
      'advanced' => array(
        'title' => '',
        'target' => '',
        'class' => '',
        'rel' => '',
        'text' => '',
      ),
    ),
  );
  /* Field: Content: Meeting Minutes PDF */
  $handler->display->display_options['fields']['field_meeting_minutes_pdf']['id'] = 'field_meeting_minutes_pdf';
  $handler->display->display_options['fields']['field_meeting_minutes_pdf']['table'] = 'field_data_field_meeting_minutes_pdf';
  $handler->display->display_options['fields']['field_meeting_minutes_pdf']['field'] = 'field_meeting_minutes_pdf';
  $handler->display->display_options['fields']['field_meeting_minutes_pdf']['label'] = '';
  $handler->display->display_options['fields']['field_meeting_minutes_pdf']['exclude'] = TRUE;
  $handler->display->display_options['fields']['field_meeting_minutes_pdf']['alter']['alter_text'] = TRUE;
  $handler->display->display_options['fields']['field_meeting_minutes_pdf']['alter']['text'] = '<a href="[field_meeting_minutes_pdf]">Minutes PDF</a>';
  $handler->display->display_options['fields']['field_meeting_minutes_pdf']['element_label_colon'] = FALSE;
  $handler->display->display_options['fields']['field_meeting_minutes_pdf']['settings'] = array(
    'linked_field' => array(
      'linked' => 0,
      'destination' => '',
      'advanced' => array(
        'title' => '',
        'target' => '',
        'class' => '',
        'rel' => '',
        'text' => '',
      ),
    ),
  );
  /* Field: Global: Custom text */
  $handler->display->display_options['fields']['nothing']['id'] = 'nothing';
  $handler->display->display_options['fields']['nothing']['table'] = 'views';
  $handler->display->display_options['fields']['nothing']['field'] = 'nothing';
  $handler->display->display_options['fields']['nothing']['label'] = '';
  $handler->display->display_options['fields']['nothing']['alter']['text'] = '<h4>[field_meeting_agenda_html] [field_meeting_agenda_pdf] [field_meeting_minutes_pdf]</h4>';
  $handler->display->display_options['fields']['nothing']['element_label_colon'] = FALSE;
  /* Field: Content: Meeting Attachment */
  $handler->display->display_options['fields']['field_meeting_attachment']['id'] = 'field_meeting_attachment';
  $handler->display->display_options['fields']['field_meeting_attachment']['table'] = 'field_data_field_meeting_attachment';
  $handler->display->display_options['fields']['field_meeting_attachment']['field'] = 'field_meeting_attachment';
  $handler->display->display_options['fields']['field_meeting_attachment']['label'] = 'Meeting Attachments';
  $handler->display->display_options['fields']['field_meeting_attachment']['alter']['alter_text'] = TRUE;
  $handler->display->display_options['fields']['field_meeting_attachment']['alter']['text'] = '<a href="[field_meeting_attachment-value]" target="_blank" class="pdf">[field_meeting_attachment-value] </a>';
  $handler->display->display_options['fields']['field_meeting_attachment']['element_label_type'] = 'strong';
  $handler->display->display_options['fields']['field_meeting_attachment']['element_label_colon'] = FALSE;
  $handler->display->display_options['fields']['field_meeting_attachment']['settings'] = array(
    'linked_field' => array(
      'linked' => 0,
      'destination' => '',
      'advanced' => array(
        'title' => '',
        'target' => '',
        'class' => '',
        'rel' => '',
        'text' => '',
      ),
    ),
  );
  $handler->display->display_options['fields']['field_meeting_attachment']['delta_offset'] = '0';
  $handler->display->display_options['fields']['field_meeting_attachment']['multi_type'] = 'ul';
  $handler->display->display_options['defaults']['sorts'] = FALSE;
  $handler->display->display_options['defaults']['arguments'] = FALSE;
  /* Contextual filter: Content: Nid */
  $handler->display->display_options['arguments']['nid']['id'] = 'nid';
  $handler->display->display_options['arguments']['nid']['table'] = 'node';
  $handler->display->display_options['arguments']['nid']['field'] = 'nid';
  $handler->display->display_options['arguments']['nid']['default_action'] = 'default';
  $handler->display->display_options['arguments']['nid']['default_argument_type'] = 'node';
  $handler->display->display_options['arguments']['nid']['summary']['number_of_records'] = '0';
  $handler->display->display_options['arguments']['nid']['summary']['format'] = 'default_summary';
  $handler->display->display_options['arguments']['nid']['summary_options']['items_per_page'] = '25';
  $handler->display->display_options['defaults']['filter_groups'] = FALSE;
  $handler->display->display_options['defaults']['filters'] = FALSE;
  /* Filter criterion: Content: Published status */
  $handler->display->display_options['filters']['status']['id'] = 'status';
  $handler->display->display_options['filters']['status']['table'] = 'node';
  $handler->display->display_options['filters']['status']['field'] = 'status';
  $handler->display->display_options['filters']['status']['value'] = 1;
  $handler->display->display_options['filters']['status']['group'] = 1;
  $handler->display->display_options['filters']['status']['expose']['operator'] = FALSE;
  /* Filter criterion: Content: Type */
  $handler->display->display_options['filters']['type']['id'] = 'type';
  $handler->display->display_options['filters']['type']['table'] = 'node';
  $handler->display->display_options['filters']['type']['field'] = 'type';
  $handler->display->display_options['filters']['type']['value'] = array(
    'meeting' => 'meeting',
  );

  /* Display: Block */
  $handler = $view->new_display('block', 'Block', 'block_3');
  $handler->display->display_options['defaults']['title'] = FALSE;
  $handler->display->display_options['title'] = 'Meetings - Upcoming - Agricultural';
  $handler->display->display_options['defaults']['pager'] = FALSE;
  $handler->display->display_options['pager']['type'] = 'some';
  $handler->display->display_options['pager']['options']['items_per_page'] = '10';
  $handler->display->display_options['defaults']['style_plugin'] = FALSE;
  $handler->display->display_options['style_plugin'] = 'table';
  $handler->display->display_options['style_options']['columns'] = array(
    'title' => 'title',
    'field_date' => 'field_date',
    'field_meeting_location' => 'field_meeting_location',
  );
  $handler->display->display_options['style_options']['default'] = '-1';
  $handler->display->display_options['style_options']['info'] = array(
    'title' => array(
      'sortable' => 0,
      'default_sort_order' => 'asc',
      'align' => '',
      'separator' => '',
      'empty_column' => 0,
    ),
    'field_date' => array(
      'align' => '',
      'separator' => '',
      'empty_column' => 0,
    ),
    'field_meeting_location' => array(
      'sortable' => 0,
      'default_sort_order' => 'asc',
      'align' => '',
      'separator' => '',
      'empty_column' => 0,
    ),
  );
  $handler->display->display_options['defaults']['style_options'] = FALSE;
  $handler->display->display_options['defaults']['row_plugin'] = FALSE;
  $handler->display->display_options['defaults']['row_options'] = FALSE;
  $handler->display->display_options['defaults']['footer'] = FALSE;
  /* Footer: Global: Text area */
  $handler->display->display_options['footer']['area']['id'] = 'area';
  $handler->display->display_options['footer']['area']['table'] = 'views';
  $handler->display->display_options['footer']['area']['field'] = 'area';
  $handler->display->display_options['footer']['area']['empty'] = TRUE;
  $handler->display->display_options['footer']['area']['content'] = '<h4><a href="/city-hall/council/committees/agricultural-advisory-committee/meeting-archives">Meeting Archives</a></h4>';
  $handler->display->display_options['footer']['area']['format'] = 'full_html';
  $handler->display->display_options['defaults']['empty'] = FALSE;
  /* No results behavior: Global: Text area */
  $handler->display->display_options['empty']['area']['id'] = 'area';
  $handler->display->display_options['empty']['area']['table'] = 'views';
  $handler->display->display_options['empty']['area']['field'] = 'area';
  $handler->display->display_options['empty']['area']['empty'] = TRUE;
  $handler->display->display_options['empty']['area']['content'] = '<p>There are no upcoming meetings posted at this time. Please check back or subscribe to our <a href="/rss/meetings.xml">RSS feed</a> for notification.</p>';
  $handler->display->display_options['empty']['area']['format'] = 'full_html';
  $handler->display->display_options['defaults']['fields'] = FALSE;
  /* Field: Content: Title */
  $handler->display->display_options['fields']['title']['id'] = 'title';
  $handler->display->display_options['fields']['title']['table'] = 'node';
  $handler->display->display_options['fields']['title']['field'] = 'title';
  $handler->display->display_options['fields']['title']['label'] = 'Meeting';
  $handler->display->display_options['fields']['title']['alter']['word_boundary'] = FALSE;
  $handler->display->display_options['fields']['title']['alter']['ellipsis'] = FALSE;
  $handler->display->display_options['fields']['title']['element_label_colon'] = FALSE;
  $handler->display->display_options['fields']['title']['link_to_node'] = FALSE;
  /* Field: Content: Date */
  $handler->display->display_options['fields']['field_date']['id'] = 'field_date';
  $handler->display->display_options['fields']['field_date']['table'] = 'field_data_field_date';
  $handler->display->display_options['fields']['field_date']['field'] = 'field_date';
  $handler->display->display_options['fields']['field_date']['element_label_colon'] = FALSE;
  $handler->display->display_options['fields']['field_date']['settings'] = array(
    'format_type' => 'month_day_year_time',
    'fromto' => 'both',
    'multiple_number' => '',
    'multiple_from' => '',
    'multiple_to' => '',
    'show_remaining_days' => 0,
    'show_repeat_rule' => 'show',
    'linked_field' => array(
      'linked' => 0,
      'destination' => '',
      'advanced' => array(
        'title' => '',
        'target' => '',
        'class' => '',
        'rel' => '',
        'text' => '',
      ),
    ),
  );
  $handler->display->display_options['fields']['field_date']['delta_offset'] = '0';
  /* Field: Content: Meeting Address */
  $handler->display->display_options['fields']['field_meeting_address']['id'] = 'field_meeting_address';
  $handler->display->display_options['fields']['field_meeting_address']['table'] = 'field_data_field_meeting_address';
  $handler->display->display_options['fields']['field_meeting_address']['field'] = 'field_meeting_address';
  $handler->display->display_options['fields']['field_meeting_address']['label'] = '';
  $handler->display->display_options['fields']['field_meeting_address']['exclude'] = TRUE;
  $handler->display->display_options['fields']['field_meeting_address']['element_label_colon'] = FALSE;
  $handler->display->display_options['fields']['field_meeting_address']['type'] = 'text_plain';
  $handler->display->display_options['fields']['field_meeting_address']['settings'] = array(
    'linked_field' => array(
      'linked' => 0,
      'destination' => '',
      'advanced' => array(
        'title' => '',
        'target' => '',
        'class' => '',
        'rel' => '',
        'text' => '',
      ),
    ),
  );
  /* Field: Content: Meeting Location */
  $handler->display->display_options['fields']['field_meeting_location']['id'] = 'field_meeting_location';
  $handler->display->display_options['fields']['field_meeting_location']['table'] = 'field_data_field_meeting_location';
  $handler->display->display_options['fields']['field_meeting_location']['field'] = 'field_meeting_location';
  $handler->display->display_options['fields']['field_meeting_location']['label'] = 'Location';
  $handler->display->display_options['fields']['field_meeting_location']['alter']['alter_text'] = TRUE;
  $handler->display->display_options['fields']['field_meeting_location']['alter']['text'] = '[field_meeting_location]<br>
[field_meeting_address]';
  $handler->display->display_options['fields']['field_meeting_location']['element_label_colon'] = FALSE;
  $handler->display->display_options['fields']['field_meeting_location']['settings'] = array(
    'linked_field' => array(
      'linked' => 0,
      'destination' => '',
      'advanced' => array(
        'title' => '',
        'target' => '',
        'class' => '',
        'rel' => '',
        'text' => '',
      ),
    ),
  );
  /* Field: Content: Meeting Agenda HTML */
  $handler->display->display_options['fields']['field_meeting_agenda_html']['id'] = 'field_meeting_agenda_html';
  $handler->display->display_options['fields']['field_meeting_agenda_html']['table'] = 'field_data_field_meeting_agenda_html';
  $handler->display->display_options['fields']['field_meeting_agenda_html']['field'] = 'field_meeting_agenda_html';
  $handler->display->display_options['fields']['field_meeting_agenda_html']['label'] = '';
  $handler->display->display_options['fields']['field_meeting_agenda_html']['exclude'] = TRUE;
  $handler->display->display_options['fields']['field_meeting_agenda_html']['alter']['alter_text'] = TRUE;
  $handler->display->display_options['fields']['field_meeting_agenda_html']['alter']['text'] = '<a href="[field_meeting_agenda_html]" target="_blank">HTML</a>';
  $handler->display->display_options['fields']['field_meeting_agenda_html']['element_label_colon'] = FALSE;
  $handler->display->display_options['fields']['field_meeting_agenda_html']['settings'] = array(
    'linked_field' => array(
      'linked' => 0,
      'destination' => '',
      'advanced' => array(
        'title' => '',
        'target' => '',
        'class' => '',
        'rel' => '',
        'text' => '',
      ),
    ),
  );
  /* Field: Content: Meeting Agenda PDF */
  $handler->display->display_options['fields']['field_meeting_agenda_pdf']['id'] = 'field_meeting_agenda_pdf';
  $handler->display->display_options['fields']['field_meeting_agenda_pdf']['table'] = 'field_data_field_meeting_agenda_pdf';
  $handler->display->display_options['fields']['field_meeting_agenda_pdf']['field'] = 'field_meeting_agenda_pdf';
  $handler->display->display_options['fields']['field_meeting_agenda_pdf']['label'] = '';
  $handler->display->display_options['fields']['field_meeting_agenda_pdf']['exclude'] = TRUE;
  $handler->display->display_options['fields']['field_meeting_agenda_pdf']['alter']['alter_text'] = TRUE;
  $handler->display->display_options['fields']['field_meeting_agenda_pdf']['alter']['text'] = '<a href="[field_meeting_agenda_pdf]" target="_blank">PDF</a>';
  $handler->display->display_options['fields']['field_meeting_agenda_pdf']['element_label_colon'] = FALSE;
  $handler->display->display_options['fields']['field_meeting_agenda_pdf']['settings'] = array(
    'linked_field' => array(
      'linked' => 0,
      'destination' => '',
      'advanced' => array(
        'title' => '',
        'target' => '',
        'class' => '',
        'rel' => '',
        'text' => '',
      ),
    ),
  );
  /* Field: Global: Custom text */
  $handler->display->display_options['fields']['nothing']['id'] = 'nothing';
  $handler->display->display_options['fields']['nothing']['table'] = 'views';
  $handler->display->display_options['fields']['nothing']['field'] = 'nothing';
  $handler->display->display_options['fields']['nothing']['label'] = 'Agenda';
  $handler->display->display_options['fields']['nothing']['alter']['text'] = '[field_meeting_agenda_html] | [field_meeting_agenda_pdf]';
  $handler->display->display_options['fields']['nothing']['element_label_colon'] = FALSE;
  $handler->display->display_options['defaults']['sorts'] = FALSE;
  /* Sort criterion: Content: Date -  start date (field_date) */
  $handler->display->display_options['sorts']['field_date_value']['id'] = 'field_date_value';
  $handler->display->display_options['sorts']['field_date_value']['table'] = 'field_data_field_date';
  $handler->display->display_options['sorts']['field_date_value']['field'] = 'field_date_value';
  $handler->display->display_options['defaults']['filter_groups'] = FALSE;
  $handler->display->display_options['defaults']['filters'] = FALSE;
  /* Filter criterion: Content: Published status */
  $handler->display->display_options['filters']['status']['id'] = 'status';
  $handler->display->display_options['filters']['status']['table'] = 'node';
  $handler->display->display_options['filters']['status']['field'] = 'status';
  $handler->display->display_options['filters']['status']['value'] = 1;
  $handler->display->display_options['filters']['status']['group'] = 1;
  $handler->display->display_options['filters']['status']['expose']['operator'] = FALSE;
  /* Filter criterion: Content: Type */
  $handler->display->display_options['filters']['type']['id'] = 'type';
  $handler->display->display_options['filters']['type']['table'] = 'node';
  $handler->display->display_options['filters']['type']['field'] = 'type';
  $handler->display->display_options['filters']['type']['value'] = array(
    'meeting' => 'meeting',
  );
  /* Filter criterion: Content: Date -  start date (field_date) */
  $handler->display->display_options['filters']['field_date_value']['id'] = 'field_date_value';
  $handler->display->display_options['filters']['field_date_value']['table'] = 'field_data_field_date';
  $handler->display->display_options['filters']['field_date_value']['field'] = 'field_date_value';
  $handler->display->display_options['filters']['field_date_value']['operator'] = '>=';
  $handler->display->display_options['filters']['field_date_value']['default_date'] = 'now';
  /* Filter criterion: Content: Meeting Type (field_meeting_type) */
  $handler->display->display_options['filters']['field_meeting_type_tid']['id'] = 'field_meeting_type_tid';
  $handler->display->display_options['filters']['field_meeting_type_tid']['table'] = 'field_data_field_meeting_type';
  $handler->display->display_options['filters']['field_meeting_type_tid']['field'] = 'field_meeting_type_tid';
  $handler->display->display_options['filters']['field_meeting_type_tid']['value'] = array(
    2153 => '2153',
  );
  $handler->display->display_options['filters']['field_meeting_type_tid']['type'] = 'select';
  $handler->display->display_options['filters']['field_meeting_type_tid']['vocabulary'] = 'meeting_type';
  $handler->display->display_options['block_description'] = 'Meetings - Upcoming - Agricultural';

  /* Display: Block */
  $handler = $view->new_display('block', 'Block', 'block_4');
  $handler->display->display_options['defaults']['title'] = FALSE;
  $handler->display->display_options['title'] = 'Meetings - Upcoming - Airport';
  $handler->display->display_options['defaults']['pager'] = FALSE;
  $handler->display->display_options['pager']['type'] = 'some';
  $handler->display->display_options['pager']['options']['items_per_page'] = '10';
  $handler->display->display_options['defaults']['style_plugin'] = FALSE;
  $handler->display->display_options['style_plugin'] = 'table';
  $handler->display->display_options['style_options']['columns'] = array(
    'title' => 'title',
    'field_date' => 'field_date',
    'field_meeting_location' => 'field_meeting_location',
  );
  $handler->display->display_options['style_options']['default'] = '-1';
  $handler->display->display_options['style_options']['info'] = array(
    'title' => array(
      'sortable' => 0,
      'default_sort_order' => 'asc',
      'align' => '',
      'separator' => '',
      'empty_column' => 0,
    ),
    'field_date' => array(
      'align' => '',
      'separator' => '',
      'empty_column' => 0,
    ),
    'field_meeting_location' => array(
      'sortable' => 0,
      'default_sort_order' => 'asc',
      'align' => '',
      'separator' => '',
      'empty_column' => 0,
    ),
  );
  $handler->display->display_options['defaults']['style_options'] = FALSE;
  $handler->display->display_options['defaults']['row_plugin'] = FALSE;
  $handler->display->display_options['defaults']['row_options'] = FALSE;
  $handler->display->display_options['defaults']['footer'] = FALSE;
  /* Footer: Global: Text area */
  $handler->display->display_options['footer']['area']['id'] = 'area';
  $handler->display->display_options['footer']['area']['table'] = 'views';
  $handler->display->display_options['footer']['area']['field'] = 'area';
  $handler->display->display_options['footer']['area']['empty'] = TRUE;
  $handler->display->display_options['footer']['area']['content'] = '<h4><a href="/city-hall/council/committees/airport-advisory-committee/meeting-archives">Meeting Archives</a></h4>';
  $handler->display->display_options['footer']['area']['format'] = 'full_html';
  $handler->display->display_options['defaults']['empty'] = FALSE;
  /* No results behavior: Global: Text area */
  $handler->display->display_options['empty']['area']['id'] = 'area';
  $handler->display->display_options['empty']['area']['table'] = 'views';
  $handler->display->display_options['empty']['area']['field'] = 'area';
  $handler->display->display_options['empty']['area']['empty'] = TRUE;
  $handler->display->display_options['empty']['area']['content'] = '<p>There are no upcoming meetings posted at this time. Please check back or subscribe to our <a href="/rss/meetings.xml">RSS feed</a> for notification.</p>';
  $handler->display->display_options['empty']['area']['format'] = 'full_html';
  $handler->display->display_options['defaults']['fields'] = FALSE;
  /* Field: Content: Title */
  $handler->display->display_options['fields']['title']['id'] = 'title';
  $handler->display->display_options['fields']['title']['table'] = 'node';
  $handler->display->display_options['fields']['title']['field'] = 'title';
  $handler->display->display_options['fields']['title']['label'] = 'Meeting';
  $handler->display->display_options['fields']['title']['alter']['word_boundary'] = FALSE;
  $handler->display->display_options['fields']['title']['alter']['ellipsis'] = FALSE;
  $handler->display->display_options['fields']['title']['element_label_colon'] = FALSE;
  $handler->display->display_options['fields']['title']['link_to_node'] = FALSE;
  /* Field: Content: Date */
  $handler->display->display_options['fields']['field_date']['id'] = 'field_date';
  $handler->display->display_options['fields']['field_date']['table'] = 'field_data_field_date';
  $handler->display->display_options['fields']['field_date']['field'] = 'field_date';
  $handler->display->display_options['fields']['field_date']['element_label_colon'] = FALSE;
  $handler->display->display_options['fields']['field_date']['settings'] = array(
    'format_type' => 'month_day_year_time',
    'fromto' => 'both',
    'multiple_number' => '',
    'multiple_from' => '',
    'multiple_to' => '',
    'show_remaining_days' => 0,
    'show_repeat_rule' => 'show',
    'linked_field' => array(
      'linked' => 0,
      'destination' => '',
      'advanced' => array(
        'title' => '',
        'target' => '',
        'class' => '',
        'rel' => '',
        'text' => '',
      ),
    ),
  );
  $handler->display->display_options['fields']['field_date']['delta_offset'] = '0';
  /* Field: Content: Meeting Address */
  $handler->display->display_options['fields']['field_meeting_address']['id'] = 'field_meeting_address';
  $handler->display->display_options['fields']['field_meeting_address']['table'] = 'field_data_field_meeting_address';
  $handler->display->display_options['fields']['field_meeting_address']['field'] = 'field_meeting_address';
  $handler->display->display_options['fields']['field_meeting_address']['label'] = '';
  $handler->display->display_options['fields']['field_meeting_address']['exclude'] = TRUE;
  $handler->display->display_options['fields']['field_meeting_address']['element_label_colon'] = FALSE;
  $handler->display->display_options['fields']['field_meeting_address']['type'] = 'text_plain';
  $handler->display->display_options['fields']['field_meeting_address']['settings'] = array(
    'linked_field' => array(
      'linked' => 0,
      'destination' => '',
      'advanced' => array(
        'title' => '',
        'target' => '',
        'class' => '',
        'rel' => '',
        'text' => '',
      ),
    ),
  );
  /* Field: Content: Meeting Location */
  $handler->display->display_options['fields']['field_meeting_location']['id'] = 'field_meeting_location';
  $handler->display->display_options['fields']['field_meeting_location']['table'] = 'field_data_field_meeting_location';
  $handler->display->display_options['fields']['field_meeting_location']['field'] = 'field_meeting_location';
  $handler->display->display_options['fields']['field_meeting_location']['label'] = 'Location';
  $handler->display->display_options['fields']['field_meeting_location']['alter']['alter_text'] = TRUE;
  $handler->display->display_options['fields']['field_meeting_location']['alter']['text'] = '[field_meeting_location]<br>
[field_meeting_address]';
  $handler->display->display_options['fields']['field_meeting_location']['element_label_colon'] = FALSE;
  $handler->display->display_options['fields']['field_meeting_location']['settings'] = array(
    'linked_field' => array(
      'linked' => 0,
      'destination' => '',
      'advanced' => array(
        'title' => '',
        'target' => '',
        'class' => '',
        'rel' => '',
        'text' => '',
      ),
    ),
  );
  /* Field: Content: Meeting Agenda HTML */
  $handler->display->display_options['fields']['field_meeting_agenda_html']['id'] = 'field_meeting_agenda_html';
  $handler->display->display_options['fields']['field_meeting_agenda_html']['table'] = 'field_data_field_meeting_agenda_html';
  $handler->display->display_options['fields']['field_meeting_agenda_html']['field'] = 'field_meeting_agenda_html';
  $handler->display->display_options['fields']['field_meeting_agenda_html']['label'] = '';
  $handler->display->display_options['fields']['field_meeting_agenda_html']['exclude'] = TRUE;
  $handler->display->display_options['fields']['field_meeting_agenda_html']['alter']['alter_text'] = TRUE;
  $handler->display->display_options['fields']['field_meeting_agenda_html']['alter']['text'] = '<a href="[field_meeting_agenda_html]" target="_blank">HTML</a>';
  $handler->display->display_options['fields']['field_meeting_agenda_html']['element_label_colon'] = FALSE;
  $handler->display->display_options['fields']['field_meeting_agenda_html']['settings'] = array(
    'linked_field' => array(
      'linked' => 0,
      'destination' => '',
      'advanced' => array(
        'title' => '',
        'target' => '',
        'class' => '',
        'rel' => '',
        'text' => '',
      ),
    ),
  );
  /* Field: Content: Meeting Agenda PDF */
  $handler->display->display_options['fields']['field_meeting_agenda_pdf']['id'] = 'field_meeting_agenda_pdf';
  $handler->display->display_options['fields']['field_meeting_agenda_pdf']['table'] = 'field_data_field_meeting_agenda_pdf';
  $handler->display->display_options['fields']['field_meeting_agenda_pdf']['field'] = 'field_meeting_agenda_pdf';
  $handler->display->display_options['fields']['field_meeting_agenda_pdf']['label'] = '';
  $handler->display->display_options['fields']['field_meeting_agenda_pdf']['exclude'] = TRUE;
  $handler->display->display_options['fields']['field_meeting_agenda_pdf']['alter']['alter_text'] = TRUE;
  $handler->display->display_options['fields']['field_meeting_agenda_pdf']['alter']['text'] = '<a href="[field_meeting_agenda_pdf]" target="_blank">PDF</a>';
  $handler->display->display_options['fields']['field_meeting_agenda_pdf']['element_label_colon'] = FALSE;
  $handler->display->display_options['fields']['field_meeting_agenda_pdf']['settings'] = array(
    'linked_field' => array(
      'linked' => 0,
      'destination' => '',
      'advanced' => array(
        'title' => '',
        'target' => '',
        'class' => '',
        'rel' => '',
        'text' => '',
      ),
    ),
  );
  /* Field: Global: Custom text */
  $handler->display->display_options['fields']['nothing']['id'] = 'nothing';
  $handler->display->display_options['fields']['nothing']['table'] = 'views';
  $handler->display->display_options['fields']['nothing']['field'] = 'nothing';
  $handler->display->display_options['fields']['nothing']['label'] = 'Agenda';
  $handler->display->display_options['fields']['nothing']['alter']['text'] = '[field_meeting_agenda_html] | [field_meeting_agenda_pdf]';
  $handler->display->display_options['fields']['nothing']['element_label_colon'] = FALSE;
  $handler->display->display_options['defaults']['sorts'] = FALSE;
  /* Sort criterion: Content: Date -  start date (field_date) */
  $handler->display->display_options['sorts']['field_date_value']['id'] = 'field_date_value';
  $handler->display->display_options['sorts']['field_date_value']['table'] = 'field_data_field_date';
  $handler->display->display_options['sorts']['field_date_value']['field'] = 'field_date_value';
  $handler->display->display_options['defaults']['filter_groups'] = FALSE;
  $handler->display->display_options['defaults']['filters'] = FALSE;
  /* Filter criterion: Content: Published status */
  $handler->display->display_options['filters']['status']['id'] = 'status';
  $handler->display->display_options['filters']['status']['table'] = 'node';
  $handler->display->display_options['filters']['status']['field'] = 'status';
  $handler->display->display_options['filters']['status']['value'] = 1;
  $handler->display->display_options['filters']['status']['group'] = 1;
  $handler->display->display_options['filters']['status']['expose']['operator'] = FALSE;
  /* Filter criterion: Content: Type */
  $handler->display->display_options['filters']['type']['id'] = 'type';
  $handler->display->display_options['filters']['type']['table'] = 'node';
  $handler->display->display_options['filters']['type']['field'] = 'type';
  $handler->display->display_options['filters']['type']['value'] = array(
    'meeting' => 'meeting',
  );
  /* Filter criterion: Content: Date -  start date (field_date) */
  $handler->display->display_options['filters']['field_date_value']['id'] = 'field_date_value';
  $handler->display->display_options['filters']['field_date_value']['table'] = 'field_data_field_date';
  $handler->display->display_options['filters']['field_date_value']['field'] = 'field_date_value';
  $handler->display->display_options['filters']['field_date_value']['operator'] = '>=';
  $handler->display->display_options['filters']['field_date_value']['default_date'] = 'now';
  /* Filter criterion: Content: Meeting Type (field_meeting_type) */
  $handler->display->display_options['filters']['field_meeting_type_tid']['id'] = 'field_meeting_type_tid';
  $handler->display->display_options['filters']['field_meeting_type_tid']['table'] = 'field_data_field_meeting_type';
  $handler->display->display_options['filters']['field_meeting_type_tid']['field'] = 'field_meeting_type_tid';
  $handler->display->display_options['filters']['field_meeting_type_tid']['value'] = array(
    2164 => '2164',
  );
  $handler->display->display_options['filters']['field_meeting_type_tid']['type'] = 'select';
  $handler->display->display_options['filters']['field_meeting_type_tid']['vocabulary'] = 'meeting_type';
  $handler->display->display_options['block_description'] = 'Meetings - Upcoming - Airport';

  /* Display: Block */
  $handler = $view->new_display('block', 'Block', 'block_5');
  $handler->display->display_options['defaults']['title'] = FALSE;
  $handler->display->display_options['title'] = 'Meetings - Upcoming - Audit';
  $handler->display->display_options['defaults']['pager'] = FALSE;
  $handler->display->display_options['pager']['type'] = 'some';
  $handler->display->display_options['pager']['options']['items_per_page'] = '10';
  $handler->display->display_options['defaults']['style_plugin'] = FALSE;
  $handler->display->display_options['style_plugin'] = 'table';
  $handler->display->display_options['style_options']['columns'] = array(
    'title' => 'title',
    'field_date' => 'field_date',
    'field_meeting_location' => 'field_meeting_location',
  );
  $handler->display->display_options['style_options']['default'] = '-1';
  $handler->display->display_options['style_options']['info'] = array(
    'title' => array(
      'sortable' => 0,
      'default_sort_order' => 'asc',
      'align' => '',
      'separator' => '',
      'empty_column' => 0,
    ),
    'field_date' => array(
      'align' => '',
      'separator' => '',
      'empty_column' => 0,
    ),
    'field_meeting_location' => array(
      'sortable' => 0,
      'default_sort_order' => 'asc',
      'align' => '',
      'separator' => '',
      'empty_column' => 0,
    ),
  );
  $handler->display->display_options['defaults']['style_options'] = FALSE;
  $handler->display->display_options['defaults']['row_plugin'] = FALSE;
  $handler->display->display_options['defaults']['row_options'] = FALSE;
  $handler->display->display_options['defaults']['footer'] = FALSE;
  /* Footer: Global: Text area */
  $handler->display->display_options['footer']['area']['id'] = 'area';
  $handler->display->display_options['footer']['area']['table'] = 'views';
  $handler->display->display_options['footer']['area']['field'] = 'area';
  $handler->display->display_options['footer']['area']['empty'] = TRUE;
  $handler->display->display_options['footer']['area']['content'] = '<h4><a href="/city-hall/council/committees/audit-committee/meeting-archives">Meeting Archives</a></h4>';
  $handler->display->display_options['footer']['area']['format'] = 'full_html';
  $handler->display->display_options['defaults']['empty'] = FALSE;
  /* No results behavior: Global: Text area */
  $handler->display->display_options['empty']['area']['id'] = 'area';
  $handler->display->display_options['empty']['area']['table'] = 'views';
  $handler->display->display_options['empty']['area']['field'] = 'area';
  $handler->display->display_options['empty']['area']['empty'] = TRUE;
  $handler->display->display_options['empty']['area']['content'] = '<p>There are no upcoming meetings posted at this time. Please check back or subscribe to our <a href="/rss/meetings.xml">RSS feed</a> for notification.</p>';
  $handler->display->display_options['empty']['area']['format'] = 'full_html';
  $handler->display->display_options['defaults']['fields'] = FALSE;
  /* Field: Content: Title */
  $handler->display->display_options['fields']['title']['id'] = 'title';
  $handler->display->display_options['fields']['title']['table'] = 'node';
  $handler->display->display_options['fields']['title']['field'] = 'title';
  $handler->display->display_options['fields']['title']['label'] = 'Meeting';
  $handler->display->display_options['fields']['title']['alter']['word_boundary'] = FALSE;
  $handler->display->display_options['fields']['title']['alter']['ellipsis'] = FALSE;
  $handler->display->display_options['fields']['title']['element_label_colon'] = FALSE;
  $handler->display->display_options['fields']['title']['link_to_node'] = FALSE;
  /* Field: Content: Date */
  $handler->display->display_options['fields']['field_date']['id'] = 'field_date';
  $handler->display->display_options['fields']['field_date']['table'] = 'field_data_field_date';
  $handler->display->display_options['fields']['field_date']['field'] = 'field_date';
  $handler->display->display_options['fields']['field_date']['element_label_colon'] = FALSE;
  $handler->display->display_options['fields']['field_date']['settings'] = array(
    'format_type' => 'month_day_year_time',
    'fromto' => 'both',
    'multiple_number' => '',
    'multiple_from' => '',
    'multiple_to' => '',
    'show_remaining_days' => 0,
    'show_repeat_rule' => 'show',
    'linked_field' => array(
      'linked' => 0,
      'destination' => '',
      'advanced' => array(
        'title' => '',
        'target' => '',
        'class' => '',
        'rel' => '',
        'text' => '',
      ),
    ),
  );
  $handler->display->display_options['fields']['field_date']['delta_offset'] = '0';
  /* Field: Content: Meeting Address */
  $handler->display->display_options['fields']['field_meeting_address']['id'] = 'field_meeting_address';
  $handler->display->display_options['fields']['field_meeting_address']['table'] = 'field_data_field_meeting_address';
  $handler->display->display_options['fields']['field_meeting_address']['field'] = 'field_meeting_address';
  $handler->display->display_options['fields']['field_meeting_address']['label'] = '';
  $handler->display->display_options['fields']['field_meeting_address']['exclude'] = TRUE;
  $handler->display->display_options['fields']['field_meeting_address']['element_label_colon'] = FALSE;
  $handler->display->display_options['fields']['field_meeting_address']['type'] = 'text_plain';
  $handler->display->display_options['fields']['field_meeting_address']['settings'] = array(
    'linked_field' => array(
      'linked' => 0,
      'destination' => '',
      'advanced' => array(
        'title' => '',
        'target' => '',
        'class' => '',
        'rel' => '',
        'text' => '',
      ),
    ),
  );
  /* Field: Content: Meeting Location */
  $handler->display->display_options['fields']['field_meeting_location']['id'] = 'field_meeting_location';
  $handler->display->display_options['fields']['field_meeting_location']['table'] = 'field_data_field_meeting_location';
  $handler->display->display_options['fields']['field_meeting_location']['field'] = 'field_meeting_location';
  $handler->display->display_options['fields']['field_meeting_location']['label'] = 'Location';
  $handler->display->display_options['fields']['field_meeting_location']['alter']['alter_text'] = TRUE;
  $handler->display->display_options['fields']['field_meeting_location']['alter']['text'] = '[field_meeting_location]<br>
[field_meeting_address]';
  $handler->display->display_options['fields']['field_meeting_location']['element_label_colon'] = FALSE;
  $handler->display->display_options['fields']['field_meeting_location']['settings'] = array(
    'linked_field' => array(
      'linked' => 0,
      'destination' => '',
      'advanced' => array(
        'title' => '',
        'target' => '',
        'class' => '',
        'rel' => '',
        'text' => '',
      ),
    ),
  );
  /* Field: Content: Meeting Agenda HTML */
  $handler->display->display_options['fields']['field_meeting_agenda_html']['id'] = 'field_meeting_agenda_html';
  $handler->display->display_options['fields']['field_meeting_agenda_html']['table'] = 'field_data_field_meeting_agenda_html';
  $handler->display->display_options['fields']['field_meeting_agenda_html']['field'] = 'field_meeting_agenda_html';
  $handler->display->display_options['fields']['field_meeting_agenda_html']['label'] = '';
  $handler->display->display_options['fields']['field_meeting_agenda_html']['exclude'] = TRUE;
  $handler->display->display_options['fields']['field_meeting_agenda_html']['alter']['alter_text'] = TRUE;
  $handler->display->display_options['fields']['field_meeting_agenda_html']['alter']['text'] = '<a href="[field_meeting_agenda_html]" target="_blank">HTML</a>';
  $handler->display->display_options['fields']['field_meeting_agenda_html']['element_label_colon'] = FALSE;
  $handler->display->display_options['fields']['field_meeting_agenda_html']['settings'] = array(
    'linked_field' => array(
      'linked' => 0,
      'destination' => '',
      'advanced' => array(
        'title' => '',
        'target' => '',
        'class' => '',
        'rel' => '',
        'text' => '',
      ),
    ),
  );
  /* Field: Content: Meeting Agenda PDF */
  $handler->display->display_options['fields']['field_meeting_agenda_pdf']['id'] = 'field_meeting_agenda_pdf';
  $handler->display->display_options['fields']['field_meeting_agenda_pdf']['table'] = 'field_data_field_meeting_agenda_pdf';
  $handler->display->display_options['fields']['field_meeting_agenda_pdf']['field'] = 'field_meeting_agenda_pdf';
  $handler->display->display_options['fields']['field_meeting_agenda_pdf']['label'] = '';
  $handler->display->display_options['fields']['field_meeting_agenda_pdf']['exclude'] = TRUE;
  $handler->display->display_options['fields']['field_meeting_agenda_pdf']['alter']['alter_text'] = TRUE;
  $handler->display->display_options['fields']['field_meeting_agenda_pdf']['alter']['text'] = '<a href="[field_meeting_agenda_pdf]" target="_blank">PDF</a>';
  $handler->display->display_options['fields']['field_meeting_agenda_pdf']['element_label_colon'] = FALSE;
  $handler->display->display_options['fields']['field_meeting_agenda_pdf']['settings'] = array(
    'linked_field' => array(
      'linked' => 0,
      'destination' => '',
      'advanced' => array(
        'title' => '',
        'target' => '',
        'class' => '',
        'rel' => '',
        'text' => '',
      ),
    ),
  );
  /* Field: Global: Custom text */
  $handler->display->display_options['fields']['nothing']['id'] = 'nothing';
  $handler->display->display_options['fields']['nothing']['table'] = 'views';
  $handler->display->display_options['fields']['nothing']['field'] = 'nothing';
  $handler->display->display_options['fields']['nothing']['label'] = 'Agenda';
  $handler->display->display_options['fields']['nothing']['alter']['text'] = '[field_meeting_agenda_html] | [field_meeting_agenda_pdf]';
  $handler->display->display_options['fields']['nothing']['element_label_colon'] = FALSE;
  $handler->display->display_options['defaults']['sorts'] = FALSE;
  /* Sort criterion: Content: Date -  start date (field_date) */
  $handler->display->display_options['sorts']['field_date_value']['id'] = 'field_date_value';
  $handler->display->display_options['sorts']['field_date_value']['table'] = 'field_data_field_date';
  $handler->display->display_options['sorts']['field_date_value']['field'] = 'field_date_value';
  $handler->display->display_options['defaults']['filter_groups'] = FALSE;
  $handler->display->display_options['defaults']['filters'] = FALSE;
  /* Filter criterion: Content: Published status */
  $handler->display->display_options['filters']['status']['id'] = 'status';
  $handler->display->display_options['filters']['status']['table'] = 'node';
  $handler->display->display_options['filters']['status']['field'] = 'status';
  $handler->display->display_options['filters']['status']['value'] = 1;
  $handler->display->display_options['filters']['status']['group'] = 1;
  $handler->display->display_options['filters']['status']['expose']['operator'] = FALSE;
  /* Filter criterion: Content: Type */
  $handler->display->display_options['filters']['type']['id'] = 'type';
  $handler->display->display_options['filters']['type']['table'] = 'node';
  $handler->display->display_options['filters']['type']['field'] = 'type';
  $handler->display->display_options['filters']['type']['value'] = array(
    'meeting' => 'meeting',
  );
  /* Filter criterion: Content: Date -  start date (field_date) */
  $handler->display->display_options['filters']['field_date_value']['id'] = 'field_date_value';
  $handler->display->display_options['filters']['field_date_value']['table'] = 'field_data_field_date';
  $handler->display->display_options['filters']['field_date_value']['field'] = 'field_date_value';
  $handler->display->display_options['filters']['field_date_value']['operator'] = '>=';
  $handler->display->display_options['filters']['field_date_value']['default_date'] = 'now';
  /* Filter criterion: Content: Meeting Type (field_meeting_type) */
  $handler->display->display_options['filters']['field_meeting_type_tid']['id'] = 'field_meeting_type_tid';
  $handler->display->display_options['filters']['field_meeting_type_tid']['table'] = 'field_data_field_meeting_type';
  $handler->display->display_options['filters']['field_meeting_type_tid']['field'] = 'field_meeting_type_tid';
  $handler->display->display_options['filters']['field_meeting_type_tid']['value'] = array(
    2163 => '2163',
  );
  $handler->display->display_options['filters']['field_meeting_type_tid']['type'] = 'select';
  $handler->display->display_options['filters']['field_meeting_type_tid']['vocabulary'] = 'meeting_type';
  $handler->display->display_options['block_description'] = 'Meetings - Upcoming - Audit';

  /* Display: Block */
  $handler = $view->new_display('block', 'Block', 'block_6');
  $handler->display->display_options['defaults']['title'] = FALSE;
  $handler->display->display_options['title'] = 'Meetings - Upcoming - Board of Variance';
  $handler->display->display_options['defaults']['pager'] = FALSE;
  $handler->display->display_options['pager']['type'] = 'some';
  $handler->display->display_options['pager']['options']['items_per_page'] = '10';
  $handler->display->display_options['defaults']['style_plugin'] = FALSE;
  $handler->display->display_options['style_plugin'] = 'table';
  $handler->display->display_options['style_options']['columns'] = array(
    'title' => 'title',
    'field_date' => 'field_date',
    'field_meeting_location' => 'field_meeting_location',
  );
  $handler->display->display_options['style_options']['default'] = '-1';
  $handler->display->display_options['style_options']['info'] = array(
    'title' => array(
      'sortable' => 0,
      'default_sort_order' => 'asc',
      'align' => '',
      'separator' => '',
      'empty_column' => 0,
    ),
    'field_date' => array(
      'align' => '',
      'separator' => '',
      'empty_column' => 0,
    ),
    'field_meeting_location' => array(
      'sortable' => 0,
      'default_sort_order' => 'asc',
      'align' => '',
      'separator' => '',
      'empty_column' => 0,
    ),
  );
  $handler->display->display_options['defaults']['style_options'] = FALSE;
  $handler->display->display_options['defaults']['row_plugin'] = FALSE;
  $handler->display->display_options['defaults']['row_options'] = FALSE;
  $handler->display->display_options['defaults']['footer'] = FALSE;
  /* Footer: Global: Text area */
  $handler->display->display_options['footer']['area']['id'] = 'area';
  $handler->display->display_options['footer']['area']['table'] = 'views';
  $handler->display->display_options['footer']['area']['field'] = 'area';
  $handler->display->display_options['footer']['area']['empty'] = TRUE;
  $handler->display->display_options['footer']['area']['content'] = '<h4><a href="/city-hall/council/committees/board-variance/meeting-archives">Meeting Archives</a></h4>';
  $handler->display->display_options['footer']['area']['format'] = 'full_html';
  $handler->display->display_options['defaults']['empty'] = FALSE;
  /* No results behavior: Global: Text area */
  $handler->display->display_options['empty']['area']['id'] = 'area';
  $handler->display->display_options['empty']['area']['table'] = 'views';
  $handler->display->display_options['empty']['area']['field'] = 'area';
  $handler->display->display_options['empty']['area']['empty'] = TRUE;
  $handler->display->display_options['empty']['area']['content'] = '<p>There are no upcoming meetings posted at this time. Please check back or subscribe to our <a href="/rss/meetings.xml">RSS feed</a> for notification.</p>';
  $handler->display->display_options['empty']['area']['format'] = 'full_html';
  $handler->display->display_options['defaults']['fields'] = FALSE;
  /* Field: Content: Title */
  $handler->display->display_options['fields']['title']['id'] = 'title';
  $handler->display->display_options['fields']['title']['table'] = 'node';
  $handler->display->display_options['fields']['title']['field'] = 'title';
  $handler->display->display_options['fields']['title']['label'] = 'Meeting';
  $handler->display->display_options['fields']['title']['alter']['word_boundary'] = FALSE;
  $handler->display->display_options['fields']['title']['alter']['ellipsis'] = FALSE;
  $handler->display->display_options['fields']['title']['element_label_colon'] = FALSE;
  $handler->display->display_options['fields']['title']['link_to_node'] = FALSE;
  /* Field: Content: Date */
  $handler->display->display_options['fields']['field_date']['id'] = 'field_date';
  $handler->display->display_options['fields']['field_date']['table'] = 'field_data_field_date';
  $handler->display->display_options['fields']['field_date']['field'] = 'field_date';
  $handler->display->display_options['fields']['field_date']['element_label_colon'] = FALSE;
  $handler->display->display_options['fields']['field_date']['settings'] = array(
    'format_type' => 'month_day_year_time',
    'fromto' => 'both',
    'multiple_number' => '',
    'multiple_from' => '',
    'multiple_to' => '',
    'show_remaining_days' => 0,
    'show_repeat_rule' => 'show',
    'linked_field' => array(
      'linked' => 0,
      'destination' => '',
      'advanced' => array(
        'title' => '',
        'target' => '',
        'class' => '',
        'rel' => '',
        'text' => '',
      ),
    ),
  );
  $handler->display->display_options['fields']['field_date']['delta_offset'] = '0';
  /* Field: Content: Meeting Address */
  $handler->display->display_options['fields']['field_meeting_address']['id'] = 'field_meeting_address';
  $handler->display->display_options['fields']['field_meeting_address']['table'] = 'field_data_field_meeting_address';
  $handler->display->display_options['fields']['field_meeting_address']['field'] = 'field_meeting_address';
  $handler->display->display_options['fields']['field_meeting_address']['label'] = '';
  $handler->display->display_options['fields']['field_meeting_address']['exclude'] = TRUE;
  $handler->display->display_options['fields']['field_meeting_address']['element_label_colon'] = FALSE;
  $handler->display->display_options['fields']['field_meeting_address']['type'] = 'text_plain';
  $handler->display->display_options['fields']['field_meeting_address']['settings'] = array(
    'linked_field' => array(
      'linked' => 0,
      'destination' => '',
      'advanced' => array(
        'title' => '',
        'target' => '',
        'class' => '',
        'rel' => '',
        'text' => '',
      ),
    ),
  );
  /* Field: Content: Meeting Location */
  $handler->display->display_options['fields']['field_meeting_location']['id'] = 'field_meeting_location';
  $handler->display->display_options['fields']['field_meeting_location']['table'] = 'field_data_field_meeting_location';
  $handler->display->display_options['fields']['field_meeting_location']['field'] = 'field_meeting_location';
  $handler->display->display_options['fields']['field_meeting_location']['label'] = 'Location';
  $handler->display->display_options['fields']['field_meeting_location']['alter']['alter_text'] = TRUE;
  $handler->display->display_options['fields']['field_meeting_location']['alter']['text'] = '[field_meeting_location]<br>
[field_meeting_address]';
  $handler->display->display_options['fields']['field_meeting_location']['element_label_colon'] = FALSE;
  $handler->display->display_options['fields']['field_meeting_location']['settings'] = array(
    'linked_field' => array(
      'linked' => 0,
      'destination' => '',
      'advanced' => array(
        'title' => '',
        'target' => '',
        'class' => '',
        'rel' => '',
        'text' => '',
      ),
    ),
  );
  /* Field: Content: Meeting Agenda HTML */
  $handler->display->display_options['fields']['field_meeting_agenda_html']['id'] = 'field_meeting_agenda_html';
  $handler->display->display_options['fields']['field_meeting_agenda_html']['table'] = 'field_data_field_meeting_agenda_html';
  $handler->display->display_options['fields']['field_meeting_agenda_html']['field'] = 'field_meeting_agenda_html';
  $handler->display->display_options['fields']['field_meeting_agenda_html']['label'] = '';
  $handler->display->display_options['fields']['field_meeting_agenda_html']['exclude'] = TRUE;
  $handler->display->display_options['fields']['field_meeting_agenda_html']['alter']['alter_text'] = TRUE;
  $handler->display->display_options['fields']['field_meeting_agenda_html']['alter']['text'] = '<a href="[field_meeting_agenda_html]" target="_blank">HTML</a>';
  $handler->display->display_options['fields']['field_meeting_agenda_html']['element_label_colon'] = FALSE;
  $handler->display->display_options['fields']['field_meeting_agenda_html']['settings'] = array(
    'linked_field' => array(
      'linked' => 0,
      'destination' => '',
      'advanced' => array(
        'title' => '',
        'target' => '',
        'class' => '',
        'rel' => '',
        'text' => '',
      ),
    ),
  );
  /* Field: Content: Meeting Agenda PDF */
  $handler->display->display_options['fields']['field_meeting_agenda_pdf']['id'] = 'field_meeting_agenda_pdf';
  $handler->display->display_options['fields']['field_meeting_agenda_pdf']['table'] = 'field_data_field_meeting_agenda_pdf';
  $handler->display->display_options['fields']['field_meeting_agenda_pdf']['field'] = 'field_meeting_agenda_pdf';
  $handler->display->display_options['fields']['field_meeting_agenda_pdf']['label'] = '';
  $handler->display->display_options['fields']['field_meeting_agenda_pdf']['exclude'] = TRUE;
  $handler->display->display_options['fields']['field_meeting_agenda_pdf']['alter']['alter_text'] = TRUE;
  $handler->display->display_options['fields']['field_meeting_agenda_pdf']['alter']['text'] = '<a href="[field_meeting_agenda_pdf]" target="_blank">PDF</a>';
  $handler->display->display_options['fields']['field_meeting_agenda_pdf']['element_label_colon'] = FALSE;
  $handler->display->display_options['fields']['field_meeting_agenda_pdf']['settings'] = array(
    'linked_field' => array(
      'linked' => 0,
      'destination' => '',
      'advanced' => array(
        'title' => '',
        'target' => '',
        'class' => '',
        'rel' => '',
        'text' => '',
      ),
    ),
  );
  /* Field: Global: Custom text */
  $handler->display->display_options['fields']['nothing']['id'] = 'nothing';
  $handler->display->display_options['fields']['nothing']['table'] = 'views';
  $handler->display->display_options['fields']['nothing']['field'] = 'nothing';
  $handler->display->display_options['fields']['nothing']['label'] = 'Agenda';
  $handler->display->display_options['fields']['nothing']['alter']['text'] = '[field_meeting_agenda_html] | [field_meeting_agenda_pdf]';
  $handler->display->display_options['fields']['nothing']['element_label_colon'] = FALSE;
  $handler->display->display_options['defaults']['sorts'] = FALSE;
  /* Sort criterion: Content: Date -  start date (field_date) */
  $handler->display->display_options['sorts']['field_date_value']['id'] = 'field_date_value';
  $handler->display->display_options['sorts']['field_date_value']['table'] = 'field_data_field_date';
  $handler->display->display_options['sorts']['field_date_value']['field'] = 'field_date_value';
  $handler->display->display_options['defaults']['filter_groups'] = FALSE;
  $handler->display->display_options['defaults']['filters'] = FALSE;
  /* Filter criterion: Content: Published status */
  $handler->display->display_options['filters']['status']['id'] = 'status';
  $handler->display->display_options['filters']['status']['table'] = 'node';
  $handler->display->display_options['filters']['status']['field'] = 'status';
  $handler->display->display_options['filters']['status']['value'] = 1;
  $handler->display->display_options['filters']['status']['group'] = 1;
  $handler->display->display_options['filters']['status']['expose']['operator'] = FALSE;
  /* Filter criterion: Content: Type */
  $handler->display->display_options['filters']['type']['id'] = 'type';
  $handler->display->display_options['filters']['type']['table'] = 'node';
  $handler->display->display_options['filters']['type']['field'] = 'type';
  $handler->display->display_options['filters']['type']['value'] = array(
    'meeting' => 'meeting',
  );
  /* Filter criterion: Content: Date -  start date (field_date) */
  $handler->display->display_options['filters']['field_date_value']['id'] = 'field_date_value';
  $handler->display->display_options['filters']['field_date_value']['table'] = 'field_data_field_date';
  $handler->display->display_options['filters']['field_date_value']['field'] = 'field_date_value';
  $handler->display->display_options['filters']['field_date_value']['operator'] = '>=';
  $handler->display->display_options['filters']['field_date_value']['default_date'] = 'now';
  /* Filter criterion: Content: Meeting Type (field_meeting_type) */
  $handler->display->display_options['filters']['field_meeting_type_tid']['id'] = 'field_meeting_type_tid';
  $handler->display->display_options['filters']['field_meeting_type_tid']['table'] = 'field_data_field_meeting_type';
  $handler->display->display_options['filters']['field_meeting_type_tid']['field'] = 'field_meeting_type_tid';
  $handler->display->display_options['filters']['field_meeting_type_tid']['value'] = array(
    2166 => '2166',
  );
  $handler->display->display_options['filters']['field_meeting_type_tid']['type'] = 'select';
  $handler->display->display_options['filters']['field_meeting_type_tid']['vocabulary'] = 'meeting_type';
  $handler->display->display_options['block_description'] = 'Meetings - Upcoming - Board of Variance';

  /* Display: Block */
  $handler = $view->new_display('block', 'Block', 'block_7');
  $handler->display->display_options['defaults']['title'] = FALSE;
  $handler->display->display_options['title'] = 'Meetings - Upcoming - Civic and Community';
  $handler->display->display_options['defaults']['pager'] = FALSE;
  $handler->display->display_options['pager']['type'] = 'some';
  $handler->display->display_options['pager']['options']['items_per_page'] = '10';
  $handler->display->display_options['defaults']['style_plugin'] = FALSE;
  $handler->display->display_options['style_plugin'] = 'table';
  $handler->display->display_options['style_options']['columns'] = array(
    'title' => 'title',
    'field_date' => 'field_date',
    'field_meeting_location' => 'field_meeting_location',
  );
  $handler->display->display_options['style_options']['default'] = '-1';
  $handler->display->display_options['style_options']['info'] = array(
    'title' => array(
      'sortable' => 0,
      'default_sort_order' => 'asc',
      'align' => '',
      'separator' => '',
      'empty_column' => 0,
    ),
    'field_date' => array(
      'align' => '',
      'separator' => '',
      'empty_column' => 0,
    ),
    'field_meeting_location' => array(
      'sortable' => 0,
      'default_sort_order' => 'asc',
      'align' => '',
      'separator' => '',
      'empty_column' => 0,
    ),
  );
  $handler->display->display_options['defaults']['style_options'] = FALSE;
  $handler->display->display_options['defaults']['row_plugin'] = FALSE;
  $handler->display->display_options['defaults']['row_options'] = FALSE;
  $handler->display->display_options['defaults']['footer'] = FALSE;
  /* Footer: Global: Text area */
  $handler->display->display_options['footer']['area']['id'] = 'area';
  $handler->display->display_options['footer']['area']['table'] = 'views';
  $handler->display->display_options['footer']['area']['field'] = 'area';
  $handler->display->display_options['footer']['area']['empty'] = TRUE;
  $handler->display->display_options['footer']['area']['content'] = '<h4><a href="/city-hall/council/committees/civic-and-community-awards-steering-committee/meeting-archives">Meeting Archives</a></h4>';
  $handler->display->display_options['footer']['area']['format'] = 'full_html';
  $handler->display->display_options['defaults']['empty'] = FALSE;
  /* No results behavior: Global: Text area */
  $handler->display->display_options['empty']['area']['id'] = 'area';
  $handler->display->display_options['empty']['area']['table'] = 'views';
  $handler->display->display_options['empty']['area']['field'] = 'area';
  $handler->display->display_options['empty']['area']['empty'] = TRUE;
  $handler->display->display_options['empty']['area']['content'] = '<p>There are no upcoming meetings posted at this time. Please check back or subscribe to our <a href="/rss/meetings.xml">RSS feed</a> for notification.</p>';
  $handler->display->display_options['empty']['area']['format'] = 'full_html';
  $handler->display->display_options['defaults']['fields'] = FALSE;
  /* Field: Content: Title */
  $handler->display->display_options['fields']['title']['id'] = 'title';
  $handler->display->display_options['fields']['title']['table'] = 'node';
  $handler->display->display_options['fields']['title']['field'] = 'title';
  $handler->display->display_options['fields']['title']['label'] = 'Meeting';
  $handler->display->display_options['fields']['title']['alter']['word_boundary'] = FALSE;
  $handler->display->display_options['fields']['title']['alter']['ellipsis'] = FALSE;
  $handler->display->display_options['fields']['title']['element_label_colon'] = FALSE;
  $handler->display->display_options['fields']['title']['link_to_node'] = FALSE;
  /* Field: Content: Date */
  $handler->display->display_options['fields']['field_date']['id'] = 'field_date';
  $handler->display->display_options['fields']['field_date']['table'] = 'field_data_field_date';
  $handler->display->display_options['fields']['field_date']['field'] = 'field_date';
  $handler->display->display_options['fields']['field_date']['element_label_colon'] = FALSE;
  $handler->display->display_options['fields']['field_date']['settings'] = array(
    'format_type' => 'month_day_year_time',
    'fromto' => 'both',
    'multiple_number' => '',
    'multiple_from' => '',
    'multiple_to' => '',
    'show_remaining_days' => 0,
    'show_repeat_rule' => 'show',
    'linked_field' => array(
      'linked' => 0,
      'destination' => '',
      'advanced' => array(
        'title' => '',
        'target' => '',
        'class' => '',
        'rel' => '',
        'text' => '',
      ),
    ),
  );
  $handler->display->display_options['fields']['field_date']['delta_offset'] = '0';
  /* Field: Content: Meeting Address */
  $handler->display->display_options['fields']['field_meeting_address']['id'] = 'field_meeting_address';
  $handler->display->display_options['fields']['field_meeting_address']['table'] = 'field_data_field_meeting_address';
  $handler->display->display_options['fields']['field_meeting_address']['field'] = 'field_meeting_address';
  $handler->display->display_options['fields']['field_meeting_address']['label'] = '';
  $handler->display->display_options['fields']['field_meeting_address']['exclude'] = TRUE;
  $handler->display->display_options['fields']['field_meeting_address']['element_label_colon'] = FALSE;
  $handler->display->display_options['fields']['field_meeting_address']['type'] = 'text_plain';
  $handler->display->display_options['fields']['field_meeting_address']['settings'] = array(
    'linked_field' => array(
      'linked' => 0,
      'destination' => '',
      'advanced' => array(
        'title' => '',
        'target' => '',
        'class' => '',
        'rel' => '',
        'text' => '',
      ),
    ),
  );
  /* Field: Content: Meeting Location */
  $handler->display->display_options['fields']['field_meeting_location']['id'] = 'field_meeting_location';
  $handler->display->display_options['fields']['field_meeting_location']['table'] = 'field_data_field_meeting_location';
  $handler->display->display_options['fields']['field_meeting_location']['field'] = 'field_meeting_location';
  $handler->display->display_options['fields']['field_meeting_location']['label'] = 'Location';
  $handler->display->display_options['fields']['field_meeting_location']['alter']['alter_text'] = TRUE;
  $handler->display->display_options['fields']['field_meeting_location']['alter']['text'] = '[field_meeting_location]<br>
[field_meeting_address]';
  $handler->display->display_options['fields']['field_meeting_location']['element_label_colon'] = FALSE;
  $handler->display->display_options['fields']['field_meeting_location']['settings'] = array(
    'linked_field' => array(
      'linked' => 0,
      'destination' => '',
      'advanced' => array(
        'title' => '',
        'target' => '',
        'class' => '',
        'rel' => '',
        'text' => '',
      ),
    ),
  );
  /* Field: Content: Meeting Agenda HTML */
  $handler->display->display_options['fields']['field_meeting_agenda_html']['id'] = 'field_meeting_agenda_html';
  $handler->display->display_options['fields']['field_meeting_agenda_html']['table'] = 'field_data_field_meeting_agenda_html';
  $handler->display->display_options['fields']['field_meeting_agenda_html']['field'] = 'field_meeting_agenda_html';
  $handler->display->display_options['fields']['field_meeting_agenda_html']['label'] = '';
  $handler->display->display_options['fields']['field_meeting_agenda_html']['exclude'] = TRUE;
  $handler->display->display_options['fields']['field_meeting_agenda_html']['alter']['alter_text'] = TRUE;
  $handler->display->display_options['fields']['field_meeting_agenda_html']['alter']['text'] = '<a href="[field_meeting_agenda_html]" target="_blank">HTML</a>';
  $handler->display->display_options['fields']['field_meeting_agenda_html']['element_label_colon'] = FALSE;
  $handler->display->display_options['fields']['field_meeting_agenda_html']['settings'] = array(
    'linked_field' => array(
      'linked' => 0,
      'destination' => '',
      'advanced' => array(
        'title' => '',
        'target' => '',
        'class' => '',
        'rel' => '',
        'text' => '',
      ),
    ),
  );
  /* Field: Content: Meeting Agenda PDF */
  $handler->display->display_options['fields']['field_meeting_agenda_pdf']['id'] = 'field_meeting_agenda_pdf';
  $handler->display->display_options['fields']['field_meeting_agenda_pdf']['table'] = 'field_data_field_meeting_agenda_pdf';
  $handler->display->display_options['fields']['field_meeting_agenda_pdf']['field'] = 'field_meeting_agenda_pdf';
  $handler->display->display_options['fields']['field_meeting_agenda_pdf']['label'] = '';
  $handler->display->display_options['fields']['field_meeting_agenda_pdf']['exclude'] = TRUE;
  $handler->display->display_options['fields']['field_meeting_agenda_pdf']['alter']['alter_text'] = TRUE;
  $handler->display->display_options['fields']['field_meeting_agenda_pdf']['alter']['text'] = '<a href="[field_meeting_agenda_pdf]" target="_blank">PDF</a>';
  $handler->display->display_options['fields']['field_meeting_agenda_pdf']['element_label_colon'] = FALSE;
  $handler->display->display_options['fields']['field_meeting_agenda_pdf']['settings'] = array(
    'linked_field' => array(
      'linked' => 0,
      'destination' => '',
      'advanced' => array(
        'title' => '',
        'target' => '',
        'class' => '',
        'rel' => '',
        'text' => '',
      ),
    ),
  );
  /* Field: Global: Custom text */
  $handler->display->display_options['fields']['nothing']['id'] = 'nothing';
  $handler->display->display_options['fields']['nothing']['table'] = 'views';
  $handler->display->display_options['fields']['nothing']['field'] = 'nothing';
  $handler->display->display_options['fields']['nothing']['label'] = 'Agenda';
  $handler->display->display_options['fields']['nothing']['alter']['text'] = '[field_meeting_agenda_html] | [field_meeting_agenda_pdf]';
  $handler->display->display_options['fields']['nothing']['element_label_colon'] = FALSE;
  $handler->display->display_options['defaults']['sorts'] = FALSE;
  /* Sort criterion: Content: Date -  start date (field_date) */
  $handler->display->display_options['sorts']['field_date_value']['id'] = 'field_date_value';
  $handler->display->display_options['sorts']['field_date_value']['table'] = 'field_data_field_date';
  $handler->display->display_options['sorts']['field_date_value']['field'] = 'field_date_value';
  $handler->display->display_options['defaults']['filter_groups'] = FALSE;
  $handler->display->display_options['defaults']['filters'] = FALSE;
  /* Filter criterion: Content: Published status */
  $handler->display->display_options['filters']['status']['id'] = 'status';
  $handler->display->display_options['filters']['status']['table'] = 'node';
  $handler->display->display_options['filters']['status']['field'] = 'status';
  $handler->display->display_options['filters']['status']['value'] = 1;
  $handler->display->display_options['filters']['status']['group'] = 1;
  $handler->display->display_options['filters']['status']['expose']['operator'] = FALSE;
  /* Filter criterion: Content: Type */
  $handler->display->display_options['filters']['type']['id'] = 'type';
  $handler->display->display_options['filters']['type']['table'] = 'node';
  $handler->display->display_options['filters']['type']['field'] = 'type';
  $handler->display->display_options['filters']['type']['value'] = array(
    'meeting' => 'meeting',
  );
  /* Filter criterion: Content: Date -  start date (field_date) */
  $handler->display->display_options['filters']['field_date_value']['id'] = 'field_date_value';
  $handler->display->display_options['filters']['field_date_value']['table'] = 'field_data_field_date';
  $handler->display->display_options['filters']['field_date_value']['field'] = 'field_date_value';
  $handler->display->display_options['filters']['field_date_value']['operator'] = '>=';
  $handler->display->display_options['filters']['field_date_value']['default_date'] = 'now';
  /* Filter criterion: Content: Meeting Type (field_meeting_type) */
  $handler->display->display_options['filters']['field_meeting_type_tid']['id'] = 'field_meeting_type_tid';
  $handler->display->display_options['filters']['field_meeting_type_tid']['table'] = 'field_data_field_meeting_type';
  $handler->display->display_options['filters']['field_meeting_type_tid']['field'] = 'field_meeting_type_tid';
  $handler->display->display_options['filters']['field_meeting_type_tid']['value'] = array(
    2144 => '2144',
  );
  $handler->display->display_options['filters']['field_meeting_type_tid']['type'] = 'select';
  $handler->display->display_options['filters']['field_meeting_type_tid']['vocabulary'] = 'meeting_type';
  $handler->display->display_options['block_description'] = 'Meetings - Upcoming - Civic and Community';

  /* Display: Block */
  $handler = $view->new_display('block', 'Block', 'block_8');
  $handler->display->display_options['defaults']['title'] = FALSE;
  $handler->display->display_options['title'] = 'Meetings - Upcoming - Heritage';
  $handler->display->display_options['defaults']['pager'] = FALSE;
  $handler->display->display_options['pager']['type'] = 'some';
  $handler->display->display_options['pager']['options']['items_per_page'] = '10';
  $handler->display->display_options['defaults']['style_plugin'] = FALSE;
  $handler->display->display_options['style_plugin'] = 'table';
  $handler->display->display_options['style_options']['columns'] = array(
    'title' => 'title',
    'field_date' => 'field_date',
    'field_meeting_location' => 'field_meeting_location',
  );
  $handler->display->display_options['style_options']['default'] = '-1';
  $handler->display->display_options['style_options']['info'] = array(
    'title' => array(
      'sortable' => 0,
      'default_sort_order' => 'asc',
      'align' => '',
      'separator' => '',
      'empty_column' => 0,
    ),
    'field_date' => array(
      'align' => '',
      'separator' => '',
      'empty_column' => 0,
    ),
    'field_meeting_location' => array(
      'sortable' => 0,
      'default_sort_order' => 'asc',
      'align' => '',
      'separator' => '',
      'empty_column' => 0,
    ),
  );
  $handler->display->display_options['defaults']['style_options'] = FALSE;
  $handler->display->display_options['defaults']['row_plugin'] = FALSE;
  $handler->display->display_options['defaults']['row_options'] = FALSE;
  $handler->display->display_options['defaults']['footer'] = FALSE;
  /* Footer: Global: Text area */
  $handler->display->display_options['footer']['area']['id'] = 'area';
  $handler->display->display_options['footer']['area']['table'] = 'views';
  $handler->display->display_options['footer']['area']['field'] = 'area';
  $handler->display->display_options['footer']['area']['empty'] = TRUE;
  $handler->display->display_options['footer']['area']['content'] = '<h4><a href="/city-hall/council/committees/heritage-advisory-committee/meeting-archives">Meeting Archives</a></h4>';
  $handler->display->display_options['footer']['area']['format'] = 'full_html';
  $handler->display->display_options['defaults']['empty'] = FALSE;
  /* No results behavior: Global: Text area */
  $handler->display->display_options['empty']['area']['id'] = 'area';
  $handler->display->display_options['empty']['area']['table'] = 'views';
  $handler->display->display_options['empty']['area']['field'] = 'area';
  $handler->display->display_options['empty']['area']['empty'] = TRUE;
  $handler->display->display_options['empty']['area']['content'] = '<p>There are no upcoming meetings posted at this time. Please check back or subscribe to our <a href="/rss/meetings.xml">RSS feed</a> for notification.</p>';
  $handler->display->display_options['empty']['area']['format'] = 'full_html';
  $handler->display->display_options['defaults']['fields'] = FALSE;
  /* Field: Content: Title */
  $handler->display->display_options['fields']['title']['id'] = 'title';
  $handler->display->display_options['fields']['title']['table'] = 'node';
  $handler->display->display_options['fields']['title']['field'] = 'title';
  $handler->display->display_options['fields']['title']['label'] = 'Meeting';
  $handler->display->display_options['fields']['title']['alter']['word_boundary'] = FALSE;
  $handler->display->display_options['fields']['title']['alter']['ellipsis'] = FALSE;
  $handler->display->display_options['fields']['title']['element_label_colon'] = FALSE;
  $handler->display->display_options['fields']['title']['link_to_node'] = FALSE;
  /* Field: Content: Date */
  $handler->display->display_options['fields']['field_date']['id'] = 'field_date';
  $handler->display->display_options['fields']['field_date']['table'] = 'field_data_field_date';
  $handler->display->display_options['fields']['field_date']['field'] = 'field_date';
  $handler->display->display_options['fields']['field_date']['element_label_colon'] = FALSE;
  $handler->display->display_options['fields']['field_date']['settings'] = array(
    'format_type' => 'month_day_year_time',
    'fromto' => 'both',
    'multiple_number' => '',
    'multiple_from' => '',
    'multiple_to' => '',
    'show_remaining_days' => 0,
    'show_repeat_rule' => 'show',
    'linked_field' => array(
      'linked' => 0,
      'destination' => '',
      'advanced' => array(
        'title' => '',
        'target' => '',
        'class' => '',
        'rel' => '',
        'text' => '',
      ),
    ),
  );
  $handler->display->display_options['fields']['field_date']['delta_offset'] = '0';
  /* Field: Content: Meeting Address */
  $handler->display->display_options['fields']['field_meeting_address']['id'] = 'field_meeting_address';
  $handler->display->display_options['fields']['field_meeting_address']['table'] = 'field_data_field_meeting_address';
  $handler->display->display_options['fields']['field_meeting_address']['field'] = 'field_meeting_address';
  $handler->display->display_options['fields']['field_meeting_address']['label'] = '';
  $handler->display->display_options['fields']['field_meeting_address']['exclude'] = TRUE;
  $handler->display->display_options['fields']['field_meeting_address']['element_label_colon'] = FALSE;
  $handler->display->display_options['fields']['field_meeting_address']['type'] = 'text_plain';
  $handler->display->display_options['fields']['field_meeting_address']['settings'] = array(
    'linked_field' => array(
      'linked' => 0,
      'destination' => '',
      'advanced' => array(
        'title' => '',
        'target' => '',
        'class' => '',
        'rel' => '',
        'text' => '',
      ),
    ),
  );
  /* Field: Content: Meeting Location */
  $handler->display->display_options['fields']['field_meeting_location']['id'] = 'field_meeting_location';
  $handler->display->display_options['fields']['field_meeting_location']['table'] = 'field_data_field_meeting_location';
  $handler->display->display_options['fields']['field_meeting_location']['field'] = 'field_meeting_location';
  $handler->display->display_options['fields']['field_meeting_location']['label'] = 'Location';
  $handler->display->display_options['fields']['field_meeting_location']['alter']['alter_text'] = TRUE;
  $handler->display->display_options['fields']['field_meeting_location']['alter']['text'] = '[field_meeting_location]<br>
[field_meeting_address]';
  $handler->display->display_options['fields']['field_meeting_location']['element_label_colon'] = FALSE;
  $handler->display->display_options['fields']['field_meeting_location']['settings'] = array(
    'linked_field' => array(
      'linked' => 0,
      'destination' => '',
      'advanced' => array(
        'title' => '',
        'target' => '',
        'class' => '',
        'rel' => '',
        'text' => '',
      ),
    ),
  );
  /* Field: Content: Meeting Agenda HTML */
  $handler->display->display_options['fields']['field_meeting_agenda_html']['id'] = 'field_meeting_agenda_html';
  $handler->display->display_options['fields']['field_meeting_agenda_html']['table'] = 'field_data_field_meeting_agenda_html';
  $handler->display->display_options['fields']['field_meeting_agenda_html']['field'] = 'field_meeting_agenda_html';
  $handler->display->display_options['fields']['field_meeting_agenda_html']['label'] = '';
  $handler->display->display_options['fields']['field_meeting_agenda_html']['exclude'] = TRUE;
  $handler->display->display_options['fields']['field_meeting_agenda_html']['alter']['alter_text'] = TRUE;
  $handler->display->display_options['fields']['field_meeting_agenda_html']['alter']['text'] = '<a href="[field_meeting_agenda_html]" target="_blank">HTML</a>';
  $handler->display->display_options['fields']['field_meeting_agenda_html']['element_label_colon'] = FALSE;
  $handler->display->display_options['fields']['field_meeting_agenda_html']['settings'] = array(
    'linked_field' => array(
      'linked' => 0,
      'destination' => '',
      'advanced' => array(
        'title' => '',
        'target' => '',
        'class' => '',
        'rel' => '',
        'text' => '',
      ),
    ),
  );
  /* Field: Content: Meeting Agenda PDF */
  $handler->display->display_options['fields']['field_meeting_agenda_pdf']['id'] = 'field_meeting_agenda_pdf';
  $handler->display->display_options['fields']['field_meeting_agenda_pdf']['table'] = 'field_data_field_meeting_agenda_pdf';
  $handler->display->display_options['fields']['field_meeting_agenda_pdf']['field'] = 'field_meeting_agenda_pdf';
  $handler->display->display_options['fields']['field_meeting_agenda_pdf']['label'] = '';
  $handler->display->display_options['fields']['field_meeting_agenda_pdf']['exclude'] = TRUE;
  $handler->display->display_options['fields']['field_meeting_agenda_pdf']['alter']['alter_text'] = TRUE;
  $handler->display->display_options['fields']['field_meeting_agenda_pdf']['alter']['text'] = '<a href="[field_meeting_agenda_pdf]" target="_blank">PDF</a>';
  $handler->display->display_options['fields']['field_meeting_agenda_pdf']['element_label_colon'] = FALSE;
  $handler->display->display_options['fields']['field_meeting_agenda_pdf']['settings'] = array(
    'linked_field' => array(
      'linked' => 0,
      'destination' => '',
      'advanced' => array(
        'title' => '',
        'target' => '',
        'class' => '',
        'rel' => '',
        'text' => '',
      ),
    ),
  );
  /* Field: Global: Custom text */
  $handler->display->display_options['fields']['nothing']['id'] = 'nothing';
  $handler->display->display_options['fields']['nothing']['table'] = 'views';
  $handler->display->display_options['fields']['nothing']['field'] = 'nothing';
  $handler->display->display_options['fields']['nothing']['label'] = 'Agenda';
  $handler->display->display_options['fields']['nothing']['alter']['text'] = '[field_meeting_agenda_html] | [field_meeting_agenda_pdf]';
  $handler->display->display_options['fields']['nothing']['element_label_colon'] = FALSE;
  $handler->display->display_options['defaults']['sorts'] = FALSE;
  /* Sort criterion: Content: Date -  start date (field_date) */
  $handler->display->display_options['sorts']['field_date_value']['id'] = 'field_date_value';
  $handler->display->display_options['sorts']['field_date_value']['table'] = 'field_data_field_date';
  $handler->display->display_options['sorts']['field_date_value']['field'] = 'field_date_value';
  $handler->display->display_options['defaults']['filter_groups'] = FALSE;
  $handler->display->display_options['defaults']['filters'] = FALSE;
  /* Filter criterion: Content: Published status */
  $handler->display->display_options['filters']['status']['id'] = 'status';
  $handler->display->display_options['filters']['status']['table'] = 'node';
  $handler->display->display_options['filters']['status']['field'] = 'status';
  $handler->display->display_options['filters']['status']['value'] = 1;
  $handler->display->display_options['filters']['status']['group'] = 1;
  $handler->display->display_options['filters']['status']['expose']['operator'] = FALSE;
  /* Filter criterion: Content: Type */
  $handler->display->display_options['filters']['type']['id'] = 'type';
  $handler->display->display_options['filters']['type']['table'] = 'node';
  $handler->display->display_options['filters']['type']['field'] = 'type';
  $handler->display->display_options['filters']['type']['value'] = array(
    'meeting' => 'meeting',
  );
  /* Filter criterion: Content: Date -  start date (field_date) */
  $handler->display->display_options['filters']['field_date_value']['id'] = 'field_date_value';
  $handler->display->display_options['filters']['field_date_value']['table'] = 'field_data_field_date';
  $handler->display->display_options['filters']['field_date_value']['field'] = 'field_date_value';
  $handler->display->display_options['filters']['field_date_value']['operator'] = '>=';
  $handler->display->display_options['filters']['field_date_value']['default_date'] = 'now';
  /* Filter criterion: Content: Meeting Type (field_meeting_type) */
  $handler->display->display_options['filters']['field_meeting_type_tid']['id'] = 'field_meeting_type_tid';
  $handler->display->display_options['filters']['field_meeting_type_tid']['table'] = 'field_data_field_meeting_type';
  $handler->display->display_options['filters']['field_meeting_type_tid']['field'] = 'field_meeting_type_tid';
  $handler->display->display_options['filters']['field_meeting_type_tid']['value'] = array(
    2165 => '2165',
  );
  $handler->display->display_options['filters']['field_meeting_type_tid']['type'] = 'select';
  $handler->display->display_options['filters']['field_meeting_type_tid']['vocabulary'] = 'meeting_type';
  $handler->display->display_options['block_description'] = 'Meetings - Upcoming - Heritage';

  /* Display: Block */
  $handler = $view->new_display('block', 'Block', 'block_9');
  $handler->display->display_options['defaults']['title'] = FALSE;
  $handler->display->display_options['title'] = 'Meetings - Upcoming - Parcel Tax';
  $handler->display->display_options['defaults']['pager'] = FALSE;
  $handler->display->display_options['pager']['type'] = 'some';
  $handler->display->display_options['pager']['options']['items_per_page'] = '10';
  $handler->display->display_options['defaults']['style_plugin'] = FALSE;
  $handler->display->display_options['style_plugin'] = 'table';
  $handler->display->display_options['style_options']['columns'] = array(
    'title' => 'title',
    'field_date' => 'field_date',
    'field_meeting_location' => 'field_meeting_location',
  );
  $handler->display->display_options['style_options']['default'] = '-1';
  $handler->display->display_options['style_options']['info'] = array(
    'title' => array(
      'sortable' => 0,
      'default_sort_order' => 'asc',
      'align' => '',
      'separator' => '',
      'empty_column' => 0,
    ),
    'field_date' => array(
      'align' => '',
      'separator' => '',
      'empty_column' => 0,
    ),
    'field_meeting_location' => array(
      'sortable' => 0,
      'default_sort_order' => 'asc',
      'align' => '',
      'separator' => '',
      'empty_column' => 0,
    ),
  );
  $handler->display->display_options['defaults']['style_options'] = FALSE;
  $handler->display->display_options['defaults']['row_plugin'] = FALSE;
  $handler->display->display_options['defaults']['row_options'] = FALSE;
  $handler->display->display_options['defaults']['footer'] = FALSE;
  /* Footer: Global: Text area */
  $handler->display->display_options['footer']['area']['id'] = 'area';
  $handler->display->display_options['footer']['area']['table'] = 'views';
  $handler->display->display_options['footer']['area']['field'] = 'area';
  $handler->display->display_options['footer']['area']['empty'] = TRUE;
  $handler->display->display_options['footer']['area']['content'] = '<h4><a href="/city-hall/council/committees/parcel-tax-review-panel/meeting-archives">Meeting Archives</a></h4>';
  $handler->display->display_options['footer']['area']['format'] = 'full_html';
  $handler->display->display_options['defaults']['empty'] = FALSE;
  /* No results behavior: Global: Text area */
  $handler->display->display_options['empty']['area']['id'] = 'area';
  $handler->display->display_options['empty']['area']['table'] = 'views';
  $handler->display->display_options['empty']['area']['field'] = 'area';
  $handler->display->display_options['empty']['area']['empty'] = TRUE;
  $handler->display->display_options['empty']['area']['content'] = '<p>There are no upcoming meetings posted at this time. Please check back or subscribe to our <a href="/rss/meetings.xml">RSS feed</a> for notification.</p>';
  $handler->display->display_options['empty']['area']['format'] = 'full_html';
  $handler->display->display_options['defaults']['fields'] = FALSE;
  /* Field: Content: Title */
  $handler->display->display_options['fields']['title']['id'] = 'title';
  $handler->display->display_options['fields']['title']['table'] = 'node';
  $handler->display->display_options['fields']['title']['field'] = 'title';
  $handler->display->display_options['fields']['title']['label'] = 'Meeting';
  $handler->display->display_options['fields']['title']['alter']['word_boundary'] = FALSE;
  $handler->display->display_options['fields']['title']['alter']['ellipsis'] = FALSE;
  $handler->display->display_options['fields']['title']['element_label_colon'] = FALSE;
  $handler->display->display_options['fields']['title']['link_to_node'] = FALSE;
  /* Field: Content: Date */
  $handler->display->display_options['fields']['field_date']['id'] = 'field_date';
  $handler->display->display_options['fields']['field_date']['table'] = 'field_data_field_date';
  $handler->display->display_options['fields']['field_date']['field'] = 'field_date';
  $handler->display->display_options['fields']['field_date']['element_label_colon'] = FALSE;
  $handler->display->display_options['fields']['field_date']['settings'] = array(
    'format_type' => 'month_day_year_time',
    'fromto' => 'both',
    'multiple_number' => '',
    'multiple_from' => '',
    'multiple_to' => '',
    'show_remaining_days' => 0,
    'show_repeat_rule' => 'show',
    'linked_field' => array(
      'linked' => 0,
      'destination' => '',
      'advanced' => array(
        'title' => '',
        'target' => '',
        'class' => '',
        'rel' => '',
        'text' => '',
      ),
    ),
  );
  $handler->display->display_options['fields']['field_date']['delta_offset'] = '0';
  /* Field: Content: Meeting Address */
  $handler->display->display_options['fields']['field_meeting_address']['id'] = 'field_meeting_address';
  $handler->display->display_options['fields']['field_meeting_address']['table'] = 'field_data_field_meeting_address';
  $handler->display->display_options['fields']['field_meeting_address']['field'] = 'field_meeting_address';
  $handler->display->display_options['fields']['field_meeting_address']['label'] = '';
  $handler->display->display_options['fields']['field_meeting_address']['exclude'] = TRUE;
  $handler->display->display_options['fields']['field_meeting_address']['element_label_colon'] = FALSE;
  $handler->display->display_options['fields']['field_meeting_address']['type'] = 'text_plain';
  $handler->display->display_options['fields']['field_meeting_address']['settings'] = array(
    'linked_field' => array(
      'linked' => 0,
      'destination' => '',
      'advanced' => array(
        'title' => '',
        'target' => '',
        'class' => '',
        'rel' => '',
        'text' => '',
      ),
    ),
  );
  /* Field: Content: Meeting Location */
  $handler->display->display_options['fields']['field_meeting_location']['id'] = 'field_meeting_location';
  $handler->display->display_options['fields']['field_meeting_location']['table'] = 'field_data_field_meeting_location';
  $handler->display->display_options['fields']['field_meeting_location']['field'] = 'field_meeting_location';
  $handler->display->display_options['fields']['field_meeting_location']['label'] = 'Location';
  $handler->display->display_options['fields']['field_meeting_location']['alter']['alter_text'] = TRUE;
  $handler->display->display_options['fields']['field_meeting_location']['alter']['text'] = '[field_meeting_location]<br>
[field_meeting_address]';
  $handler->display->display_options['fields']['field_meeting_location']['element_label_colon'] = FALSE;
  $handler->display->display_options['fields']['field_meeting_location']['settings'] = array(
    'linked_field' => array(
      'linked' => 0,
      'destination' => '',
      'advanced' => array(
        'title' => '',
        'target' => '',
        'class' => '',
        'rel' => '',
        'text' => '',
      ),
    ),
  );
  /* Field: Content: Meeting Agenda HTML */
  $handler->display->display_options['fields']['field_meeting_agenda_html']['id'] = 'field_meeting_agenda_html';
  $handler->display->display_options['fields']['field_meeting_agenda_html']['table'] = 'field_data_field_meeting_agenda_html';
  $handler->display->display_options['fields']['field_meeting_agenda_html']['field'] = 'field_meeting_agenda_html';
  $handler->display->display_options['fields']['field_meeting_agenda_html']['label'] = '';
  $handler->display->display_options['fields']['field_meeting_agenda_html']['exclude'] = TRUE;
  $handler->display->display_options['fields']['field_meeting_agenda_html']['alter']['alter_text'] = TRUE;
  $handler->display->display_options['fields']['field_meeting_agenda_html']['alter']['text'] = '<a href="[field_meeting_agenda_html]" target="_blank">HTML</a>';
  $handler->display->display_options['fields']['field_meeting_agenda_html']['element_label_colon'] = FALSE;
  $handler->display->display_options['fields']['field_meeting_agenda_html']['settings'] = array(
    'linked_field' => array(
      'linked' => 0,
      'destination' => '',
      'advanced' => array(
        'title' => '',
        'target' => '',
        'class' => '',
        'rel' => '',
        'text' => '',
      ),
    ),
  );
  /* Field: Content: Meeting Agenda PDF */
  $handler->display->display_options['fields']['field_meeting_agenda_pdf']['id'] = 'field_meeting_agenda_pdf';
  $handler->display->display_options['fields']['field_meeting_agenda_pdf']['table'] = 'field_data_field_meeting_agenda_pdf';
  $handler->display->display_options['fields']['field_meeting_agenda_pdf']['field'] = 'field_meeting_agenda_pdf';
  $handler->display->display_options['fields']['field_meeting_agenda_pdf']['label'] = '';
  $handler->display->display_options['fields']['field_meeting_agenda_pdf']['exclude'] = TRUE;
  $handler->display->display_options['fields']['field_meeting_agenda_pdf']['alter']['alter_text'] = TRUE;
  $handler->display->display_options['fields']['field_meeting_agenda_pdf']['alter']['text'] = '<a href="[field_meeting_agenda_pdf]" target="_blank">PDF</a>';
  $handler->display->display_options['fields']['field_meeting_agenda_pdf']['element_label_colon'] = FALSE;
  $handler->display->display_options['fields']['field_meeting_agenda_pdf']['settings'] = array(
    'linked_field' => array(
      'linked' => 0,
      'destination' => '',
      'advanced' => array(
        'title' => '',
        'target' => '',
        'class' => '',
        'rel' => '',
        'text' => '',
      ),
    ),
  );
  /* Field: Global: Custom text */
  $handler->display->display_options['fields']['nothing']['id'] = 'nothing';
  $handler->display->display_options['fields']['nothing']['table'] = 'views';
  $handler->display->display_options['fields']['nothing']['field'] = 'nothing';
  $handler->display->display_options['fields']['nothing']['label'] = 'Agenda';
  $handler->display->display_options['fields']['nothing']['alter']['text'] = '[field_meeting_agenda_html] | [field_meeting_agenda_pdf]';
  $handler->display->display_options['fields']['nothing']['element_label_colon'] = FALSE;
  $handler->display->display_options['defaults']['sorts'] = FALSE;
  /* Sort criterion: Content: Date -  start date (field_date) */
  $handler->display->display_options['sorts']['field_date_value']['id'] = 'field_date_value';
  $handler->display->display_options['sorts']['field_date_value']['table'] = 'field_data_field_date';
  $handler->display->display_options['sorts']['field_date_value']['field'] = 'field_date_value';
  $handler->display->display_options['defaults']['filter_groups'] = FALSE;
  $handler->display->display_options['defaults']['filters'] = FALSE;
  /* Filter criterion: Content: Published status */
  $handler->display->display_options['filters']['status']['id'] = 'status';
  $handler->display->display_options['filters']['status']['table'] = 'node';
  $handler->display->display_options['filters']['status']['field'] = 'status';
  $handler->display->display_options['filters']['status']['value'] = 1;
  $handler->display->display_options['filters']['status']['group'] = 1;
  $handler->display->display_options['filters']['status']['expose']['operator'] = FALSE;
  /* Filter criterion: Content: Type */
  $handler->display->display_options['filters']['type']['id'] = 'type';
  $handler->display->display_options['filters']['type']['table'] = 'node';
  $handler->display->display_options['filters']['type']['field'] = 'type';
  $handler->display->display_options['filters']['type']['value'] = array(
    'meeting' => 'meeting',
  );
  /* Filter criterion: Content: Date -  start date (field_date) */
  $handler->display->display_options['filters']['field_date_value']['id'] = 'field_date_value';
  $handler->display->display_options['filters']['field_date_value']['table'] = 'field_data_field_date';
  $handler->display->display_options['filters']['field_date_value']['field'] = 'field_date_value';
  $handler->display->display_options['filters']['field_date_value']['operator'] = '>=';
  $handler->display->display_options['filters']['field_date_value']['default_date'] = 'now';
  /* Filter criterion: Content: Meeting Type (field_meeting_type) */
  $handler->display->display_options['filters']['field_meeting_type_tid']['id'] = 'field_meeting_type_tid';
  $handler->display->display_options['filters']['field_meeting_type_tid']['table'] = 'field_data_field_meeting_type';
  $handler->display->display_options['filters']['field_meeting_type_tid']['field'] = 'field_meeting_type_tid';
  $handler->display->display_options['filters']['field_meeting_type_tid']['value'] = array(
    2167 => '2167',
  );
  $handler->display->display_options['filters']['field_meeting_type_tid']['type'] = 'select';
  $handler->display->display_options['filters']['field_meeting_type_tid']['vocabulary'] = 'meeting_type';
  $handler->display->display_options['block_description'] = 'Meetings - Upcoming - Parcel Tax';

  /* Display: Block */
  $handler = $view->new_display('block', 'Block', 'block_11');
  $handler->display->display_options['defaults']['title'] = FALSE;
  $handler->display->display_options['title'] = 'Meetings - Past - Agricultural';
  $handler->display->display_options['defaults']['pager'] = FALSE;
  $handler->display->display_options['pager']['type'] = 'full';
  $handler->display->display_options['pager']['options']['items_per_page'] = '10';
  $handler->display->display_options['pager']['options']['offset'] = '0';
  $handler->display->display_options['pager']['options']['id'] = '0';
  $handler->display->display_options['pager']['options']['quantity'] = '9';
  $handler->display->display_options['defaults']['style_plugin'] = FALSE;
  $handler->display->display_options['style_plugin'] = 'table';
  $handler->display->display_options['style_options']['columns'] = array(
    'field_meeting_type' => 'field_meeting_type',
    'field_date' => 'field_date',
    'field_meeting_address' => 'field_meeting_address',
    'field_meeting_location' => 'field_meeting_location',
    'field_meeting_agenda_html' => 'field_meeting_agenda_html',
    'field_meeting_agenda_pdf' => 'field_meeting_agenda_pdf',
    'nothing' => 'nothing',
    'field_meeting_minutes_pdf' => 'field_meeting_minutes_pdf',
  );
  $handler->display->display_options['style_options']['default'] = '-1';
  $handler->display->display_options['style_options']['info'] = array(
    'field_meeting_type' => array(
      'sortable' => 0,
      'default_sort_order' => 'asc',
      'align' => '',
      'separator' => '',
      'empty_column' => 0,
    ),
    'field_date' => array(
      'align' => '',
      'separator' => '',
      'empty_column' => 0,
    ),
    'field_meeting_address' => array(
      'sortable' => 0,
      'default_sort_order' => 'asc',
      'align' => '',
      'separator' => '',
      'empty_column' => 0,
    ),
    'field_meeting_location' => array(
      'sortable' => 0,
      'default_sort_order' => 'asc',
      'align' => '',
      'separator' => '',
      'empty_column' => 0,
    ),
    'field_meeting_agenda_html' => array(
      'sortable' => 0,
      'default_sort_order' => 'asc',
      'align' => '',
      'separator' => '',
      'empty_column' => 0,
    ),
    'field_meeting_agenda_pdf' => array(
      'sortable' => 0,
      'default_sort_order' => 'asc',
      'align' => '',
      'separator' => '',
      'empty_column' => 0,
    ),
    'nothing' => array(
      'align' => '',
      'separator' => '',
      'empty_column' => 0,
    ),
    'field_meeting_minutes_pdf' => array(
      'sortable' => 0,
      'default_sort_order' => 'asc',
      'align' => '',
      'separator' => '',
      'empty_column' => 0,
    ),
  );
  $handler->display->display_options['defaults']['style_options'] = FALSE;
  $handler->display->display_options['defaults']['row_plugin'] = FALSE;
  $handler->display->display_options['defaults']['row_options'] = FALSE;
  $handler->display->display_options['defaults']['footer'] = FALSE;
  /* Footer: Global: Text area */
  $handler->display->display_options['footer']['area']['id'] = 'area';
  $handler->display->display_options['footer']['area']['table'] = 'views';
  $handler->display->display_options['footer']['area']['field'] = 'area';
  $handler->display->display_options['footer']['area']['empty'] = TRUE;
  $handler->display->display_options['footer']['area']['content'] = '<h4><a href="/city-hall/council/committees/agricultural-advisory-committee/meeting-archives">Meeting Archives</a></h4>';
  $handler->display->display_options['footer']['area']['format'] = 'full_html';
  $handler->display->display_options['defaults']['empty'] = FALSE;
  /* No results behavior: Global: Text area */
  $handler->display->display_options['empty']['area']['id'] = 'area';
  $handler->display->display_options['empty']['area']['table'] = 'views';
  $handler->display->display_options['empty']['area']['field'] = 'area';
  $handler->display->display_options['empty']['area']['empty'] = TRUE;
  $handler->display->display_options['empty']['area']['content'] = 'Please refer to the archives for this committee\'s past meeting information.';
  $handler->display->display_options['empty']['area']['format'] = 'full_html';
  $handler->display->display_options['defaults']['fields'] = FALSE;
  /* Field: Content: Meeting Type */
  $handler->display->display_options['fields']['field_meeting_type']['id'] = 'field_meeting_type';
  $handler->display->display_options['fields']['field_meeting_type']['table'] = 'field_data_field_meeting_type';
  $handler->display->display_options['fields']['field_meeting_type']['field'] = 'field_meeting_type';
  $handler->display->display_options['fields']['field_meeting_type']['label'] = '';
  $handler->display->display_options['fields']['field_meeting_type']['exclude'] = TRUE;
  $handler->display->display_options['fields']['field_meeting_type']['element_label_colon'] = FALSE;
  $handler->display->display_options['fields']['field_meeting_type']['type'] = 'taxonomy_term_reference_plain';
  $handler->display->display_options['fields']['field_meeting_type']['settings'] = array(
    'linked_field' => array(
      'linked' => 0,
      'destination' => '',
      'advanced' => array(
        'title' => '',
        'target' => '',
        'class' => '',
        'rel' => '',
        'text' => '',
      ),
    ),
  );
  /* Field: Content: Title */
  $handler->display->display_options['fields']['title']['id'] = 'title';
  $handler->display->display_options['fields']['title']['table'] = 'node';
  $handler->display->display_options['fields']['title']['field'] = 'title';
  $handler->display->display_options['fields']['title']['label'] = 'Meeting';
  $handler->display->display_options['fields']['title']['element_label_colon'] = FALSE;
  $handler->display->display_options['fields']['title']['link_to_node'] = FALSE;
  /* Field: Content: Date */
  $handler->display->display_options['fields']['field_date']['id'] = 'field_date';
  $handler->display->display_options['fields']['field_date']['table'] = 'field_data_field_date';
  $handler->display->display_options['fields']['field_date']['field'] = 'field_date';
  $handler->display->display_options['fields']['field_date']['element_label_colon'] = FALSE;
  $handler->display->display_options['fields']['field_date']['settings'] = array(
    'format_type' => 'month_day_year_time',
    'fromto' => 'value',
    'multiple_number' => '',
    'multiple_from' => '',
    'multiple_to' => '',
    'show_remaining_days' => 0,
    'show_repeat_rule' => 'show',
    'linked_field' => array(
      'linked' => 0,
      'destination' => '',
      'advanced' => array(
        'title' => '',
        'target' => '',
        'class' => '',
        'rel' => '',
        'text' => '',
      ),
    ),
  );
  $handler->display->display_options['fields']['field_date']['delta_offset'] = '0';
  /* Field: Content: Meeting Address */
  $handler->display->display_options['fields']['field_meeting_address']['id'] = 'field_meeting_address';
  $handler->display->display_options['fields']['field_meeting_address']['table'] = 'field_data_field_meeting_address';
  $handler->display->display_options['fields']['field_meeting_address']['field'] = 'field_meeting_address';
  $handler->display->display_options['fields']['field_meeting_address']['label'] = '';
  $handler->display->display_options['fields']['field_meeting_address']['exclude'] = TRUE;
  $handler->display->display_options['fields']['field_meeting_address']['element_label_colon'] = FALSE;
  $handler->display->display_options['fields']['field_meeting_address']['type'] = 'text_plain';
  $handler->display->display_options['fields']['field_meeting_address']['settings'] = array(
    'linked_field' => array(
      'linked' => 0,
      'destination' => '',
      'advanced' => array(
        'title' => '',
        'target' => '',
        'class' => '',
        'rel' => '',
        'text' => '',
      ),
    ),
  );
  /* Field: Content: Meeting Location */
  $handler->display->display_options['fields']['field_meeting_location']['id'] = 'field_meeting_location';
  $handler->display->display_options['fields']['field_meeting_location']['table'] = 'field_data_field_meeting_location';
  $handler->display->display_options['fields']['field_meeting_location']['field'] = 'field_meeting_location';
  $handler->display->display_options['fields']['field_meeting_location']['label'] = 'Location';
  $handler->display->display_options['fields']['field_meeting_location']['alter']['alter_text'] = TRUE;
  $handler->display->display_options['fields']['field_meeting_location']['alter']['text'] = '[field_meeting_location]<br>
[field_meeting_address]
';
  $handler->display->display_options['fields']['field_meeting_location']['element_label_colon'] = FALSE;
  $handler->display->display_options['fields']['field_meeting_location']['type'] = 'text_plain';
  $handler->display->display_options['fields']['field_meeting_location']['settings'] = array(
    'linked_field' => array(
      'linked' => 0,
      'destination' => '',
      'advanced' => array(
        'title' => '',
        'target' => '',
        'class' => '',
        'rel' => '',
        'text' => '',
      ),
    ),
  );
  /* Field: Content: Meeting Agenda HTML */
  $handler->display->display_options['fields']['field_meeting_agenda_html']['id'] = 'field_meeting_agenda_html';
  $handler->display->display_options['fields']['field_meeting_agenda_html']['table'] = 'field_data_field_meeting_agenda_html';
  $handler->display->display_options['fields']['field_meeting_agenda_html']['field'] = 'field_meeting_agenda_html';
  $handler->display->display_options['fields']['field_meeting_agenda_html']['label'] = '';
  $handler->display->display_options['fields']['field_meeting_agenda_html']['exclude'] = TRUE;
  $handler->display->display_options['fields']['field_meeting_agenda_html']['alter']['alter_text'] = TRUE;
  $handler->display->display_options['fields']['field_meeting_agenda_html']['alter']['text'] = '<a href="[field_meeting_agenda_html]" target="_blank">HTML</a>';
  $handler->display->display_options['fields']['field_meeting_agenda_html']['element_label_colon'] = FALSE;
  $handler->display->display_options['fields']['field_meeting_agenda_html']['settings'] = array(
    'linked_field' => array(
      'linked' => 0,
      'destination' => '',
      'advanced' => array(
        'title' => '',
        'target' => '',
        'class' => '',
        'rel' => '',
        'text' => '',
      ),
    ),
  );
  /* Field: Content: Meeting Agenda PDF */
  $handler->display->display_options['fields']['field_meeting_agenda_pdf']['id'] = 'field_meeting_agenda_pdf';
  $handler->display->display_options['fields']['field_meeting_agenda_pdf']['table'] = 'field_data_field_meeting_agenda_pdf';
  $handler->display->display_options['fields']['field_meeting_agenda_pdf']['field'] = 'field_meeting_agenda_pdf';
  $handler->display->display_options['fields']['field_meeting_agenda_pdf']['label'] = '';
  $handler->display->display_options['fields']['field_meeting_agenda_pdf']['exclude'] = TRUE;
  $handler->display->display_options['fields']['field_meeting_agenda_pdf']['alter']['alter_text'] = TRUE;
  $handler->display->display_options['fields']['field_meeting_agenda_pdf']['alter']['text'] = '<a href="[field_meeting_agenda_pdf]" target="_blank">PDF</a>';
  $handler->display->display_options['fields']['field_meeting_agenda_pdf']['element_label_colon'] = FALSE;
  $handler->display->display_options['fields']['field_meeting_agenda_pdf']['settings'] = array(
    'linked_field' => array(
      'linked' => 0,
      'destination' => '',
      'advanced' => array(
        'title' => '',
        'target' => '',
        'class' => '',
        'rel' => '',
        'text' => '',
      ),
    ),
  );
  /* Field: Global: Custom text */
  $handler->display->display_options['fields']['nothing']['id'] = 'nothing';
  $handler->display->display_options['fields']['nothing']['table'] = 'views';
  $handler->display->display_options['fields']['nothing']['field'] = 'nothing';
  $handler->display->display_options['fields']['nothing']['label'] = 'Agenda';
  $handler->display->display_options['fields']['nothing']['alter']['text'] = '[field_meeting_agenda_html] | [field_meeting_agenda_pdf]';
  $handler->display->display_options['fields']['nothing']['element_label_colon'] = FALSE;
  /* Field: Content: Meeting Minutes PDF */
  $handler->display->display_options['fields']['field_meeting_minutes_pdf']['id'] = 'field_meeting_minutes_pdf';
  $handler->display->display_options['fields']['field_meeting_minutes_pdf']['table'] = 'field_data_field_meeting_minutes_pdf';
  $handler->display->display_options['fields']['field_meeting_minutes_pdf']['field'] = 'field_meeting_minutes_pdf';
  $handler->display->display_options['fields']['field_meeting_minutes_pdf']['label'] = 'Minutes';
  $handler->display->display_options['fields']['field_meeting_minutes_pdf']['alter']['alter_text'] = TRUE;
  $handler->display->display_options['fields']['field_meeting_minutes_pdf']['alter']['text'] = '<a href="[field_meeting_minutes_pdf]" target="_blank">PDF</a>';
  $handler->display->display_options['fields']['field_meeting_minutes_pdf']['element_label_colon'] = FALSE;
  $handler->display->display_options['fields']['field_meeting_minutes_pdf']['settings'] = array(
    'linked_field' => array(
      'linked' => 0,
      'destination' => '',
      'advanced' => array(
        'title' => '',
        'target' => '',
        'class' => '',
        'rel' => '',
        'text' => '',
      ),
    ),
  );
  $handler->display->display_options['defaults']['sorts'] = FALSE;
  /* Sort criterion: Content: Date -  start date (field_date) */
  $handler->display->display_options['sorts']['field_date_value']['id'] = 'field_date_value';
  $handler->display->display_options['sorts']['field_date_value']['table'] = 'field_data_field_date';
  $handler->display->display_options['sorts']['field_date_value']['field'] = 'field_date_value';
  $handler->display->display_options['sorts']['field_date_value']['order'] = 'DESC';
  $handler->display->display_options['defaults']['filter_groups'] = FALSE;
  $handler->display->display_options['defaults']['filters'] = FALSE;
  /* Filter criterion: Content: Published status */
  $handler->display->display_options['filters']['status']['id'] = 'status';
  $handler->display->display_options['filters']['status']['table'] = 'node';
  $handler->display->display_options['filters']['status']['field'] = 'status';
  $handler->display->display_options['filters']['status']['value'] = 1;
  $handler->display->display_options['filters']['status']['group'] = 1;
  $handler->display->display_options['filters']['status']['expose']['operator'] = FALSE;
  /* Filter criterion: Content: Type */
  $handler->display->display_options['filters']['type']['id'] = 'type';
  $handler->display->display_options['filters']['type']['table'] = 'node';
  $handler->display->display_options['filters']['type']['field'] = 'type';
  $handler->display->display_options['filters']['type']['value'] = array(
    'meeting' => 'meeting',
  );
  /* Filter criterion: Content: Date -  start date (field_date) */
  $handler->display->display_options['filters']['field_date_value_1']['id'] = 'field_date_value_1';
  $handler->display->display_options['filters']['field_date_value_1']['table'] = 'field_data_field_date';
  $handler->display->display_options['filters']['field_date_value_1']['field'] = 'field_date_value';
  $handler->display->display_options['filters']['field_date_value_1']['operator'] = '<=';
  $handler->display->display_options['filters']['field_date_value_1']['default_date'] = 'now';
  /* Filter criterion: Content: Meeting Type (field_meeting_type) */
  $handler->display->display_options['filters']['field_meeting_type_tid']['id'] = 'field_meeting_type_tid';
  $handler->display->display_options['filters']['field_meeting_type_tid']['table'] = 'field_data_field_meeting_type';
  $handler->display->display_options['filters']['field_meeting_type_tid']['field'] = 'field_meeting_type_tid';
  $handler->display->display_options['filters']['field_meeting_type_tid']['value'] = array(
    2153 => '2153',
  );
  $handler->display->display_options['filters']['field_meeting_type_tid']['type'] = 'select';
  $handler->display->display_options['filters']['field_meeting_type_tid']['vocabulary'] = 'meeting_type';
  $handler->display->display_options['block_description'] = 'Meetings - Past - Agricultural';

  /* Display: Block */
  $handler = $view->new_display('block', 'Block', 'block_12');
  $handler->display->display_options['defaults']['title'] = FALSE;
  $handler->display->display_options['title'] = 'Meetings - Past - Airport';
  $handler->display->display_options['defaults']['pager'] = FALSE;
  $handler->display->display_options['pager']['type'] = 'full';
  $handler->display->display_options['pager']['options']['items_per_page'] = '10';
  $handler->display->display_options['pager']['options']['offset'] = '0';
  $handler->display->display_options['pager']['options']['id'] = '0';
  $handler->display->display_options['pager']['options']['quantity'] = '9';
  $handler->display->display_options['defaults']['style_plugin'] = FALSE;
  $handler->display->display_options['style_plugin'] = 'table';
  $handler->display->display_options['style_options']['columns'] = array(
    'field_meeting_type' => 'field_meeting_type',
    'field_date' => 'field_date',
    'field_meeting_address' => 'field_meeting_address',
    'field_meeting_location' => 'field_meeting_location',
    'field_meeting_agenda_html' => 'field_meeting_agenda_html',
    'field_meeting_agenda_pdf' => 'field_meeting_agenda_pdf',
    'nothing' => 'nothing',
    'field_meeting_minutes_pdf' => 'field_meeting_minutes_pdf',
  );
  $handler->display->display_options['style_options']['default'] = '-1';
  $handler->display->display_options['style_options']['info'] = array(
    'field_meeting_type' => array(
      'sortable' => 0,
      'default_sort_order' => 'asc',
      'align' => '',
      'separator' => '',
      'empty_column' => 0,
    ),
    'field_date' => array(
      'align' => '',
      'separator' => '',
      'empty_column' => 0,
    ),
    'field_meeting_address' => array(
      'sortable' => 0,
      'default_sort_order' => 'asc',
      'align' => '',
      'separator' => '',
      'empty_column' => 0,
    ),
    'field_meeting_location' => array(
      'sortable' => 0,
      'default_sort_order' => 'asc',
      'align' => '',
      'separator' => '',
      'empty_column' => 0,
    ),
    'field_meeting_agenda_html' => array(
      'sortable' => 0,
      'default_sort_order' => 'asc',
      'align' => '',
      'separator' => '',
      'empty_column' => 0,
    ),
    'field_meeting_agenda_pdf' => array(
      'sortable' => 0,
      'default_sort_order' => 'asc',
      'align' => '',
      'separator' => '',
      'empty_column' => 0,
    ),
    'nothing' => array(
      'align' => '',
      'separator' => '',
      'empty_column' => 0,
    ),
    'field_meeting_minutes_pdf' => array(
      'sortable' => 0,
      'default_sort_order' => 'asc',
      'align' => '',
      'separator' => '',
      'empty_column' => 0,
    ),
  );
  $handler->display->display_options['defaults']['style_options'] = FALSE;
  $handler->display->display_options['defaults']['row_plugin'] = FALSE;
  $handler->display->display_options['defaults']['row_options'] = FALSE;
  $handler->display->display_options['defaults']['footer'] = FALSE;
  /* Footer: Global: Text area */
  $handler->display->display_options['footer']['area']['id'] = 'area';
  $handler->display->display_options['footer']['area']['table'] = 'views';
  $handler->display->display_options['footer']['area']['field'] = 'area';
  $handler->display->display_options['footer']['area']['empty'] = TRUE;
  $handler->display->display_options['footer']['area']['content'] = '<h4><a href="/city-hall/council/committees/airport-advisory-committee/meeting-archives">Meeting Archives</a></h4>';
  $handler->display->display_options['footer']['area']['format'] = 'full_html';
  $handler->display->display_options['defaults']['empty'] = FALSE;
  /* No results behavior: Global: Text area */
  $handler->display->display_options['empty']['area']['id'] = 'area';
  $handler->display->display_options['empty']['area']['table'] = 'views';
  $handler->display->display_options['empty']['area']['field'] = 'area';
  $handler->display->display_options['empty']['area']['empty'] = TRUE;
  $handler->display->display_options['empty']['area']['content'] = 'Please refer to the archives for this committee\'s past meeting information.';
  $handler->display->display_options['empty']['area']['format'] = 'full_html';
  $handler->display->display_options['defaults']['fields'] = FALSE;
  /* Field: Content: Meeting Type */
  $handler->display->display_options['fields']['field_meeting_type']['id'] = 'field_meeting_type';
  $handler->display->display_options['fields']['field_meeting_type']['table'] = 'field_data_field_meeting_type';
  $handler->display->display_options['fields']['field_meeting_type']['field'] = 'field_meeting_type';
  $handler->display->display_options['fields']['field_meeting_type']['label'] = '';
  $handler->display->display_options['fields']['field_meeting_type']['exclude'] = TRUE;
  $handler->display->display_options['fields']['field_meeting_type']['element_label_colon'] = FALSE;
  $handler->display->display_options['fields']['field_meeting_type']['type'] = 'taxonomy_term_reference_plain';
  $handler->display->display_options['fields']['field_meeting_type']['settings'] = array(
    'linked_field' => array(
      'linked' => 0,
      'destination' => '',
      'advanced' => array(
        'title' => '',
        'target' => '',
        'class' => '',
        'rel' => '',
        'text' => '',
      ),
    ),
  );
  /* Field: Content: Title */
  $handler->display->display_options['fields']['title']['id'] = 'title';
  $handler->display->display_options['fields']['title']['table'] = 'node';
  $handler->display->display_options['fields']['title']['field'] = 'title';
  $handler->display->display_options['fields']['title']['label'] = 'Meeting';
  $handler->display->display_options['fields']['title']['element_label_colon'] = FALSE;
  $handler->display->display_options['fields']['title']['link_to_node'] = FALSE;
  /* Field: Content: Date */
  $handler->display->display_options['fields']['field_date']['id'] = 'field_date';
  $handler->display->display_options['fields']['field_date']['table'] = 'field_data_field_date';
  $handler->display->display_options['fields']['field_date']['field'] = 'field_date';
  $handler->display->display_options['fields']['field_date']['element_label_colon'] = FALSE;
  $handler->display->display_options['fields']['field_date']['settings'] = array(
    'format_type' => 'month_day_year_time',
    'fromto' => 'value',
    'multiple_number' => '',
    'multiple_from' => '',
    'multiple_to' => '',
    'show_remaining_days' => 0,
    'show_repeat_rule' => 'show',
    'linked_field' => array(
      'linked' => 0,
      'destination' => '',
      'advanced' => array(
        'title' => '',
        'target' => '',
        'class' => '',
        'rel' => '',
        'text' => '',
      ),
    ),
  );
  $handler->display->display_options['fields']['field_date']['delta_offset'] = '0';
  /* Field: Content: Meeting Address */
  $handler->display->display_options['fields']['field_meeting_address']['id'] = 'field_meeting_address';
  $handler->display->display_options['fields']['field_meeting_address']['table'] = 'field_data_field_meeting_address';
  $handler->display->display_options['fields']['field_meeting_address']['field'] = 'field_meeting_address';
  $handler->display->display_options['fields']['field_meeting_address']['label'] = '';
  $handler->display->display_options['fields']['field_meeting_address']['exclude'] = TRUE;
  $handler->display->display_options['fields']['field_meeting_address']['element_label_colon'] = FALSE;
  $handler->display->display_options['fields']['field_meeting_address']['type'] = 'text_plain';
  $handler->display->display_options['fields']['field_meeting_address']['settings'] = array(
    'linked_field' => array(
      'linked' => 0,
      'destination' => '',
      'advanced' => array(
        'title' => '',
        'target' => '',
        'class' => '',
        'rel' => '',
        'text' => '',
      ),
    ),
  );
  /* Field: Content: Meeting Location */
  $handler->display->display_options['fields']['field_meeting_location']['id'] = 'field_meeting_location';
  $handler->display->display_options['fields']['field_meeting_location']['table'] = 'field_data_field_meeting_location';
  $handler->display->display_options['fields']['field_meeting_location']['field'] = 'field_meeting_location';
  $handler->display->display_options['fields']['field_meeting_location']['label'] = 'Location';
  $handler->display->display_options['fields']['field_meeting_location']['alter']['alter_text'] = TRUE;
  $handler->display->display_options['fields']['field_meeting_location']['alter']['text'] = '[field_meeting_location]<br>
[field_meeting_address]
';
  $handler->display->display_options['fields']['field_meeting_location']['element_label_colon'] = FALSE;
  $handler->display->display_options['fields']['field_meeting_location']['type'] = 'text_plain';
  $handler->display->display_options['fields']['field_meeting_location']['settings'] = array(
    'linked_field' => array(
      'linked' => 0,
      'destination' => '',
      'advanced' => array(
        'title' => '',
        'target' => '',
        'class' => '',
        'rel' => '',
        'text' => '',
      ),
    ),
  );
  /* Field: Content: Meeting Agenda HTML */
  $handler->display->display_options['fields']['field_meeting_agenda_html']['id'] = 'field_meeting_agenda_html';
  $handler->display->display_options['fields']['field_meeting_agenda_html']['table'] = 'field_data_field_meeting_agenda_html';
  $handler->display->display_options['fields']['field_meeting_agenda_html']['field'] = 'field_meeting_agenda_html';
  $handler->display->display_options['fields']['field_meeting_agenda_html']['label'] = '';
  $handler->display->display_options['fields']['field_meeting_agenda_html']['exclude'] = TRUE;
  $handler->display->display_options['fields']['field_meeting_agenda_html']['alter']['alter_text'] = TRUE;
  $handler->display->display_options['fields']['field_meeting_agenda_html']['alter']['text'] = '<a href="[field_meeting_agenda_html]" target="_blank">HTML</a>';
  $handler->display->display_options['fields']['field_meeting_agenda_html']['element_label_colon'] = FALSE;
  $handler->display->display_options['fields']['field_meeting_agenda_html']['settings'] = array(
    'linked_field' => array(
      'linked' => 0,
      'destination' => '',
      'advanced' => array(
        'title' => '',
        'target' => '',
        'class' => '',
        'rel' => '',
        'text' => '',
      ),
    ),
  );
  /* Field: Content: Meeting Agenda PDF */
  $handler->display->display_options['fields']['field_meeting_agenda_pdf']['id'] = 'field_meeting_agenda_pdf';
  $handler->display->display_options['fields']['field_meeting_agenda_pdf']['table'] = 'field_data_field_meeting_agenda_pdf';
  $handler->display->display_options['fields']['field_meeting_agenda_pdf']['field'] = 'field_meeting_agenda_pdf';
  $handler->display->display_options['fields']['field_meeting_agenda_pdf']['label'] = '';
  $handler->display->display_options['fields']['field_meeting_agenda_pdf']['exclude'] = TRUE;
  $handler->display->display_options['fields']['field_meeting_agenda_pdf']['alter']['alter_text'] = TRUE;
  $handler->display->display_options['fields']['field_meeting_agenda_pdf']['alter']['text'] = '<a href="[field_meeting_agenda_pdf]" target="_blank">PDF</a>';
  $handler->display->display_options['fields']['field_meeting_agenda_pdf']['element_label_colon'] = FALSE;
  $handler->display->display_options['fields']['field_meeting_agenda_pdf']['settings'] = array(
    'linked_field' => array(
      'linked' => 0,
      'destination' => '',
      'advanced' => array(
        'title' => '',
        'target' => '',
        'class' => '',
        'rel' => '',
        'text' => '',
      ),
    ),
  );
  /* Field: Global: Custom text */
  $handler->display->display_options['fields']['nothing']['id'] = 'nothing';
  $handler->display->display_options['fields']['nothing']['table'] = 'views';
  $handler->display->display_options['fields']['nothing']['field'] = 'nothing';
  $handler->display->display_options['fields']['nothing']['label'] = 'Agenda';
  $handler->display->display_options['fields']['nothing']['alter']['text'] = '[field_meeting_agenda_html] | [field_meeting_agenda_pdf]';
  $handler->display->display_options['fields']['nothing']['element_label_colon'] = FALSE;
  /* Field: Content: Meeting Minutes PDF */
  $handler->display->display_options['fields']['field_meeting_minutes_pdf']['id'] = 'field_meeting_minutes_pdf';
  $handler->display->display_options['fields']['field_meeting_minutes_pdf']['table'] = 'field_data_field_meeting_minutes_pdf';
  $handler->display->display_options['fields']['field_meeting_minutes_pdf']['field'] = 'field_meeting_minutes_pdf';
  $handler->display->display_options['fields']['field_meeting_minutes_pdf']['label'] = 'Minutes';
  $handler->display->display_options['fields']['field_meeting_minutes_pdf']['alter']['alter_text'] = TRUE;
  $handler->display->display_options['fields']['field_meeting_minutes_pdf']['alter']['text'] = '<a href="[field_meeting_minutes_pdf]" target="_blank">PDF</a>';
  $handler->display->display_options['fields']['field_meeting_minutes_pdf']['element_label_colon'] = FALSE;
  $handler->display->display_options['fields']['field_meeting_minutes_pdf']['settings'] = array(
    'linked_field' => array(
      'linked' => 0,
      'destination' => '',
      'advanced' => array(
        'title' => '',
        'target' => '',
        'class' => '',
        'rel' => '',
        'text' => '',
      ),
    ),
  );
  $handler->display->display_options['defaults']['sorts'] = FALSE;
  /* Sort criterion: Content: Date -  start date (field_date) */
  $handler->display->display_options['sorts']['field_date_value']['id'] = 'field_date_value';
  $handler->display->display_options['sorts']['field_date_value']['table'] = 'field_data_field_date';
  $handler->display->display_options['sorts']['field_date_value']['field'] = 'field_date_value';
  $handler->display->display_options['sorts']['field_date_value']['order'] = 'DESC';
  $handler->display->display_options['defaults']['filter_groups'] = FALSE;
  $handler->display->display_options['defaults']['filters'] = FALSE;
  /* Filter criterion: Content: Published status */
  $handler->display->display_options['filters']['status']['id'] = 'status';
  $handler->display->display_options['filters']['status']['table'] = 'node';
  $handler->display->display_options['filters']['status']['field'] = 'status';
  $handler->display->display_options['filters']['status']['value'] = 1;
  $handler->display->display_options['filters']['status']['group'] = 1;
  $handler->display->display_options['filters']['status']['expose']['operator'] = FALSE;
  /* Filter criterion: Content: Type */
  $handler->display->display_options['filters']['type']['id'] = 'type';
  $handler->display->display_options['filters']['type']['table'] = 'node';
  $handler->display->display_options['filters']['type']['field'] = 'type';
  $handler->display->display_options['filters']['type']['value'] = array(
    'meeting' => 'meeting',
  );
  /* Filter criterion: Content: Date -  start date (field_date) */
  $handler->display->display_options['filters']['field_date_value_1']['id'] = 'field_date_value_1';
  $handler->display->display_options['filters']['field_date_value_1']['table'] = 'field_data_field_date';
  $handler->display->display_options['filters']['field_date_value_1']['field'] = 'field_date_value';
  $handler->display->display_options['filters']['field_date_value_1']['operator'] = '<=';
  $handler->display->display_options['filters']['field_date_value_1']['default_date'] = 'now';
  /* Filter criterion: Content: Meeting Type (field_meeting_type) */
  $handler->display->display_options['filters']['field_meeting_type_tid']['id'] = 'field_meeting_type_tid';
  $handler->display->display_options['filters']['field_meeting_type_tid']['table'] = 'field_data_field_meeting_type';
  $handler->display->display_options['filters']['field_meeting_type_tid']['field'] = 'field_meeting_type_tid';
  $handler->display->display_options['filters']['field_meeting_type_tid']['value'] = array(
    2164 => '2164',
  );
  $handler->display->display_options['filters']['field_meeting_type_tid']['type'] = 'select';
  $handler->display->display_options['filters']['field_meeting_type_tid']['vocabulary'] = 'meeting_type';
  $handler->display->display_options['block_description'] = 'Meetings - Past - Airport';

  /* Display: Block */
  $handler = $view->new_display('block', 'Block', 'block_13');
  $handler->display->display_options['defaults']['title'] = FALSE;
  $handler->display->display_options['title'] = 'Meetings - Past - Audit';
  $handler->display->display_options['defaults']['pager'] = FALSE;
  $handler->display->display_options['pager']['type'] = 'full';
  $handler->display->display_options['pager']['options']['items_per_page'] = '10';
  $handler->display->display_options['pager']['options']['offset'] = '0';
  $handler->display->display_options['pager']['options']['id'] = '0';
  $handler->display->display_options['pager']['options']['quantity'] = '9';
  $handler->display->display_options['defaults']['style_plugin'] = FALSE;
  $handler->display->display_options['style_plugin'] = 'table';
  $handler->display->display_options['style_options']['columns'] = array(
    'field_meeting_type' => 'field_meeting_type',
    'field_date' => 'field_date',
    'field_meeting_address' => 'field_meeting_address',
    'field_meeting_location' => 'field_meeting_location',
    'field_meeting_agenda_html' => 'field_meeting_agenda_html',
    'field_meeting_agenda_pdf' => 'field_meeting_agenda_pdf',
    'nothing' => 'nothing',
    'field_meeting_minutes_pdf' => 'field_meeting_minutes_pdf',
  );
  $handler->display->display_options['style_options']['default'] = '-1';
  $handler->display->display_options['style_options']['info'] = array(
    'field_meeting_type' => array(
      'sortable' => 0,
      'default_sort_order' => 'asc',
      'align' => '',
      'separator' => '',
      'empty_column' => 0,
    ),
    'field_date' => array(
      'align' => '',
      'separator' => '',
      'empty_column' => 0,
    ),
    'field_meeting_address' => array(
      'sortable' => 0,
      'default_sort_order' => 'asc',
      'align' => '',
      'separator' => '',
      'empty_column' => 0,
    ),
    'field_meeting_location' => array(
      'sortable' => 0,
      'default_sort_order' => 'asc',
      'align' => '',
      'separator' => '',
      'empty_column' => 0,
    ),
    'field_meeting_agenda_html' => array(
      'sortable' => 0,
      'default_sort_order' => 'asc',
      'align' => '',
      'separator' => '',
      'empty_column' => 0,
    ),
    'field_meeting_agenda_pdf' => array(
      'sortable' => 0,
      'default_sort_order' => 'asc',
      'align' => '',
      'separator' => '',
      'empty_column' => 0,
    ),
    'nothing' => array(
      'align' => '',
      'separator' => '',
      'empty_column' => 0,
    ),
    'field_meeting_minutes_pdf' => array(
      'sortable' => 0,
      'default_sort_order' => 'asc',
      'align' => '',
      'separator' => '',
      'empty_column' => 0,
    ),
  );
  $handler->display->display_options['defaults']['style_options'] = FALSE;
  $handler->display->display_options['defaults']['row_plugin'] = FALSE;
  $handler->display->display_options['defaults']['row_options'] = FALSE;
  $handler->display->display_options['defaults']['footer'] = FALSE;
  /* Footer: Global: Text area */
  $handler->display->display_options['footer']['area']['id'] = 'area';
  $handler->display->display_options['footer']['area']['table'] = 'views';
  $handler->display->display_options['footer']['area']['field'] = 'area';
  $handler->display->display_options['footer']['area']['empty'] = TRUE;
  $handler->display->display_options['footer']['area']['content'] = '<h4><a href="/city-hall/council/committees/audit-committee/meeting-archives">Meeting Archives</a></h4>';
  $handler->display->display_options['footer']['area']['format'] = 'full_html';
  $handler->display->display_options['defaults']['empty'] = FALSE;
  /* No results behavior: Global: Text area */
  $handler->display->display_options['empty']['area']['id'] = 'area';
  $handler->display->display_options['empty']['area']['table'] = 'views';
  $handler->display->display_options['empty']['area']['field'] = 'area';
  $handler->display->display_options['empty']['area']['empty'] = TRUE;
  $handler->display->display_options['empty']['area']['content'] = 'Please refer to the archives for this committee\'s past meeting information.';
  $handler->display->display_options['empty']['area']['format'] = 'full_html';
  $handler->display->display_options['defaults']['fields'] = FALSE;
  /* Field: Content: Meeting Type */
  $handler->display->display_options['fields']['field_meeting_type']['id'] = 'field_meeting_type';
  $handler->display->display_options['fields']['field_meeting_type']['table'] = 'field_data_field_meeting_type';
  $handler->display->display_options['fields']['field_meeting_type']['field'] = 'field_meeting_type';
  $handler->display->display_options['fields']['field_meeting_type']['label'] = '';
  $handler->display->display_options['fields']['field_meeting_type']['exclude'] = TRUE;
  $handler->display->display_options['fields']['field_meeting_type']['element_label_colon'] = FALSE;
  $handler->display->display_options['fields']['field_meeting_type']['type'] = 'taxonomy_term_reference_plain';
  $handler->display->display_options['fields']['field_meeting_type']['settings'] = array(
    'linked_field' => array(
      'linked' => 0,
      'destination' => '',
      'advanced' => array(
        'title' => '',
        'target' => '',
        'class' => '',
        'rel' => '',
        'text' => '',
      ),
    ),
  );
  /* Field: Content: Title */
  $handler->display->display_options['fields']['title']['id'] = 'title';
  $handler->display->display_options['fields']['title']['table'] = 'node';
  $handler->display->display_options['fields']['title']['field'] = 'title';
  $handler->display->display_options['fields']['title']['label'] = 'Meeting';
  $handler->display->display_options['fields']['title']['element_label_colon'] = FALSE;
  $handler->display->display_options['fields']['title']['link_to_node'] = FALSE;
  /* Field: Content: Date */
  $handler->display->display_options['fields']['field_date']['id'] = 'field_date';
  $handler->display->display_options['fields']['field_date']['table'] = 'field_data_field_date';
  $handler->display->display_options['fields']['field_date']['field'] = 'field_date';
  $handler->display->display_options['fields']['field_date']['element_label_colon'] = FALSE;
  $handler->display->display_options['fields']['field_date']['settings'] = array(
    'format_type' => 'month_day_year_time',
    'fromto' => 'value',
    'multiple_number' => '',
    'multiple_from' => '',
    'multiple_to' => '',
    'show_remaining_days' => 0,
    'show_repeat_rule' => 'show',
    'linked_field' => array(
      'linked' => 0,
      'destination' => '',
      'advanced' => array(
        'title' => '',
        'target' => '',
        'class' => '',
        'rel' => '',
        'text' => '',
      ),
    ),
  );
  $handler->display->display_options['fields']['field_date']['delta_offset'] = '0';
  /* Field: Content: Meeting Address */
  $handler->display->display_options['fields']['field_meeting_address']['id'] = 'field_meeting_address';
  $handler->display->display_options['fields']['field_meeting_address']['table'] = 'field_data_field_meeting_address';
  $handler->display->display_options['fields']['field_meeting_address']['field'] = 'field_meeting_address';
  $handler->display->display_options['fields']['field_meeting_address']['label'] = '';
  $handler->display->display_options['fields']['field_meeting_address']['exclude'] = TRUE;
  $handler->display->display_options['fields']['field_meeting_address']['element_label_colon'] = FALSE;
  $handler->display->display_options['fields']['field_meeting_address']['type'] = 'text_plain';
  $handler->display->display_options['fields']['field_meeting_address']['settings'] = array(
    'linked_field' => array(
      'linked' => 0,
      'destination' => '',
      'advanced' => array(
        'title' => '',
        'target' => '',
        'class' => '',
        'rel' => '',
        'text' => '',
      ),
    ),
  );
  /* Field: Content: Meeting Location */
  $handler->display->display_options['fields']['field_meeting_location']['id'] = 'field_meeting_location';
  $handler->display->display_options['fields']['field_meeting_location']['table'] = 'field_data_field_meeting_location';
  $handler->display->display_options['fields']['field_meeting_location']['field'] = 'field_meeting_location';
  $handler->display->display_options['fields']['field_meeting_location']['label'] = 'Location';
  $handler->display->display_options['fields']['field_meeting_location']['alter']['alter_text'] = TRUE;
  $handler->display->display_options['fields']['field_meeting_location']['alter']['text'] = '[field_meeting_location]<br>
[field_meeting_address]
';
  $handler->display->display_options['fields']['field_meeting_location']['element_label_colon'] = FALSE;
  $handler->display->display_options['fields']['field_meeting_location']['type'] = 'text_plain';
  $handler->display->display_options['fields']['field_meeting_location']['settings'] = array(
    'linked_field' => array(
      'linked' => 0,
      'destination' => '',
      'advanced' => array(
        'title' => '',
        'target' => '',
        'class' => '',
        'rel' => '',
        'text' => '',
      ),
    ),
  );
  /* Field: Content: Meeting Agenda HTML */
  $handler->display->display_options['fields']['field_meeting_agenda_html']['id'] = 'field_meeting_agenda_html';
  $handler->display->display_options['fields']['field_meeting_agenda_html']['table'] = 'field_data_field_meeting_agenda_html';
  $handler->display->display_options['fields']['field_meeting_agenda_html']['field'] = 'field_meeting_agenda_html';
  $handler->display->display_options['fields']['field_meeting_agenda_html']['label'] = '';
  $handler->display->display_options['fields']['field_meeting_agenda_html']['exclude'] = TRUE;
  $handler->display->display_options['fields']['field_meeting_agenda_html']['alter']['alter_text'] = TRUE;
  $handler->display->display_options['fields']['field_meeting_agenda_html']['alter']['text'] = '<a href="[field_meeting_agenda_html]" target="_blank">HTML</a>';
  $handler->display->display_options['fields']['field_meeting_agenda_html']['element_label_colon'] = FALSE;
  $handler->display->display_options['fields']['field_meeting_agenda_html']['settings'] = array(
    'linked_field' => array(
      'linked' => 0,
      'destination' => '',
      'advanced' => array(
        'title' => '',
        'target' => '',
        'class' => '',
        'rel' => '',
        'text' => '',
      ),
    ),
  );
  /* Field: Content: Meeting Agenda PDF */
  $handler->display->display_options['fields']['field_meeting_agenda_pdf']['id'] = 'field_meeting_agenda_pdf';
  $handler->display->display_options['fields']['field_meeting_agenda_pdf']['table'] = 'field_data_field_meeting_agenda_pdf';
  $handler->display->display_options['fields']['field_meeting_agenda_pdf']['field'] = 'field_meeting_agenda_pdf';
  $handler->display->display_options['fields']['field_meeting_agenda_pdf']['label'] = '';
  $handler->display->display_options['fields']['field_meeting_agenda_pdf']['exclude'] = TRUE;
  $handler->display->display_options['fields']['field_meeting_agenda_pdf']['alter']['alter_text'] = TRUE;
  $handler->display->display_options['fields']['field_meeting_agenda_pdf']['alter']['text'] = '<a href="[field_meeting_agenda_pdf]" target="_blank">PDF</a>';
  $handler->display->display_options['fields']['field_meeting_agenda_pdf']['element_label_colon'] = FALSE;
  $handler->display->display_options['fields']['field_meeting_agenda_pdf']['settings'] = array(
    'linked_field' => array(
      'linked' => 0,
      'destination' => '',
      'advanced' => array(
        'title' => '',
        'target' => '',
        'class' => '',
        'rel' => '',
        'text' => '',
      ),
    ),
  );
  /* Field: Global: Custom text */
  $handler->display->display_options['fields']['nothing']['id'] = 'nothing';
  $handler->display->display_options['fields']['nothing']['table'] = 'views';
  $handler->display->display_options['fields']['nothing']['field'] = 'nothing';
  $handler->display->display_options['fields']['nothing']['label'] = 'Agenda';
  $handler->display->display_options['fields']['nothing']['alter']['text'] = '[field_meeting_agenda_html] | [field_meeting_agenda_pdf]';
  $handler->display->display_options['fields']['nothing']['element_label_colon'] = FALSE;
  /* Field: Content: Meeting Minutes PDF */
  $handler->display->display_options['fields']['field_meeting_minutes_pdf']['id'] = 'field_meeting_minutes_pdf';
  $handler->display->display_options['fields']['field_meeting_minutes_pdf']['table'] = 'field_data_field_meeting_minutes_pdf';
  $handler->display->display_options['fields']['field_meeting_minutes_pdf']['field'] = 'field_meeting_minutes_pdf';
  $handler->display->display_options['fields']['field_meeting_minutes_pdf']['label'] = 'Minutes';
  $handler->display->display_options['fields']['field_meeting_minutes_pdf']['alter']['alter_text'] = TRUE;
  $handler->display->display_options['fields']['field_meeting_minutes_pdf']['alter']['text'] = '<a href="[field_meeting_minutes_pdf]" target="_blank">PDF</a>';
  $handler->display->display_options['fields']['field_meeting_minutes_pdf']['element_label_colon'] = FALSE;
  $handler->display->display_options['fields']['field_meeting_minutes_pdf']['settings'] = array(
    'linked_field' => array(
      'linked' => 0,
      'destination' => '',
      'advanced' => array(
        'title' => '',
        'target' => '',
        'class' => '',
        'rel' => '',
        'text' => '',
      ),
    ),
  );
  $handler->display->display_options['defaults']['sorts'] = FALSE;
  /* Sort criterion: Content: Date -  start date (field_date) */
  $handler->display->display_options['sorts']['field_date_value']['id'] = 'field_date_value';
  $handler->display->display_options['sorts']['field_date_value']['table'] = 'field_data_field_date';
  $handler->display->display_options['sorts']['field_date_value']['field'] = 'field_date_value';
  $handler->display->display_options['sorts']['field_date_value']['order'] = 'DESC';
  $handler->display->display_options['defaults']['filter_groups'] = FALSE;
  $handler->display->display_options['defaults']['filters'] = FALSE;
  /* Filter criterion: Content: Published status */
  $handler->display->display_options['filters']['status']['id'] = 'status';
  $handler->display->display_options['filters']['status']['table'] = 'node';
  $handler->display->display_options['filters']['status']['field'] = 'status';
  $handler->display->display_options['filters']['status']['value'] = 1;
  $handler->display->display_options['filters']['status']['group'] = 1;
  $handler->display->display_options['filters']['status']['expose']['operator'] = FALSE;
  /* Filter criterion: Content: Type */
  $handler->display->display_options['filters']['type']['id'] = 'type';
  $handler->display->display_options['filters']['type']['table'] = 'node';
  $handler->display->display_options['filters']['type']['field'] = 'type';
  $handler->display->display_options['filters']['type']['value'] = array(
    'meeting' => 'meeting',
  );
  /* Filter criterion: Content: Date -  start date (field_date) */
  $handler->display->display_options['filters']['field_date_value_1']['id'] = 'field_date_value_1';
  $handler->display->display_options['filters']['field_date_value_1']['table'] = 'field_data_field_date';
  $handler->display->display_options['filters']['field_date_value_1']['field'] = 'field_date_value';
  $handler->display->display_options['filters']['field_date_value_1']['operator'] = '<=';
  $handler->display->display_options['filters']['field_date_value_1']['default_date'] = 'now';
  /* Filter criterion: Content: Meeting Type (field_meeting_type) */
  $handler->display->display_options['filters']['field_meeting_type_tid']['id'] = 'field_meeting_type_tid';
  $handler->display->display_options['filters']['field_meeting_type_tid']['table'] = 'field_data_field_meeting_type';
  $handler->display->display_options['filters']['field_meeting_type_tid']['field'] = 'field_meeting_type_tid';
  $handler->display->display_options['filters']['field_meeting_type_tid']['value'] = array(
    2163 => '2163',
  );
  $handler->display->display_options['filters']['field_meeting_type_tid']['type'] = 'select';
  $handler->display->display_options['filters']['field_meeting_type_tid']['vocabulary'] = 'meeting_type';
  $handler->display->display_options['block_description'] = 'Meetings - Past - Audit';

  /* Display: Block */
  $handler = $view->new_display('block', 'Block', 'block_14');
  $handler->display->display_options['defaults']['title'] = FALSE;
  $handler->display->display_options['title'] = 'Meetings - Past - Board of Variance';
  $handler->display->display_options['defaults']['pager'] = FALSE;
  $handler->display->display_options['pager']['type'] = 'full';
  $handler->display->display_options['pager']['options']['items_per_page'] = '10';
  $handler->display->display_options['pager']['options']['offset'] = '0';
  $handler->display->display_options['pager']['options']['id'] = '0';
  $handler->display->display_options['pager']['options']['quantity'] = '9';
  $handler->display->display_options['defaults']['style_plugin'] = FALSE;
  $handler->display->display_options['style_plugin'] = 'table';
  $handler->display->display_options['style_options']['columns'] = array(
    'field_meeting_type' => 'field_meeting_type',
    'field_date' => 'field_date',
    'field_meeting_address' => 'field_meeting_address',
    'field_meeting_location' => 'field_meeting_location',
    'field_meeting_agenda_html' => 'field_meeting_agenda_html',
    'field_meeting_agenda_pdf' => 'field_meeting_agenda_pdf',
    'nothing' => 'nothing',
    'field_meeting_minutes_pdf' => 'field_meeting_minutes_pdf',
  );
  $handler->display->display_options['style_options']['default'] = '-1';
  $handler->display->display_options['style_options']['info'] = array(
    'field_meeting_type' => array(
      'sortable' => 0,
      'default_sort_order' => 'asc',
      'align' => '',
      'separator' => '',
      'empty_column' => 0,
    ),
    'field_date' => array(
      'align' => '',
      'separator' => '',
      'empty_column' => 0,
    ),
    'field_meeting_address' => array(
      'sortable' => 0,
      'default_sort_order' => 'asc',
      'align' => '',
      'separator' => '',
      'empty_column' => 0,
    ),
    'field_meeting_location' => array(
      'sortable' => 0,
      'default_sort_order' => 'asc',
      'align' => '',
      'separator' => '',
      'empty_column' => 0,
    ),
    'field_meeting_agenda_html' => array(
      'sortable' => 0,
      'default_sort_order' => 'asc',
      'align' => '',
      'separator' => '',
      'empty_column' => 0,
    ),
    'field_meeting_agenda_pdf' => array(
      'sortable' => 0,
      'default_sort_order' => 'asc',
      'align' => '',
      'separator' => '',
      'empty_column' => 0,
    ),
    'nothing' => array(
      'align' => '',
      'separator' => '',
      'empty_column' => 0,
    ),
    'field_meeting_minutes_pdf' => array(
      'sortable' => 0,
      'default_sort_order' => 'asc',
      'align' => '',
      'separator' => '',
      'empty_column' => 0,
    ),
  );
  $handler->display->display_options['defaults']['style_options'] = FALSE;
  $handler->display->display_options['defaults']['row_plugin'] = FALSE;
  $handler->display->display_options['defaults']['row_options'] = FALSE;
  $handler->display->display_options['defaults']['footer'] = FALSE;
  /* Footer: Global: Text area */
  $handler->display->display_options['footer']['area']['id'] = 'area';
  $handler->display->display_options['footer']['area']['table'] = 'views';
  $handler->display->display_options['footer']['area']['field'] = 'area';
  $handler->display->display_options['footer']['area']['empty'] = TRUE;
  $handler->display->display_options['footer']['area']['content'] = '<h4><a href="/city-hall/council/committees/board-variance/meeting-archives">Meeting Archives</a></h4>';
  $handler->display->display_options['footer']['area']['format'] = 'full_html';
  $handler->display->display_options['defaults']['empty'] = FALSE;
  /* No results behavior: Global: Text area */
  $handler->display->display_options['empty']['area']['id'] = 'area';
  $handler->display->display_options['empty']['area']['table'] = 'views';
  $handler->display->display_options['empty']['area']['field'] = 'area';
  $handler->display->display_options['empty']['area']['empty'] = TRUE;
  $handler->display->display_options['empty']['area']['content'] = 'Please refer to the archives for this committee\'s past meeting information.';
  $handler->display->display_options['empty']['area']['format'] = 'full_html';
  $handler->display->display_options['defaults']['fields'] = FALSE;
  /* Field: Content: Meeting Type */
  $handler->display->display_options['fields']['field_meeting_type']['id'] = 'field_meeting_type';
  $handler->display->display_options['fields']['field_meeting_type']['table'] = 'field_data_field_meeting_type';
  $handler->display->display_options['fields']['field_meeting_type']['field'] = 'field_meeting_type';
  $handler->display->display_options['fields']['field_meeting_type']['label'] = '';
  $handler->display->display_options['fields']['field_meeting_type']['exclude'] = TRUE;
  $handler->display->display_options['fields']['field_meeting_type']['element_label_colon'] = FALSE;
  $handler->display->display_options['fields']['field_meeting_type']['type'] = 'taxonomy_term_reference_plain';
  $handler->display->display_options['fields']['field_meeting_type']['settings'] = array(
    'linked_field' => array(
      'linked' => 0,
      'destination' => '',
      'advanced' => array(
        'title' => '',
        'target' => '',
        'class' => '',
        'rel' => '',
        'text' => '',
      ),
    ),
  );
  /* Field: Content: Title */
  $handler->display->display_options['fields']['title']['id'] = 'title';
  $handler->display->display_options['fields']['title']['table'] = 'node';
  $handler->display->display_options['fields']['title']['field'] = 'title';
  $handler->display->display_options['fields']['title']['label'] = 'Meeting';
  $handler->display->display_options['fields']['title']['element_label_colon'] = FALSE;
  $handler->display->display_options['fields']['title']['link_to_node'] = FALSE;
  /* Field: Content: Date */
  $handler->display->display_options['fields']['field_date']['id'] = 'field_date';
  $handler->display->display_options['fields']['field_date']['table'] = 'field_data_field_date';
  $handler->display->display_options['fields']['field_date']['field'] = 'field_date';
  $handler->display->display_options['fields']['field_date']['element_label_colon'] = FALSE;
  $handler->display->display_options['fields']['field_date']['settings'] = array(
    'format_type' => 'month_day_year_time',
    'fromto' => 'value',
    'multiple_number' => '',
    'multiple_from' => '',
    'multiple_to' => '',
    'show_remaining_days' => 0,
    'show_repeat_rule' => 'show',
    'linked_field' => array(
      'linked' => 0,
      'destination' => '',
      'advanced' => array(
        'title' => '',
        'target' => '',
        'class' => '',
        'rel' => '',
        'text' => '',
      ),
    ),
  );
  $handler->display->display_options['fields']['field_date']['delta_offset'] = '0';
  /* Field: Content: Meeting Address */
  $handler->display->display_options['fields']['field_meeting_address']['id'] = 'field_meeting_address';
  $handler->display->display_options['fields']['field_meeting_address']['table'] = 'field_data_field_meeting_address';
  $handler->display->display_options['fields']['field_meeting_address']['field'] = 'field_meeting_address';
  $handler->display->display_options['fields']['field_meeting_address']['label'] = '';
  $handler->display->display_options['fields']['field_meeting_address']['exclude'] = TRUE;
  $handler->display->display_options['fields']['field_meeting_address']['element_label_colon'] = FALSE;
  $handler->display->display_options['fields']['field_meeting_address']['type'] = 'text_plain';
  $handler->display->display_options['fields']['field_meeting_address']['settings'] = array(
    'linked_field' => array(
      'linked' => 0,
      'destination' => '',
      'advanced' => array(
        'title' => '',
        'target' => '',
        'class' => '',
        'rel' => '',
        'text' => '',
      ),
    ),
  );
  /* Field: Content: Meeting Location */
  $handler->display->display_options['fields']['field_meeting_location']['id'] = 'field_meeting_location';
  $handler->display->display_options['fields']['field_meeting_location']['table'] = 'field_data_field_meeting_location';
  $handler->display->display_options['fields']['field_meeting_location']['field'] = 'field_meeting_location';
  $handler->display->display_options['fields']['field_meeting_location']['label'] = 'Location';
  $handler->display->display_options['fields']['field_meeting_location']['alter']['alter_text'] = TRUE;
  $handler->display->display_options['fields']['field_meeting_location']['alter']['text'] = '[field_meeting_location]<br>
[field_meeting_address]
';
  $handler->display->display_options['fields']['field_meeting_location']['element_label_colon'] = FALSE;
  $handler->display->display_options['fields']['field_meeting_location']['type'] = 'text_plain';
  $handler->display->display_options['fields']['field_meeting_location']['settings'] = array(
    'linked_field' => array(
      'linked' => 0,
      'destination' => '',
      'advanced' => array(
        'title' => '',
        'target' => '',
        'class' => '',
        'rel' => '',
        'text' => '',
      ),
    ),
  );
  /* Field: Content: Meeting Agenda HTML */
  $handler->display->display_options['fields']['field_meeting_agenda_html']['id'] = 'field_meeting_agenda_html';
  $handler->display->display_options['fields']['field_meeting_agenda_html']['table'] = 'field_data_field_meeting_agenda_html';
  $handler->display->display_options['fields']['field_meeting_agenda_html']['field'] = 'field_meeting_agenda_html';
  $handler->display->display_options['fields']['field_meeting_agenda_html']['label'] = '';
  $handler->display->display_options['fields']['field_meeting_agenda_html']['exclude'] = TRUE;
  $handler->display->display_options['fields']['field_meeting_agenda_html']['alter']['alter_text'] = TRUE;
  $handler->display->display_options['fields']['field_meeting_agenda_html']['alter']['text'] = '<a href="[field_meeting_agenda_html]" target="_blank">HTML</a>';
  $handler->display->display_options['fields']['field_meeting_agenda_html']['element_label_colon'] = FALSE;
  $handler->display->display_options['fields']['field_meeting_agenda_html']['settings'] = array(
    'linked_field' => array(
      'linked' => 0,
      'destination' => '',
      'advanced' => array(
        'title' => '',
        'target' => '',
        'class' => '',
        'rel' => '',
        'text' => '',
      ),
    ),
  );
  /* Field: Content: Meeting Agenda PDF */
  $handler->display->display_options['fields']['field_meeting_agenda_pdf']['id'] = 'field_meeting_agenda_pdf';
  $handler->display->display_options['fields']['field_meeting_agenda_pdf']['table'] = 'field_data_field_meeting_agenda_pdf';
  $handler->display->display_options['fields']['field_meeting_agenda_pdf']['field'] = 'field_meeting_agenda_pdf';
  $handler->display->display_options['fields']['field_meeting_agenda_pdf']['label'] = '';
  $handler->display->display_options['fields']['field_meeting_agenda_pdf']['exclude'] = TRUE;
  $handler->display->display_options['fields']['field_meeting_agenda_pdf']['alter']['alter_text'] = TRUE;
  $handler->display->display_options['fields']['field_meeting_agenda_pdf']['alter']['text'] = '<a href="[field_meeting_agenda_pdf]" target="_blank">PDF</a>';
  $handler->display->display_options['fields']['field_meeting_agenda_pdf']['element_label_colon'] = FALSE;
  $handler->display->display_options['fields']['field_meeting_agenda_pdf']['settings'] = array(
    'linked_field' => array(
      'linked' => 0,
      'destination' => '',
      'advanced' => array(
        'title' => '',
        'target' => '',
        'class' => '',
        'rel' => '',
        'text' => '',
      ),
    ),
  );
  /* Field: Global: Custom text */
  $handler->display->display_options['fields']['nothing']['id'] = 'nothing';
  $handler->display->display_options['fields']['nothing']['table'] = 'views';
  $handler->display->display_options['fields']['nothing']['field'] = 'nothing';
  $handler->display->display_options['fields']['nothing']['label'] = 'Agenda';
  $handler->display->display_options['fields']['nothing']['alter']['text'] = '[field_meeting_agenda_html] | [field_meeting_agenda_pdf]';
  $handler->display->display_options['fields']['nothing']['element_label_colon'] = FALSE;
  /* Field: Content: Meeting Minutes PDF */
  $handler->display->display_options['fields']['field_meeting_minutes_pdf']['id'] = 'field_meeting_minutes_pdf';
  $handler->display->display_options['fields']['field_meeting_minutes_pdf']['table'] = 'field_data_field_meeting_minutes_pdf';
  $handler->display->display_options['fields']['field_meeting_minutes_pdf']['field'] = 'field_meeting_minutes_pdf';
  $handler->display->display_options['fields']['field_meeting_minutes_pdf']['label'] = 'Minutes';
  $handler->display->display_options['fields']['field_meeting_minutes_pdf']['alter']['alter_text'] = TRUE;
  $handler->display->display_options['fields']['field_meeting_minutes_pdf']['alter']['text'] = '<a href="[field_meeting_minutes_pdf]" target="_blank">PDF</a>';
  $handler->display->display_options['fields']['field_meeting_minutes_pdf']['element_label_colon'] = FALSE;
  $handler->display->display_options['fields']['field_meeting_minutes_pdf']['settings'] = array(
    'linked_field' => array(
      'linked' => 0,
      'destination' => '',
      'advanced' => array(
        'title' => '',
        'target' => '',
        'class' => '',
        'rel' => '',
        'text' => '',
      ),
    ),
  );
  $handler->display->display_options['defaults']['sorts'] = FALSE;
  /* Sort criterion: Content: Date -  start date (field_date) */
  $handler->display->display_options['sorts']['field_date_value']['id'] = 'field_date_value';
  $handler->display->display_options['sorts']['field_date_value']['table'] = 'field_data_field_date';
  $handler->display->display_options['sorts']['field_date_value']['field'] = 'field_date_value';
  $handler->display->display_options['sorts']['field_date_value']['order'] = 'DESC';
  $handler->display->display_options['defaults']['filter_groups'] = FALSE;
  $handler->display->display_options['defaults']['filters'] = FALSE;
  /* Filter criterion: Content: Published status */
  $handler->display->display_options['filters']['status']['id'] = 'status';
  $handler->display->display_options['filters']['status']['table'] = 'node';
  $handler->display->display_options['filters']['status']['field'] = 'status';
  $handler->display->display_options['filters']['status']['value'] = 1;
  $handler->display->display_options['filters']['status']['group'] = 1;
  $handler->display->display_options['filters']['status']['expose']['operator'] = FALSE;
  /* Filter criterion: Content: Type */
  $handler->display->display_options['filters']['type']['id'] = 'type';
  $handler->display->display_options['filters']['type']['table'] = 'node';
  $handler->display->display_options['filters']['type']['field'] = 'type';
  $handler->display->display_options['filters']['type']['value'] = array(
    'meeting' => 'meeting',
  );
  /* Filter criterion: Content: Date -  start date (field_date) */
  $handler->display->display_options['filters']['field_date_value_1']['id'] = 'field_date_value_1';
  $handler->display->display_options['filters']['field_date_value_1']['table'] = 'field_data_field_date';
  $handler->display->display_options['filters']['field_date_value_1']['field'] = 'field_date_value';
  $handler->display->display_options['filters']['field_date_value_1']['operator'] = '<=';
  $handler->display->display_options['filters']['field_date_value_1']['default_date'] = 'now';
  /* Filter criterion: Content: Meeting Type (field_meeting_type) */
  $handler->display->display_options['filters']['field_meeting_type_tid']['id'] = 'field_meeting_type_tid';
  $handler->display->display_options['filters']['field_meeting_type_tid']['table'] = 'field_data_field_meeting_type';
  $handler->display->display_options['filters']['field_meeting_type_tid']['field'] = 'field_meeting_type_tid';
  $handler->display->display_options['filters']['field_meeting_type_tid']['value'] = array(
    2166 => '2166',
  );
  $handler->display->display_options['filters']['field_meeting_type_tid']['type'] = 'select';
  $handler->display->display_options['filters']['field_meeting_type_tid']['vocabulary'] = 'meeting_type';
  $handler->display->display_options['block_description'] = 'Meetings - Past - Board of Variance';

  /* Display: Block */
  $handler = $view->new_display('block', 'Block', 'block_15');
  $handler->display->display_options['defaults']['title'] = FALSE;
  $handler->display->display_options['title'] = 'Meetings - Past - Civic and Community';
  $handler->display->display_options['defaults']['pager'] = FALSE;
  $handler->display->display_options['pager']['type'] = 'full';
  $handler->display->display_options['pager']['options']['items_per_page'] = '10';
  $handler->display->display_options['pager']['options']['offset'] = '0';
  $handler->display->display_options['pager']['options']['id'] = '0';
  $handler->display->display_options['pager']['options']['quantity'] = '9';
  $handler->display->display_options['defaults']['style_plugin'] = FALSE;
  $handler->display->display_options['style_plugin'] = 'table';
  $handler->display->display_options['style_options']['columns'] = array(
    'field_meeting_type' => 'field_meeting_type',
    'field_date' => 'field_date',
    'field_meeting_address' => 'field_meeting_address',
    'field_meeting_location' => 'field_meeting_location',
    'field_meeting_agenda_html' => 'field_meeting_agenda_html',
    'field_meeting_agenda_pdf' => 'field_meeting_agenda_pdf',
    'nothing' => 'nothing',
    'field_meeting_minutes_pdf' => 'field_meeting_minutes_pdf',
  );
  $handler->display->display_options['style_options']['default'] = '-1';
  $handler->display->display_options['style_options']['info'] = array(
    'field_meeting_type' => array(
      'sortable' => 0,
      'default_sort_order' => 'asc',
      'align' => '',
      'separator' => '',
      'empty_column' => 0,
    ),
    'field_date' => array(
      'align' => '',
      'separator' => '',
      'empty_column' => 0,
    ),
    'field_meeting_address' => array(
      'sortable' => 0,
      'default_sort_order' => 'asc',
      'align' => '',
      'separator' => '',
      'empty_column' => 0,
    ),
    'field_meeting_location' => array(
      'sortable' => 0,
      'default_sort_order' => 'asc',
      'align' => '',
      'separator' => '',
      'empty_column' => 0,
    ),
    'field_meeting_agenda_html' => array(
      'sortable' => 0,
      'default_sort_order' => 'asc',
      'align' => '',
      'separator' => '',
      'empty_column' => 0,
    ),
    'field_meeting_agenda_pdf' => array(
      'sortable' => 0,
      'default_sort_order' => 'asc',
      'align' => '',
      'separator' => '',
      'empty_column' => 0,
    ),
    'nothing' => array(
      'align' => '',
      'separator' => '',
      'empty_column' => 0,
    ),
    'field_meeting_minutes_pdf' => array(
      'sortable' => 0,
      'default_sort_order' => 'asc',
      'align' => '',
      'separator' => '',
      'empty_column' => 0,
    ),
  );
  $handler->display->display_options['defaults']['style_options'] = FALSE;
  $handler->display->display_options['defaults']['row_plugin'] = FALSE;
  $handler->display->display_options['defaults']['row_options'] = FALSE;
  $handler->display->display_options['defaults']['footer'] = FALSE;
  /* Footer: Global: Text area */
  $handler->display->display_options['footer']['area']['id'] = 'area';
  $handler->display->display_options['footer']['area']['table'] = 'views';
  $handler->display->display_options['footer']['area']['field'] = 'area';
  $handler->display->display_options['footer']['area']['empty'] = TRUE;
  $handler->display->display_options['footer']['area']['content'] = '<h4><a href="/city-hall/council/committees/civic-and-community-awards-steering-committee/meeting-archives">Meeting Archives</a></h4>';
  $handler->display->display_options['footer']['area']['format'] = 'full_html';
  $handler->display->display_options['defaults']['empty'] = FALSE;
  /* No results behavior: Global: Text area */
  $handler->display->display_options['empty']['area']['id'] = 'area';
  $handler->display->display_options['empty']['area']['table'] = 'views';
  $handler->display->display_options['empty']['area']['field'] = 'area';
  $handler->display->display_options['empty']['area']['empty'] = TRUE;
  $handler->display->display_options['empty']['area']['content'] = 'Please refer to the archives for this committee\'s past meeting information.';
  $handler->display->display_options['empty']['area']['format'] = 'full_html';
  $handler->display->display_options['defaults']['fields'] = FALSE;
  /* Field: Content: Meeting Type */
  $handler->display->display_options['fields']['field_meeting_type']['id'] = 'field_meeting_type';
  $handler->display->display_options['fields']['field_meeting_type']['table'] = 'field_data_field_meeting_type';
  $handler->display->display_options['fields']['field_meeting_type']['field'] = 'field_meeting_type';
  $handler->display->display_options['fields']['field_meeting_type']['label'] = '';
  $handler->display->display_options['fields']['field_meeting_type']['exclude'] = TRUE;
  $handler->display->display_options['fields']['field_meeting_type']['element_label_colon'] = FALSE;
  $handler->display->display_options['fields']['field_meeting_type']['type'] = 'taxonomy_term_reference_plain';
  $handler->display->display_options['fields']['field_meeting_type']['settings'] = array(
    'linked_field' => array(
      'linked' => 0,
      'destination' => '',
      'advanced' => array(
        'title' => '',
        'target' => '',
        'class' => '',
        'rel' => '',
        'text' => '',
      ),
    ),
  );
  /* Field: Content: Title */
  $handler->display->display_options['fields']['title']['id'] = 'title';
  $handler->display->display_options['fields']['title']['table'] = 'node';
  $handler->display->display_options['fields']['title']['field'] = 'title';
  $handler->display->display_options['fields']['title']['label'] = 'Meeting';
  $handler->display->display_options['fields']['title']['element_label_colon'] = FALSE;
  $handler->display->display_options['fields']['title']['link_to_node'] = FALSE;
  /* Field: Content: Date */
  $handler->display->display_options['fields']['field_date']['id'] = 'field_date';
  $handler->display->display_options['fields']['field_date']['table'] = 'field_data_field_date';
  $handler->display->display_options['fields']['field_date']['field'] = 'field_date';
  $handler->display->display_options['fields']['field_date']['element_label_colon'] = FALSE;
  $handler->display->display_options['fields']['field_date']['settings'] = array(
    'format_type' => 'month_day_year_time',
    'fromto' => 'value',
    'multiple_number' => '',
    'multiple_from' => '',
    'multiple_to' => '',
    'show_remaining_days' => 0,
    'show_repeat_rule' => 'show',
    'linked_field' => array(
      'linked' => 0,
      'destination' => '',
      'advanced' => array(
        'title' => '',
        'target' => '',
        'class' => '',
        'rel' => '',
        'text' => '',
      ),
    ),
  );
  $handler->display->display_options['fields']['field_date']['delta_offset'] = '0';
  /* Field: Content: Meeting Address */
  $handler->display->display_options['fields']['field_meeting_address']['id'] = 'field_meeting_address';
  $handler->display->display_options['fields']['field_meeting_address']['table'] = 'field_data_field_meeting_address';
  $handler->display->display_options['fields']['field_meeting_address']['field'] = 'field_meeting_address';
  $handler->display->display_options['fields']['field_meeting_address']['label'] = '';
  $handler->display->display_options['fields']['field_meeting_address']['exclude'] = TRUE;
  $handler->display->display_options['fields']['field_meeting_address']['element_label_colon'] = FALSE;
  $handler->display->display_options['fields']['field_meeting_address']['type'] = 'text_plain';
  $handler->display->display_options['fields']['field_meeting_address']['settings'] = array(
    'linked_field' => array(
      'linked' => 0,
      'destination' => '',
      'advanced' => array(
        'title' => '',
        'target' => '',
        'class' => '',
        'rel' => '',
        'text' => '',
      ),
    ),
  );
  /* Field: Content: Meeting Location */
  $handler->display->display_options['fields']['field_meeting_location']['id'] = 'field_meeting_location';
  $handler->display->display_options['fields']['field_meeting_location']['table'] = 'field_data_field_meeting_location';
  $handler->display->display_options['fields']['field_meeting_location']['field'] = 'field_meeting_location';
  $handler->display->display_options['fields']['field_meeting_location']['label'] = 'Location';
  $handler->display->display_options['fields']['field_meeting_location']['alter']['alter_text'] = TRUE;
  $handler->display->display_options['fields']['field_meeting_location']['alter']['text'] = '[field_meeting_location]<br>
[field_meeting_address]
';
  $handler->display->display_options['fields']['field_meeting_location']['element_label_colon'] = FALSE;
  $handler->display->display_options['fields']['field_meeting_location']['type'] = 'text_plain';
  $handler->display->display_options['fields']['field_meeting_location']['settings'] = array(
    'linked_field' => array(
      'linked' => 0,
      'destination' => '',
      'advanced' => array(
        'title' => '',
        'target' => '',
        'class' => '',
        'rel' => '',
        'text' => '',
      ),
    ),
  );
  /* Field: Content: Meeting Agenda HTML */
  $handler->display->display_options['fields']['field_meeting_agenda_html']['id'] = 'field_meeting_agenda_html';
  $handler->display->display_options['fields']['field_meeting_agenda_html']['table'] = 'field_data_field_meeting_agenda_html';
  $handler->display->display_options['fields']['field_meeting_agenda_html']['field'] = 'field_meeting_agenda_html';
  $handler->display->display_options['fields']['field_meeting_agenda_html']['label'] = '';
  $handler->display->display_options['fields']['field_meeting_agenda_html']['exclude'] = TRUE;
  $handler->display->display_options['fields']['field_meeting_agenda_html']['alter']['alter_text'] = TRUE;
  $handler->display->display_options['fields']['field_meeting_agenda_html']['alter']['text'] = '<a href="[field_meeting_agenda_html]" target="_blank">HTML</a>';
  $handler->display->display_options['fields']['field_meeting_agenda_html']['element_label_colon'] = FALSE;
  $handler->display->display_options['fields']['field_meeting_agenda_html']['settings'] = array(
    'linked_field' => array(
      'linked' => 0,
      'destination' => '',
      'advanced' => array(
        'title' => '',
        'target' => '',
        'class' => '',
        'rel' => '',
        'text' => '',
      ),
    ),
  );
  /* Field: Content: Meeting Agenda PDF */
  $handler->display->display_options['fields']['field_meeting_agenda_pdf']['id'] = 'field_meeting_agenda_pdf';
  $handler->display->display_options['fields']['field_meeting_agenda_pdf']['table'] = 'field_data_field_meeting_agenda_pdf';
  $handler->display->display_options['fields']['field_meeting_agenda_pdf']['field'] = 'field_meeting_agenda_pdf';
  $handler->display->display_options['fields']['field_meeting_agenda_pdf']['label'] = '';
  $handler->display->display_options['fields']['field_meeting_agenda_pdf']['exclude'] = TRUE;
  $handler->display->display_options['fields']['field_meeting_agenda_pdf']['alter']['alter_text'] = TRUE;
  $handler->display->display_options['fields']['field_meeting_agenda_pdf']['alter']['text'] = '<a href="[field_meeting_agenda_pdf]" target="_blank">PDF</a>';
  $handler->display->display_options['fields']['field_meeting_agenda_pdf']['element_label_colon'] = FALSE;
  $handler->display->display_options['fields']['field_meeting_agenda_pdf']['settings'] = array(
    'linked_field' => array(
      'linked' => 0,
      'destination' => '',
      'advanced' => array(
        'title' => '',
        'target' => '',
        'class' => '',
        'rel' => '',
        'text' => '',
      ),
    ),
  );
  /* Field: Global: Custom text */
  $handler->display->display_options['fields']['nothing']['id'] = 'nothing';
  $handler->display->display_options['fields']['nothing']['table'] = 'views';
  $handler->display->display_options['fields']['nothing']['field'] = 'nothing';
  $handler->display->display_options['fields']['nothing']['label'] = 'Agenda';
  $handler->display->display_options['fields']['nothing']['alter']['text'] = '[field_meeting_agenda_html] | [field_meeting_agenda_pdf]';
  $handler->display->display_options['fields']['nothing']['element_label_colon'] = FALSE;
  /* Field: Content: Meeting Minutes PDF */
  $handler->display->display_options['fields']['field_meeting_minutes_pdf']['id'] = 'field_meeting_minutes_pdf';
  $handler->display->display_options['fields']['field_meeting_minutes_pdf']['table'] = 'field_data_field_meeting_minutes_pdf';
  $handler->display->display_options['fields']['field_meeting_minutes_pdf']['field'] = 'field_meeting_minutes_pdf';
  $handler->display->display_options['fields']['field_meeting_minutes_pdf']['label'] = 'Minutes';
  $handler->display->display_options['fields']['field_meeting_minutes_pdf']['alter']['alter_text'] = TRUE;
  $handler->display->display_options['fields']['field_meeting_minutes_pdf']['alter']['text'] = '<a href="[field_meeting_minutes_pdf]" target="_blank">PDF</a>';
  $handler->display->display_options['fields']['field_meeting_minutes_pdf']['element_label_colon'] = FALSE;
  $handler->display->display_options['fields']['field_meeting_minutes_pdf']['settings'] = array(
    'linked_field' => array(
      'linked' => 0,
      'destination' => '',
      'advanced' => array(
        'title' => '',
        'target' => '',
        'class' => '',
        'rel' => '',
        'text' => '',
      ),
    ),
  );
  $handler->display->display_options['defaults']['sorts'] = FALSE;
  /* Sort criterion: Content: Date -  start date (field_date) */
  $handler->display->display_options['sorts']['field_date_value']['id'] = 'field_date_value';
  $handler->display->display_options['sorts']['field_date_value']['table'] = 'field_data_field_date';
  $handler->display->display_options['sorts']['field_date_value']['field'] = 'field_date_value';
  $handler->display->display_options['sorts']['field_date_value']['order'] = 'DESC';
  $handler->display->display_options['defaults']['filter_groups'] = FALSE;
  $handler->display->display_options['defaults']['filters'] = FALSE;
  /* Filter criterion: Content: Published status */
  $handler->display->display_options['filters']['status']['id'] = 'status';
  $handler->display->display_options['filters']['status']['table'] = 'node';
  $handler->display->display_options['filters']['status']['field'] = 'status';
  $handler->display->display_options['filters']['status']['value'] = 1;
  $handler->display->display_options['filters']['status']['group'] = 1;
  $handler->display->display_options['filters']['status']['expose']['operator'] = FALSE;
  /* Filter criterion: Content: Type */
  $handler->display->display_options['filters']['type']['id'] = 'type';
  $handler->display->display_options['filters']['type']['table'] = 'node';
  $handler->display->display_options['filters']['type']['field'] = 'type';
  $handler->display->display_options['filters']['type']['value'] = array(
    'meeting' => 'meeting',
  );
  /* Filter criterion: Content: Date -  start date (field_date) */
  $handler->display->display_options['filters']['field_date_value_1']['id'] = 'field_date_value_1';
  $handler->display->display_options['filters']['field_date_value_1']['table'] = 'field_data_field_date';
  $handler->display->display_options['filters']['field_date_value_1']['field'] = 'field_date_value';
  $handler->display->display_options['filters']['field_date_value_1']['operator'] = '<=';
  $handler->display->display_options['filters']['field_date_value_1']['default_date'] = 'now';
  /* Filter criterion: Content: Meeting Type (field_meeting_type) */
  $handler->display->display_options['filters']['field_meeting_type_tid']['id'] = 'field_meeting_type_tid';
  $handler->display->display_options['filters']['field_meeting_type_tid']['table'] = 'field_data_field_meeting_type';
  $handler->display->display_options['filters']['field_meeting_type_tid']['field'] = 'field_meeting_type_tid';
  $handler->display->display_options['filters']['field_meeting_type_tid']['value'] = array(
    2144 => '2144',
  );
  $handler->display->display_options['filters']['field_meeting_type_tid']['type'] = 'select';
  $handler->display->display_options['filters']['field_meeting_type_tid']['vocabulary'] = 'meeting_type';
  $handler->display->display_options['block_description'] = 'Meetings - Past - Civic and Community';

  /* Display: Block */
  $handler = $view->new_display('block', 'Block', 'block_16');
  $handler->display->display_options['defaults']['title'] = FALSE;
  $handler->display->display_options['title'] = 'Meetings - Past - Heritage';
  $handler->display->display_options['defaults']['pager'] = FALSE;
  $handler->display->display_options['pager']['type'] = 'full';
  $handler->display->display_options['pager']['options']['items_per_page'] = '10';
  $handler->display->display_options['pager']['options']['offset'] = '0';
  $handler->display->display_options['pager']['options']['id'] = '0';
  $handler->display->display_options['pager']['options']['quantity'] = '9';
  $handler->display->display_options['defaults']['style_plugin'] = FALSE;
  $handler->display->display_options['style_plugin'] = 'table';
  $handler->display->display_options['style_options']['columns'] = array(
    'field_meeting_type' => 'field_meeting_type',
    'field_date' => 'field_date',
    'field_meeting_address' => 'field_meeting_address',
    'field_meeting_location' => 'field_meeting_location',
    'field_meeting_agenda_html' => 'field_meeting_agenda_html',
    'field_meeting_agenda_pdf' => 'field_meeting_agenda_pdf',
    'nothing' => 'nothing',
    'field_meeting_minutes_pdf' => 'field_meeting_minutes_pdf',
  );
  $handler->display->display_options['style_options']['default'] = '-1';
  $handler->display->display_options['style_options']['info'] = array(
    'field_meeting_type' => array(
      'sortable' => 0,
      'default_sort_order' => 'asc',
      'align' => '',
      'separator' => '',
      'empty_column' => 0,
    ),
    'field_date' => array(
      'align' => '',
      'separator' => '',
      'empty_column' => 0,
    ),
    'field_meeting_address' => array(
      'sortable' => 0,
      'default_sort_order' => 'asc',
      'align' => '',
      'separator' => '',
      'empty_column' => 0,
    ),
    'field_meeting_location' => array(
      'sortable' => 0,
      'default_sort_order' => 'asc',
      'align' => '',
      'separator' => '',
      'empty_column' => 0,
    ),
    'field_meeting_agenda_html' => array(
      'sortable' => 0,
      'default_sort_order' => 'asc',
      'align' => '',
      'separator' => '',
      'empty_column' => 0,
    ),
    'field_meeting_agenda_pdf' => array(
      'sortable' => 0,
      'default_sort_order' => 'asc',
      'align' => '',
      'separator' => '',
      'empty_column' => 0,
    ),
    'nothing' => array(
      'align' => '',
      'separator' => '',
      'empty_column' => 0,
    ),
    'field_meeting_minutes_pdf' => array(
      'sortable' => 0,
      'default_sort_order' => 'asc',
      'align' => '',
      'separator' => '',
      'empty_column' => 0,
    ),
  );
  $handler->display->display_options['defaults']['style_options'] = FALSE;
  $handler->display->display_options['defaults']['row_plugin'] = FALSE;
  $handler->display->display_options['defaults']['row_options'] = FALSE;
  $handler->display->display_options['defaults']['footer'] = FALSE;
  /* Footer: Global: Text area */
  $handler->display->display_options['footer']['area']['id'] = 'area';
  $handler->display->display_options['footer']['area']['table'] = 'views';
  $handler->display->display_options['footer']['area']['field'] = 'area';
  $handler->display->display_options['footer']['area']['empty'] = TRUE;
  $handler->display->display_options['footer']['area']['content'] = '<h4><a href="/city-hall/council/committees/heritage-advisory-committee/meeting-archives">Meeting Archives</a></h4>';
  $handler->display->display_options['footer']['area']['format'] = 'full_html';
  $handler->display->display_options['defaults']['empty'] = FALSE;
  /* No results behavior: Global: Text area */
  $handler->display->display_options['empty']['area']['id'] = 'area';
  $handler->display->display_options['empty']['area']['table'] = 'views';
  $handler->display->display_options['empty']['area']['field'] = 'area';
  $handler->display->display_options['empty']['area']['empty'] = TRUE;
  $handler->display->display_options['empty']['area']['content'] = 'Please refer to the archives for this committee\'s past meeting information.';
  $handler->display->display_options['empty']['area']['format'] = 'full_html';
  $handler->display->display_options['defaults']['fields'] = FALSE;
  /* Field: Content: Meeting Type */
  $handler->display->display_options['fields']['field_meeting_type']['id'] = 'field_meeting_type';
  $handler->display->display_options['fields']['field_meeting_type']['table'] = 'field_data_field_meeting_type';
  $handler->display->display_options['fields']['field_meeting_type']['field'] = 'field_meeting_type';
  $handler->display->display_options['fields']['field_meeting_type']['label'] = '';
  $handler->display->display_options['fields']['field_meeting_type']['exclude'] = TRUE;
  $handler->display->display_options['fields']['field_meeting_type']['element_label_colon'] = FALSE;
  $handler->display->display_options['fields']['field_meeting_type']['type'] = 'taxonomy_term_reference_plain';
  $handler->display->display_options['fields']['field_meeting_type']['settings'] = array(
    'linked_field' => array(
      'linked' => 0,
      'destination' => '',
      'advanced' => array(
        'title' => '',
        'target' => '',
        'class' => '',
        'rel' => '',
        'text' => '',
      ),
    ),
  );
  /* Field: Content: Title */
  $handler->display->display_options['fields']['title']['id'] = 'title';
  $handler->display->display_options['fields']['title']['table'] = 'node';
  $handler->display->display_options['fields']['title']['field'] = 'title';
  $handler->display->display_options['fields']['title']['label'] = 'Meeting';
  $handler->display->display_options['fields']['title']['element_label_colon'] = FALSE;
  $handler->display->display_options['fields']['title']['link_to_node'] = FALSE;
  /* Field: Content: Date */
  $handler->display->display_options['fields']['field_date']['id'] = 'field_date';
  $handler->display->display_options['fields']['field_date']['table'] = 'field_data_field_date';
  $handler->display->display_options['fields']['field_date']['field'] = 'field_date';
  $handler->display->display_options['fields']['field_date']['element_label_colon'] = FALSE;
  $handler->display->display_options['fields']['field_date']['settings'] = array(
    'format_type' => 'month_day_year_time',
    'fromto' => 'value',
    'multiple_number' => '',
    'multiple_from' => '',
    'multiple_to' => '',
    'show_remaining_days' => 0,
    'show_repeat_rule' => 'show',
    'linked_field' => array(
      'linked' => 0,
      'destination' => '',
      'advanced' => array(
        'title' => '',
        'target' => '',
        'class' => '',
        'rel' => '',
        'text' => '',
      ),
    ),
  );
  $handler->display->display_options['fields']['field_date']['delta_offset'] = '0';
  /* Field: Content: Meeting Address */
  $handler->display->display_options['fields']['field_meeting_address']['id'] = 'field_meeting_address';
  $handler->display->display_options['fields']['field_meeting_address']['table'] = 'field_data_field_meeting_address';
  $handler->display->display_options['fields']['field_meeting_address']['field'] = 'field_meeting_address';
  $handler->display->display_options['fields']['field_meeting_address']['label'] = '';
  $handler->display->display_options['fields']['field_meeting_address']['exclude'] = TRUE;
  $handler->display->display_options['fields']['field_meeting_address']['element_label_colon'] = FALSE;
  $handler->display->display_options['fields']['field_meeting_address']['type'] = 'text_plain';
  $handler->display->display_options['fields']['field_meeting_address']['settings'] = array(
    'linked_field' => array(
      'linked' => 0,
      'destination' => '',
      'advanced' => array(
        'title' => '',
        'target' => '',
        'class' => '',
        'rel' => '',
        'text' => '',
      ),
    ),
  );
  /* Field: Content: Meeting Location */
  $handler->display->display_options['fields']['field_meeting_location']['id'] = 'field_meeting_location';
  $handler->display->display_options['fields']['field_meeting_location']['table'] = 'field_data_field_meeting_location';
  $handler->display->display_options['fields']['field_meeting_location']['field'] = 'field_meeting_location';
  $handler->display->display_options['fields']['field_meeting_location']['label'] = 'Location';
  $handler->display->display_options['fields']['field_meeting_location']['alter']['alter_text'] = TRUE;
  $handler->display->display_options['fields']['field_meeting_location']['alter']['text'] = '[field_meeting_location]<br>
[field_meeting_address]
';
  $handler->display->display_options['fields']['field_meeting_location']['element_label_colon'] = FALSE;
  $handler->display->display_options['fields']['field_meeting_location']['type'] = 'text_plain';
  $handler->display->display_options['fields']['field_meeting_location']['settings'] = array(
    'linked_field' => array(
      'linked' => 0,
      'destination' => '',
      'advanced' => array(
        'title' => '',
        'target' => '',
        'class' => '',
        'rel' => '',
        'text' => '',
      ),
    ),
  );
  /* Field: Content: Meeting Agenda HTML */
  $handler->display->display_options['fields']['field_meeting_agenda_html']['id'] = 'field_meeting_agenda_html';
  $handler->display->display_options['fields']['field_meeting_agenda_html']['table'] = 'field_data_field_meeting_agenda_html';
  $handler->display->display_options['fields']['field_meeting_agenda_html']['field'] = 'field_meeting_agenda_html';
  $handler->display->display_options['fields']['field_meeting_agenda_html']['label'] = '';
  $handler->display->display_options['fields']['field_meeting_agenda_html']['exclude'] = TRUE;
  $handler->display->display_options['fields']['field_meeting_agenda_html']['alter']['alter_text'] = TRUE;
  $handler->display->display_options['fields']['field_meeting_agenda_html']['alter']['text'] = '<a href="[field_meeting_agenda_html]" target="_blank">HTML</a>';
  $handler->display->display_options['fields']['field_meeting_agenda_html']['element_label_colon'] = FALSE;
  $handler->display->display_options['fields']['field_meeting_agenda_html']['settings'] = array(
    'linked_field' => array(
      'linked' => 0,
      'destination' => '',
      'advanced' => array(
        'title' => '',
        'target' => '',
        'class' => '',
        'rel' => '',
        'text' => '',
      ),
    ),
  );
  /* Field: Content: Meeting Agenda PDF */
  $handler->display->display_options['fields']['field_meeting_agenda_pdf']['id'] = 'field_meeting_agenda_pdf';
  $handler->display->display_options['fields']['field_meeting_agenda_pdf']['table'] = 'field_data_field_meeting_agenda_pdf';
  $handler->display->display_options['fields']['field_meeting_agenda_pdf']['field'] = 'field_meeting_agenda_pdf';
  $handler->display->display_options['fields']['field_meeting_agenda_pdf']['label'] = '';
  $handler->display->display_options['fields']['field_meeting_agenda_pdf']['exclude'] = TRUE;
  $handler->display->display_options['fields']['field_meeting_agenda_pdf']['alter']['alter_text'] = TRUE;
  $handler->display->display_options['fields']['field_meeting_agenda_pdf']['alter']['text'] = '<a href="[field_meeting_agenda_pdf]" target="_blank">PDF</a>';
  $handler->display->display_options['fields']['field_meeting_agenda_pdf']['element_label_colon'] = FALSE;
  $handler->display->display_options['fields']['field_meeting_agenda_pdf']['settings'] = array(
    'linked_field' => array(
      'linked' => 0,
      'destination' => '',
      'advanced' => array(
        'title' => '',
        'target' => '',
        'class' => '',
        'rel' => '',
        'text' => '',
      ),
    ),
  );
  /* Field: Global: Custom text */
  $handler->display->display_options['fields']['nothing']['id'] = 'nothing';
  $handler->display->display_options['fields']['nothing']['table'] = 'views';
  $handler->display->display_options['fields']['nothing']['field'] = 'nothing';
  $handler->display->display_options['fields']['nothing']['label'] = 'Agenda';
  $handler->display->display_options['fields']['nothing']['alter']['text'] = '[field_meeting_agenda_html] | [field_meeting_agenda_pdf]';
  $handler->display->display_options['fields']['nothing']['element_label_colon'] = FALSE;
  /* Field: Content: Meeting Minutes PDF */
  $handler->display->display_options['fields']['field_meeting_minutes_pdf']['id'] = 'field_meeting_minutes_pdf';
  $handler->display->display_options['fields']['field_meeting_minutes_pdf']['table'] = 'field_data_field_meeting_minutes_pdf';
  $handler->display->display_options['fields']['field_meeting_minutes_pdf']['field'] = 'field_meeting_minutes_pdf';
  $handler->display->display_options['fields']['field_meeting_minutes_pdf']['label'] = 'Minutes';
  $handler->display->display_options['fields']['field_meeting_minutes_pdf']['alter']['alter_text'] = TRUE;
  $handler->display->display_options['fields']['field_meeting_minutes_pdf']['alter']['text'] = '<a href="[field_meeting_minutes_pdf]" target="_blank">PDF</a>';
  $handler->display->display_options['fields']['field_meeting_minutes_pdf']['element_label_colon'] = FALSE;
  $handler->display->display_options['fields']['field_meeting_minutes_pdf']['settings'] = array(
    'linked_field' => array(
      'linked' => 0,
      'destination' => '',
      'advanced' => array(
        'title' => '',
        'target' => '',
        'class' => '',
        'rel' => '',
        'text' => '',
      ),
    ),
  );
  $handler->display->display_options['defaults']['sorts'] = FALSE;
  /* Sort criterion: Content: Date -  start date (field_date) */
  $handler->display->display_options['sorts']['field_date_value']['id'] = 'field_date_value';
  $handler->display->display_options['sorts']['field_date_value']['table'] = 'field_data_field_date';
  $handler->display->display_options['sorts']['field_date_value']['field'] = 'field_date_value';
  $handler->display->display_options['sorts']['field_date_value']['order'] = 'DESC';
  $handler->display->display_options['defaults']['filter_groups'] = FALSE;
  $handler->display->display_options['defaults']['filters'] = FALSE;
  /* Filter criterion: Content: Published status */
  $handler->display->display_options['filters']['status']['id'] = 'status';
  $handler->display->display_options['filters']['status']['table'] = 'node';
  $handler->display->display_options['filters']['status']['field'] = 'status';
  $handler->display->display_options['filters']['status']['value'] = 1;
  $handler->display->display_options['filters']['status']['group'] = 1;
  $handler->display->display_options['filters']['status']['expose']['operator'] = FALSE;
  /* Filter criterion: Content: Type */
  $handler->display->display_options['filters']['type']['id'] = 'type';
  $handler->display->display_options['filters']['type']['table'] = 'node';
  $handler->display->display_options['filters']['type']['field'] = 'type';
  $handler->display->display_options['filters']['type']['value'] = array(
    'meeting' => 'meeting',
  );
  /* Filter criterion: Content: Date -  start date (field_date) */
  $handler->display->display_options['filters']['field_date_value_1']['id'] = 'field_date_value_1';
  $handler->display->display_options['filters']['field_date_value_1']['table'] = 'field_data_field_date';
  $handler->display->display_options['filters']['field_date_value_1']['field'] = 'field_date_value';
  $handler->display->display_options['filters']['field_date_value_1']['operator'] = '<=';
  $handler->display->display_options['filters']['field_date_value_1']['default_date'] = 'now';
  /* Filter criterion: Content: Meeting Type (field_meeting_type) */
  $handler->display->display_options['filters']['field_meeting_type_tid']['id'] = 'field_meeting_type_tid';
  $handler->display->display_options['filters']['field_meeting_type_tid']['table'] = 'field_data_field_meeting_type';
  $handler->display->display_options['filters']['field_meeting_type_tid']['field'] = 'field_meeting_type_tid';
  $handler->display->display_options['filters']['field_meeting_type_tid']['value'] = array(
    2165 => '2165',
  );
  $handler->display->display_options['filters']['field_meeting_type_tid']['type'] = 'select';
  $handler->display->display_options['filters']['field_meeting_type_tid']['vocabulary'] = 'meeting_type';
  $handler->display->display_options['block_description'] = 'Meetings - Past - Heritage';

  /* Display: Block */
  $handler = $view->new_display('block', 'Block', 'block_17');
  $handler->display->display_options['defaults']['title'] = FALSE;
  $handler->display->display_options['title'] = 'Meetings - Past - Parcel Tax';
  $handler->display->display_options['defaults']['pager'] = FALSE;
  $handler->display->display_options['pager']['type'] = 'full';
  $handler->display->display_options['pager']['options']['items_per_page'] = '10';
  $handler->display->display_options['pager']['options']['offset'] = '0';
  $handler->display->display_options['pager']['options']['id'] = '0';
  $handler->display->display_options['pager']['options']['quantity'] = '9';
  $handler->display->display_options['defaults']['style_plugin'] = FALSE;
  $handler->display->display_options['style_plugin'] = 'table';
  $handler->display->display_options['style_options']['columns'] = array(
    'field_meeting_type' => 'field_meeting_type',
    'field_date' => 'field_date',
    'field_meeting_address' => 'field_meeting_address',
    'field_meeting_location' => 'field_meeting_location',
    'field_meeting_agenda_html' => 'field_meeting_agenda_html',
    'field_meeting_agenda_pdf' => 'field_meeting_agenda_pdf',
    'nothing' => 'nothing',
    'field_meeting_minutes_pdf' => 'field_meeting_minutes_pdf',
  );
  $handler->display->display_options['style_options']['default'] = '-1';
  $handler->display->display_options['style_options']['info'] = array(
    'field_meeting_type' => array(
      'sortable' => 0,
      'default_sort_order' => 'asc',
      'align' => '',
      'separator' => '',
      'empty_column' => 0,
    ),
    'field_date' => array(
      'align' => '',
      'separator' => '',
      'empty_column' => 0,
    ),
    'field_meeting_address' => array(
      'sortable' => 0,
      'default_sort_order' => 'asc',
      'align' => '',
      'separator' => '',
      'empty_column' => 0,
    ),
    'field_meeting_location' => array(
      'sortable' => 0,
      'default_sort_order' => 'asc',
      'align' => '',
      'separator' => '',
      'empty_column' => 0,
    ),
    'field_meeting_agenda_html' => array(
      'sortable' => 0,
      'default_sort_order' => 'asc',
      'align' => '',
      'separator' => '',
      'empty_column' => 0,
    ),
    'field_meeting_agenda_pdf' => array(
      'sortable' => 0,
      'default_sort_order' => 'asc',
      'align' => '',
      'separator' => '',
      'empty_column' => 0,
    ),
    'nothing' => array(
      'align' => '',
      'separator' => '',
      'empty_column' => 0,
    ),
    'field_meeting_minutes_pdf' => array(
      'sortable' => 0,
      'default_sort_order' => 'asc',
      'align' => '',
      'separator' => '',
      'empty_column' => 0,
    ),
  );
  $handler->display->display_options['defaults']['style_options'] = FALSE;
  $handler->display->display_options['defaults']['row_plugin'] = FALSE;
  $handler->display->display_options['defaults']['row_options'] = FALSE;
  $handler->display->display_options['defaults']['footer'] = FALSE;
  /* Footer: Global: Text area */
  $handler->display->display_options['footer']['area']['id'] = 'area';
  $handler->display->display_options['footer']['area']['table'] = 'views';
  $handler->display->display_options['footer']['area']['field'] = 'area';
  $handler->display->display_options['footer']['area']['empty'] = TRUE;
  $handler->display->display_options['footer']['area']['content'] = '<h4><a href="/city-hall/council/committees/parcel-tax-review-panel/meeting-archives">Meeting Archives</a></h4>';
  $handler->display->display_options['footer']['area']['format'] = 'full_html';
  $handler->display->display_options['defaults']['empty'] = FALSE;
  /* No results behavior: Global: Text area */
  $handler->display->display_options['empty']['area']['id'] = 'area';
  $handler->display->display_options['empty']['area']['table'] = 'views';
  $handler->display->display_options['empty']['area']['field'] = 'area';
  $handler->display->display_options['empty']['area']['empty'] = TRUE;
  $handler->display->display_options['empty']['area']['content'] = 'Please refer to the archives for this committee\'s past meeting information.';
  $handler->display->display_options['empty']['area']['format'] = 'full_html';
  $handler->display->display_options['defaults']['fields'] = FALSE;
  /* Field: Content: Meeting Type */
  $handler->display->display_options['fields']['field_meeting_type']['id'] = 'field_meeting_type';
  $handler->display->display_options['fields']['field_meeting_type']['table'] = 'field_data_field_meeting_type';
  $handler->display->display_options['fields']['field_meeting_type']['field'] = 'field_meeting_type';
  $handler->display->display_options['fields']['field_meeting_type']['label'] = '';
  $handler->display->display_options['fields']['field_meeting_type']['exclude'] = TRUE;
  $handler->display->display_options['fields']['field_meeting_type']['element_label_colon'] = FALSE;
  $handler->display->display_options['fields']['field_meeting_type']['type'] = 'taxonomy_term_reference_plain';
  $handler->display->display_options['fields']['field_meeting_type']['settings'] = array(
    'linked_field' => array(
      'linked' => 0,
      'destination' => '',
      'advanced' => array(
        'title' => '',
        'target' => '',
        'class' => '',
        'rel' => '',
        'text' => '',
      ),
    ),
  );
  /* Field: Content: Title */
  $handler->display->display_options['fields']['title']['id'] = 'title';
  $handler->display->display_options['fields']['title']['table'] = 'node';
  $handler->display->display_options['fields']['title']['field'] = 'title';
  $handler->display->display_options['fields']['title']['label'] = 'Meeting';
  $handler->display->display_options['fields']['title']['element_label_colon'] = FALSE;
  $handler->display->display_options['fields']['title']['link_to_node'] = FALSE;
  /* Field: Content: Date */
  $handler->display->display_options['fields']['field_date']['id'] = 'field_date';
  $handler->display->display_options['fields']['field_date']['table'] = 'field_data_field_date';
  $handler->display->display_options['fields']['field_date']['field'] = 'field_date';
  $handler->display->display_options['fields']['field_date']['element_label_colon'] = FALSE;
  $handler->display->display_options['fields']['field_date']['settings'] = array(
    'format_type' => 'month_day_year_time',
    'fromto' => 'value',
    'multiple_number' => '',
    'multiple_from' => '',
    'multiple_to' => '',
    'show_remaining_days' => 0,
    'show_repeat_rule' => 'show',
    'linked_field' => array(
      'linked' => 0,
      'destination' => '',
      'advanced' => array(
        'title' => '',
        'target' => '',
        'class' => '',
        'rel' => '',
        'text' => '',
      ),
    ),
  );
  $handler->display->display_options['fields']['field_date']['delta_offset'] = '0';
  /* Field: Content: Meeting Address */
  $handler->display->display_options['fields']['field_meeting_address']['id'] = 'field_meeting_address';
  $handler->display->display_options['fields']['field_meeting_address']['table'] = 'field_data_field_meeting_address';
  $handler->display->display_options['fields']['field_meeting_address']['field'] = 'field_meeting_address';
  $handler->display->display_options['fields']['field_meeting_address']['label'] = '';
  $handler->display->display_options['fields']['field_meeting_address']['exclude'] = TRUE;
  $handler->display->display_options['fields']['field_meeting_address']['element_label_colon'] = FALSE;
  $handler->display->display_options['fields']['field_meeting_address']['type'] = 'text_plain';
  $handler->display->display_options['fields']['field_meeting_address']['settings'] = array(
    'linked_field' => array(
      'linked' => 0,
      'destination' => '',
      'advanced' => array(
        'title' => '',
        'target' => '',
        'class' => '',
        'rel' => '',
        'text' => '',
      ),
    ),
  );
  /* Field: Content: Meeting Location */
  $handler->display->display_options['fields']['field_meeting_location']['id'] = 'field_meeting_location';
  $handler->display->display_options['fields']['field_meeting_location']['table'] = 'field_data_field_meeting_location';
  $handler->display->display_options['fields']['field_meeting_location']['field'] = 'field_meeting_location';
  $handler->display->display_options['fields']['field_meeting_location']['label'] = 'Location';
  $handler->display->display_options['fields']['field_meeting_location']['alter']['alter_text'] = TRUE;
  $handler->display->display_options['fields']['field_meeting_location']['alter']['text'] = '[field_meeting_location]<br>
[field_meeting_address]
';
  $handler->display->display_options['fields']['field_meeting_location']['element_label_colon'] = FALSE;
  $handler->display->display_options['fields']['field_meeting_location']['type'] = 'text_plain';
  $handler->display->display_options['fields']['field_meeting_location']['settings'] = array(
    'linked_field' => array(
      'linked' => 0,
      'destination' => '',
      'advanced' => array(
        'title' => '',
        'target' => '',
        'class' => '',
        'rel' => '',
        'text' => '',
      ),
    ),
  );
  /* Field: Content: Meeting Agenda HTML */
  $handler->display->display_options['fields']['field_meeting_agenda_html']['id'] = 'field_meeting_agenda_html';
  $handler->display->display_options['fields']['field_meeting_agenda_html']['table'] = 'field_data_field_meeting_agenda_html';
  $handler->display->display_options['fields']['field_meeting_agenda_html']['field'] = 'field_meeting_agenda_html';
  $handler->display->display_options['fields']['field_meeting_agenda_html']['label'] = '';
  $handler->display->display_options['fields']['field_meeting_agenda_html']['exclude'] = TRUE;
  $handler->display->display_options['fields']['field_meeting_agenda_html']['alter']['alter_text'] = TRUE;
  $handler->display->display_options['fields']['field_meeting_agenda_html']['alter']['text'] = '<a href="[field_meeting_agenda_html]" target="_blank">HTML</a>';
  $handler->display->display_options['fields']['field_meeting_agenda_html']['element_label_colon'] = FALSE;
  $handler->display->display_options['fields']['field_meeting_agenda_html']['settings'] = array(
    'linked_field' => array(
      'linked' => 0,
      'destination' => '',
      'advanced' => array(
        'title' => '',
        'target' => '',
        'class' => '',
        'rel' => '',
        'text' => '',
      ),
    ),
  );
  /* Field: Content: Meeting Agenda PDF */
  $handler->display->display_options['fields']['field_meeting_agenda_pdf']['id'] = 'field_meeting_agenda_pdf';
  $handler->display->display_options['fields']['field_meeting_agenda_pdf']['table'] = 'field_data_field_meeting_agenda_pdf';
  $handler->display->display_options['fields']['field_meeting_agenda_pdf']['field'] = 'field_meeting_agenda_pdf';
  $handler->display->display_options['fields']['field_meeting_agenda_pdf']['label'] = '';
  $handler->display->display_options['fields']['field_meeting_agenda_pdf']['exclude'] = TRUE;
  $handler->display->display_options['fields']['field_meeting_agenda_pdf']['alter']['alter_text'] = TRUE;
  $handler->display->display_options['fields']['field_meeting_agenda_pdf']['alter']['text'] = '<a href="[field_meeting_agenda_pdf]" target="_blank">PDF</a>';
  $handler->display->display_options['fields']['field_meeting_agenda_pdf']['element_label_colon'] = FALSE;
  $handler->display->display_options['fields']['field_meeting_agenda_pdf']['settings'] = array(
    'linked_field' => array(
      'linked' => 0,
      'destination' => '',
      'advanced' => array(
        'title' => '',
        'target' => '',
        'class' => '',
        'rel' => '',
        'text' => '',
      ),
    ),
  );
  /* Field: Global: Custom text */
  $handler->display->display_options['fields']['nothing']['id'] = 'nothing';
  $handler->display->display_options['fields']['nothing']['table'] = 'views';
  $handler->display->display_options['fields']['nothing']['field'] = 'nothing';
  $handler->display->display_options['fields']['nothing']['label'] = 'Agenda';
  $handler->display->display_options['fields']['nothing']['alter']['text'] = '[field_meeting_agenda_html] | [field_meeting_agenda_pdf]';
  $handler->display->display_options['fields']['nothing']['element_label_colon'] = FALSE;
  /* Field: Content: Meeting Minutes PDF */
  $handler->display->display_options['fields']['field_meeting_minutes_pdf']['id'] = 'field_meeting_minutes_pdf';
  $handler->display->display_options['fields']['field_meeting_minutes_pdf']['table'] = 'field_data_field_meeting_minutes_pdf';
  $handler->display->display_options['fields']['field_meeting_minutes_pdf']['field'] = 'field_meeting_minutes_pdf';
  $handler->display->display_options['fields']['field_meeting_minutes_pdf']['label'] = 'Minutes';
  $handler->display->display_options['fields']['field_meeting_minutes_pdf']['alter']['alter_text'] = TRUE;
  $handler->display->display_options['fields']['field_meeting_minutes_pdf']['alter']['text'] = '<a href="[field_meeting_minutes_pdf]" target="_blank">PDF</a>';
  $handler->display->display_options['fields']['field_meeting_minutes_pdf']['element_label_colon'] = FALSE;
  $handler->display->display_options['fields']['field_meeting_minutes_pdf']['settings'] = array(
    'linked_field' => array(
      'linked' => 0,
      'destination' => '',
      'advanced' => array(
        'title' => '',
        'target' => '',
        'class' => '',
        'rel' => '',
        'text' => '',
      ),
    ),
  );
  $handler->display->display_options['defaults']['sorts'] = FALSE;
  /* Sort criterion: Content: Date -  start date (field_date) */
  $handler->display->display_options['sorts']['field_date_value']['id'] = 'field_date_value';
  $handler->display->display_options['sorts']['field_date_value']['table'] = 'field_data_field_date';
  $handler->display->display_options['sorts']['field_date_value']['field'] = 'field_date_value';
  $handler->display->display_options['sorts']['field_date_value']['order'] = 'DESC';
  $handler->display->display_options['defaults']['filter_groups'] = FALSE;
  $handler->display->display_options['defaults']['filters'] = FALSE;
  /* Filter criterion: Content: Published status */
  $handler->display->display_options['filters']['status']['id'] = 'status';
  $handler->display->display_options['filters']['status']['table'] = 'node';
  $handler->display->display_options['filters']['status']['field'] = 'status';
  $handler->display->display_options['filters']['status']['value'] = 1;
  $handler->display->display_options['filters']['status']['group'] = 1;
  $handler->display->display_options['filters']['status']['expose']['operator'] = FALSE;
  /* Filter criterion: Content: Type */
  $handler->display->display_options['filters']['type']['id'] = 'type';
  $handler->display->display_options['filters']['type']['table'] = 'node';
  $handler->display->display_options['filters']['type']['field'] = 'type';
  $handler->display->display_options['filters']['type']['value'] = array(
    'meeting' => 'meeting',
  );
  /* Filter criterion: Content: Date -  start date (field_date) */
  $handler->display->display_options['filters']['field_date_value_1']['id'] = 'field_date_value_1';
  $handler->display->display_options['filters']['field_date_value_1']['table'] = 'field_data_field_date';
  $handler->display->display_options['filters']['field_date_value_1']['field'] = 'field_date_value';
  $handler->display->display_options['filters']['field_date_value_1']['operator'] = '<=';
  $handler->display->display_options['filters']['field_date_value_1']['default_date'] = 'now';
  /* Filter criterion: Content: Meeting Type (field_meeting_type) */
  $handler->display->display_options['filters']['field_meeting_type_tid']['id'] = 'field_meeting_type_tid';
  $handler->display->display_options['filters']['field_meeting_type_tid']['table'] = 'field_data_field_meeting_type';
  $handler->display->display_options['filters']['field_meeting_type_tid']['field'] = 'field_meeting_type_tid';
  $handler->display->display_options['filters']['field_meeting_type_tid']['value'] = array(
    2167 => '2167',
  );
  $handler->display->display_options['filters']['field_meeting_type_tid']['type'] = 'select';
  $handler->display->display_options['filters']['field_meeting_type_tid']['vocabulary'] = 'meeting_type';
  $handler->display->display_options['block_description'] = 'Meetings - Past - Parcel Tax';

  /* Display: Block */
  $handler = $view->new_display('block', 'Block', 'block_10');
  $handler->display->display_options['defaults']['title'] = FALSE;
  $handler->display->display_options['title'] = 'Meetings - Past - Journey Home Task Force';
  $handler->display->display_options['defaults']['pager'] = FALSE;
  $handler->display->display_options['pager']['type'] = 'full';
  $handler->display->display_options['pager']['options']['items_per_page'] = '10';
  $handler->display->display_options['pager']['options']['offset'] = '0';
  $handler->display->display_options['pager']['options']['id'] = '0';
  $handler->display->display_options['pager']['options']['quantity'] = '9';
  $handler->display->display_options['defaults']['style_plugin'] = FALSE;
  $handler->display->display_options['style_plugin'] = 'table';
  $handler->display->display_options['style_options']['columns'] = array(
    'field_meeting_type' => 'field_meeting_type',
    'field_date' => 'field_date',
    'field_meeting_address' => 'field_meeting_address',
    'field_meeting_location' => 'field_meeting_location',
    'field_meeting_agenda_html' => 'field_meeting_agenda_html',
    'field_meeting_agenda_pdf' => 'field_meeting_agenda_pdf',
    'nothing' => 'nothing',
    'field_meeting_minutes_pdf' => 'field_meeting_minutes_pdf',
  );
  $handler->display->display_options['style_options']['default'] = '-1';
  $handler->display->display_options['style_options']['info'] = array(
    'field_meeting_type' => array(
      'sortable' => 0,
      'default_sort_order' => 'asc',
      'align' => '',
      'separator' => '',
      'empty_column' => 0,
    ),
    'field_date' => array(
      'align' => '',
      'separator' => '',
      'empty_column' => 0,
    ),
    'field_meeting_address' => array(
      'sortable' => 0,
      'default_sort_order' => 'asc',
      'align' => '',
      'separator' => '',
      'empty_column' => 0,
    ),
    'field_meeting_location' => array(
      'sortable' => 0,
      'default_sort_order' => 'asc',
      'align' => '',
      'separator' => '',
      'empty_column' => 0,
    ),
    'field_meeting_agenda_html' => array(
      'sortable' => 0,
      'default_sort_order' => 'asc',
      'align' => '',
      'separator' => '',
      'empty_column' => 0,
    ),
    'field_meeting_agenda_pdf' => array(
      'sortable' => 0,
      'default_sort_order' => 'asc',
      'align' => '',
      'separator' => '',
      'empty_column' => 0,
    ),
    'nothing' => array(
      'align' => '',
      'separator' => '',
      'empty_column' => 0,
    ),
    'field_meeting_minutes_pdf' => array(
      'sortable' => 0,
      'default_sort_order' => 'asc',
      'align' => '',
      'separator' => '',
      'empty_column' => 0,
    ),
  );
  $handler->display->display_options['defaults']['style_options'] = FALSE;
  $handler->display->display_options['defaults']['row_plugin'] = FALSE;
  $handler->display->display_options['defaults']['row_options'] = FALSE;
  $handler->display->display_options['defaults']['footer'] = FALSE;
  $handler->display->display_options['defaults']['empty'] = FALSE;
  /* No results behavior: Global: Text area */
  $handler->display->display_options['empty']['area']['id'] = 'area';
  $handler->display->display_options['empty']['area']['table'] = 'views';
  $handler->display->display_options['empty']['area']['field'] = 'area';
  $handler->display->display_options['empty']['area']['empty'] = TRUE;
  $handler->display->display_options['empty']['area']['content'] = 'There are currently no past meetings for this committee.';
  $handler->display->display_options['empty']['area']['format'] = 'full_html';
  $handler->display->display_options['defaults']['fields'] = FALSE;
  /* Field: Content: Meeting Type */
  $handler->display->display_options['fields']['field_meeting_type']['id'] = 'field_meeting_type';
  $handler->display->display_options['fields']['field_meeting_type']['table'] = 'field_data_field_meeting_type';
  $handler->display->display_options['fields']['field_meeting_type']['field'] = 'field_meeting_type';
  $handler->display->display_options['fields']['field_meeting_type']['label'] = '';
  $handler->display->display_options['fields']['field_meeting_type']['exclude'] = TRUE;
  $handler->display->display_options['fields']['field_meeting_type']['element_label_colon'] = FALSE;
  $handler->display->display_options['fields']['field_meeting_type']['type'] = 'taxonomy_term_reference_plain';
  $handler->display->display_options['fields']['field_meeting_type']['settings'] = array(
    'linked_field' => array(
      'linked' => 0,
      'destination' => '',
      'advanced' => array(
        'title' => '',
        'target' => '',
        'class' => '',
        'rel' => '',
        'text' => '',
      ),
    ),
  );
  /* Field: Content: Title */
  $handler->display->display_options['fields']['title']['id'] = 'title';
  $handler->display->display_options['fields']['title']['table'] = 'node';
  $handler->display->display_options['fields']['title']['field'] = 'title';
  $handler->display->display_options['fields']['title']['label'] = 'Meeting';
  $handler->display->display_options['fields']['title']['element_label_colon'] = FALSE;
  $handler->display->display_options['fields']['title']['link_to_node'] = FALSE;
  /* Field: Content: Date */
  $handler->display->display_options['fields']['field_date']['id'] = 'field_date';
  $handler->display->display_options['fields']['field_date']['table'] = 'field_data_field_date';
  $handler->display->display_options['fields']['field_date']['field'] = 'field_date';
  $handler->display->display_options['fields']['field_date']['element_label_colon'] = FALSE;
  $handler->display->display_options['fields']['field_date']['settings'] = array(
    'format_type' => 'month_day_year_time',
    'fromto' => 'value',
    'multiple_number' => '',
    'multiple_from' => '',
    'multiple_to' => '',
    'show_remaining_days' => 0,
    'show_repeat_rule' => 'show',
    'linked_field' => array(
      'linked' => 0,
      'destination' => '',
      'advanced' => array(
        'title' => '',
        'target' => '',
        'class' => '',
        'rel' => '',
        'text' => '',
      ),
    ),
  );
  $handler->display->display_options['fields']['field_date']['delta_offset'] = '0';
  /* Field: Content: Meeting Address */
  $handler->display->display_options['fields']['field_meeting_address']['id'] = 'field_meeting_address';
  $handler->display->display_options['fields']['field_meeting_address']['table'] = 'field_data_field_meeting_address';
  $handler->display->display_options['fields']['field_meeting_address']['field'] = 'field_meeting_address';
  $handler->display->display_options['fields']['field_meeting_address']['label'] = '';
  $handler->display->display_options['fields']['field_meeting_address']['exclude'] = TRUE;
  $handler->display->display_options['fields']['field_meeting_address']['element_label_colon'] = FALSE;
  $handler->display->display_options['fields']['field_meeting_address']['type'] = 'text_plain';
  $handler->display->display_options['fields']['field_meeting_address']['settings'] = array(
    'linked_field' => array(
      'linked' => 0,
      'destination' => '',
      'advanced' => array(
        'title' => '',
        'target' => '',
        'class' => '',
        'rel' => '',
        'text' => '',
      ),
    ),
  );
  /* Field: Content: Meeting Location */
  $handler->display->display_options['fields']['field_meeting_location']['id'] = 'field_meeting_location';
  $handler->display->display_options['fields']['field_meeting_location']['table'] = 'field_data_field_meeting_location';
  $handler->display->display_options['fields']['field_meeting_location']['field'] = 'field_meeting_location';
  $handler->display->display_options['fields']['field_meeting_location']['label'] = 'Location';
  $handler->display->display_options['fields']['field_meeting_location']['alter']['alter_text'] = TRUE;
  $handler->display->display_options['fields']['field_meeting_location']['alter']['text'] = '[field_meeting_location]<br>
[field_meeting_address]
';
  $handler->display->display_options['fields']['field_meeting_location']['element_label_colon'] = FALSE;
  $handler->display->display_options['fields']['field_meeting_location']['type'] = 'text_plain';
  $handler->display->display_options['fields']['field_meeting_location']['settings'] = array(
    'linked_field' => array(
      'linked' => 0,
      'destination' => '',
      'advanced' => array(
        'title' => '',
        'target' => '',
        'class' => '',
        'rel' => '',
        'text' => '',
      ),
    ),
  );
  /* Field: Content: Meeting Agenda HTML */
  $handler->display->display_options['fields']['field_meeting_agenda_html']['id'] = 'field_meeting_agenda_html';
  $handler->display->display_options['fields']['field_meeting_agenda_html']['table'] = 'field_data_field_meeting_agenda_html';
  $handler->display->display_options['fields']['field_meeting_agenda_html']['field'] = 'field_meeting_agenda_html';
  $handler->display->display_options['fields']['field_meeting_agenda_html']['label'] = '';
  $handler->display->display_options['fields']['field_meeting_agenda_html']['exclude'] = TRUE;
  $handler->display->display_options['fields']['field_meeting_agenda_html']['alter']['alter_text'] = TRUE;
  $handler->display->display_options['fields']['field_meeting_agenda_html']['alter']['text'] = '<a href="[field_meeting_agenda_html]" target="_blank">HTML</a>';
  $handler->display->display_options['fields']['field_meeting_agenda_html']['element_label_colon'] = FALSE;
  $handler->display->display_options['fields']['field_meeting_agenda_html']['settings'] = array(
    'linked_field' => array(
      'linked' => 0,
      'destination' => '',
      'advanced' => array(
        'title' => '',
        'target' => '',
        'class' => '',
        'rel' => '',
        'text' => '',
      ),
    ),
  );
  /* Field: Content: Meeting Agenda PDF */
  $handler->display->display_options['fields']['field_meeting_agenda_pdf']['id'] = 'field_meeting_agenda_pdf';
  $handler->display->display_options['fields']['field_meeting_agenda_pdf']['table'] = 'field_data_field_meeting_agenda_pdf';
  $handler->display->display_options['fields']['field_meeting_agenda_pdf']['field'] = 'field_meeting_agenda_pdf';
  $handler->display->display_options['fields']['field_meeting_agenda_pdf']['label'] = '';
  $handler->display->display_options['fields']['field_meeting_agenda_pdf']['exclude'] = TRUE;
  $handler->display->display_options['fields']['field_meeting_agenda_pdf']['alter']['alter_text'] = TRUE;
  $handler->display->display_options['fields']['field_meeting_agenda_pdf']['alter']['text'] = '<a href="[field_meeting_agenda_pdf]" target="_blank">PDF</a>';
  $handler->display->display_options['fields']['field_meeting_agenda_pdf']['element_label_colon'] = FALSE;
  $handler->display->display_options['fields']['field_meeting_agenda_pdf']['settings'] = array(
    'linked_field' => array(
      'linked' => 0,
      'destination' => '',
      'advanced' => array(
        'title' => '',
        'target' => '',
        'class' => '',
        'rel' => '',
        'text' => '',
      ),
    ),
  );
  /* Field: Global: Custom text */
  $handler->display->display_options['fields']['nothing']['id'] = 'nothing';
  $handler->display->display_options['fields']['nothing']['table'] = 'views';
  $handler->display->display_options['fields']['nothing']['field'] = 'nothing';
  $handler->display->display_options['fields']['nothing']['label'] = 'Agenda';
  $handler->display->display_options['fields']['nothing']['alter']['text'] = '[field_meeting_agenda_html] | [field_meeting_agenda_pdf]';
  $handler->display->display_options['fields']['nothing']['element_label_colon'] = FALSE;
  /* Field: Content: Meeting Minutes PDF */
  $handler->display->display_options['fields']['field_meeting_minutes_pdf']['id'] = 'field_meeting_minutes_pdf';
  $handler->display->display_options['fields']['field_meeting_minutes_pdf']['table'] = 'field_data_field_meeting_minutes_pdf';
  $handler->display->display_options['fields']['field_meeting_minutes_pdf']['field'] = 'field_meeting_minutes_pdf';
  $handler->display->display_options['fields']['field_meeting_minutes_pdf']['label'] = 'Minutes';
  $handler->display->display_options['fields']['field_meeting_minutes_pdf']['alter']['alter_text'] = TRUE;
  $handler->display->display_options['fields']['field_meeting_minutes_pdf']['alter']['text'] = '<a href="[field_meeting_minutes_pdf]" target="_blank">PDF</a>';
  $handler->display->display_options['fields']['field_meeting_minutes_pdf']['element_label_colon'] = FALSE;
  $handler->display->display_options['fields']['field_meeting_minutes_pdf']['settings'] = array(
    'linked_field' => array(
      'linked' => 0,
      'destination' => '',
      'advanced' => array(
        'title' => '',
        'target' => '',
        'class' => '',
        'rel' => '',
        'text' => '',
      ),
    ),
  );
  $handler->display->display_options['defaults']['sorts'] = FALSE;
  /* Sort criterion: Content: Date -  start date (field_date) */
  $handler->display->display_options['sorts']['field_date_value']['id'] = 'field_date_value';
  $handler->display->display_options['sorts']['field_date_value']['table'] = 'field_data_field_date';
  $handler->display->display_options['sorts']['field_date_value']['field'] = 'field_date_value';
  $handler->display->display_options['sorts']['field_date_value']['order'] = 'DESC';
  $handler->display->display_options['defaults']['filter_groups'] = FALSE;
  $handler->display->display_options['defaults']['filters'] = FALSE;
  /* Filter criterion: Content: Published status */
  $handler->display->display_options['filters']['status']['id'] = 'status';
  $handler->display->display_options['filters']['status']['table'] = 'node';
  $handler->display->display_options['filters']['status']['field'] = 'status';
  $handler->display->display_options['filters']['status']['value'] = 1;
  $handler->display->display_options['filters']['status']['group'] = 1;
  $handler->display->display_options['filters']['status']['expose']['operator'] = FALSE;
  /* Filter criterion: Content: Type */
  $handler->display->display_options['filters']['type']['id'] = 'type';
  $handler->display->display_options['filters']['type']['table'] = 'node';
  $handler->display->display_options['filters']['type']['field'] = 'type';
  $handler->display->display_options['filters']['type']['value'] = array(
    'meeting' => 'meeting',
  );
  /* Filter criterion: Content: Date -  start date (field_date) */
  $handler->display->display_options['filters']['field_date_value_1']['id'] = 'field_date_value_1';
  $handler->display->display_options['filters']['field_date_value_1']['table'] = 'field_data_field_date';
  $handler->display->display_options['filters']['field_date_value_1']['field'] = 'field_date_value';
  $handler->display->display_options['filters']['field_date_value_1']['operator'] = '<=';
  $handler->display->display_options['filters']['field_date_value_1']['default_date'] = 'now';
  /* Filter criterion: Content: Meeting Type (field_meeting_type) */
  $handler->display->display_options['filters']['field_meeting_type_tid']['id'] = 'field_meeting_type_tid';
  $handler->display->display_options['filters']['field_meeting_type_tid']['table'] = 'field_data_field_meeting_type';
  $handler->display->display_options['filters']['field_meeting_type_tid']['field'] = 'field_meeting_type_tid';
  $handler->display->display_options['filters']['field_meeting_type_tid']['value'] = array(
    2336 => '2336',
  );
  $handler->display->display_options['filters']['field_meeting_type_tid']['type'] = 'select';
  $handler->display->display_options['filters']['field_meeting_type_tid']['vocabulary'] = 'meeting_type';
  $handler->display->display_options['block_description'] = 'Meetings - Past - Journey Home Task Force';

  /* Display: Block */
  $handler = $view->new_display('block', 'Block', 'block_18');
  $handler->display->display_options['defaults']['title'] = FALSE;
  $handler->display->display_options['title'] = 'Meetings - Upcoming - Journey Home Task Force';
  $handler->display->display_options['defaults']['pager'] = FALSE;
  $handler->display->display_options['pager']['type'] = 'some';
  $handler->display->display_options['pager']['options']['items_per_page'] = '10';
  $handler->display->display_options['defaults']['style_plugin'] = FALSE;
  $handler->display->display_options['style_plugin'] = 'table';
  $handler->display->display_options['style_options']['columns'] = array(
    'title' => 'title',
    'field_date' => 'field_date',
    'field_meeting_location' => 'field_meeting_location',
  );
  $handler->display->display_options['style_options']['default'] = '-1';
  $handler->display->display_options['style_options']['info'] = array(
    'title' => array(
      'sortable' => 0,
      'default_sort_order' => 'asc',
      'align' => '',
      'separator' => '',
      'empty_column' => 0,
    ),
    'field_date' => array(
      'align' => '',
      'separator' => '',
      'empty_column' => 0,
    ),
    'field_meeting_location' => array(
      'sortable' => 0,
      'default_sort_order' => 'asc',
      'align' => '',
      'separator' => '',
      'empty_column' => 0,
    ),
  );
  $handler->display->display_options['defaults']['style_options'] = FALSE;
  $handler->display->display_options['defaults']['row_plugin'] = FALSE;
  $handler->display->display_options['defaults']['row_options'] = FALSE;
  $handler->display->display_options['defaults']['footer'] = FALSE;
  $handler->display->display_options['defaults']['empty'] = FALSE;
  /* No results behavior: Global: Text area */
  $handler->display->display_options['empty']['area']['id'] = 'area';
  $handler->display->display_options['empty']['area']['table'] = 'views';
  $handler->display->display_options['empty']['area']['field'] = 'area';
  $handler->display->display_options['empty']['area']['empty'] = TRUE;
  $handler->display->display_options['empty']['area']['content'] = '<p>There are no upcoming meetings posted at this time. Please check back or subscribe to our <a href="/rss/meetings.xml">RSS feed</a> for notification.</p>';
  $handler->display->display_options['empty']['area']['format'] = 'full_html';
  $handler->display->display_options['defaults']['fields'] = FALSE;
  /* Field: Content: Title */
  $handler->display->display_options['fields']['title']['id'] = 'title';
  $handler->display->display_options['fields']['title']['table'] = 'node';
  $handler->display->display_options['fields']['title']['field'] = 'title';
  $handler->display->display_options['fields']['title']['label'] = 'Meeting';
  $handler->display->display_options['fields']['title']['alter']['word_boundary'] = FALSE;
  $handler->display->display_options['fields']['title']['alter']['ellipsis'] = FALSE;
  $handler->display->display_options['fields']['title']['element_label_colon'] = FALSE;
  $handler->display->display_options['fields']['title']['link_to_node'] = FALSE;
  /* Field: Content: Date */
  $handler->display->display_options['fields']['field_date']['id'] = 'field_date';
  $handler->display->display_options['fields']['field_date']['table'] = 'field_data_field_date';
  $handler->display->display_options['fields']['field_date']['field'] = 'field_date';
  $handler->display->display_options['fields']['field_date']['element_label_colon'] = FALSE;
  $handler->display->display_options['fields']['field_date']['settings'] = array(
    'format_type' => 'month_day_year_time',
    'fromto' => 'both',
    'multiple_number' => '',
    'multiple_from' => '',
    'multiple_to' => '',
    'show_remaining_days' => 0,
    'show_repeat_rule' => 'show',
    'linked_field' => array(
      'linked' => 0,
      'destination' => '',
      'advanced' => array(
        'title' => '',
        'target' => '',
        'class' => '',
        'rel' => '',
        'text' => '',
      ),
    ),
  );
  $handler->display->display_options['fields']['field_date']['delta_offset'] = '0';
  /* Field: Content: Meeting Address */
  $handler->display->display_options['fields']['field_meeting_address']['id'] = 'field_meeting_address';
  $handler->display->display_options['fields']['field_meeting_address']['table'] = 'field_data_field_meeting_address';
  $handler->display->display_options['fields']['field_meeting_address']['field'] = 'field_meeting_address';
  $handler->display->display_options['fields']['field_meeting_address']['label'] = '';
  $handler->display->display_options['fields']['field_meeting_address']['exclude'] = TRUE;
  $handler->display->display_options['fields']['field_meeting_address']['element_label_colon'] = FALSE;
  $handler->display->display_options['fields']['field_meeting_address']['type'] = 'text_plain';
  $handler->display->display_options['fields']['field_meeting_address']['settings'] = array(
    'linked_field' => array(
      'linked' => 0,
      'destination' => '',
      'advanced' => array(
        'title' => '',
        'target' => '',
        'class' => '',
        'rel' => '',
        'text' => '',
      ),
    ),
  );
  /* Field: Content: Meeting Location */
  $handler->display->display_options['fields']['field_meeting_location']['id'] = 'field_meeting_location';
  $handler->display->display_options['fields']['field_meeting_location']['table'] = 'field_data_field_meeting_location';
  $handler->display->display_options['fields']['field_meeting_location']['field'] = 'field_meeting_location';
  $handler->display->display_options['fields']['field_meeting_location']['label'] = 'Location';
  $handler->display->display_options['fields']['field_meeting_location']['alter']['alter_text'] = TRUE;
  $handler->display->display_options['fields']['field_meeting_location']['alter']['text'] = '[field_meeting_location]<br>
[field_meeting_address]';
  $handler->display->display_options['fields']['field_meeting_location']['element_label_colon'] = FALSE;
  $handler->display->display_options['fields']['field_meeting_location']['settings'] = array(
    'linked_field' => array(
      'linked' => 0,
      'destination' => '',
      'advanced' => array(
        'title' => '',
        'target' => '',
        'class' => '',
        'rel' => '',
        'text' => '',
      ),
    ),
  );
  /* Field: Content: Meeting Agenda HTML */
  $handler->display->display_options['fields']['field_meeting_agenda_html']['id'] = 'field_meeting_agenda_html';
  $handler->display->display_options['fields']['field_meeting_agenda_html']['table'] = 'field_data_field_meeting_agenda_html';
  $handler->display->display_options['fields']['field_meeting_agenda_html']['field'] = 'field_meeting_agenda_html';
  $handler->display->display_options['fields']['field_meeting_agenda_html']['label'] = '';
  $handler->display->display_options['fields']['field_meeting_agenda_html']['exclude'] = TRUE;
  $handler->display->display_options['fields']['field_meeting_agenda_html']['alter']['alter_text'] = TRUE;
  $handler->display->display_options['fields']['field_meeting_agenda_html']['alter']['text'] = '<a href="[field_meeting_agenda_html]" target="_blank">HTML</a>';
  $handler->display->display_options['fields']['field_meeting_agenda_html']['element_label_colon'] = FALSE;
  $handler->display->display_options['fields']['field_meeting_agenda_html']['settings'] = array(
    'linked_field' => array(
      'linked' => 0,
      'destination' => '',
      'advanced' => array(
        'title' => '',
        'target' => '',
        'class' => '',
        'rel' => '',
        'text' => '',
      ),
    ),
  );
  /* Field: Content: Meeting Agenda PDF */
  $handler->display->display_options['fields']['field_meeting_agenda_pdf']['id'] = 'field_meeting_agenda_pdf';
  $handler->display->display_options['fields']['field_meeting_agenda_pdf']['table'] = 'field_data_field_meeting_agenda_pdf';
  $handler->display->display_options['fields']['field_meeting_agenda_pdf']['field'] = 'field_meeting_agenda_pdf';
  $handler->display->display_options['fields']['field_meeting_agenda_pdf']['label'] = '';
  $handler->display->display_options['fields']['field_meeting_agenda_pdf']['exclude'] = TRUE;
  $handler->display->display_options['fields']['field_meeting_agenda_pdf']['alter']['alter_text'] = TRUE;
  $handler->display->display_options['fields']['field_meeting_agenda_pdf']['alter']['text'] = '<a href="[field_meeting_agenda_pdf]" target="_blank">PDF</a>';
  $handler->display->display_options['fields']['field_meeting_agenda_pdf']['element_label_colon'] = FALSE;
  $handler->display->display_options['fields']['field_meeting_agenda_pdf']['settings'] = array(
    'linked_field' => array(
      'linked' => 0,
      'destination' => '',
      'advanced' => array(
        'title' => '',
        'target' => '',
        'class' => '',
        'rel' => '',
        'text' => '',
      ),
    ),
  );
  /* Field: Global: Custom text */
  $handler->display->display_options['fields']['nothing']['id'] = 'nothing';
  $handler->display->display_options['fields']['nothing']['table'] = 'views';
  $handler->display->display_options['fields']['nothing']['field'] = 'nothing';
  $handler->display->display_options['fields']['nothing']['label'] = 'Agenda';
  $handler->display->display_options['fields']['nothing']['alter']['text'] = '[field_meeting_agenda_html] | [field_meeting_agenda_pdf]';
  $handler->display->display_options['fields']['nothing']['element_label_colon'] = FALSE;
  $handler->display->display_options['defaults']['sorts'] = FALSE;
  /* Sort criterion: Content: Date -  start date (field_date) */
  $handler->display->display_options['sorts']['field_date_value']['id'] = 'field_date_value';
  $handler->display->display_options['sorts']['field_date_value']['table'] = 'field_data_field_date';
  $handler->display->display_options['sorts']['field_date_value']['field'] = 'field_date_value';
  $handler->display->display_options['defaults']['filter_groups'] = FALSE;
  $handler->display->display_options['defaults']['filters'] = FALSE;
  /* Filter criterion: Content: Published status */
  $handler->display->display_options['filters']['status']['id'] = 'status';
  $handler->display->display_options['filters']['status']['table'] = 'node';
  $handler->display->display_options['filters']['status']['field'] = 'status';
  $handler->display->display_options['filters']['status']['value'] = 1;
  $handler->display->display_options['filters']['status']['group'] = 1;
  $handler->display->display_options['filters']['status']['expose']['operator'] = FALSE;
  /* Filter criterion: Content: Type */
  $handler->display->display_options['filters']['type']['id'] = 'type';
  $handler->display->display_options['filters']['type']['table'] = 'node';
  $handler->display->display_options['filters']['type']['field'] = 'type';
  $handler->display->display_options['filters']['type']['value'] = array(
    'meeting' => 'meeting',
  );
  /* Filter criterion: Content: Date -  start date (field_date) */
  $handler->display->display_options['filters']['field_date_value']['id'] = 'field_date_value';
  $handler->display->display_options['filters']['field_date_value']['table'] = 'field_data_field_date';
  $handler->display->display_options['filters']['field_date_value']['field'] = 'field_date_value';
  $handler->display->display_options['filters']['field_date_value']['operator'] = '>=';
  $handler->display->display_options['filters']['field_date_value']['default_date'] = 'now';
  /* Filter criterion: Content: Meeting Type (field_meeting_type) */
  $handler->display->display_options['filters']['field_meeting_type_tid']['id'] = 'field_meeting_type_tid';
  $handler->display->display_options['filters']['field_meeting_type_tid']['table'] = 'field_data_field_meeting_type';
  $handler->display->display_options['filters']['field_meeting_type_tid']['field'] = 'field_meeting_type_tid';
  $handler->display->display_options['filters']['field_meeting_type_tid']['value'] = array(
    2336 => '2336',
  );
  $handler->display->display_options['filters']['field_meeting_type_tid']['type'] = 'select';
  $handler->display->display_options['filters']['field_meeting_type_tid']['vocabulary'] = 'meeting_type';
  $handler->display->display_options['block_description'] = 'Meetings - Upcoming - Journey Home Task Force';

  /* Display: Meetings - Archived */
  $handler = $view->new_display('block', 'Meetings - Archived', 'block_19');
  $handler->display->display_options['defaults']['title'] = FALSE;
  $handler->display->display_options['title'] = 'Meetings - Archived';
  $handler->display->display_options['defaults']['pager'] = FALSE;
  $handler->display->display_options['pager']['type'] = 'none';
  $handler->display->display_options['pager']['options']['offset'] = '0';
  $handler->display->display_options['defaults']['style_plugin'] = FALSE;
  $handler->display->display_options['style_plugin'] = 'table';
  $handler->display->display_options['style_options']['grouping'] = array(
    0 => array(
      'field' => 'field_date_1',
      'rendered' => 1,
      'rendered_strip' => 0,
    ),
    1 => array(
      'field' => 'field_meeting_type',
      'rendered' => 1,
      'rendered_strip' => 0,
    ),
  );
  $handler->display->display_options['style_options']['columns'] = array(
    'field_meeting_type' => 'field_meeting_type',
    'field_date' => 'field_date',
    'field_meeting_address' => 'field_meeting_address',
    'field_meeting_location' => 'field_meeting_location',
    'field_meeting_agenda_html' => 'field_meeting_agenda_html',
    'field_meeting_agenda_pdf' => 'field_meeting_agenda_pdf',
    'nothing' => 'nothing',
    'field_meeting_minutes_pdf' => 'field_meeting_minutes_pdf',
    'field_date_1' => 'field_date_1',
  );
  $handler->display->display_options['style_options']['class'] = '';
  $handler->display->display_options['style_options']['default'] = '-1';
  $handler->display->display_options['style_options']['info'] = array(
    'field_meeting_type' => array(
      'sortable' => 0,
      'default_sort_order' => 'asc',
      'align' => '',
      'separator' => '',
      'empty_column' => 0,
    ),
    'field_date' => array(
      'align' => '',
      'separator' => '',
      'empty_column' => 0,
    ),
    'field_meeting_address' => array(
      'sortable' => 0,
      'default_sort_order' => 'asc',
      'align' => '',
      'separator' => '',
      'empty_column' => 0,
    ),
    'field_meeting_location' => array(
      'sortable' => 0,
      'default_sort_order' => 'asc',
      'align' => '',
      'separator' => '',
      'empty_column' => 0,
    ),
    'field_meeting_agenda_html' => array(
      'sortable' => 0,
      'default_sort_order' => 'asc',
      'align' => '',
      'separator' => '',
      'empty_column' => 0,
    ),
    'field_meeting_agenda_pdf' => array(
      'sortable' => 0,
      'default_sort_order' => 'asc',
      'align' => '',
      'separator' => '',
      'empty_column' => 0,
    ),
    'nothing' => array(
      'align' => '',
      'separator' => '',
      'empty_column' => 0,
    ),
    'field_meeting_minutes_pdf' => array(
      'sortable' => 0,
      'default_sort_order' => 'asc',
      'align' => '',
      'separator' => '',
      'empty_column' => 0,
    ),
    'field_date_1' => array(
      'align' => '',
      'separator' => '',
      'empty_column' => 0,
    ),
  );
  $handler->display->display_options['defaults']['style_options'] = FALSE;
  $handler->display->display_options['defaults']['row_plugin'] = FALSE;
  $handler->display->display_options['defaults']['row_options'] = FALSE;
  $handler->display->display_options['defaults']['fields'] = FALSE;
  /* Field: Content: Path */
  $handler->display->display_options['fields']['path']['id'] = 'path';
  $handler->display->display_options['fields']['path']['table'] = 'node';
  $handler->display->display_options['fields']['path']['field'] = 'path';
  $handler->display->display_options['fields']['path']['label'] = '';
  $handler->display->display_options['fields']['path']['exclude'] = TRUE;
  $handler->display->display_options['fields']['path']['element_label_colon'] = FALSE;
  /* Field: Content: Meeting Type */
  $handler->display->display_options['fields']['field_meeting_type']['id'] = 'field_meeting_type';
  $handler->display->display_options['fields']['field_meeting_type']['table'] = 'field_data_field_meeting_type';
  $handler->display->display_options['fields']['field_meeting_type']['field'] = 'field_meeting_type';
  $handler->display->display_options['fields']['field_meeting_type']['label'] = '';
  $handler->display->display_options['fields']['field_meeting_type']['exclude'] = TRUE;
  $handler->display->display_options['fields']['field_meeting_type']['element_label_colon'] = FALSE;
  $handler->display->display_options['fields']['field_meeting_type']['type'] = 'taxonomy_term_reference_plain';
  $handler->display->display_options['fields']['field_meeting_type']['settings'] = array(
    'linked_field' => array(
      'linked' => 0,
      'destination' => '',
      'advanced' => array(
        'title' => '',
        'target' => '',
        'class' => '',
        'rel' => '',
        'text' => '',
      ),
    ),
  );
  /* Field: Content: Date */
  $handler->display->display_options['fields']['field_date']['id'] = 'field_date';
  $handler->display->display_options['fields']['field_date']['table'] = 'field_data_field_date';
  $handler->display->display_options['fields']['field_date']['field'] = 'field_date';
  $handler->display->display_options['fields']['field_date']['alter']['alter_text'] = TRUE;
  $handler->display->display_options['fields']['field_date']['alter']['text'] = '<a href="[path]">[field_date] </a>';
  $handler->display->display_options['fields']['field_date']['element_label_colon'] = FALSE;
  $handler->display->display_options['fields']['field_date']['settings'] = array(
    'format_type' => 'month_day_year',
    'fromto' => 'value',
    'multiple_number' => '',
    'multiple_from' => '',
    'multiple_to' => '',
    'show_remaining_days' => 0,
    'show_repeat_rule' => 'show',
    'linked_field' => array(
      'linked' => 0,
      'destination' => '',
      'advanced' => array(
        'title' => '',
        'target' => '',
        'class' => '',
        'rel' => '',
        'text' => '',
      ),
    ),
  );
  $handler->display->display_options['fields']['field_date']['delta_offset'] = '0';
  /* Field: Content: Meeting Address */
  $handler->display->display_options['fields']['field_meeting_address']['id'] = 'field_meeting_address';
  $handler->display->display_options['fields']['field_meeting_address']['table'] = 'field_data_field_meeting_address';
  $handler->display->display_options['fields']['field_meeting_address']['field'] = 'field_meeting_address';
  $handler->display->display_options['fields']['field_meeting_address']['label'] = '';
  $handler->display->display_options['fields']['field_meeting_address']['exclude'] = TRUE;
  $handler->display->display_options['fields']['field_meeting_address']['element_label_colon'] = FALSE;
  $handler->display->display_options['fields']['field_meeting_address']['type'] = 'text_plain';
  $handler->display->display_options['fields']['field_meeting_address']['settings'] = array(
    'linked_field' => array(
      'linked' => 0,
      'destination' => '',
      'advanced' => array(
        'title' => '',
        'target' => '',
        'class' => '',
        'rel' => '',
        'text' => '',
      ),
    ),
  );
  /* Field: Content: Meeting Agenda HTML */
  $handler->display->display_options['fields']['field_meeting_agenda_html']['id'] = 'field_meeting_agenda_html';
  $handler->display->display_options['fields']['field_meeting_agenda_html']['table'] = 'field_data_field_meeting_agenda_html';
  $handler->display->display_options['fields']['field_meeting_agenda_html']['field'] = 'field_meeting_agenda_html';
  $handler->display->display_options['fields']['field_meeting_agenda_html']['label'] = '';
  $handler->display->display_options['fields']['field_meeting_agenda_html']['exclude'] = TRUE;
  $handler->display->display_options['fields']['field_meeting_agenda_html']['alter']['alter_text'] = TRUE;
  $handler->display->display_options['fields']['field_meeting_agenda_html']['alter']['text'] = '<a href="[field_meeting_agenda_html]" target="_blank">HTML</a>';
  $handler->display->display_options['fields']['field_meeting_agenda_html']['element_label_colon'] = FALSE;
  $handler->display->display_options['fields']['field_meeting_agenda_html']['settings'] = array(
    'linked_field' => array(
      'linked' => 0,
      'destination' => '',
      'advanced' => array(
        'title' => '',
        'target' => '',
        'class' => '',
        'rel' => '',
        'text' => '',
      ),
    ),
  );
  /* Field: Content: Meeting Agenda PDF */
  $handler->display->display_options['fields']['field_meeting_agenda_pdf']['id'] = 'field_meeting_agenda_pdf';
  $handler->display->display_options['fields']['field_meeting_agenda_pdf']['table'] = 'field_data_field_meeting_agenda_pdf';
  $handler->display->display_options['fields']['field_meeting_agenda_pdf']['field'] = 'field_meeting_agenda_pdf';
  $handler->display->display_options['fields']['field_meeting_agenda_pdf']['label'] = '';
  $handler->display->display_options['fields']['field_meeting_agenda_pdf']['exclude'] = TRUE;
  $handler->display->display_options['fields']['field_meeting_agenda_pdf']['alter']['alter_text'] = TRUE;
  $handler->display->display_options['fields']['field_meeting_agenda_pdf']['alter']['text'] = '<a href="[field_meeting_agenda_pdf]" target="_blank">PDF</a>';
  $handler->display->display_options['fields']['field_meeting_agenda_pdf']['element_label_colon'] = FALSE;
  $handler->display->display_options['fields']['field_meeting_agenda_pdf']['settings'] = array(
    'linked_field' => array(
      'linked' => 0,
      'destination' => '',
      'advanced' => array(
        'title' => '',
        'target' => '',
        'class' => '',
        'rel' => '',
        'text' => '',
      ),
    ),
  );
  /* Field: Global: Custom text */
  $handler->display->display_options['fields']['nothing']['id'] = 'nothing';
  $handler->display->display_options['fields']['nothing']['table'] = 'views';
  $handler->display->display_options['fields']['nothing']['field'] = 'nothing';
  $handler->display->display_options['fields']['nothing']['label'] = 'Agenda';
  $handler->display->display_options['fields']['nothing']['alter']['text'] = '[field_meeting_agenda_html] | [field_meeting_agenda_pdf]';
  $handler->display->display_options['fields']['nothing']['element_label_colon'] = FALSE;
  /* Field: Content: Meeting Minutes PDF */
  $handler->display->display_options['fields']['field_meeting_minutes_pdf']['id'] = 'field_meeting_minutes_pdf';
  $handler->display->display_options['fields']['field_meeting_minutes_pdf']['table'] = 'field_data_field_meeting_minutes_pdf';
  $handler->display->display_options['fields']['field_meeting_minutes_pdf']['field'] = 'field_meeting_minutes_pdf';
  $handler->display->display_options['fields']['field_meeting_minutes_pdf']['label'] = 'Minutes';
  $handler->display->display_options['fields']['field_meeting_minutes_pdf']['alter']['alter_text'] = TRUE;
  $handler->display->display_options['fields']['field_meeting_minutes_pdf']['alter']['text'] = '<a href="[field_meeting_minutes_pdf]" target="_blank">PDF</a>';
  $handler->display->display_options['fields']['field_meeting_minutes_pdf']['element_label_colon'] = FALSE;
  $handler->display->display_options['fields']['field_meeting_minutes_pdf']['settings'] = array(
    'linked_field' => array(
      'linked' => 0,
      'destination' => '',
      'advanced' => array(
        'title' => '',
        'target' => '',
        'class' => '',
        'rel' => '',
        'text' => '',
      ),
    ),
  );
  /* Field: Content: Date */
  $handler->display->display_options['fields']['field_date_1']['id'] = 'field_date_1';
  $handler->display->display_options['fields']['field_date_1']['table'] = 'field_data_field_date';
  $handler->display->display_options['fields']['field_date_1']['field'] = 'field_date';
  $handler->display->display_options['fields']['field_date_1']['label'] = '';
  $handler->display->display_options['fields']['field_date_1']['exclude'] = TRUE;
  $handler->display->display_options['fields']['field_date_1']['alter']['strip_tags'] = TRUE;
  $handler->display->display_options['fields']['field_date_1']['element_label_colon'] = FALSE;
  $handler->display->display_options['fields']['field_date_1']['settings'] = array(
    'format_type' => 'year',
    'fromto' => 'value',
    'multiple_number' => '',
    'multiple_from' => '',
    'multiple_to' => '',
    'show_remaining_days' => 0,
    'show_repeat_rule' => 'show',
    'linked_field' => array(
      'linked' => 0,
      'destination' => '',
      'advanced' => array(
        'title' => '',
        'target' => '',
        'class' => '',
        'rel' => '',
        'text' => '',
      ),
    ),
  );
  $handler->display->display_options['fields']['field_date_1']['delta_offset'] = '0';
  $handler->display->display_options['defaults']['sorts'] = FALSE;
  /* Sort criterion: Content: Date -  start date (field_date) */
  $handler->display->display_options['sorts']['field_date_value']['id'] = 'field_date_value';
  $handler->display->display_options['sorts']['field_date_value']['table'] = 'field_data_field_date';
  $handler->display->display_options['sorts']['field_date_value']['field'] = 'field_date_value';
  $handler->display->display_options['sorts']['field_date_value']['order'] = 'DESC';
  $handler->display->display_options['defaults']['filter_groups'] = FALSE;
  $handler->display->display_options['defaults']['filters'] = FALSE;
  /* Filter criterion: Content: Published status */
  $handler->display->display_options['filters']['status']['id'] = 'status';
  $handler->display->display_options['filters']['status']['table'] = 'node';
  $handler->display->display_options['filters']['status']['field'] = 'status';
  $handler->display->display_options['filters']['status']['value'] = 1;
  $handler->display->display_options['filters']['status']['group'] = 1;
  $handler->display->display_options['filters']['status']['expose']['operator'] = FALSE;
  /* Filter criterion: Content: Type */
  $handler->display->display_options['filters']['type']['id'] = 'type';
  $handler->display->display_options['filters']['type']['table'] = 'node';
  $handler->display->display_options['filters']['type']['field'] = 'type';
  $handler->display->display_options['filters']['type']['value'] = array(
    'meeting' => 'meeting',
  );
  $handler->display->display_options['filters']['type']['group'] = 1;
  /* Filter criterion: Content: Date -  start date (field_date) */
  $handler->display->display_options['filters']['field_date_value_1']['id'] = 'field_date_value_1';
  $handler->display->display_options['filters']['field_date_value_1']['table'] = 'field_data_field_date';
  $handler->display->display_options['filters']['field_date_value_1']['field'] = 'field_date_value';
  $handler->display->display_options['filters']['field_date_value_1']['operator'] = '<=';
  $handler->display->display_options['filters']['field_date_value_1']['group'] = 1;
  $handler->display->display_options['filters']['field_date_value_1']['default_date'] = 'now';
  /* Filter criterion: Content: Meeting Type (field_meeting_type) */
  $handler->display->display_options['filters']['field_meeting_type_tid']['id'] = 'field_meeting_type_tid';
  $handler->display->display_options['filters']['field_meeting_type_tid']['table'] = 'field_data_field_meeting_type';
  $handler->display->display_options['filters']['field_meeting_type_tid']['field'] = 'field_meeting_type_tid';
  $handler->display->display_options['filters']['field_meeting_type_tid']['value'] = array(
    1006 => '1006',
    2346 => '2346',
    1009 => '1009',
    2379 => '2379',
    1007 => '1007',
    913 => '913',
    912 => '912',
    1008 => '1008',
  );
  $handler->display->display_options['filters']['field_meeting_type_tid']['group'] = 1;
  $handler->display->display_options['filters']['field_meeting_type_tid']['type'] = 'select';
  $handler->display->display_options['filters']['field_meeting_type_tid']['vocabulary'] = 'meeting_type';
  /* Filter criterion: Content: Date -  start date (field_date) */
  $handler->display->display_options['filters']['field_date_value']['id'] = 'field_date_value';
  $handler->display->display_options['filters']['field_date_value']['table'] = 'field_data_field_date';
  $handler->display->display_options['filters']['field_date_value']['field'] = 'field_date_value';
  $handler->display->display_options['filters']['field_date_value']['operator'] = '<';
  $handler->display->display_options['filters']['field_date_value']['granularity'] = 'year';
  $handler->display->display_options['filters']['field_date_value']['default_date'] = 'now - 1 year';
  $handler->display->display_options['block_description'] = 'Meetings - Archived';
  $export['meetings'] = $view;

  return $export;
}
