<?php
/*
Plugin Name:  Pardot Cf7 Integration
Plugin URI:   https://korbyt.com/
Description:  This plugin helps to integrate contact form 7 with pardot forms
Version:      1.0
Author:       WP GN
*/


class PardotIntegration {
    public function __construct() {
        add_action( 'init' , array( $this , 'initialize' )  );
    }

    public function initialize(){
            // Enqueue plugin CSS
            add_action('wp_enqueue_scripts', array($this, 'enqueue_custom_css'));
            
             
       

            // Handle contact form submission
            add_action('wpcf7_before_send_mail', array($this, 'contactSubmission'));
    }
    

    public function enqueue_custom_css() {
        wp_enqueue_style('PardotIntegration-css', plugin_dir_url(__FILE__) . 'style.css');
    }
    
    public function capture_utm_params() {
        // Storing the params in $utm_params
        $utm_params = $_GET;

     // Check if the UTM parameter exists and is not empty
        if (isset($utm_params) && !empty($utm_params)) {
            // Add UTM parameter value to Contact Form 7 hidden field
            add_filter('wpcf7_form_hidden_fields', function ($hidden_fields) use ($utm_params) {
                $hidden_fields['utm_source'] = sanitize_text_field($utm_params['utm_source']) ?? '';
                $hidden_fields['utm_campaign'] = sanitize_text_field($utm_params['utm_campaign']) ?? '';
                $hidden_fields['utm_medium'] = sanitize_text_field($utm_params['utm_medium']) ?? '';
                $hidden_fields['utm_content'] = sanitize_text_field($utm_params['utm_content']) ?? '';
                $hidden_fields['utm_term'] = sanitize_text_field($utm_params['utm_term']) ?? '';
                return $hidden_fields;
            });
        }
    }

    public function contactSubmission() {
        try {
            // Get the submitted form data
            $submission = WPCF7_Submission::get_instance();
            $postData = $submission->get_posted_data();
            $apiUrl = '';
           if (method_exists($this, 'capture_utm_params')) {
            $this->capture_utm_params();
        }
    
            // Get the "Additional Settings" of the Contact Form 7 form
            $form = WPCF7_ContactForm::get_current();
            $additional_settings = $form->prop('additional_settings') ?? "";
    
            // Extract the API URL from the settings
            $apiUrl = sanitize_url($additional_settings);
    
            // Send the lead to the specified API URL
            if (isset($apiUrl) && !empty( $apiUrl )) {
                return $this->wp_remote_postInitialization($apiUrl, $postData);
            }
        } catch (Exception $e) {
            // Handle the exception by returning an error response
            return 'An error occurred: ' . $e->getMessage();
        }
    }

    public function wp_remote_postInitialization($apiUrl, $postData) {
        try {
            $postJson = array(
                'Email' => $postData['your-email'] ?? '',
                'First Name' => $postData['first-name'] ?? '',
                'Last Name' => $postData['last-name'] ?? '',
				'Phone' => $postData['number'] ?? '',
                'utm_source' => $postData['utm_source'] ?? '',
                'utm_medium' => $postData['utm_medium'] ?? '',
                'utm_campaign' => $postData['utm_campaign'] ?? '',
                'utm_content' => $postData['utm_content'] ?? '',
                'utm_term' => $postData['utm_term'] ?? '',
                'ft_utm_source' => $postData['utm_source'] ?? '',
                'ft_utm_medium' => $postData['utm_medium'] ?? '',
                'ft_utm_campaign' => $postData['utm_campaign'] ?? '',
                'ft_utm_content' => $postData['utm_content'] ?? '',
                'ft_utm_term' => $postData['utm_term'] ?? '',
                'lt_utm_source' => $postData['utm_source'] ?? '',
                'lt_utm_medium' => $postData['utm_medium'] ?? '',
                'lt_utm_campaign' => $postData['utm_campaign'] ?? '',
                'lt_utm_content' => $postData['utm_content'] ?? '',
                'lt_utm_term' => $postData['utm_term'] ?? ''
            );

            // Create an array for the request arguments
            $request_args = array(
                'body' => $postJson,
                'headers' => array(
                    'Content-Type' => 'application/x-www-form-urlencoded'
                )
            );

            // Make the POST request using wp_remote_post
            $response = wp_remote_post($apiUrl, $request_args);

            // Check if the request was successful
            if (is_wp_error($response)) {
                // Handle the error
                echo 'Error: ' . $response->get_error_message();
            } else {
                // Get the response body
                $apiResponse = wp_remote_retrieve_body($response);
                return $apiResponse;
            }
        } catch (Exception $e) {
            // Handle the exception
            return 'Error: ' . $e->getMessage();
        }
    }
}

// Instantiate the plugin class
$PardotIntegration = new PardotIntegration();