<?php

namespace WPFormsLocker\Migrations;

use WPForms\Migrations\UpgradeBase;

/**
 * Class Form Locker addon v2.0.0 upgrade.
 *
 * @since 2.2.0
 *
 * @noinspection PhpUnused
 */
class Upgrade200 extends UpgradeBase {

	/**
	 * Run upgrade.
	 *
	 * @since 2.2.0
	 *
	 * @return bool|null Upgrade result:
	 *                   true  - the upgrade completed successfully,
	 *                   false - in the case of failure,
	 *                   null  - upgrade started but not yet finished (background task).
	 */
	public function run() {

		if ( ! wpforms_form_locker()->email_storage->table_exists() ) {
			wpforms_form_locker()->email_storage->create_table();
		}

		// Update Password locker old options.
		$this->password_option_upgrade();

		return true;
	}

	/**
	 * Migrate Password locker option.
	 *
	 * @since 2.2.0
	 */
	private function password_option_upgrade() {

		$forms = wpforms()->form->get( '', [ 'cap' => false ] );

		if ( empty( $forms ) ) {
			return;
		}

		$password = [
			'form_locker_verification'      => 1,
			'form_locker_verification_type' => 'password',
			'form_locker_password_enable'   => '',
		];

		foreach ( $forms as $form ) {
			$form_data = wpforms_decode( $form->post_content );

			if ( empty( $form_data['settings']['form_locker_password_enable'] ) ) {
				continue;
			}

			$form_data['settings'] = array_replace_recursive( $form_data['settings'], $password );
			wpforms()->form->update( $form->ID, $form_data, [ 'cap' => false ] );
		}
	}
}
