jQuery(document).ready(function () {

  //start header fixed js
  var header = jQuery("nav.sv-bg-dark");
  jQuery(window).scroll(function () {
    var scroll = jQuery(window).scrollTop();
    if (scroll >= 220) {
      header.addClass("navbar-fixed-top");
    } else {
      header.removeClass('navbar-fixed-top');
    }
  });
  //end header fixed js
  //start sub menu child dropdwon js
  jQuery(".sv-sub-child-menu-title").click(function () {
    jQuery(this)
      .parent()
      .toggleClass("sv-sub-child-menu-dropdown-show")
      .siblings()
      .removeClass("sv-sub-child-menu-dropdown-show");
  });
  //end sub menu child dropdwon js

  //start mobile menu toggle
  jQuery(".sv-navbar-toggle").click(function () {
    jQuery(".sv-menu-wrapper").addClass("active");
    jQuery('body').addClass("body-overflow-hide");
  });

  jQuery(".sv-menu-close").click(function () {
    jQuery(".sv-menu-wrapper").removeClass("active");
    jQuery('body').removeClass("body-overflow-hide")
    jQuery(".sv-sub-navbar-links").removeClass(
      "sv-navbar-item-sub-dropdown-show"
    );
  });
  //end mobile menu toggle

  //start mobile sub-menu

  jQuery(".sv-navbar-item-dropdown").click(function () {
    jQuery(this)
      .parent()
      .toggleClass("active-show")
      .siblings()
      .removeClass("active-show");
  });

  jQuery(".sv-navbar-item-sub-dropdown").click(function () {
    jQuery(this)
      .parent()
      .toggleClass("sv-navbar-item-sub-dropdown-show")
      .siblings()
      .removeClass("sv-navbar-item-sub-dropdown-show");
  });
  jQuery(".sv-sub-child-menu-wrapper > h5").click(function () {
    jQuery(".sv-sub-navbar-links").removeClass(
      "sv-navbar-item-sub-dropdown-show"
    );
  });
  //end mobile sub-menu

  //verticle slick slider
  var titleMain = jQuery("#sv-hero-slick");
  var titleSubs = titleMain.find("slick-active");

  if (titleMain.length) {
    titleMain.slick({
      autoplay: false,
      arrows: true,
      dots: true,
      customPaging: function (slick, index) {
        return '<span> 0' + (index + 1) + '</span>';
      },
      slidesToShow: 1,
      centerPadding: "10px",
      draggable: false,
      infinite: true,
      pauseOnHover: false,
      swipe: false,
      touchMove: false,
      vertical: true,
      verticalScrolling: true,
      speed: 1500,
      autoplaySpeed: 3000,
      useTransform: true,
      cssEase: "cubic-bezier(0.645, 0.045, 0.355, 1.000)",
      adaptiveHeight: true,
      responsive: [{
        breakpoint: 991,
        settings: {
          vertical: false,
          verticalScrolling: false,
        }
      }]
    });

    // On init
    jQuery(".sv-vertical-slick-dupe").each(function (index, el) {
      jQuery("#animatedHeading").slick(
        "slickAdd",
        "<div>" + el.innerHTML + "</div>"
      );
    });

    // Manually refresh positioning of slick
    titleMain.slick("slickPlay");
  }

  //verticle slick slider

  //start fashion pick slider
  jQuery('.sv-fashion-pick-slider').slick({
    dots: true,
    infinite: true,
    speed: 300,
    slidesToShow: 2,
    slidesToScroll: 2,
    arrows: false,
    responsive: [{
      breakpoint: 800,
      settings: {
        slidesToShow: 1,
        slidesToScroll: 1,
      }
    }, ]
  });
  //end fashion pick slider
  //start Best Range slider
  jQuery('.sv-best-range-slider').slick({
    dots: true,
    infinite: true,
    arrows: false,
    speed: 300,
    slidesToShow: 4,
    slidesToScroll: 4,
    responsive: [{
        breakpoint: 1200,
        settings: {
          slidesToShow: 3,
          slidesToScroll: 3,
        }
      },
      {
        breakpoint: 768,
        settings: {
          slidesToShow: 1,
          slidesToScroll: 1,
        }
      }
    ]
  });
  jQuery(".sv-best-range-tab .nav-link").click(function () {
    jQuery('.sv-best-range-slider').slick('refresh');
  });
  //end Best Range slider

  //start slider with progress
  var $slider = jQuery('.sv-loves-warth-slider');
  var $progressBar = jQuery('.sv-loves-warth-progress');
  var $progressBarLabel = jQuery('.slider__label');

  $slider.on('beforeChange', function (event, slick, currentSlide, nextSlide) {
    var calc = ((currentSlide) / (slick.slideCount - 1)) * 100;

    $progressBar
      .css('background-size', calc + '% 100%')
      .attr('aria-valuenow', calc);

    $progressBarLabel.text(calc + '% completed');
  });

  $slider.slick({
    slidesToShow: 1,
    slidesToScroll: 1,
    speed: 400,
    nav: true
  });
  //end slider with progress

  //start categories slider
  jQuery('.sv-accessories-slider').slick({
    dots: true,
    infinite: true,
    speed: 300,
    slidesToShow: 4,
    slidesToScroll: 1,
    centerMode: true,
    arrows: false,
    responsive: [{
      breakpoint: 768,
      settings: {
        slidesToShow: 1,
        slidesToScroll: 1,
      }
    }]
  });
  //end categories slider
  //blog detail slider
  jQuery('.sv-Blog-slider').slick({
    dots: true,
    infinite: true,
    arrows: true,
    autoplay: true,
    speed: 1000,
    slidesToShow: 2,
    slidesToScroll: 2,
    responsive: [{
        breakpoint: 767,
        settings: {
          slidesToShow: 1,
          slidesToScroll: 1,
          
        }
      }
    ]
  });
  //end categories slider

  //start sample product slider
  jQuery('.sv-sample-slck-slider, .sv-testmonial').slick({
    slidesToShow: 3,
    slidesToScroll: 1,
    centerMode: true,
    arrows: true,
    dots: true,
    speed: 300,
    centerPadding: '0',
    infinite: true,
    autoplaySpeed:2000,
    autoplay: false,
    responsive: [
      {
        breakpoint: 768,
        settings: {
          slidesToShow: 1,
          slidesToScroll: 1,
        }
      }
    ]
  });
  //end sample product slider
  //start filter accordion
  jQuery('.sv-filter-heading').on('click', function () {
    jQuery(this).next().slideToggle(200);
    jQuery(this).toggleClass('open', 200);
  });

  //end filter accordion

  //start price range

  const rangeInput = document.querySelectorAll(".sv-range-input input"),
  priceInput = document.querySelectorAll(".sv-price-input input"),
  range = document.querySelector(".sv-slider .progress");
let priceGap = 1000;

priceInput.forEach((input) => {
  input.addEventListener("input", (e) => {
    let minPrice = parseInt(priceInput[0].value),
      maxPrice = parseInt(priceInput[1].value);

    if (maxPrice - minPrice >= priceGap && maxPrice <= rangeInput[1].max) {
      if (e.target.className === "input-min") {
        rangeInput[0].value = minPrice;
        range.style.left = (minPrice / rangeInput[0].max) * 100 + "%";
      } else {
        rangeInput[1].value = maxPrice;
        range.style.right = 100 - (maxPrice / rangeInput[1].max) * 100 + "%";
      }
    }
  });
});

rangeInput.forEach((input) => {
  input.addEventListener("input", (e) => {
    let minVal = parseInt(rangeInput[0].value),
      maxVal = parseInt(rangeInput[1].value);

    if (maxVal - minVal < priceGap) {
      if (e.target.className === "range-min") {
        rangeInput[0].value = maxVal - priceGap;
      } else {
        rangeInput[1].value = minVal + priceGap;
      }
    } else {
      priceInput[0].value = minVal;
      priceInput[1].value = maxVal;
      range.style.left = (minVal / rangeInput[0].max) * 100 + "%";
      range.style.right = 100 - (maxVal / rangeInput[1].max) * 100 + "%";
    }
  });
});
//end price range

//Start Filter Side
jQuery('.sv-btn-filter').click(function(){
  console.log('text');
  jQuery('.sv-product-filter').addClass('sv-filter-show');
  jQuery('body').addClass("body-overflow-hide");
});

jQuery('.sv-btn-close').click(function(){
  jQuery('.sv-product-filter').removeClass('sv-filter-show');
  jQuery('body').removeClass("body-overflow-hide");
});
//End Filter Side

//start size modal popup
var modal = document.querySelector(".sv-size-modal");
var trigger = document.querySelector(".sv-size-trigger");
var closeButton = document.querySelector(".sv-size-close");

function toggleModal() {
    modal.classList.toggle("sv-show-modal");
}

function windowOnClick(event) {
    if (event.target === modal) {
        toggleModal();
    }
}

trigger.addEventListener("click", toggleModal);
closeButton.addEventListener("click", toggleModal);
window.addEventListener("click", windowOnClick);
//end size modal popup
});

