<?php

/**
 *Template Name: Home page
 */

get_header(); 
$HomeData = get_fields(); 
$ThemeOptions = get_fields('options'); ?>
<?php $bannerData = $HomeData['slider_settings'] ?? null;
if (isset($bannerData) && is_array($bannerData)) : ?>
<!--start hero slick slider-->
<section class="sv-hero-slider-section">
    <div class="sv-vertical-slick-slider" id="sv-hero-slick">
        <?php foreach( ($bannerData ? $bannerData : array()) as $slideOption ) : ?>
        <div class="sv-vertical-slick-dupe">
            <div class="row">
                <div class="col-lg-6">
                    <div class="sv-verticle-banner-img" <?php if (!empty($slideOption['slide_image']['url'])) { ?>
                        style="background-image: url(<?php echo $slideOption['slide_image']['url'] ?>); " <?php } ?>>
                    </div>
                </div>
                <div class="col-lg-5">
                    <div class="sv-verticle-banner-content">
                        <?php if (isset($slideOption['slide_heading']) && !empty($slideOption['slide_heading'])) : ?>
                        <h2 class="sv-verticle-banner-title"><?php echo $slideOption['slide_heading']; ?></h2>
                        <?php endif; ?>
                        <?php if (isset($slideOption['slide_description']) && !empty($slideOption['slide_description'])) : ?>
                        <p class="sv-verticle-banner-des"><?php echo $slideOption['slide_description']; ?></p>
                        <?php endif; ?>
                        <?php $ctaLabel = $slideOption['button_label'] ?? null;
                    if (isset($ctaLabel) && !empty($ctaLabel)) : ?>
                        <div class="sv-verticle-banner-button">
                            <a href="<?php echo !empty($slideOption['button_link']['url']) ? $slideOption['button_link']['url'] : '#0' ?>" target="<?php echo !empty($slideOption['button_link']['target']) ? $slideOption['button_link']['target'] : '_self' ?>" aria-label="<?php echo $ctaLabel; ?>" class="sv-btn"><?php echo $ctaLabel; ?></a>
                        </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
        <?php endforeach; ?>
    </div>
</section>
<!--end hero slick slider-->
<?php endif; ?>
<?php $fashionData = $HomeData['products_repeater'] ?? null;
if (isset($fashionData) && is_array($fashionData)) : ?>
<!--start fashion picks section -->
<section class="sv-section-spacing sv-fashion-pick">
    <div class="container">
        <?php if (isset($HomeData['fashion_section_heading']) && !empty($HomeData['fashion_section_heading'])) : ?>
        <div class="sv-section-heading">
            <h2 class="text-center"><?php echo $HomeData['fashion_section_heading']; ?></h2>
        </div>
        <?php endif; ?>
        <div class="sv-fashion-pick-slider">

            <?php $featuredRep = $HomeData['products_repeater']; ?>
            <?php $fashionProdCount = count($featuredRep);
                $count = 1 ; ?>
            <?php foreach ( ($featuredRep ? $featuredRep : array()) as $featuredItem) : ?>
            <?php if ($count%2 == 1)
                {  
                    echo "<div class='sv-fashion-pick-col'>";
                } ?>

            <div class="sv-fashion-pick-card">
                <?php $ProdId = $featuredItem['select_product']->ID; 
                 $product_info = wc_get_product( $ProdId ); ?>
                <a href="<?php  echo get_permalink($ProdId); ?>" class="sv-fashion-pick-link">
                    <?php
                    $ProdImage = wp_get_attachment_image_src( get_post_thumbnail_id( $ProdId ), 'single-post-thumbnail' );
                    $product_instance = wc_get_product($ProdId);
                    ?>
                    <div class="sv-fashion-pick-img" style="background-image: url('<?php echo $ProdImage[0]; ?>');">
                        <h3><?php echo $featuredItem['select_product']->post_title; ?></h3>
                    </div>
                    <div class="fashion-pick-card-content">
                        <p><?php 
                            echo $featuredItem['select_product']->post_excerpt;
                             ?></p>
                    </div>
                </a>
            </div>
            <?php
                if ($count%2 == 0)
                {
                    echo "</div>";
                }
                $count++;
            ?>
            <?php endforeach; ?>
            <?php
            if ($count%2 != 1) echo "</div>";
            ?>

        </div>
    </div>
</section>
<!--end fashion picks section -->
<?php endif; ?>
<?php $formData = $HomeData['video_form_data'] ?? null; ?>
<?php if (isset($formData) && is_array($formData) ) : ?>
<!--start get offer form section-->
<section class="sv-get-offer-section">
    <div class="row g-0">
        <div class="col-md-6">
            <?php if (isset($formData['video']['url']) && !empty($formData['video']['url'])) : ?>
            <div class="sv-get-offer-img">
                <video width="100%" autoplay="" muted="" loop="" id="bannerVideo">
                    <source src="<?php echo $formData['video']['url']; ?>" type="video/mp4">
                </video>
            </div>
            <?php endif; ?>
        </div>
        <div class="col-md-5">
            <div class="sv-get-offer-content">
                <?php if (isset($formData['form_heading']) && !empty($formData['form_heading'])) : ?>
                <h3><?php echo $formData['form_heading']; ?></h3>
                <?php endif; ?>
                <?php if (isset($formData['form_description']) && !empty($formData['form_description'])) : ?>
                <?php echo $formData['form_description']; ?>
                <?php endif; ?>
                <?php  if (!empty($formData['form_shortcode'])): ?>
                <div class="">
                    <?php $shortcodedata = isset($formData['form_shortcode']) ? do_shortcode($formData['form_shortcode']) : ""; ?>
                    <?php echo $shortcodedata; ?>
                </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</section>
<!--end get offer form section-->
<?php endif; ?>
<?php $rangeData = $HomeData['best_range_info'] ?? null;  ?>
<?php if (isset($rangeData) && is_array($rangeData)) : ?>
<!--start best range section-->
<section class="sv-section-spacing">
    <div class="container">
        <?php if (isset($rangeData['main_heading']) && !empty($rangeData['main_heading'])) : ?>
        <div class="sv-section-heading">
            <h2 class="text-center"><?php echo $rangeData['main_heading']; ?></h2>
        </div>
        <?php endif; ?>

        <ul class="nav nav-pills sv-best-range-tab" id="pills-tab" role="tablist">

            <?php if (isset($rangeData['range_one_heading']) && !empty($rangeData['range_one_heading'])) : ?>
            <li class="nav-item" role="presentation">
                <button class="nav-link active" id="pills-newArrivals-tab" data-bs-toggle="pill"
                    data-bs-target="#pills-newArrivals" type="button" role="tab" aria-controls="pills-newArrivals"
                    aria-selected="true"><?php echo $rangeData['range_one_heading']; ?></button>
            </li>
            <?php endif; ?>
            <?php if (isset($rangeData['range_two_heading']) && !empty($rangeData['range_two_heading'])) : ?>
            <li class="nav-item" role="presentation">
                <button class="nav-link" id="pills-hotSeller-tab" data-bs-toggle="pill"
                    data-bs-target="#pills-hotSeller" type="button" role="tab" aria-controls="pills-hotSeller"
                    aria-selected="false"><?php echo $rangeData['range_two_heading']; ?></button>
            </li>
            <?php endif; ?>
            <?php if (isset($rangeData['range_three_heading']) && !empty($rangeData['range_three_heading'])) : ?>
            <li class="nav-item" role="presentation">
                <button class="nav-link" id="pills-sale-tab" data-bs-toggle="pill" data-bs-target="#pills-sale"
                    type="button" role="tab" aria-controls="pills-sale"
                    aria-selected="false"><?php echo $rangeData['range_three_heading']; ?></button>
            </li>
            <?php endif; ?>
        </ul>
        <div class="tab-content" id="pills-tabContent">
            <div class="tab-pane fade show active" id="pills-newArrivals" role="tabpanel"
                aria-labelledby="pills-newArrivals-tab" tabindex="0">
                <div class="sv-best-range-slider">
                    <?php
                    $args = array(
                        'post_type' => 'product',
                        'posts_per_page' => 8,
                        'orderby' => 'date',
                        'category__not_in'      => array('accessories'),
                        'no_found_rows' => true,
                        'tax_query'            => array(
                            array(
                                'taxonomy' => 'product_cat',
                                'field'    => 'slug', // Or 'name' or 'term_id'
                                'terms'    => array('accessories'),
                                'operator' => 'NOT IN', // Excluded
                            )
                        )
                    );
                    $loop = new WP_Query( $args );
                    if ( $loop->have_posts() ) :
                        while ( ($loop->have_posts()) ) : $loop->the_post();
                        $product_data = get_product(get_the_ID());
                        global $product;
                        ?>
                    <div class="sv-best-range-product">
                        <div class="sv-range-img-wrapper">
                            <?php
                            $ProdData = wp_get_attachment_image_src( get_post_thumbnail_id(get_the_ID() ), 'single-post-thumbnail' ); ?>
                            <a href="<?php  echo get_permalink(); ?>" class="sv-range-product-img">
                                <img src="<?php echo $ProdData[0]; ?>" alt="<?php echo the_title(); ?> Image"
                                    class="img-fluid">
                            </a>
                            <!-- <div class="sv-whistlist-icon">
                                    <button class="sv-product-btn" type="button">
                                        <img src="https://soraavi.demandtech.org/wp-content/uploads/2023/10/sv-heart-icon.svg" alt="WHistlist">
                                    </button>
                                    <button class="sv-product-btn" type="button">
                                        <img src="https://soraavi.demandtech.org/wp-content/uploads/2023/10/sv-quick-view-icon.svg" alt="Quick View">
                                    </button>
                                </div> -->
                            <a href="<?php echo $product_data->add_to_cart_url(); ?>" class="sv-btn sv-btn-white">
                                <?php if (isset($ThemeOptions['cart_icon_dark']) && !empty($ThemeOptions['cart_icon_dark'])) : ?>
                                <img src="<?php echo $ThemeOptions['cart_icon_dark']; ?>" alt="Add to Cart">
                                <?php endif; ?>
                                <?php echo __( 'Add to Cart' ); ?></a>
                        </div>
                        <div class="sv-range-content-wrapper">
                            <h5 class="sv-product-title">
                                <a href="<?php  echo get_permalink(); ?>"
                                    class="sv-product-link"><?php echo the_title(); ?></a>
                            </h5>
                            <h4>
                                <?php echo $product->get_price_html(); ?>
                            </h4>
                        </div>
                    </div>
                    <?php
                        endwhile;
                    else :
                        echo __( 'No products found' );
                    endif;
                    wp_reset_postdata();
                    ?>
                </div>
            </div>
            <div class="tab-pane fade" id="pills-hotSeller" role="tabpanel" aria-labelledby="pills-hotSeller-tab"
                tabindex="0">
                <div class="sv-best-range-slider">
                    <?php 
                    $query = new WP_Query( array(
                        'posts_per_page' => 8,
                        'post_type' => 'product',
                        'post_status' => 'publish',
                        'ignore_sticky_posts' => 1,
                        'meta_key' => 'total_sales',
                        'orderby' => 'meta_value_num',
                        'order' => 'DESC',
                        'tax_query'            => array(
                            array(
                                'taxonomy' => 'product_cat',
                                'field'    => 'slug', // Or 'name' or 'term_id'
                                'terms'    => array('accessories'),
                                'operator' => 'NOT IN', // Excluded
                            )
                        )
                    ) );
                    ?>
                    <?php 
                    if($query->have_posts()) :
                        while($query->have_posts()) : $query->the_post(); 
                        $product_data1 = get_product(get_the_ID());
                        global $product; ?>
                    <div class="sv-best-range-product">
                        <div class="sv-range-img-wrapper">
                            <?php
                            $bestSellerProdData = wp_get_attachment_image_src( get_post_thumbnail_id(get_the_ID() ), 'single-post-thumbnail' );  ?>
                            <a href="<?php  echo get_permalink(); ?>" class="sv-range-product-img">
                                <img src="<?php echo $bestSellerProdData[0]; ?>" alt="<?php echo the_title(); ?> Image"
                                    class="img-fluid">
                            </a>
                            <a href="<?php echo $product_data1->add_to_cart_url(); ?>" class="sv-btn sv-btn-white">
                                <?php if (isset($ThemeOptions['cart_icon_dark']) && !empty($ThemeOptions['cart_icon_dark'])) : ?>
                                <img src="<?php echo $ThemeOptions['cart_icon_dark']; ?>" alt="Add to Cart">
                                <?php endif; ?>
                                <?php echo __( 'Add to Cart' ); ?></a>
                        </div>
                        <div class="sv-range-content-wrapper">
                            <h5 class="sv-product-title">
                                <a href="<?php  echo get_permalink(); ?>"
                                    class="sv-product-link"><?php echo the_title(); ?></a>
                            </h5>
                            <h4>
                                <?php echo $product->get_price_html(); ?>
                            </h4>
                        </div>
                    </div>
                    <?php
                        endwhile;
                    else :
                        echo __( 'No products found' );
                    endif;
                    wp_reset_postdata();
                    ?>
                </div>
            </div>
            <div class="tab-pane fade" id="pills-sale" role="tabpanel" aria-labelledby="pills-sale-tab" tabindex="0">
                <div class="sv-best-range-slider">
                    <?php $query_args = array(
                    'posts_per_page' => 8,
                    'no_found_rows' => 1,
                    'post_status' => 'publish',
                    'post_type' => 'product',
                    'meta_query' => WC()->query->get_meta_query(),
                    'post__in' => array_merge(array(0), wc_get_product_ids_on_sale()),
                    'tax_query'            => array(
                        array(
                            'taxonomy' => 'product_cat',
                            'field'    => 'slug', // Or 'name' or 'term_id'
                            'terms'    => array('accessories'),
                            'operator' => 'NOT IN', // Excluded
                        )
                    )
                );
                $products = new WP_Query($query_args); ?>
                    <?php
                    if ($products->have_posts()) :
                        while ($products->have_posts()) : $products->the_post(); 
                        $product_data2 = get_product(get_the_ID());
                        global $product; ?>
                    <div class="sv-best-range-product">
                        <div class="sv-range-img-wrapper">
                            <?php
                            $SaleProdData = wp_get_attachment_image_src( get_post_thumbnail_id(get_the_ID() ), 'single-post-thumbnail' );  ?>
                            <a href="<?php  echo get_permalink(); ?>" class="sv-range-product-img">
                                <img src="<?php echo $SaleProdData[0]; ?>" alt="<?php echo the_title(); ?> Image"
                                    class="img-fluid">
                            </a>
                            <a href="<?php echo $product_data2->add_to_cart_url(); ?>" class="sv-btn sv-btn-white">
                                <?php if (isset($ThemeOptions['cart_icon_dark']) && !empty($ThemeOptions['cart_icon_dark'])) : ?>
                                <img src="<?php echo $ThemeOptions['cart_icon_dark']; ?>" alt="Add to Cart">
                                <?php endif; ?>
                                <?php echo __( 'Add to Cart' ); ?></a>
                        </div>
                        <div class="sv-range-content-wrapper">
                            <h5 class="sv-product-title">
                                <a href="<?php  echo get_permalink(); ?>"
                                    class="sv-product-link"><?php echo the_title(); ?></a>
                            </h5>
                            <h4>
                                <?php echo $product->get_price_html(); ?>
                            </h4>
                        </div>
                    </div>
                    <?php
                        endwhile;
                    else :
                        echo __( 'No products found' );
                    endif;
                    wp_reset_postdata(); ?>
                </div>
            </div>
        </div>
    </div>
</section>
<!--end best range section-->
<?php endif; ?>
<?php $multisliderData = $HomeData['multi-images_slider_info'] ?? null;  ?>
<?php if (isset($multisliderData) && is_array($multisliderData)) : ?>
<section class="sv-section-bottom sv-loves-warth">
    <div class="container">
        <div class="row justify-content-between align-items-center">
            <div class="col-md-6">
                <div class="">
                    <?php if (isset($multisliderData['heading']) && !empty($multisliderData['heading'])) : ?>
                    <h3><?php echo $multisliderData['heading']; ?></h3>
                    <?php endif; ?>
                    <?php if (isset($multisliderData['description']) && !empty($multisliderData['description'])) : ?>
                    <?php echo $multisliderData['description']; ?>
                    <?php endif; ?>
                </div>
            </div>
            <div class="col-md-5">
                <div class="sv-loves-warth-slider">
                    <?php $multisliderRep = $multisliderData['slider_images'];?>
                    <?php foreach(($multisliderRep ? $multisliderRep : array()) as $multiSlide ) : ?>
                    <div class="sv-loves-warth-slider-image">
                        <?php if (isset($multiSlide['slide_image']['url']) && !empty($multiSlide['slide_image']['url'])) : ?>
                        <div class="sv-loves-warth-bg"
                            style="background-image: url(<?php echo $multiSlide['slide_image']['url']; ?>);">
                        </div>
                        <?php endif; ?>
                    </div>
                    <?php endforeach; ?>
                </div>
                <?php if (isset($multisliderRep) && is_array($multisliderRep)) : ?>
                <div class="progress sv-loves-warth-progress" role="progressbar" aria-valuemin="10" aria-valuemax="100"
                    style="background-size: 10% 100%;" aria-valuenow="10">
                    <span class="slider__label sr-only"> </span>
                </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</section>
<?php endif; ?>
<!--start get offer form section-->
<?php $formData2 = $HomeData['image_form_data'] ?? null;  ?>
<?php if (isset($formData2) && is_array($formData2)) : ?>
<section class="sv-get-offer-section sv-newsletter-section">
    <div class="row g-0">
        <div class="col-md-6 sv-newsletter-bg-col">
            <?php if (isset($formData2['image']['url']) && !empty($formData2['image']['url'])) : ?>
            <div class="sv-newsletter-bg" style="background-image: url(<?php echo $formData2['image']['url']; ?>);">
            </div>
            <?php endif; ?>
        </div>
        <div class="col-md-5">
            <div class="sv-get-offer-content">
                <?php if (isset($formData2['form_heading']) && !empty($formData2['form_heading'])) : ?>
                <h3><?php echo $formData2['form_heading']; ?></h3>
                <?php endif; ?>
                <?php if (isset($formData2['form_description']) && !empty($formData2['form_description'])) : ?>
                <?php echo $formData2['form_description']; ?>
                <?php endif; ?>
                <?php  if (!empty($formData2['form_shortcode'])): ?>
                <div class="">
                    <?php $shortcodedata2 = isset($formData2['form_shortcode']) ? do_shortcode($formData2['form_shortcode']) : ""; ?>
                    <?php echo $shortcodedata2; ?>
                </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</section>
<!--end get offer form section-->
<?php endif; ?>
<?php $accessoriesData = $HomeData['accessories_info'] ?? null;  ?>
<?php if (isset($accessoriesData) && is_array($accessoriesData)) : ?>
<!--start get offer form section-->
<section class="sv-accessories-section sv-section-spacing">
    <div class="container">
        <div class="sv-section-heading">
            <?php if (isset($accessoriesData['heading']) && !empty($accessoriesData['heading'])) : ?>
            <h2 class="text-center"><?php echo $accessoriesData['heading']; ?></h2>
            <?php endif; ?>
            <?php if (isset($accessoriesData['description']) && !empty($accessoriesData['description'])) : ?>
            <p class="text-center"><?php echo $accessoriesData['description']; ?></p>
            <?php endif; ?>
        </div>
        <div class="sv-accessories-wrapper">
            <?php $accessriesRep = $accessoriesData['accessories_repeater'];?>
            <?php if (isset($accessriesRep) && is_array($accessriesRep)) : ?>
            <div class="sv-accessories-slider">
                <?php foreach(($accessriesRep ? $accessriesRep : array()) as $accessoryItem ) : ?>
                <div class="sv-accessories-col">
                    <a href="<?php echo !empty($accessoryItem['accessory_link']['url']) ? $accessoryItem['accessory_link']['url'] : '#0' ?>"
                        target="<?php echo !empty($accessoryItem['accessory_link']['target']) ? $accessoryItem['accessory_link']['target'] : '_self' ?>"
                        aria-label="<?php echo $accessoryItem['accessory_name'] ?? null; ?>"
                        class="sv-accessories-link">
                        <?php if (isset($accessoryItem['accessory_image']['url']) && !empty($accessoryItem['accessory_image']['url'])) : ?>
                        <img src="<?php echo $accessoryItem['accessory_image']['url'];?>"
                            alt="<?php echo $accessoryItem['accessory_image']['alt'];?>">
                        <?php endif; ?>
                        <?php if (isset($accessoryItem['accessory_name']) && !empty($accessoryItem['accessory_name'])) : ?>
                        <p><?php echo $accessoryItem['accessory_name']; ?></p>
                        <?php endif; ?>
                    </a>
                </div>
                <?php endforeach; ?>
            </div>
            <?php endif; ?>
        </div>
    </div>
</section>
<!--end get offer form section-->
<?php endif; ?>
<?php $smallIconData = $HomeData['small_icons_text_grid'] ?? null;
if (is_array($smallIconData) && !empty($smallIconData) && array_filter($smallIconData)) : ?>
<!-- start about meet section-->
    <?php include(get_template_directory() . '/includes/small_icons_grid.php'); ?>
<!-- End about meet section-->
<?php endif; ?>
<?php $alternateImageData = $HomeData['alternate_image_with_text'] ?? null;  ?>
<?php if (isset($alternateImageData) && is_array($alternateImageData)) : ?>
    <?php include(get_template_directory() . '/includes/alternate_image_with_text.php'); ?>
<?php endif; ?>
<?php if (isset($ThemeOptions['testimonial_heading']) && !empty($ThemeOptions['testimonial_heading'])) : ?>
<!--start Testmonial-->      
<section class="sv-testmonial-section sv-section-spacing">
    <div class="container">
        <div class="sv-section-heading sv-section-heading-line">
            <h2 class="text-center"><?php echo $ThemeOptions['testimonial_heading']; ?></h2>
        </div>
        <div class="sv-testmonial">
        <?php foreach( ($ThemeOptions['testimonial_repeater'] ? $ThemeOptions['testimonial_repeater'] : array()) as $testimonialItem ) : ?>
            <div class="sv-testmonial-card">
                <?php if (isset($testimonialItem['rating']) && !empty($testimonialItem['rating'])) : ?>
                <i data-star="<?php echo $testimonialItem['rating']; ?>"></i>
                <?php endif; ?>
                <?php if (isset($testimonialItem['testimonial_content']) && !empty($testimonialItem['testimonial_content'])) : ?>
                    <?php echo $testimonialItem['testimonial_content']; ?>
                <?php endif; ?>
                <?php if (isset($testimonialItem['client_name']) && !empty($testimonialItem['client_name'])) : ?>
                <h4><?php echo $testimonialItem['client_name']; ?></h4>
                <?php endif; ?>
            </div>
        <?php endforeach; ?>
        </div>
    </div>
</section>
<!--end Testmonial-->
<?php endif; ?>
<?php
get_footer();
?>