<?php

function enqueue_parent_styles()
{
	wp_register_style('bootstrap', get_template_directory_uri() . '/assets/css/bootstrap.min.css');
	wp_enqueue_style('bootstrap');
	wp_register_style('slick-slider', get_template_directory_uri() . '/assets/plugins/slick-slider/slick.css');
	wp_enqueue_style('slick-slider');
	wp_register_style('fonts', get_template_directory_uri() . '/assets/css/fonts.css');
	wp_enqueue_style('fonts');
	wp_register_style('style', get_template_directory_uri() . '/assets/css/style.css');
	wp_enqueue_style('style');
}
add_action('wp_enqueue_scripts', 'enqueue_parent_styles');

function load_js()
{
	wp_register_script('jquery', get_template_directory_uri() . '/assets/src/js/jquery-3.7.0.min.js', array(), 1, 1, 1);
	wp_enqueue_script('jquery');
	wp_enqueue_script('popper');
	wp_register_script('bootstrap', get_template_directory_uri() . '/assets/js/bootstrap.bundle.min.js', array(), 1, 1, 1);
	wp_enqueue_script('bootstrap');

	wp_register_script('slick-slider', get_template_directory_uri() . '/assets/plugins/slick-slider/slick.min.js', array(), 1, 1, 1);
	wp_enqueue_script('slick-slider');
	wp_register_script('custom', get_template_directory_uri() . '/assets/js/custom.js', array(), 1, 1, 1);
	wp_enqueue_script('custom');
}

add_action('wp_enqueue_scripts', 'load_js');
// To register Case studies CPT


add_theme_support('post-thumbnails');
// For displaying site logo option in customizer
function config_custom_logo()
{
	add_theme_support('custom-logo');
}
add_action('after_setup_theme', 'config_custom_logo');
//for options page
add_action('acf/init', 'my_acf_op_init');
function my_acf_op_init()
{
	// Check function exists.
	if (function_exists('acf_add_options_sub_page')) {
		// Add parent.
		$parent = acf_add_options_page(array(
			'page_title' => __('Theme General Settings'),
			'menu_title' => __('Theme Settings'),
			'menu_slug'  => __('theme-settings'),
			'redirect'   => false,
		));
	}
}

add_action( 'phpmailer_init', 'vm_phpmailer_smtp' );
function vm_phpmailer_smtp( $phpmailer ) {
    $phpmailer->isSMTP();     
    $phpmailer->Host = SMTP_server;  
    $phpmailer->SMTPAuth = SMTP_AUTH;
    $phpmailer->Port = SMTP_PORT;
    $phpmailer->Username = SMTP_username;
    $phpmailer->Password = SMTP_password;
    $phpmailer->SMTPSecure = SMTP_SECURE;
    $phpmailer->From = SMTP_FROM;
    $phpmailer->FromName = SMTP_NAME;
}

//Fx for custom menues
function wpb_custom_new_menu()
{
	register_nav_menus(
		array(
			'soraavi-menu' => __('Soraavi Header Menu')
		)
	);
}
add_action('init', 'wpb_custom_new_menu');

/** Fx to add json file in media */
function add_upload_mimes($types)
{
	$types['json'] = 'text/plain';
	return $types;
}
add_filter('upload_mimes', 'add_upload_mimes');
// Allow SVG media upload
add_filter('wp_check_filetype_and_ext', function ($data, $file, $filename, $mimes) {
	$filetype = wp_check_filetype($filename, $mimes);
	return [
		'ext'             => $filetype['ext'],
		'type'            => $filetype['type'],
		'proper_filename' => $data['proper_filename']
	];
}, 10, 4);

function cc_mime_types($mimes)
{
	$mimes['svg'] = 'image/svg+xml';
	return $mimes;
}
add_filter('upload_mimes', 'cc_mime_types');

/** Fx to call desired menu  */
function prefix_get_menu_items($menu_name)
{
	if (($locations = get_nav_menu_locations()) && isset($locations[$menu_name])) {
		$menu = wp_get_nav_menu_object($locations[$menu_name]);
		return wp_get_nav_menu_items($menu->term_id);
	}
}
//header ajax search 

add_action('wp_footer', 'ajax_fetch');
function ajax_fetch()
{ ?>
	<script type="text/javascript">
		function fetch() {
			if (document.getElementById('keyword').value.trim().length == 0) {

				jQuery('#sv-product-ajax-search').html('');

			} else {

				jQuery.ajax({
					url: '<?php echo admin_url('admin-ajax.php'); ?>',
					type: 'post',
					data: {
						action: 'data_fetch',
						keyword: jQuery('#keyword').val()
					},
					success: function(data) {
						jQuery('#sv-product-ajax-search').html(data);
					}
				});
			}
		}
	</script>
	<?php
}

add_action('wp_ajax_data_fetch', 'product_fetch');
add_action('wp_ajax_nopriv_data_fetch', 'product_fetch');
function product_fetch()
{

	$the_query = new WP_Query(array('posts_per_page' => 4, 's' => esc_attr($_POST['keyword']), 'post_type' => 'product'));

	if ($the_query->have_posts()) : ?>
		<div class="sv-search-wrapper">
			<div class="row">
				<?php while ($the_query->have_posts()) : $the_query->the_post(); 
				 global $product; ?>

					<div class="col-md-3">
						<div class="sv-product-card">
						<?php echo the_post_thumbnail('full'); ?>
							<h5><a href="<?php echo esc_url(post_permalink()); ?>"><?php the_title(); ?></a></h5>
							<h4><?php echo $product->get_price_html(); ?></h4>
						</div>
					</div>
				<?php endwhile;
				?>
				<div class="col-12">
					<a href="" class="sv-btn">View All</a>
				</div>
			</div>
		</div>
	<?php
		wp_reset_postdata();
	else : ?>
		<div class="sv-search-wrapper">
			<p>No product found</p>
		</div>

<?php endif;
	die();
}
// Fx for Header mini cart
function custom_mini_cart() {
	echo '<a href="#" class="dropdown-back" data-toggle="dropdown"> ';
	echo '<img src="http://localhost/gitlab-projects/soraavi/wp-content/uploads/2023/12/sv-cart-icon.svg" alt="Cart">';
	echo '<div class="basket-item-count" style="display: inline;">';
	echo '<span class="cart-items-count count">';
	echo WC()->cart->get_cart_contents_count();
	echo '</span>';
	echo '</div>';
	echo '</a>';
	echo '<ul class="dropdown-menu dropdown-menu-mini-cart">';
	echo '<li> <div class="widget_shopping_cart_content">';
	woocommerce_mini_cart();
	echo '</div></li></ul>';
	
	}
add_shortcode( 'quadlayers-mini-cart', 'custom_mini_cart' );
// Fx to fix WooCommerce regenerate images issue
add_filter('woocommerce_resize_images', static function() {
    return false;
});
/** Fx to modify WooCommerce get_price_html to create custom price display */
add_filter( 'woocommerce_format_sale_price', 'invert_formatted_sale_price', 10, 3 );
function invert_formatted_sale_price( $price, $regular_price, $sale_price ) {
    return '<ins>' . ( is_numeric( $sale_price ) ? wc_price( $sale_price ) : $sale_price ) . '</ins> <del>' . ( is_numeric( $regular_price ) ? wc_price( $regular_price ) : $regular_price ) . '</del>';
}
 /** Fx to override WooCommerce template files */
/* making theme woocomerce compatable */
add_action( 'after_setup_theme', 'woocommerce_support' );
function woocommerce_support() {
   add_theme_support( 'woocommerce');
} 
// adding new features to wordpress theme
function fn_theme_supports() {
	add_theme_support( 'title-tag' );
}

add_action( 'after_setup_theme', 'fn_theme_supports' );

/** Fx to update the breadcrumbs HTML */
add_filter( 'woocommerce_breadcrumb_defaults', 'custom_woocommerce_breadcrumbs' );
function custom_woocommerce_breadcrumbs() {
  return array(
    'delimiter'   => '<span class="sv-separator">|</span>',
    'wrap_before' => '<nav class="woocommerce-breadcrumb sv-woocommerce-breadcrumb">',
    'wrap_after'  => '</nav>',
    'before'      => '',
    'after'       => '',
    'home'        => _x( 'Home', 'breadcrumb', 'woocommerce' ),
  );
}


/** Code to change position priority of Product category on PDP WC */
remove_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_meta', 40 );
add_action('woocommerce_single_product_summary', 'woocommerce_template_single_meta', 5);
/** Hook to change Color Attribute Label */
add_filter( 'woocommerce_attribute_label', 'custom_attribute_label', 10, 3 );
function custom_attribute_label( $label, $name, $product ) {
    // For "pa_farge" attribute taxonomy on single product pages.
	if( $name == 'pa_size' && is_product() ) {
        $label = __('Select size', 'woocommerce');
    }
	
    return $label;
}
/** Fx to add size chart on PDP WC */
add_action( 'woocommerce_after_variations_table', 'shoptimizer_custom_author_field', 10, 0 );
  
function shoptimizer_custom_author_field() { ?>
 
<?php 
global $product;
$product_id = $product->get_id();
$product_size_chart = get_field( 'required_size_chart' );
if($product_size_chart != 'none' ) : ?>
	<button id="sizeChart-button"  class="sv-size-trigger">Size Chart</button>

	<!-- Modal -->
	<?php //if(get_field('required_size_chart') ) : ?>
		<div id="sizing-chart" class="show-cm sv-size-modal">
			<div class="modal-content">
				<span class="sv-size-close">×</span>
				<h3>SIZE GUIDE</h3>
				<div class="row align-items-center">
					<div class="col-md-6">
					<?php $productSizeImg = ($product_size_chart == 'sweater' )  ? get_field('sweater_size_image', 'option') : get_field('socks_size_image', 'option'); ?>
						<div>
							<img class="img-fluid" src="<?php echo $productSizeImg['url']; ?>" alt="<?php echo $productSizeImg['alt']; ?>">
						</div>
					</div>
					<div class="col-md-6">
						<div class="toggle-measurement-group">
							<button class="toggle-measurement set-cm" data-measurement="cm">cm</button><button class="toggle-measurement set-inches" data-measurement="inches">in</button>
						</div>
					<?php //if(get_field('specification_repeater', 'option')) : 
							$specsRepeater = ($product_size_chart == 'sweater' )  ? get_field('specification_repeater', 'option') : get_field('socks_specification_repeater', 'option');  ?>
							<div class="table">
								<table>
								<thead>
									<th colspan="1"></th>
								<?php foreach( ($specsRepeater[0]['size_repeater'] ? $specsRepeater[0]['size_repeater'] : array()) as $sizeOptions ) : ?>
									<th class="measurement"><?php echo $sizeOptions['size_label'] ?? null; ?></th>
								<?php endforeach; ?>
									</tr>
								</thead>
								<tbody>
									
									<?php foreach( ($specsRepeater ? $specsRepeater : array()) as $specsOptions ) : 
										?>
									<tr>
									<td><?php echo $specsOptions['specification_label']; ?></td>
									<?php foreach( ($specsOptions['size_repeater'] ? $specsOptions['size_repeater'] : array()) as $sizeOptions ) : ?>
									<td class="measurement">
										<span class="size-cm"><?php echo $sizeOptions['size_in_cm_centimeter']; ?></span>
										<span class="size-inch"><?php echo $sizeOptions['size_in_inches']; ?></span>
									</td>
									<?php endforeach; ?>
									</tr>
									<?php endforeach; ?>
								</tbody>
								</table>
							</div>
						<?php //endif; ?>
					</div>
				</div>
			</div>
		</div>
		<script>
		jQuery('.toggle-measurement').click(function() {
			var measurements = jQuery(this).data().measurement;
			jQuery('#sizing-chart').removeClass('show-inches show-cm').addClass('show-' + measurements);
		})
		</script>
		<?php endif; ?>
		
	<!-- end modal -->
	<?php //endif; ?>
<?php 
//endif; 
}

/** Fx to Change Upsells heading text on PDP WC */
add_filter( 'gettext', 'wpd_change_up_sell_heading', 10, 3 );
function wpd_change_up_sell_heading( $translation_text, $text, $domain ) {
	if( $domain == 'woocommerce' && is_singular( 'product' ) ) {
		switch ( $translation_text ) {
			case 'You may also like&hellip;' : 
				$translation_text = 'Add Ons'; // You will enter your custom text here
				break;
		}
	}
	
	return $translation_text;
}
/** Fx to change Related Products Heading on PDP WC */
add_filter( 'woocommerce_product_related_products_heading', 'change_related_products_heading' );

function change_related_products_heading() {
	return 'Frequently Bought';
}
/** Code to change position priority of Upsells & reviews on PDP WC */
add_filter( 'woocommerce_product_tabs', 'woo_remove_product_tabs', 98 );

function woo_remove_product_tabs( $tabs )
{
    unset( $tabs['reviews'] );

    return $tabs;
}
add_action( 'woocommerce_after_single_product_summary', 'your_theme_review_replacing_reviews_position', 18 );

function your_theme_review_replacing_reviews_position()
{
  comments_template();
}
/** Code to move position of add to cart button under product thumbnail on shop page WC */
// remove_action( 'woocommerce_after_shop_loop_item', 'woocommerce_template_loop_add_to_cart', 10 );
// add_action( 'woocommerce_before_shop_loop_item_title', 'woocommerce_template_loop_add_to_cart', 20 );
/** code snippets to add plus + and minus – buttons to WooCommerce quantity input on product page */
add_action( 'woocommerce_after_add_to_cart_quantity', 'ts_quantity_plus_sign' );
 
function ts_quantity_plus_sign() {
   echo '<button type="button" class="plus" >+</button>';
}
 
add_action( 'woocommerce_before_add_to_cart_quantity', 'ts_quantity_minus_sign' );
function ts_quantity_minus_sign() {
   echo '<label class="sv-quanity-label">Quantiy:</label><button type="button" class="minus" >-</button>';
}
 
add_action( 'wp_footer', 'ts_quantity_plus_minus' );
 
function ts_quantity_plus_minus() {
   // To run this on the single product page
   if ( ! is_product() ) return;
   ?>
   <script type="text/javascript">
          
      jQuery(document).ready(function($){   
          
            $('form.cart').on( 'click', 'button.plus, button.minus', function() {
 
            // Get current quantity values
            var qty = $( this ).closest( 'form.cart' ).find( '.qty' );
            var val   = parseFloat(qty.val());
            var max = parseFloat(qty.attr( 'max' ));
            var min = parseFloat(qty.attr( 'min' ));
            var step = parseFloat(qty.attr( 'step' ));
 
            // Change the value if plus or minus
            if ( $( this ).is( '.plus' ) ) {
               if ( max && ( max <= val ) ) {
                  qty.val( max );
               } 
            else {
               qty.val( val + step );
                 }
            } 
            else {
               if ( min && ( min >= val ) ) {
                  qty.val( min );
               } 
               else if ( val > 1 ) {
                  qty.val( val - step );
               }
            }
             
         });
          
      });
          
   </script>
   <?php
}
?>