<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="<?php bloginfo('charset'); ?>">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <!-- <link rel="icon" type="image/x-icon" href="https://soraavi.demandtech.org/wp-content/uploads/2023/10/favicon.png"> -->
    <?php wp_head(); ?>
</head>
<?php
$current_page = get_queried_object();
if (!empty($current_page) && isset($current_page)) :
    $post_name = $current_page->post_name ?? null;
    if (!empty($post_name) && isset($post_name)) :
        $post_class = $current_page->post_name;
    else :
        $post_class = '';
    endif;
else :
    $post_class = '';
endif;
?>
<?php
$objID = '';
if (!empty($current_page) && is_a($current_page, 'wp_post')) {
    $objID =  $current_page->ID;
} else if (!empty($qobj) && is_category()) {
    $objID =  $current_page->term_id;
}
$HeaderOptions = get_fields('options');
$user = wp_get_current_user();
?>
<?php global $wp_query; ?>

<body <?php body_class($post_class); ?> data-attr="<?php echo $objID ?>">
    <header>
        <?php if (isset($HeaderOptions['announcement_text']) && !empty($HeaderOptions['announcement_text'])) : ?>
        <div class="sv-top-announcement-bar">
            <div class="container-fluid">
                <?php echo $HeaderOptions['announcement_text'];?>
            </div>
        </div>
        <?php endif; ?>
        <nav class="sv-bg-dark">
            <div class="sv-navbar-top">
                <div class="container-lg">
                    <div class="d-flex justify-content-between align-item-center">
                        <?php if (isset($HeaderOptions['hamburger_icon']['url']) && !empty($HeaderOptions['hamburger_icon']['url'])) : ?>
                        <button type="button" class="sv-navbar-toggle" aria-label="Toggle menu" aria-expanded="false" aria-controls="navbar-menu">
                            <img src="<?php echo $HeaderOptions['hamburger_icon']['url'];?>" alt="hamburger">
                        </button>
                        <?php endif; ?>
                        <?php if (function_exists('the_custom_logo')) {
                            the_custom_logo();
                        } ?>
                        <?php //if (isset($HeaderOptions['main_logo']) && !empty($HeaderOptions['main_logo'])) : ?>
                        <!-- <a href="sv-logo" href="<?php //echo site_url(); ?>">
                            <img src="<?php //echo $HeaderOptions['main_logo']['url'];?>" alt="SoRaavi Logo">
                        </a> -->
                        <?php //endif; ?>
                        <div class="sv-header-search">
                            <div class="sv-search-wrapper">
                                <input type="text" class="sv-search-input" placeholder="Searching..." name="keyword" id="keyword" onkeyup="fetch()"></input>
                                <?php if (isset($HeaderOptions['search_icon']) && !empty($HeaderOptions['search_icon'])) : ?>
                                <span class="sv-search-icon">
                                    <img src="<?php echo $HeaderOptions['search_icon']['url'];?>" alt="Search">
                                </span>
                                <?php endif; ?>
                            </div>
                            <div id="sv-product-ajax-search"></div>
                        </div>
                        <div class="sv-account">
                        <?php if (is_user_logged_in()) : ?>
                            <a href="<?php echo wp_logout_url(home_url()); ?>" class="sv-account-link sv-user-account" aria-lable="User Account">
                            <!-- <?php //if (isset($HeaderOptions['account_logout_icon']['url']) && !empty($HeaderOptions['account_logout_icon']['url'])) : ?>
                                <img src="<?php //echo $HeaderOptions['account_logout_icon']['url'];?>" alt="Account Logout">
                            <?php //endif; ?> -->
                            <?php echo get_avatar( $user->ID, 20 ); ?>
                            </a>
                        <?php else : ?>
                             <a href="<?php echo home_url('/my-account'); ?>" aria-lable="User Account">
                             <?php if (isset($HeaderOptions['account_login_icon']['url']) && !empty($HeaderOptions['account_login_icon']['url'])) : ?>
                                <img src="<?php echo $HeaderOptions['account_login_icon']['url'];?>" alt="Account Login">
                            <?php endif; ?>
                             </a>
                        <?php endif;?>
                            <a href="<?php echo !empty($HeaderOptions['wishlist_page_link']['url']) ? $HeaderOptions['wishlist_page_link']['url'] : 'javascript:void(0)' ?>" class="sv-account-link">
                            <?php if (isset($HeaderOptions['wishlist_icon']['url']) && !empty($HeaderOptions['wishlist_icon']['url'])) : ?>
                                <img src="<?php echo $HeaderOptions['wishlist_icon']['url'];?>" alt="Wishlist">
                            <?php endif; ?>
                            </a>
                            <?php echo do_shortcode('[quadlayers-mini-cart]'); ?>
                        </div>
                    </div>
                </div>
            </div>
            <div class="sv-menu-wrapper" id="navbar-menu">
                <div class="sv-mobile-menu-top">
                    <div class="d-flex justify-content-between">
                    <?php if (is_user_logged_in()) : ?>
                        <a href="<?php echo wp_logout_url(home_url()); ?>" class="sv-user-account">
                        <span class="sv-user-avator" aria-lable="User Account">
                            <!-- <?php //if (isset($HeaderOptions['responsive_account_logout_icon']['url']) && !empty($HeaderOptions['responsive_account_logout_icon']['url'])) : ?>
                                <img src="<?php// echo $HeaderOptions['responsive_account_logout_icon']['url'];?>" alt="Account Login" class="sv-user-icon">
                            <?php //endif; ?> -->
                            <?php echo get_avatar( $user->ID, 64 ); ?>
                        </span><?php echo $user->user_firstname.' '.$user->user_lastname; ?></a>
                        
                    <?php else : ?>
                        <a href="<?php echo home_url('/my-account'); ?>"class="sv-user-account">
                        <span class="sv-user-avator" aria-lable="User Account">
                            <?php if (isset($HeaderOptions['responsive_account_login_icon']['url']) && !empty($HeaderOptions['responsive_account_login_icon']['url'])) : ?>
                                <img src="<?php echo $HeaderOptions['responsive_account_login_icon']['url'];?>" alt="Account Login" class="sv-user-icon">
                            <?php endif; ?>
                        </span></a>
                    <?php endif; ?>
                        <?php if (isset($HeaderOptions['menu_close_icon']['url']) && !empty($HeaderOptions['menu_close_icon']['url'])) : ?>
                        <button class="sv-menu-close" type="button">
                            <img src="<?php echo $HeaderOptions['menu_close_icon']['url'];?>" alt="close" class="sv-close-icon">
                        </button>
                        <?php endif; ?> 
                    </div>
                    <div class="sv-search-wrapper sv-search-mobile-wrapper">
                        <input type="text" class="sv-search-input" placeholder="Searching..." name="keyword" id="keyword"></input>
                        <span class="sv-search-icon">
                        <?php if (isset($HeaderOptions['menu_close_icon']['url']) && !empty($HeaderOptions['menu_close_icon']['url'])) : ?>
                            <img src="<?php echo $HeaderOptions['menu_close_icon']['url'];?>" alt="Search">
                        <?php endif; ?>
                        </span>
                    </div>
                </div>
                <?php $menu_array = prefix_get_menu_items('soraavi-menu'); 
                 	$current_id = $wp_query->queried_object_id; ?>
                
                <ul class="sv-navbar-links">
                <!-- // check if menu has items -->
                <?php if (isset($menu_array) && !empty($menu_array)) : 
                    foreach ($menu_array as $num => $menu_item) :
                        $custom_menu = get_fields($menu_item->ID);
                        $menuPage = basename($menu_item->url);
                        $classList = implode(" ", $menu_item->classes);
                        $actual_link = ( isset( $_SERVER['HTTPS'] ) ? "https" : "http" ) . "://$_SERVER[HTTP_HOST]$_SERVER[REQUEST_URI]";
                        $current_levl1 = ( $_SERVER['REQUEST_URI'] == parse_url( $menu_item->url, PHP_URL_PATH ) ) ? 'current' : '';
                    ?>
                    <li class="sv-navbar-item"><a class="navbar-link" href="<?php echo !empty( $menu_item->url ) ? $menu_item->url : '#0' ?><?php //echo esc_url(home_url( $menu_item->url ));?>"><?php echo $menu_item->title; ?></a>
                    <?php
                    if (have_rows('mega_menu_flexible', $menu_item->ID)) :
                        while (have_rows('mega_menu_flexible', $menu_item->ID)) :
                        the_row();
                        if (get_row_layout() == 'mega_menu_tab') :
                        $menu_rep_field = get_sub_field('sub_menu_item');
                            if ( !empty( $menu_rep_field ) ) : ?>
                            <span class="sv-navbar-item-dropdown">
                                <?php if (isset($HeaderOptions['plus_icon']['url']) && !empty($HeaderOptions['plus_icon']['url'])) : ?>
                                <img src="<?php echo $HeaderOptions['plus_icon']['url'];?>" alt="Plus">
                                <?php endif; ?>
                                <?php if (isset($HeaderOptions['minus_icon']['url']) && !empty($HeaderOptions['minus_icon']['url'])) : ?>
                                <img src="<?php echo $HeaderOptions['minus_icon']['url'];?>" alt="Minus">
                                <?php endif; ?>
                            </span>
                            <div class="sv-sub-menu-wrapper">
                            <?php 
                            foreach ($menu_rep_field as $key => $subItem) : 
                            $subMenuName = $subItem['sub_menu_item_name']; 
                            $subMenuLink = $subItem['sub_menu_item_link']; 
                            ?>
                                <div class="sv-sub-navbar-links">
                                    <a href="<?php echo !empty( $subMenuLink['url'] ) ? $subMenuLink['url'] : '#0' ?>" target="<?php echo !empty( $subMenuLink['target'] ) ? $subMenuLink['target'] : '_self' ?>"  class="sv-sub-navbar-items"><?php echo $subMenuName; ?></a>
                                    <?php $filter_Rep = $subItem['filters_repeater']; 
                                    if ( !empty( $filter_Rep ) ) : ?>
                                    <span class="sv-navbar-item-sub-dropdown">
                                        <?php if (isset($HeaderOptions['right_arrow_icon']['url']) && !empty($HeaderOptions['right_arrow_icon']['url'])) : ?>
                                        <img src="<?php echo $HeaderOptions['right_arrow_icon']['url'];?>" alt="arrow right" class="sv-navbar-plus-icon">
                                        <?php endif; ?>
                                    </span>
                                    <div class="sv-sub-child-menu-wrapper">
                                    <h5 class="sv-mobile-sub-tilte">
                                        <?php if (isset($HeaderOptions['right_arrow_icon']['url']) && !empty($HeaderOptions['right_arrow_icon']['url'])) : ?>
                                        <img src="<?php echo $HeaderOptions['right_arrow_icon']['url'];?>" alt="arrow right" class="sv-navbar-plus-icon">
                                        <?php endif; ?>
                                        <?php echo $subMenuName ?? null; ?>
                                    </h5>
                                        <div class="container">
                                            <div class="sv-sub-child-row">
                                                <div class="sv-sub-child-menu-col">
                                                <?php 
                                                foreach ( ($filter_Rep ? $filter_Rep : array()) as $filterKey => $filterItem) : 
                                                $showArrowIcon = $filterItem['show_dropdown_icon']; 
                                                $filterName = $filterItem['filter_name']; ?>
                                                    <div class="sv-sub-child-menu-wrap sv-sub-child-menu-dropdown <?php if ($filterKey === array_key_first($filter_Rep)) : ?> sv-sub-child-menu-dropdown-show <?php endif; ?>">
                                                        <h4 class="sv-sub-child-menu-title">
                                                            <?php echo $filterName ?? null; ?>
                                                        <?php if ($showArrowIcon) : ?>
                                                            <?php if (isset($HeaderOptions['arrow_down_dark_icon']['url']) && !empty($HeaderOptions['arrow_down_dark_icon']['url'])) : ?>
                                                            <img src="<?php echo $HeaderOptions['arrow_down_dark_icon']['url'];?>" alt="arrow down" class="sv-arrow-down">
                                                            <?php endif; ?>
                                                            <?php if (isset($HeaderOptions['arrow_up_dark_icon']['url']) && !empty($HeaderOptions['arrow_up_dark_icon']['url'])) : ?>
                                                            <img src="<?php echo $HeaderOptions['arrow_up_dark_icon']['url'];?>" alt="arrow Up" class="sv-arrow-up">
                                                            <?php endif; ?>
                                                        <?php endif; ?>
                                                        </h4>
                                                        <div class="sv-sub-child-menu-links">
                                                        <?php foreach ( ($filterItem['filter_item_repeater'] ? $filterItem['filter_item_repeater'] : array()) as $filterRepItem) : ?>
                                                            <a href="<?php echo !empty( $filterRepItem['filter_item_link']['url'] ) ? $filterRepItem['filter_item_link']['url'] : '#0' ?>" target="<?php echo !empty( $filterRepItem['filter_item_link']['target'] ) ? $filterRepItem['filter_item_link']['target'] : '_self' ?>" class="sv-sub-child-menu-items"><?php echo $filterRepItem['filter_item_name'] ?? null; ?></a>
                                                        <?php endforeach; ?>
                                                        </div>
                                                    </div>
                                                <?php endforeach; ?>
                                                </div>
                                                <?php $featuredRep = $subItem['featured_products_repeater']; ?>
                                                <div class="sv-sub-child-prod-col">
                                                    <h4><?php echo __( 'FEATURE PRODUCTS' ); ?></h4>
                                                    <div class="row">
                                                        <?php foreach ( ($featuredRep ? $featuredRep : array()) as $featuredItem) : 
                                                            ?>
                                                        <div class="col-md-4">
                                                            <div class="sv-product-card">
                                                            <?php //$image = wp_get_attachment_image_src( get_post_thumbnail_id( $product_id ), 'single-post-thumbnail' );
                                                            $_product = wc_get_product( $featuredItem['select_featured_product']->ID );
                                                            echo wp_get_attachment_image( get_post_thumbnail_id( $featuredItem['select_featured_product']->ID ), [ 300, 200 ] );?>
                                                            <!-- <img class="product-img" src="/wp-content/uploads/2023/10/product-1.png" alt="full sleeves Printed Tee"> -->
                                                                <h5><a href="<?php  echo get_permalink($featuredItem['select_featured_product']->ID); ?>"><?php echo $_product->get_name(); ?></a></h5>
                                                                <h4><?php echo $_product->get_price(); ?></h4>
                                                            </div>
                                                        </div>
                                                        <?php endforeach; ?>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <?php endif; ?>
                                </div>
                            <?php endforeach; ?>
                            </div>
                            <?php endif; ?>
                        <?php endif; 
                        endwhile;
                    endif; ?>
                    </li>
                    <?php endforeach; ?>
                <?php endif; ?>
                </ul>
            </div>
        </nav>
    </header>