<?php

/**
 * The template for displaying single posts and pages.
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package WordPress
 * @subpackage Porto
 * @since Porto
 */

get_header();
?>
<main id="site-content" role="main">
    <?php
    if (have_posts()) {

        while (have_posts()) {
            the_post();
            $postID     = get_the_id();
            $postTitle  = get_the_title($postID);
            $thumbnail  = get_the_post_thumbnail();
            $categories = get_the_category($postID);
            $date       = get_the_date('M d, Y', $postID);
            $author     = get_the_author($postID);
            $cat_array  = array();
            foreach ($categories as $category) {
                $cat_array[] = $category->slug;
            }
        }
    }

    ?>
    <!-- Blog detail starts -->
    <section class="sv-blog-detail sv-section-spacing" id="post-<?php the_ID(); ?>">
        <div class="container sv-blog-detail-outer">
            <div class="content">
                <div class="sv-blog_content">
                    <div class="sv-blog-info text-center">
                        <h1><?php echo $postTitle ?></h1>
                        <div class="detail-image">
                            <?php
                            if (!empty($thumbnail)) :
                                echo $thumbnail;
                            else :
                            ?>
                                <img class="no-preview" src="<?php echo get_site_url(); ?>/wp-content/uploads/2022/08/no-preview-1.png" alt="No Preview">
                            <?php
                            endif;
                            ?>
                        </div>
                    </div>
                    <div class="sv-blog-meta-tag d-flex align-items-center justify-content-between flex-wrap">
                        <ul class="publisher-info d-flex align-items-center">
                            <li class="Publish-date">Publish on Aug 12, 2023</li>
                            <li class="author-name">Author: Kirandeep singh</li>
                        </ul>
                        <ul class="social-links d-flex align-items-center p-0">
                            <li>
                                <a href="http://www.facebook.com/share.php?u=<?php echo urlencode($page_url); ?>&title=<?php echo urlencode($title); ?>" target="_blank"><img src="/wp-content/uploads/2023/10/facebook-small.webp"></a>
                            </li>
                            <li>
                                <a href="http://www.linkedin.com/shareArticle?mini=true&url=<?php print(urlencode($page_url)); ?>&title=<?php echo urlencode($title); ?>&source=<?php echo urlencode($page_url); ?>" target="_blank"><img src="/wp-content/uploads/2023/10/twitter.webp"></a>
                            </li>
                            <li>
                                <a href="https://www.pinterest.com/pin/create/link/?url=<?php echo urlencode($page_url); ?>&media=&description=<?php echo urlencode($title); ?>" target="_blank"><img src="/wp-content/uploads/2023/10/linkedin.webp"></a>
                            </li>
                        </ul>
                    </div>
                    <div class="sv-blog-paragraph" id="content">
                        <?php echo get_the_content(); ?>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-md-12">
                    <div class="sv-blog-meta-tag d-flex align-items-center justify-content-between flex-wrap">
                        <ul class="social-links d-flex align-items-center p-0 m-0 sv-social">
                            <li>
                                <a href="http://www.facebook.com/share.php?u=<?php echo urlencode($page_url); ?>&title=<?php echo urlencode($title); ?>" target="_blank"><img src="/wp-content/uploads/2023/10/facebook.png"></a>
                            </li>
                            <li>
                                <a href="http://www.linkedin.com/shareArticle?mini=true&url=<?php print(urlencode($page_url)); ?>&title=<?php echo urlencode($title); ?>&source=<?php echo urlencode($page_url); ?>" target="_blank"><img src="/wp-content/uploads/2023/10/instagram.webp"></a>
                            </li>
                        </ul>
                    </div>
                </div>
                <div class="sv-Blog-slider slider">
                    <div class="card">
                        <div class="card-header">
                            <img src="/wp-content/uploads/2023/10/order.webp">
                        </div>
                        <div class="card-body">
                            <div class="card-content">
                                <div class="card-text">
                                    <div class="sv-blog-meta-tag d-flex align-items-center justify-content-between flex-wrap">
                                        <ul class="publisher-info d-flex align-items-center flex-wrap">
                                            <li class="Publish-date">Publish on Aug 12, 2023</li>
                                            <li class="author-name">Author: Kirandeep singh</li>
                                        </ul>
                                    </div>
                                    <h3>Lorem ipsum dolor sit amet, consetetur sadipscing elitr</h3>
                                    <p>Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt
                                        ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo
                                        dolores et ea</p>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="card">
                        <div class="card-header">
                            <img src="/wp-content/uploads/2023/10/order.webp">
                        </div>
                        <div class="card-body">
                            <div class="card-content">
                                <div class="card-text">
                                    <div class="sv-blog-meta-tag d-flex align-items-center justify-content-between flex-wrap">
                                        <ul class="publisher-info d-flex align-items-center flex-wrap">
                                            <li class="Publish-date">Publish on Aug 12, 2023</li>
                                            <li class="author-name">Author: Kirandeep singh</li>
                                        </ul>
                                    </div>
                                    <h3>Lorem ipsum dolor sit amet, consetetur sadipscing elitr</h3>
                                    <p>Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt
                                        ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo
                                        dolores et ea</p>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="card">
                        <div class="card-header">
                            <img src="/wp-content/uploads/2023/10/order.webp">
                        </div>
                        <div class="card-body">
                            <div class="card-content">
                                <div class="card-text">
                                    <div class="sv-blog-meta-tag d-flex align-items-center justify-content-between flex-wrap">
                                        <ul class="publisher-info d-flex align-items-center flex-wrap">
                                            <li class="Publish-date">Publish on Aug 12, 2023</li>
                                            <li class="author-name">Author: Kirandeep singh</li>
                                        </ul>
                                    </div>
                                    <h3>Lorem ipsum dolor sit amet, consetetur sadipscing elitr</h3>
                                    <p>Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt
                                        ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo
                                        dolores et ea</p>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="card">
                        <div class="card-header">
                            <img src="/wp-content/uploads/2023/10/order.webp">
                        </div>
                        <div class="card-body">
                            <div class="card-content">
                                <div class="card-text">
                                    <div class="sv-blog-meta-tag d-flex align-items-center justify-content-between flex-wrap">
                                        <ul class="publisher-info d-flex align-items-center flex-wrap">
                                            <li class="Publish-date">Publish on Aug 12, 2023</li>
                                            <li class="author-name">Author: Kirandeep singh</li>
                                        </ul>
                                    </div>
                                    <h3>Lorem ipsum dolor sit amet, consetetur sadipscing elitr</h3>
                                    <p>Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt
                                        ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo
                                        dolores et ea</p>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="card">
                        <div class="card-header">
                            <img src="/wp-content/uploads/2023/10/order.webp">
                        </div>
                        <div class="card-body">
                            <div class="card-content">
                                <div class="card-text">
                                    <div class="sv-blog-meta-tag d-flex align-items-center justify-content-between flex-wrap">
                                        <ul class="publisher-info d-flex align-items-center flex-wrap">
                                            <li class="Publish-date">Publish on Aug 12, 2023</li>
                                            <li class="author-name">Author: Kirandeep singh</li>
                                        </ul>
                                    </div>
                                    <h3>Lorem ipsum dolor sit amet, consetetur sadipscing elitr</h3>
                                    <p>Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt
                                        ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo
                                        dolores et ea</p>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="card">
                        <div class="card-header">
                            <img src="/wp-content/uploads/2023/10/order.webp">
                        </div>
                        <div class="card-body">
                            <div class="card-content">
                                <div class="card-text">
                                    <div class="sv-blog-meta-tag d-flex align-items-center justify-content-between flex-wrap">
                                        <ul class="publisher-info d-flex align-items-center flex-wrap">
                                            <li class="Publish-date">Publish on Aug 12, 2023</li>
                                            <li class="author-name">Author: Kirandeep singh</li>
                                        </ul>
                                    </div>
                                    <h3>Lorem ipsum dolor sit amet, consetetur sadipscing elitr</h3>
                                    <p>Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt
                                        ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo
                                        dolores et ea</p>
                                </div>
                            </div>
                        </div>
                    </div>

                </div>
            </div>
            <?php
            wp_reset_postdata();
            ?>
    </section>
    <!-- Blog detail starts -->

</main>


<?php ?>
<?php get_footer(); ?>