<?php

/**
 *Template Name: About us
 */
get_header(); 
$aboutData = get_fields(); 
$aboutOptions = get_fields('options'); ?>
<?php $heroData = $aboutData['hero_banner'] ?? null; ?>
<?php if (isset($heroData) && is_array($heroData) && array_filter($heroData) ) : ?>
    <!--About us Banner section-->
    <?php include(get_template_directory() . '/includes/hero_banner.php'); ?>
    <!-- End About us Banner section-->
<?php endif; ?>
<?php if (isset($aboutData['left_right_image_section']) && is_array($aboutData['left_right_image_section']) && array_filter($aboutData['left_right_image_section']) ) : ?>
<?php $leftRightData = $aboutData['left_right_image_section'] ?? null; ?>
    <!-- About card section-->
<section class="sv-about-card-section sv-section-extra-spacing">
  <div class="sv-about-card-img-bg">
    <div class="container">
    <?php foreach(($leftRightData ? $leftRightData : array()) as $leftRightItem ) : ?>
      <div class="row align-items-center">
          <div class="col-md-6 <?php echo $leftRightItem['row_class']  ?? null; ?>">
              <?php if (isset($leftRightItem['image']['url']) && !empty($leftRightItem['image']['url'])) : ?>
              <div class="sv-about-card-content-img">
                  <img src="<?php echo $leftRightItem['image']['url'];?>"
                      alt="<?php echo $leftRightItem['image']['alt'];?>">
              </div>
              <?php endif; ?>
          </div>
          <div class="col-md-6">
              <div class="sv-about-card-content">
                  <?php if (isset($leftRightItem['heading']) && !empty($leftRightItem['heading'])) : ?>
                  <h3><?php echo $leftRightItem['heading']; ?></h3>
                  <?php endif; ?>
                  <?php if (isset($leftRightItem['description']) && !empty($leftRightItem['description'])) : ?>
                  <?php echo $leftRightItem['description']; ?>
                  <?php endif; ?>
                  <?php $btnLabel = $leftRightItem['button_label'] ?? null;
                  if (isset($btnLabel) && !empty($btnLabel)) : ?>
                  <a href="<?php echo !empty($leftRightItem['button_link']['url']) ? $leftRightItem['button_link']['url'] : '#0' ?>"
                      target="<?php echo !empty($leftRightItem['button_link']['target']) ? $leftRightItem['button_link']['target'] : '_self' ?>"
                      aria-label="<?php echo $btnLabel; ?>"
                      class="sv-about-card-button sv-btn"><?php echo $btnLabel; ?></a>
                  <?php endif; ?>
              </div>
          </div>
      </div>
    <?php endforeach; ?>
    </div>
  </div>
</section>
<?php endif; ?>
    <!-- End About card section-->
    <!-- about card accordion -->
<?php $accordionData = $aboutData['accordion_data'] ?? null; ?>
<?php if (isset($accordionData) && is_array($accordionData) && array_filter($accordionData) ) : ?>
<!--start get offer form section-->
<section class="sv-card-accordion sv-section-spacing">
  <div class="container">
    <div class="row align-items-center">
      <div class="col-md-6">
        <div class="sv-accordion-img">
        <?php if (isset($accordionData['accordion_left_image_1']['url']) && !empty($accordionData['accordion_left_image_1']['url'])) : ?>
          <img class="sv-card-first-img" src="<?php echo $accordionData['accordion_left_image_1']['url'];?>" alt="<?php echo $accordionData['accordion_left_image_1']['alt'];?>">
        <?php endif; ?>
        <?php if (isset($accordionData['accordion_left_image_2']['url']) && !empty($accordionData['accordion_left_image_2']['url'])) : ?>
          <img class="sv-card-second-img" src="<?php echo $accordionData['accordion_left_image_2']['url'];?>" alt="<?php echo $accordionData['accordion_left_image_2']['alt'];?>">
        <?php endif; ?>
        <?php if (isset($accordionData['accordion_left_image_3']['url']) && !empty($accordionData['accordion_left_image_3']['url'])) : ?>
          <img class="sv-card-third-img" src="<?php echo $accordionData['accordion_left_image_3']['url'];?>" alt="<?php echo $accordionData['accordion_left_image_3']['alt'];?>">
        <?php endif; ?>
        </div>
      </div>
      <div class="col-md-6">
        <div class="sv-accordion">
        <?php if (isset($accordionData['accordion_section_heading']) && !empty($accordionData['accordion_section_heading'])) : ?>
          <h3><?php echo $accordionData['accordion_section_heading'];?></h3>
        <?php endif; ?>
          <div class="accordion accordion-flush" id="accordionAbout">
          <?php $accordions= $accordionData['accordion_repeater'];?>
          <?php $i=1; ?> 
          <?php foreach(($accordions ? $accordions: array()) as $accordion ) : ?>
            <div class="accordion-item">
              <?php if (isset($accordion['accordion_question']) && !empty($accordion['accordion_question'])) : ?>
              <h2 class="accordion-header" id="flush-heading<?php echo $i;?>">
                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                  data-bs-target="#flush-collapse<?php echo $i;?>" aria-expanded="false" aria-controls="flush-collapse<?php echo $i;?>">
                  <?php echo $accordion['accordion_question'];?>
                </button>
              </h2>
              <?php endif; ?>
              <div id="flush-collapse<?php echo $i;?>" class="accordion-collapse collapse" aria-labelledby="flush-heading<?php echo $i;?>"
                data-bs-parent="#accordionAbout">

                <div class="accordion-body"><?php echo $accordion['accordion_answer'] ?? null; ?></div>
              </div>
            </div>
          <?php $i++;
          endforeach; ?>
          </div>
        </div>
      </div>
    </div>
  </div>
</section>
<?php endif; ?>
    <!--End about card accordion -->
<?php $smallIconData = $aboutData['small_icons_text_grid'] ?? null;
if (is_array($smallIconData) && !empty($smallIconData)) : ?>
<!-- start about meet section-->
    <?php include(get_template_directory() . '/includes/small_icons_grid.php'); ?>
<!-- End about meet section-->
<?php endif; ?>
    <!--about contribution section-->
<?php $alternateImageData = $aboutData['alternate_image_with_text'] ?? null;  ?>
<?php if (isset($alternateImageData) && is_array($alternateImageData)) : ?>
    <?php include(get_template_directory() . '/includes/alternate_image_with_text.php'); ?>
<?php endif; ?>
<!-- <section class="sv-contribute-section sv-about-card-section sv-section-extra-spacing">
  <div class="container">
    <div class="row align-items-center">
      <div class="col-md-6 d-flex justify-content-end">
        <div class="sv-about-card-content-img">
          <img src="https://soraavi.demandtech.org/wp-content/uploads/2023/10/order.webp">
        </div>
      </div>
      <div class="col-md-6">
        <div class="sv-about-card-content">
          <h3>1 Order = 1 LIFE</h3>
          <p>Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore
            et dolore magna aliquyam erat, sed diam voluptua.</p>
          <a href="#" class="sv-about-card-button sv-btn">CONTRIBUTE NOW</a>
        </div>
      </div>
    </div>
    <div class="row align-items-center">
      <div class="col-md-6">
        <div class="sv-about-card-content-img">
          <img src="https://soraavi.demandtech.org/wp-content/uploads/2023/10/working-lady.webp">
        </div>
      </div>
      <div class="col-md-6">
        <div class="sv-about-card-content">
          <h3>Know some one who would be interested in working at SORAAVI ?</h3>
          <p>Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore
            et dolore magna aliquyam erat, sed diam voluptua.</p>
          <a href="#" class="sv-about-card-button sv-btn">GET IN TOUCH</a>
        </div>
      </div>
    </div>
  </div>
</section> -->
<!-- End about contribution section-->
<?php
get_footer();
?>