<?php

/**
 *Template Name: Home Landing Page
 */
get_header('landing'); 
$homeFields = get_fields(); 
//echo "<pre>";
//print_r($homeFields);
//print_r($themeOptions);

?>


<!--start hero banner-->
<section class="sv-about-hero-section">
    <div class="row align-items-center m-0 justify-content-between">
        <div class="col-md-6">
            <div class="sv-banner-content-div">
                <?php if (isset($homeFields['hero_banner_heading']) && !empty($homeFields['hero_banner_heading'])) : ?>
                    <h1><?php echo $homeFields['hero_banner_heading'];?></h1>
                <?php endif; ?>    
                <?php if (isset($homeFields['hero_banner_description']) && !empty($homeFields['hero_banner_description'])) : ?>    
                    <p><?php echo $homeFields['hero_banner_description'];?></p>
                <?php endif; ?> 
                <div class="sv-hero-btn">
                <?php if (isset($homeFields['hero_banner_cta_label']) && !empty($homeFields['hero_banner_cta_label'])) : ?>    
                    <a href="<?php echo $homeFields['hero_banner_cta_link'];?>" class="sv-btn"><?php echo $homeFields['hero_banner_cta_label'];?></a>
                <?php endif; ?> 
                
                </div>
            </div>
        </div>
        <div class="col-md-6 px-0 sv-column">
            <div class="sv-banner-image-div">
            <?php if (isset($homeFields['hero_banner_image_1']['url']) && !empty($homeFields['hero_banner_image_1']['url'])) : ?>  
                <img src="<?php echo $homeFields['hero_banner_image_1']['url'];?>" alt="<?php echo $homeFields['hero_banner_image_1']['alt'];?>">
            <?php endif; ?>           
            </div>
            <div class="sv-banner-top-image">
            <?php if (isset($homeFields['hero_banner_image_1']['url']) && !empty($homeFields['hero_banner_image_1']['url'])) : ?> 
                <img src="<?php echo $homeFields['hero_banner_image_2']['url']?>" alt="<?php echo $homeFields['hero_banner_image_2']['alt'];?>">
            <?php endif; ?>            
            </div>
        </div>
    </div>
    <?php if (isset($homeFields['hero_banner_href_id']) && !empty($homeFields['hero_banner_href_id'])) : ?>
        <a class="sv-scroll-next" href="<?php echo $homeFields['hero_banner_href_id'];?>">
        <?php echo $homeFields['hero_banner_href_text'];?>
            <div class="sv-arrow-container"></div>
        </a>
    <?php endif; ?> 
</section>
<!--end hero banner section-->
<!--start our story section-->
<section class="sv-about-card-section sv-story-landing-section sv-section-extra-spacing" id="sv-our-story">
    <div class="sv-about-card-img-bg">
        <div class="container">
            <div class="row align-items-center">
                <div class="col-md-6 d-flex justify-content-end">
                    <div class="sv-about-card-content-img">
                        <?php if (isset($homeFields['our_story_image']['url']) && !empty($homeFields['our_story_image']['url'])) : ?>
                            <img src="<?php echo $homeFields['our_story_image']['url'];?>" alt="<?php echo $homeFields['our_story_image']['alt'];?>">
                        <?php endif; ?>                     
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="sv-about-card-content">
                        <?php if (isset($homeFields['our_story_heading']) && !empty($homeFields['our_story_heading'])) : ?>
                            <h3><?php echo $homeFields['our_story_heading'];?></h3>
                        <?php endif; ?> 
                        <?php if (isset($homeFields['our_story_description']) && !empty($homeFields['our_story_description'])) : ?>                    
                            <p><?php echo $homeFields['our_story_description'];?></p>
                        <?php endif; ?> 
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<!--end our story section-->
<!--start sample section-->
<section class="sv-sample-slider-section sv-section-bottom">
    <div class="container">
        <div class="sv-section-heading">
            <?php if (isset($homeFields['our_samples_heading']) && !empty($homeFields['our_samples_heading'])) : ?>
                <h2 class="text-center"><?php echo $homeFields['our_samples_heading'];?></h2>
            <?php endif; ?>
        </div>
        <div class="sv-sample-slck-slider">
        <?php $sampleProducts= $homeFields['products'];?>
        <?php if (isset($sampleProducts) && !empty($sampleProducts)) : ?>
            <?php foreach($sampleProducts as $sampleProduct ){?> 
            <div class="sv-sample-items">
                <img src="<?php echo $sampleProduct['product_image']['url'];?>" alt="<?php echo $sampleProduct['product_image']['alt'];?>">
                <h3><?php echo $sampleProduct['product_name'];?></h3>
            </div>
            <?php }?>
        <?php endif; ?>
            </div>
        </div>
    </div>
</section>
<!--end sample section-->
<!--start meet section-->
<section class="sv-meet-up-card-section sv-section-spacing text-center">
    <div class="container">
    <?php if (isset($homeFields['meet_you_heading']) && !empty($homeFields['meet_you_heading'])) : ?>
        <h2><?php echo $homeFields['meet_you_heading'];?></h2>
        <?php endif; ?>
        <div class="row">
        <?php $iconDescriptions= $homeFields['icon_and_description'];?>
        <?php if (isset($iconDescriptions) && !empty($iconDescriptions)) : ?>
        <?php foreach($iconDescriptions as $iconDescription ){?> 
            <div class="col-md-3 col-sm-6">
                <div class="sv-meet-up-card-div">
                <img src="<?php echo $iconDescription['icon']['url'];?>" alt="<?php echo $iconDescription['icon']['alt'];?>">
                    <p><?php echo $iconDescription['description'];?></p>
                </div>
            </div>
        <?php }?> 
        <?php endif;?>
        </div>
    </div>
</section>
<!--end meet section-->
<section class="sv-card-accordion sv-section-spacing">
    <div class="container">
        <div class="row align-items-center">
            <div class="col-md-6">
                <div class="sv-accordion-img">
                    <img class="sv-card-first-img" src="<?php echo $homeFields['accordion_left_image_1']['url'];?>" alt="<?php echo $homeFields['accordion_left_image_1']['alt'];?>">
                    <img class="sv-card-second-img" src="<?php echo $homeFields['accordion_left_image_2']['url'];?>" alt="<?php echo $homeFields['accordion_left_image_2']['alt'];?>">
                    <img class="sv-card-third-img" src="<?php echo $homeFields['accordion_left_image_3']['url'];?>" alt="<?php echo $homeFields['accordion_left_image_2']['alt'];?>">
                </div>
            </div>
            <div class="col-md-6">
                <div class="sv-accordion">
                    <h3><?php echo $homeFields['accordion_section_heading'];?></h3>
                    <div class="accordion accordion-flush" id="accordionSetApart">
                    <?php $accordions= $homeFields['accordion_data'];?>
                    <?php $i=1;
                        foreach($accordions as $accordion ){?> 
                        <div class="accordion-item">
                            <h2 class="accordion-header" id="flush-heading-<?php echo $i;?>">
                                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#flush-collapse-<?php echo $i;?>" aria-expanded="false" aria-controls="flush-collapse-<?php echo $i;?>">
                                <?php echo $accordion['accordion_question'];?>
                                </button>
                            </h2>
                            <div id="flush-collapse-<?php echo $i;?>" class="accordion-collapse collapse" aria-labelledby="flush-heading-<?php echo $i;?>" data-bs-parent="#accordionSetApart">
                                <div class="accordion-body"><?php echo $accordion['accordion_answer'];?></div>
                            </div>
                        </div>
                    <?php $i++;}?>    
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<!--start contribution section-->
<section class="sv-contribute-section sv-about-card-section">
    <div class="sv-about-card-img-bg">
        <div class="container">
        <?php $contributes= $homeFields['contribute'];?>
        <?php foreach($contributes as $contribute ){?> 
            <div class="row align-items-center">
            
                <div class="col-md-6 <?php echo $contribute['additional_class'];?>">
                    <div class="sv-about-card-content-img">
                    <img src="<?php echo $contribute['contribute_data_hero_banner_image_1']['url'];?>" alt="<?php echo $contribute['contribute_data_hero_banner_image_1']['alt'];?>">

                    </div>
                </div>
                <div class="col-md-6">
                    <div class="sv-about-card-content">
                        <h3><?php echo $contribute['contribute_data_hero_banner_heading'];?></h3>
                        <p><?php echo $contribute['contribute_data_hero_banner_description'];?></p>
                    </div>
                </div>
                
            </div>
            <?php }?>
        </div>
    </div>
</section>
<!--end contribution section-->
<!--start contact info section-->
<section class="sv-contact-info-section sv-section-bottom" id="contactForm">
    <div class="container">
        <div class="sv-section-heading sv-section-heading-line">
            <h2 class="text-center"><?php echo $homeFields['contact_us_heading'];?></h2>
        </div>
        <div class="row justify-content-between">
            <div class="col-md-6">
                <div class="sv-contact-info">
                <h3><?php echo $homeFields['general_enquiries_heading'];?></h3>
                <?php $generalEnquiries = $homeFields['general_enquiries'];?>
                <?php foreach($generalEnquiries as $generalEnquirie ){?> 
                    <p><img src="<?php echo $generalEnquirie['flag']['url'];?>" alt="<?php echo $generalEnquirie['flag']['alt'];?>"> <a href="<?php echo ($generalEnquirie['contact_options'] == 'Phone') ? 'tel:' : 'mailto:';?>"><?php echo $generalEnquirie['value']??"";?><?php echo $generalEnquirie['phone_info']??'';?></a></p>
                    <?php }?>
                    <h3><?php echo $homeFields['postal_address_heading'];?></h3>
                    <p class="sv-address-text"><?php echo $homeFields['postal_address'];?></p>
                </div>
            </div>
            <div class="col-md-5">
                <div class="sv-contact-form">
                <?php if ( $homeFields['contact_us_right']) {
                        echo do_shortcode( $homeFields['contact_us_right'] );
                    } ?>
                </div>
            </div>
        </div>
    </div>
</section>
<!--end contact info section-->
<?php
get_footer('landing');
?>