<?php 

get_header();

?>

<header class="woocommerce-products-header sv-shop-list-header">
	<div class="container">
		<?php if ( apply_filters( 'woocommerce_show_page_title', true ) ) : ?>
			<h1 class="woocommerce-products-header__title page-title"><?php woocommerce_page_title(); ?></h1>
		<?php endif; ?>
	</div>	
	<?php
	if ( is_product_category() ){
    global $wp_query;

    // get the query object
    $cat = $wp_query->get_queried_object();

    // get the thumbnail id using the queried category term_id
    $thumbnail_id = get_term_meta( $cat->term_id, 'thumbnail_id', true ); 

    // get the image URL
    $image = wp_get_attachment_url( $thumbnail_id ); 

    // print the IMG HTML
    echo "<img src='{$image}' alt='categories' class='Img-fluid' />";
	} 
	else {

		echo "<img src='http://localhost/gitlab-projects/soraavi/wp-content/uploads/2023/12/shop-banner-bg.webp' alt='shop' class='Img-fluid'/>";
	}?>
</header>

<div class="container">
	<?php
	/**
 * Hook: woocommerce_before_main_content.
 *
 * @hooked woocommerce_output_content_wrapper - 10 (outputs opening divs for the content)
 * @hooked woocommerce_breadcrumb - 20
 * @hooked WC_Structured_Data::generate_website_data() - 30
 */
do_action( 'woocommerce_before_main_content' );
?>

<div class="sv-woocommercer-sorting">
<?php
/**
	 * Hook: woocommerce_before_shop_loop.
	 *
	 * @hooked woocommerce_output_all_notices - 10
	 * @hooked woocommerce_result_count - 20
	 * @hooked woocommerce_catalog_ordering - 30
	 */
	
	 do_action( 'woocommerce_before_shop_loop' );
	 ?>
</div>

    <div class="shop-page-row">
    	<div class="shop-custom-sidebar">
			<div class="sv-product-filter">
				<div class="sv-filter-title d-flex justify-content-between align-item-center">
                    <h4 class="mb-0">Filter</h4>
                    <button type="button" class="sv-btn-close">&#x2715; close</button>
                </div>
<?php

/**
 * Hook: woocommerce_sidebar.
 *
 * @hooked woocommerce_get_sidebar - 10
 */
// do_action( 'woocommerce_sidebar' );
echo do_shortcode('[searchandfilter id="wpf_658bfecba9b17"]');
echo '</div></div>
<div class="shop-product-list product-list">
<button class="sv-btn-filter" type="button">Filter</button>';
if ( woocommerce_product_loop() ) {

	

	woocommerce_product_loop_start();

	if ( wc_get_loop_prop( 'total' ) ) {
		while ( have_posts() ) {
			the_post();

			/**
			 * Hook: woocommerce_shop_loop.
			 */
			do_action( 'woocommerce_shop_loop' );

			wc_get_template_part( 'content', 'product' );
		}
	}
	woocommerce_product_loop_end();
	/**
	 * Hook: woocommerce_after_shop_loop.
	 *
	 * @hooked woocommerce_pagination - 10
	 */
	do_action( 'woocommerce_after_shop_loop' );
} else {
	/**
	 * Hook: woocommerce_no_products_found.
	 *
	 * @hooked wc_no_products_found - 10
	 */
	do_action( 'woocommerce_no_products_found' );
}

echo '</div>';

/**
 * Hook: woocommerce_after_main_content.
 *
 * @hooked woocommerce_output_content_wrapper_end - 10 (outputs closing divs for the content)
 */
do_action( 'woocommerce_after_main_content' );
?>

</div></div>
<?php
get_footer();

?>
