//start menu sticky//

const header = document.querySelector(".wf-navbar");
const toggleClass = "is-sticky";

window.addEventListener("scroll", () => {
  const currentScroll = window.pageYOffset;
  if (currentScroll > 180) {
    header.classList.add(toggleClass);
  } else {
    header.classList.remove(toggleClass);
  }
});
//end menu sticky//

//start tab auto cycle//
var index = 0, // Index of current tab
  interval = setInterval(function () {
    rotate();
  }, 2000), // Interval
  $tabs = jQuery("ul.wf-nav-tabs-select"),
  $content = jQuery(".wf-tab-content");

// Click handler
jQuery("ul.wf-nav-tabs-select li").each(function (i) {
  jQuery(this).click(function () {
    index = i;
    switchElement();
  });
});

function rotate() {
  // Update index to next one
  index++;

  // Check if this is a valid index, or reset to 0
  if (index >= $tabs.children("li").length) index = 0;

  switchElement();
}

function switchElement() {
  // Reset interval
  interval = setInterval(function () {
    rotate();
  }, 2000);

  // Remove class from current tab
  jQuery("ul.wf-nav-tabs-select li").removeClass("active");
  jQuery(".wf-tab-pane").fadeOut(300);

  // Show
  var $tab = $tabs.children("li").eq(index);
  $tab.addClass("active");
  $content.children(".wf-tab-pane").eq(index).delay(300).fadeIn(300);
  // Clear interval
  clearInterval(interval);
}
//end tab auto cycle//


// start tab convert to accordion //
// end tab convert to accordion //


jQuery(document).ready(function () {
  //start add active class on accordion item//
  jQuery(".accordion-item").on("click", function () {
    if (
      jQuery(this)
        .find(".accordion-header .accordion-button")
        .hasClass("collapsed") == true
    ) {
      jQuery(this).removeClass("active");
    } else {
      jQuery(".accordion-item.active").removeClass("active");
      jQuery(this).addClass("active");
    }
  });
  jQuery(".accordion-item:first").addClass("active");
  //end add active class on accordion item//

  //start toogle menu//
  $(".wf-navToggle").click (function(){
    $(this).toggleClass("open");
    $(".wf-header-menu").toggleClass("show");
  });
  //end toogle menu//

  $(".collapse.show").each(function(){
        $(this).prev(".card-header").find(".fa").addClass("fa-minus").removeClass("fa-plus");
    });

    // Toggle plus minus icon on show hide of collapse element
    $(".collapse").on('show.bs.collapse', function(){
        $(this).prev(".card-header").find(".fa").removeClass("fa-plus").addClass("fa-minus");
    }).on('hide.bs.collapse', function(){
        $(this).prev(".card-header").find(".fa").removeClass("fa-minus").addClass("fa-plus");
    });
});

tabControl();

/*
We also apply the switch when a viewport change is detected on the fly
(e.g. when you resize the browser window or flip your device from 
portrait mode to landscape). We set a timer with a small delay to run 
it only once when the resizing ends. It's not perfect, but it's better
than have it running constantly during the action of resizing.
*/
var resizeTimer;
$(window).on('resize', function(e) {
  clearTimeout(resizeTimer);
  resizeTimer = setTimeout(function() {
    tabControl();
  }, 250);
});

/*
The function below is responsible for switching the tabs when clicked.
It switches both the tabs and the accordion buttons even if 
only the one or the other can be visible on a screen. We prefer
that in order to have a consistent selection in case the viewport
changes (e.g. when you esize the browser window or flip your 
device from portrait mode to landscape).
*/
function tabControl() {
  var tabs = $('.wf-tabbed-content').find('.wf-tabs');
  if(tabs.is(':visible')) {
    tabs.find('a').on('click', function(event) {
      event.preventDefault();
      var target = $(this).attr('href'),
          tabs = $(this).parents('.wf-tabs'),
          buttons = tabs.find('a'),
          item = tabs.parents('.wf-tabbed-content').find('.wf-service-content');
      buttons.removeClass('active');
      item.removeClass('active');
      $(this).addClass('active');
      $(target).addClass('active');
    });
  } else {
    $('.wf-service-content').on('click', function() {
      var container = $(this).parents('.wf-tabbed-content'),
          currId = $(this).attr('id'),
          items = container.find('.wf-service-content');
      container.find('.wf-tabs a').removeClass('active');
      items.removeClass('active');
      $(this).addClass('active');
      container.find('.wf-tabs a[href$="#'+ currId +'"]').addClass('active');
    });
  } 
}