<?php
require( get_template_directory(). '/inc/networkOn-integration.php');
function enqueue_parent_styles()
{
	wp_register_style('bootstrap', get_template_directory_uri() . '/assets/css/bootstrap.min.css');
	wp_enqueue_style('bootstrap');
	wp_register_style('owl-carousel', get_template_directory_uri() . '/assets/plugin/owl-carousel/owl.carousel.min.css');
	wp_enqueue_style('owl-carousel');	
	wp_register_style('fonts', get_template_directory_uri() . '/assets/fonts/fonts.css');
	wp_enqueue_style('fonts');
	wp_register_style('style', get_template_directory_uri() . '/assets/css/style.css');
	wp_enqueue_style('style');		
}

add_action('wp_enqueue_scripts', 'enqueue_parent_styles');

function load_js()
{
	wp_register_script('jquery', get_template_directory_uri() . '/assets/js/jquery-3.6.4.min.js', array(), 1, 1, 1);
	wp_enqueue_script('jquery');

	wp_register_script('popper', get_template_directory_uri() . '/assets/js/popper.min.js', array(), 1, 1, 1);
	wp_enqueue_script('popper');

	wp_register_script('bootstrap', get_template_directory_uri() . '/assets/js/bootstrap.min.js', array(), 1, 1, 1);
	wp_enqueue_script('bootstrap');	

	wp_register_script('owl-carousel', get_template_directory_uri() . '/assets/plugin/owl-carousel/owl.carousel.min.js', array(), 1, 1, 1);
	wp_enqueue_script('owl-carousel');	

	wp_register_script('custom', get_template_directory_uri() . '/assets/js/custom.js', array(), 1, 1, 1);
	wp_enqueue_script('custom');	
	
}

add_action('wp_enqueue_scripts', 'load_js');


/* Enqueue Styles */
if ( ! function_exists('thr_enqueue_styles') ) {
    function thr_enqueue_styles() {
        wp_enqueue_style( 'twenty-twenty-three-style', get_template_directory_uri() .'/style.css' );
    }
    add_action('wp_enqueue_scripts', 'thr_enqueue_styles');
}
//for options page
add_action('acf/init', 'my_acf_op_init');
function my_acf_op_init()
{
	// Check function exists.
	if (function_exists('acf_add_options_sub_page')) {
		// Add parent.
		$parent = acf_add_options_page(array(
			'page_title' => __('Theme General Settings'),
			'menu_title' => __('Theme Settings'),
			'menu_slug'  => __('theme-settings'),
			'redirect'   => false,
		));
        acf_add_options_sub_page(array(
			'title'  => __('Services Products'),
			'parent' => __('theme-settings')
		));
        acf_add_options_sub_page(array(
			'title'  => __('Tabs Slider'),
			'parent' => __('theme-settings')
		));
        acf_add_options_sub_page(array(
			'title'  => __('Advertisement'),
			'parent' => __('theme-settings')
		));
	}
}
define('ALLOW_UNFILTERED_UPLOADS', true);
//for custom menues
function wpb_custom_new_menu()
{
	register_nav_menus(
		array(
			'header-navigation' => __('Header Navigation')
		)
	);
}
add_action('init', 'wpb_custom_new_menu'); 
//upload json file
function add_upload_mimes( $types ) {
	$types['json'] = 'text/plain';
	
	return $types;
  }
add_filter( 'upload_mimes', 'add_upload_mimes' );

// Allow SVG media upload
add_filter( 'wp_check_filetype_and_ext', function($data, $file, $filename, $mimes) {
	$filetype = wp_check_filetype( $filename, $mimes );
	return [
		'ext'             => $filetype['ext'],
		'type'            => $filetype['type'],
		'proper_filename' => $data['proper_filename']
	];
  
  }, 10, 4 );
  
  function cc_mime_types( $mimes ){
	$mimes['svg'] = 'image/svg+xml';
	return $mimes;
  }
  add_filter( 'upload_mimes', 'cc_mime_types' );
 //enable upload for webp image files.
 function WebP_upload_mimes( $existing_mimes ) {// add WebP to the list of mime types
	$existing_mimes['WebP'] = 'image/WebP';// return the array back to the function with our added mime type
	return $existing_mimes;
}
add_filter( 'mime_types', 'WebP_upload_mimes' );
//** * Enable preview / thumbnail for WebP image files.*/
function WebP_is_displayable($result, $path) {
	 if ($result === false) { 
		$displayable_image_types = array( IMAGETYPE_WebP ); 
		$info = @getimagesize( $path ); 
		if (empty($info)) {
			 $result = false; 
		} 
		elseif (!in_array($info[2], $displayable_image_types)) {
			 $result = false; 
		}
		else { 
			$result = true;
		} 
	}
	return $result;
}
add_filter('file_is_displayable_image', 'WebP_is_displayable', 10, 2);

// Newsletter form
add_action( 'admin_post_nopriv_contact_form', 'process_contact_form' );

add_action( 'admin_post_contact_form', 'process_contact_form' );

function process_contact_form(){

    GLOBAL $wpdb;

    $params = $_POST;

    /*create table if not exists*/

    $table_name = $wpdb->prefix.'custom_contact_form';

    $query = $wpdb->prepare( 'SHOW TABLES LIKE %s', $wpdb->esc_like( $table_name ) );

    if ( ! $wpdb->get_var( $query ) == $table_name ) {

        $sql = "CREATE TABLE {$table_name} (
        id INT(6) UNSIGNED AUTO_INCREMENT PRIMARY KEY,
        contact_email VARCHAR(255) NOT NULL,
        created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
    )";

    if($wpdb->query($sql)){
        submitsForm($table_name,$params);
    }


}else{
    submitsForm($table_name,$params);
}

/*create table if not exists*/

die;

}

function submitsForm($table_name, $params){

    GLOBAL $wpdb;

    $curTime = date('Y-m-d H:i:s');

    $query = "INSERT INTO {$table_name}(contact_email,created_at) VALUES('{$params['contact_email']}','{$curTime}')"; 

    if($wpdb->query($query)){
        wp_redirect($params['base_page'].'?success=1'); 
    }else{
        wp_redirect($params['base_page'].'?error=1'); 
    }
}
//code for cart addon
add_shortcode('woo_cart_but', 'woo_cart_but');
/**
 * Create Shortcode for WooCommerce Cart Menu Item
 */
function woo_cart_but()
{
    ob_start();

    $cart_count = WC()
        ->cart->cart_contents_count; // Set variable for cart item count
    $cart_url = wc_get_cart_url(); // Set Cart URL
    
?>
       <a class="menu-item cart-contents" href="<?php echo $cart_url; ?>" title="My Basket">
       <img src="<?php echo site_url(); ?>/wp-content/uploads/2023/05/cart-icon.webp" aria-label="Cart" alt="cart">
        <?php
        if ($cart_count > 0)
        {
        ?>
            <span class="cart-contents-count"><?php echo $cart_count; ?></span>
        <?php
        }
        ?>
        </a>
        <?php
    return ob_get_clean();

}
//Add a filter to get the cart count
add_filter('woocommerce_add_to_cart_fragments', 'woo_cart_but_count');
/**
 * Add AJAX Shortcode when cart contents update
 */
function woo_cart_but_count($fragments)
{

    ob_start();

    $cart_count = WC()
        ->cart->cart_contents_count;
    $cart_url = wc_get_cart_url();

?>
    <a class="cart-contents menu-item" href="<?php echo $cart_url; ?>" aria-label="Cart" title="<?php _e('View your shopping cart'); ?>">
    <img src="<?php echo site_url(); ?>/wp-content/uploads/2023/05/cart-icon.webp" alt="cart">
    <?php
    if ($cart_count > 0)
    {
    ?>
        <span class="cart-contents-count"><?php echo $cart_count; ?></span>
            <?php
    }
    ?>
    </a>
    <?php
    $fragments['a.cart-contents'] = ob_get_clean();

    return $fragments;
}
/** Fx to add multiple products to cart via url */
function webroom_add_multiple_products_to_cart( $url = false ) {
	// Make sure WC is installed, and add-to-cart qauery arg exists, and contains at least one comma.
	if ( ! class_exists( 'WC_Form_Handler' ) || empty( $_REQUEST['add-to-cart'] ) || false === strpos( $_REQUEST['add-to-cart'], ',' ) ) {
		return;
	}

	// Remove WooCommerce's hook, as it's useless (doesn't handle multiple products).
	remove_action( 'wp_loaded', array( 'WC_Form_Handler', 'add_to_cart_action' ), 20 );

	$product_ids = explode( ',', $_REQUEST['add-to-cart'] );
	$count       = count( $product_ids );
	$number      = 0;

	foreach ( $product_ids as $id_and_quantity ) {
		// Check for quantities defined in curie notation (<product_id>:<product_quantity>)
		
		$id_and_quantity = explode( ':', $id_and_quantity );
		$product_id = $id_and_quantity[0];

		$_REQUEST['quantity'] = ! empty( $id_and_quantity[1] ) ? absint( $id_and_quantity[1] ) : 1;

		if ( ++$number === $count ) {
			// Ok, final item, let's send it back to woocommerce's add_to_cart_action method for handling.
			$_REQUEST['add-to-cart'] = $product_id;

			return WC_Form_Handler::add_to_cart_action( $url );
		}

		$product_id        = apply_filters( 'woocommerce_add_to_cart_product_id', absint( $product_id ) );
		$was_added_to_cart = false;
		$adding_to_cart    = wc_get_product( $product_id );

		if ( ! $adding_to_cart ) {
			continue;
		}

		$add_to_cart_handler = apply_filters( 'woocommerce_add_to_cart_handler', $adding_to_cart->get_type(), $adding_to_cart );

		// Variable product handling
		if ( 'variable' === $add_to_cart_handler ) {
			woo_hack_invoke_private_method( 'WC_Form_Handler', 'add_to_cart_handler_variable', $product_id );

		// Grouped Products
		} elseif ( 'grouped' === $add_to_cart_handler ) {
			woo_hack_invoke_private_method( 'WC_Form_Handler', 'add_to_cart_handler_grouped', $product_id );

		// Custom Handler
		} elseif ( has_action( 'woocommerce_add_to_cart_handler_' . $add_to_cart_handler ) ){
			do_action( 'woocommerce_add_to_cart_handler_' . $add_to_cart_handler, $url );

		// Simple Products
		} else {
			woo_hack_invoke_private_method( 'WC_Form_Handler', 'add_to_cart_handler_simple', $product_id );
		}
	}
}

// Fire before the WC_Form_Handler::add_to_cart_action callback.
add_action( 'wp_loaded', 'webroom_add_multiple_products_to_cart', 15 );


/**
 * Invoke class private method
 *
 * @since   0.1.0
 *
 * @param   string $class_name
 * @param   string $methodName
 *
 * @return  mixed
 */
function woo_hack_invoke_private_method( $class_name, $methodName ) {
	if ( version_compare( phpversion(), '5.3', '<' ) ) {
		throw new Exception( 'PHP version does not support ReflectionClass::setAccessible()', __LINE__ );
	}

	$args = func_get_args();
	unset( $args[0], $args[1] );
	$reflection = new ReflectionClass( $class_name );
	$method = $reflection->getMethod( $methodName );
	$method->setAccessible( true );

	//$args = array_merge( array( $class_name ), $args );
	$args = array_merge( array( $reflection ), $args );
	return call_user_func_array( array( $method, 'invoke' ), $args );
}

/**
 * Changes the redirect URL for the Return To Shop button in the cart.
 */
function wc_change_return_shop_url() {
	return site_url() . '/services/';
}
add_filter( 'woocommerce_return_to_shop_redirect', 'wc_change_return_shop_url' );
/**
 * Add Cancel Button on my account orders list in Woocommerce
 */
// add_filter( 'woocommerce_valid_order_statuses_for_cancel', 'filter_valid_order_statuses_for_cancel', 20, 2 );
// function filter_valid_order_statuses_for_cancel( $statuses, $order = '' ){
//     // Set HERE the order statuses where you want the cancel button to appear
//     $custom_statuses    = array( 'pending', 'processing', 'on-hold', 'failed' );
//     // Set HERE the delay (in days)
//     $duration = 3; // 3 days
//     // UPDATE: Get the order ID and the WC_Order object
//     if( ! is_object( $order ) && isset($_GET['order_id']) )
//     	$order = wc_get_order( absint( $_GET['order_id'] ) );
//     $delay = $duration*24*60*60; // (duration in seconds)
//     $date_created_time  = strtotime($order->get_date_created()); // Creation date time stamp
//     $date_modified_time = strtotime($order->get_date_modified()); // Modified date time stamp
//     $now = strtotime("now"); // Now  time stamp
//     // Using Creation date time stamp
//     if ( ( $date_created_time + $delay ) >= $now ) return $custom_statuses;
//     else return $statuses;
// }
/**
 * Send customer email when order is cancelled in Woocommerce
 */
// add_action('woocommerce_order_status_changed', 'send_cancelled_email_notifications', 10, 4 );
// function send_cancelled_email_notifications( $order_id, $old_status, $new_status, $order ){
//     if ( $new_status == 'cancelled' ){
//         $wc_emails = WC()->mailer()->get_emails(); // Get all WC_emails objects instances
//         $customer_email = $order->get_billing_email(); // Get the customer email
//     }
 
//     if ( $new_status == 'cancelled' ) {
//         // change the recipient of the instance
//         $wc_emails['WC_Email_Cancelled_Order']->recipient = $customer_email;
//         // Sending the email from this instance
//         $wc_emails['WC_Email_Cancelled_Order']->trigger( $order_id );
//     } 
// }
  ?>


