<!DOCTYPE html>
<?php
$current_page = get_queried_object();
$field = get_fields('options');
?>
<html>

<head>
    <meta charset="<?php bloginfo('charset'); ?>">
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <title>Wash Fold</title>
    <?php wp_head(); ?>

</head>
<!-- header starts -->
<header class="wf-header">
    <div class="container">
        <div class="d-flex justify-content-between wf-navbar-top">
            <p class="wf-header-contact">
                <?php if (!empty($field['header_info']['contact_icon']['url'])) { ?>
                    <img src="<?php echo $field['header_info']['contact_icon']['url']; ?>" alt="<?php echo $field['header_info']['contact_icon']['alt']; ?>" />
                <?php } ?>

                <?php if (!empty($field['header_info']['contact_no'])) { ?>
                    <?php
                    $phone = $field['header_info']['contact_no'];
                    $str_num = str_replace(' ', '', $phone); // Remove all spaces in number.
                    $Phone_num = preg_replace('/[^0-9]/', '', $str_num);
                    ?>
                    <a href="tel:<?php echo $Phone_num; ?>"><?php echo $field['header_info']['contact_no']; ?></a>
                <?php } ?>
            </p>
            <ul class="list-inline wf-header-media">
                <?php
                if (isset($field['header_info']['social_icons']) && !empty($field['header_info']['social_icons'])) :
                    foreach ($field['header_info']['social_icons'] as $socialcontent) :
                ?>
                        <li class="list-inline-item">
                            <a href="<?php echo !empty($socialcontent['social_link']) ? $socialcontent['social_link'] : 'javascript:void(0)' ?>" target="_blank" aria-label="<?php echo !empty($socialcontent['social_icon']['alt']) ? $socialcontent['social_icon']['alt'] : 'Submit' ?>Social Icon">
                                <?php if (!empty($socialcontent['social_icon']['url'])) { ?>
                                    <img src="<?php echo $socialcontent['social_icon']['url']; ?>" alt="<?php echo $socialcontent['social_icon']['alt']; ?>" />
                                <?php } ?>
                            </a>
                        </li>
                    <?php
                    endforeach;
                    ?>
                <?php
                endif;
                ?>
            </ul>
        </div>
    </div>
    <navbar class="wf-navbar">
        <div class="container">
            <div class="wf-navbar-flex">

                <a href="<?php echo site_url(); ?>" class="wf-logo">
                    <?php
                    if (!empty($field['header_logo']['url'])) : ?>
                        <img src="<?php echo $field['header_logo']['url']; ?>" alt="<?php echo $field['header_logo']['alt']; ?>">
                    <?php
                    else :
                        bloginfo('name');
                    endif;
                    ?>
                </a>
                <div class="wf-header-menu">
                    <?php
                    $menu_items = wp_nav_menu([
                        'theme_location' => 'header-navigation',
                        'menu_class'    => 'menu'
                    ]);
                    ?>
                </div>
                <div class="wf-account-menu">
                    <div class="wf-navToggle">
                        <div class="wf-icon-left"></div>
                        <div class="wf-icon-right"></div>
                    </div>
                    <ul class="list-inline">
                        <li class="list-inline-item">
                            <?php echo do_shortcode("[woo_cart_but]"); ?>
                        </li>
                        <?php
                            echo '<li class="list-inline-item"><a href="' . get_permalink(woocommerce_get_page_id('myaccount')) . '" aria-label="Log In"><img src="'.site_url().'/wp-content/uploads/2023/05/user-icon.png" alt="user"></a></li>';
                        ?>
                    </ul>
                </div>
            </div>
        </div>
    </navbar>
</header>

<body <?php body_class($current_page->post_name); ?>>
    <div class="wf-content-wrapper">
        <!-- header ends -->