<?php
function callAPI($method, $url, $data){
    $apiKey = 'ES9ESXH-PTWMANM-JBYQGQ5-XRB00EX';  
    $curl = curl_init();
    switch ($method){
       case "POST":
          curl_setopt($curl, CURLOPT_POST, 1);
          if ($data)
             curl_setopt($curl, CURLOPT_POSTFIELDS, $data);
          break;
       case "PUT":
          curl_setopt($curl, CURLOPT_CUSTOMREQUEST, "PUT");
          if ($data)
             curl_setopt($curl, CURLOPT_POSTFIELDS, $data);			 					
          break;
       default:
          if ($data)
             $url = sprintf("%s?%s", $url, http_build_query($data));
    }
    // OPTIONS:
    curl_setopt($curl, CURLOPT_URL, $url);
    curl_setopt($curl, CURLOPT_HTTPHEADER, array(
       'api_key: '.$apiKey,
       'Content-Type: application/json',
    ));
    curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
    curl_setopt($curl, CURLOPT_HTTPAUTH, CURLAUTH_BASIC);
    // EXECUTE:
    $result = curl_exec($curl);
    if(!$result){die("Connection Failure");}
    curl_close($curl);
    return $result;
}

add_action( 'woocommerce_thankyou', 'custom_create_job', 10, 1 );

/**
 * Changes the redirect URL for the Return To Shop button in the cart.
 */
add_filter('woocommerce_general_settings', 'shop_phone_country_code');
function shop_phone_country_code($settings) {
   $key = 0;

    foreach( $settings as $values ){
        $new_settings[$key] = $values;
        $key++;

        // Inserting array just after the field "Store Address" section
        if($values['id'] == 'woocommerce_store_postcode'){
            $new_settings[$key] = array(
                'title'    => __('Phone Country Code'),
                'desc'     => __('Add phone country code of your business office'),
                'id'       => 'woocommerce_store_country_code', // <= The field ID (important)
                'default'  => '',
                'type'     => 'text',
                'desc_tip' => true, // or false
            );
            $key++;
        }
		
    }
    return $new_settings;
}
// fx for adding phone no. field in woocommerce settings
 add_filter('woocommerce_general_settings', 'general_settings_shop_phone');
function general_settings_shop_phone($settings) {
   $key = 0;

    foreach( $settings as $values ){
        $new_settings[$key] = $values;
        $key++;
        // Inserting array just after the field "Store Address" section
        if($values['id'] == 'woocommerce_store_country_code'){
            $new_settings[$key] = array(
                'title'    => __('Phone Number'),
                'desc'     => __('Add phone number of your business office'),
                'id'       => 'woocommerce_store_phone', // <= The field ID (important)
                'default'  => '',
                'type'     => 'text',
                'desc_tip' => true, // or false
            );
            $key++;
        }
		
    }
    return $new_settings;
}

function custom_create_job($order_id ) {
	if ( ! $order_id ){
	    return;
    }
	$apiKey = 'ES9ESXH-PTWMANM-JBYQGQ5-XRB00EX';
	if(!empty($apiKey)){
		$postfieldArr = array();
		$order = wc_get_order( $order_id ); //Get an instance of the WC_Order object
		$orderId = $order->get_id(); //GET order id
		$order_total = $order->get_total(); //Get order total bill
		$order_paymentMode = $order->get_payment_method_title(); //Get order total bill
		$bill_phone = $order->get_billing_phone(); // get customer phone number 
		$string = str_replace(' ', '', $bill_phone); // Remove all spaces in number.
		$str = preg_replace('/[^0-9]/', '', $string); // Removes special chars.
		$billing_phone = ltrim($str, '0');
		$billing_email = $order->get_billing_email(); // get customer email
		$store_CountryCode = get_option( 'woocommerce_store_country_code' ); // Get store owner country code
		$store_phn = get_option( 'woocommerce_store_phone' ); // Get store owner phone
		$str_num = str_replace(' ', '', $store_phn); // Remove all spaces in number.
		$num_strng = preg_replace('/[^0-9]/', '', $str_num); // Removes special chars.
		$store_phone = ltrim($num_strng, '0');
		$Wc_email = WC()->mailer()->get_emails()['WC_Email_New_Order']->recipient;
        $Wc_email = explode(",",$Wc_email);// Get store new order notification email adderess
		$store_location = get_option( 'woocommerce_store_city' ); // Get location of store
		// Customer shipping information details
		$billing_first_name = $order->get_billing_first_name();
		$billing_last_name  = $order->get_billing_last_name();
		$cx_name = $billing_first_name.' '.$billing_last_name;
		//Get order items
		$prodarr = array();
		foreach ( $order->get_items() as $item_id => $item ) {
		   $product_name = $item->get_name();
		   $prodarr[] = $product_name; // Purchased products names in an order
		}
		$prodData = implode(",",$prodarr);
		$storeName = get_bloginfo( 'name' ); //Get store name 
		$billing_address_1  = $order->get_billing_address_1();
		$billing_address_2  = $order->get_billing_address_2();
		$billing_city       = $order->get_billing_city();
		$billing_state      = $order->get_billing_state();
		$billing_postcode   = $order->get_billing_postcode();
		$billing_country    = $order->get_billing_country();
		//DateTime & timezome data
		$pickup_datetime = current_datetime()->format('Y-m-d H:i:s'); 
		$delivery_date = date('Y-m-d H:i:s', strtotime($pickup_datetime . ' +1 day')); // Increase delivery time by 1 day

		function RemoveSpecialChar($str) {	  
			$rep = str_replace( array( ':', '+' ), '', $str);
			$rep = ltrim($rep, '0');
			// Returning the result 
			return $rep;
		}
		  
			$postData = '{
			"use_geofence_check": 0,
			"auto_assign": true,
			"task_details": [
				{
					"name": "'.$cx_name.'",
					"country_code": "'.$store_CountryCode.'",
					"phone": '.$billing_phone.',
					"email": "'.$billing_email.'",
					"task_description": "'.$prodData.'",
					"task_type": 0,
					"reference_id": "'.$orderId.'",
					"local_datetime": "'.$pickup_datetime.'",
					"location": "'.$billing_address_1.' '.$billing_address_2 .', '.$billing_city.', '.$billing_state.', '.$billing_country.', '. $billing_postcode.'",
					"template": {}
				},
				{
					"name": "'.$cx_name.'",
					"country_code": "'.$store_CountryCode.'",
					"phone": '.$billing_phone.',
					"email": "'.$billing_email.'",
					"task_description": "'.$prodData.'",
					"task_type": 1,
					"reference_id": "'.$orderId.'",
					"local_datetime": "'.$delivery_date.'",
					"location": "'.$billing_address_1.' '.$billing_address_2 .', '.$billing_city.', '.$billing_state.', '.$billing_country.', '. $billing_postcode.'",
					"template": {}
				}
			]
			}';
			// Create a new Job	
			try { 
				$make_job = callAPI('POST', 'https://api.networkon.io/main/job/create', $postData);
			}
			catch(Exception $e) {
				echo 'Message: ' .$e->getMessage();
			}
	}
}

// To register new custom REST API
add_action( 'rest_api_init', function () {
    register_rest_route( 'wc/v3', 'custom', array(
        'methods' => 'POST', // array( 'GET', 'POST', 'PUT', )
        'callback' => 'get_custom_job_status',
		'permission_callback' => '__return_true',
    ));
});
