<?php

/**
 *Template Name: Contact
 */
$contactData = get_fields();
get_header();
?>
<!--start contact us-->
<?php
if (isset($contactData['contact']) && is_array($contactData['contact'])) :
?>
    <section class="wf-conatct-us section-spacing bg-img" <?php if (!empty($contactData['contact']['background_image']['url'])) { ?> style="background-image: url(<?php echo $contactData['contact']['background_image']['url'] ?>); " <?php } ?>>
        <div class="container">
            <div class="page-title">
                <h1><?php the_title(); ?></h1>
            </div>
            <div class="wf-contact-card">
                <?php
                if (!empty($contactData['contact']['heading'])) :
                ?>
                    <h2><?php echo $contactData['contact']['heading']; ?></h2>
                <?php
                endif;
                ?>
                <?php
                if (!empty($contactData['contact']['description'])) :
                ?>
                    <p><?php echo $contactData['contact']['description']; ?></p>
                <?php
                endif;
                ?>
                <ul class="contact-address">
                <?php
                if (isset($contactData['contact']['contact_info']) && is_array($contactData['contact']['contact_info'])) :
                    foreach ($contactData['contact']['contact_info'] as $ContactInfo) :
                ?>
                    <li>
                        <?php if (!empty($ContactInfo['info_icon']['url'])) : ?>
                            <img src="<?php echo $ContactInfo['info_icon']['url']; ?>" alt="<?php echo $ContactInfo['info_icon']['alt']; ?>">
                        <?php endif; ?>
                        <?php
                        if (!empty($ContactInfo['info_text'])) :
                        ?>
                            <?php echo $ContactInfo['info_text']; ?>
                        <?php
                        endif;
                        ?>
                    </li>
                <?php
                    endforeach;
                endif; ?>
                </ul>
                <?php $shortcodedata = isset($contactData['contact']['form_shortcode']) ? do_shortcode($contactData['contact']['form_shortcode']) : "";
                ?>
                <?php  echo $shortcodedata; ?>
                <?php //echo do_shortcode('[contact-form-7 id="292" title="Contact us"]'); ?>
            </div>
        </div>
    </section>
    <!--end contact us-->
<?php
endif;
?>
<?php
get_footer();
?>