<?php
/**
 * Banner Section Component
 *
 * This component represents the Banner Section used in the theme.
 * It displays a Page heading, store links to download the app.
 *
 * @package Growthnatives
 */
if (isset($args['banner']['banner_content']) && !empty($args['banner']['banner_content'])) { ?>
<section class="banner-section">
    <div class="container">
        <div class="row">
            <div class="col-sm-6">
                <div class="banner-txt">
                    <?php echo $args['banner']['banner_content'];
                    if (isset($args['banner']['banner_download_link']['url'],$args['banner']['banner_download_link']['title']) && !empty($args['banner']['banner_download_link']['url']) && !empty($args['banner']['banner_download_link']['title'])) { ?>
                    <a href="<?php echo $args['banner']['banner_download_link']['url'] ?>"
                        class="download-btn"><?php echo $args['banner']['banner_download_link']['title'] ?></a>
                        <?php }?>
                        <?php
                        if (isset($args['banner']['banner_store_links']) && !empty($args['banner']['banner_store_links'])) { ?>
                    <ul>
                        <?php foreach ($args['banner']['banner_store_links'] as $bannerStore) : ?>
                        <li><a href="<?php echo $bannerStore['store_links']['url'] ?>"> <img
                                    src="<?php echo $bannerStore['store_image']['url'] ?>"></a></li>
                        <?php endforeach?>
                    </ul>
                    <?php }?>
                </div>
            </div>
            <div class="col-sm-6">
                <div class="banner-img">
                    <img src="http://localhost/workverse/wp-content/uploads/2023/12/realistic_floating_smartphone_mockup_000-1.png"
                        alt="mobile">
                    <img src="http://localhost/workverse/workverse-web/wp-content/uploads/2023/12/Polygon-37.png"
                        class="ploygon">
                </div>
            </div>

        </div>
    </div>
</section>
<?php }?>
