<?php 
function theme_enqueue_styles()
{
    wp_enqueue_style('bootstrap-css', get_template_directory_uri() . '/assets/css/bootstrap.min.css', array(), time(), 'all');
    wp_enqueue_style('style-css', get_template_directory_uri() . '/assets/css/style.css', array(), time(), 'all');
}
add_action('wp_enqueue_scripts', 'theme_enqueue_styles');

if( function_exists('acf_add_options_page') ) {

    acf_add_options_page(array(
        'page_title'    => 'Upcoming Template',
        'menu_title'    => 'Upcoming Template',
        'menu_slug'     => 'upcoming-template',
        'capability'    => 'edit_posts',
        'redirect'      => false
    ));
    acf_add_options_page(array(
        'page_title' => 'Theme General Settings',
        'menu_title' => 'Theme Settings',
        'menu_slug' => 'theme-general-settings',
        'capability' => 'edit_posts',
        'redirect' => false,
      ));
      acf_add_options_sub_page(array(
        'page_title' => 'Theme Header Settings',
        'menu_title' => 'Header',
        'parent_slug' => 'theme-general-settings',
      ));
      acf_add_options_sub_page(array(
        'page_title' => 'Theme Footer Settings',
        'menu_title' => 'Footer',
        'parent_slug' => 'theme-general-settings',
      ));

}



// Function to add Menu
function wpb_custom_new_menu()
{
  register_nav_menus(
    array(
      'my-custom-menu' => __('My Custom Menu'),
      'container'            => 'nav',
    )
  );
}
add_action('init', 'wpb_custom_new_menu');


// Register an action to handle form submission before sending mail
add_action('wpcf7_mail_sent', 'contactSubmission');


// Register an action to handle form submission before sending mail
add_action('wpcf7_mail_sent', 'contactSubmission');

// Function to handle form submission and send data to Braze
function contactSubmission()
{
    try {
        // Get the current contact form
        $contactSubmit = WPCF7_ContactForm::get_current();
        $contactSubmitId = $contactSubmit->id;
        $submission = WPCF7_Submission::get_instance();

        // Check if the submission and contact form ID are valid
        if (isset($submission, $contactSubmitId) && !empty($submission) && !empty($contactSubmitId) && $contactSubmitId == '32' || $contactSubmitId == '4') {
            // Get the submitted form data
            $postData = $submission->get_posted_data();

            if (isset($postData) && !empty($postData)) {
                $apiUrl = 'https://sdk.iad-06.braze.com/users/track';
                // Call the function to send data to Braze
                return wp_remote_postInitialization($apiUrl, $postData);
            }
        }
    } catch (Exception $e) {
        // Handle any exceptions that might occur during form processing
        return 'Error: ' . $e->getMessage();
    }
}

// Function to initialize wp_remote_post and send data to the Braze API
function wp_remote_postInitialization($apiUrl, $postData)
{
    try {
        $postJson = array(
            'attributes' => array(
                array(
                    'external_id' => $postData['your-email'] ?? '',
                    'email' => $postData['your-email'] ?? '',
                    'email_subscribe' => $postData['opt-in'] ?? '',
                    'Lead Source' => $postData['lead-source'] ?? ''
                )
            )
        );

        // Create an array for the request arguments
        $request_args = array(
            'body' => json_encode($postJson),
            'headers' => array(
                'Content-Type' => 'application/json',
                'Authorization' => 'Bearer f9ec93f5-9f50-4511-b563-6298900e1cbc'
            )
        );

        // Make the POST request using wp_remote_post
        $response = wp_remote_post($apiUrl, $request_args);

        // Check if the request was successful
        if (is_wp_error($response)) {
            // Handle the error
            echo 'Error: ' . $response->get_error_message();
        } else {
            // Get the response body
            $apiResponse = wp_remote_retrieve_body($response);
            return $apiResponse;
        }
    } catch (Exception $e) {
        // Handle any exceptions that might occur during the API request
        return 'Error: ' . $e->getMessage();
    }
}

/**
 * Register Custom Post Type: AppFeatures
 */
add_theme_support('post-thumbnails');
function cpt_AppFeatures()
{

  // Labels for the AppFeatures Custom Post Type
  $labels = array(
    'name' => _x('AppFeatures', 'plural'),
    'singular_name' => _x('AppFeature', 'singular'),
    'menu_name' => _x('AppFeatures', 'admin menu'),
    'name_admin_bar' => _x('AppFeatures', 'admin bar'),
    'add_new' => _x('Add New', 'add new'),
    'add_new_item' => __('Add New AppFeature'),
    'new_item' => __('New AppFeature'),
    'edit_item' => __('Edit AppFeature'),
    'view_item' => __('View AppFeature'),
    'all_items' => __('All AppFeature'),
    'edit' => __('Edit'),
    'edit_item' => __('Edit AppFeature'),
    'search_items' => __('Search AppFeature'),
    'not_found' => __('Nothing found.'),
  );

  // Arguments for the AppFeatures Custom Post Type
  $args = array(
    'supports' => array('title', 'editor', 'excerpt', 'author', 'thumbnail', 'comments', 'revisions', 'custom-fields'),
    'labels' => $labels,
    'public' => true,
    'query_var' => true,
    'menu_position' => 4,
    'rewrite' => array('slug' => 'appfeatures'),
    'has_archive' => true,
    'hierarchical' => false,
  );

  // Register the AppFeatures Custom Post Type
  register_post_type('AppFeatures', $args);
}

// Hook to initialize the Custom Post Type
add_action('init', 'cpt_AppFeatures');
