<?php
/**
 * The header for our upcoming page
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package Growthnatives
 */
$upcomingData = get_fields( 'option');
?><!doctype html>
<html <?php language_attributes(); ?>>
<head>
<!-- Google Tag Manager -->
<script>(function(w,d,s,l,i){w[l]=w[l]||[];w[l].push({'gtm.start':
new Date().getTime(),event:'gtm.js'});var f=d.getElementsByTagName(s)[0],
j=d.createElement(s),dl=l!='dataLayer'?'&l='+l:'';j.async=true;j.src=
'https://www.googletagmanager.com/gtm.js?id='+i+dl;f.parentNode.insertBefore(j,f);
})(window,document,'script','dataLayer','GTM-55SX33MZ');</script>
<!-- End Google Tag Manager -->
	<meta charset="<?php bloginfo( 'charset' ); ?>" />
	<meta name="viewport" content="width=device-width, initial-scale=1" />
	<link rel="profile" href="https://gmpg.org/xfn/11" />
	<?php wp_head(); ?>
    <title>WorkVerse</title>
    <link rel="preconnect" href="https://fonts.googleapis.com">
<link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
<link href="https://fonts.googleapis.com/css2?family=Poppins:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900&display=swap" rel="stylesheet">

</head>

<body <?php body_class(); ?>>
<!-- Google Tag Manager (noscript) -->
<noscript><iframe src="https://www.googletagmanager.com/ns.html?id=GTM-55SX33MZ"
height="0" width="0" style="display:none;visibility:hidden"></iframe></noscript>
<!-- End Google Tag Manager (noscript) -->
<header>
<div class="container">
    <div class="header-sec">
        <div class="logo">
        <a href="<?php echo site_url(); ?>">
                 <?php 			
                    if (isset( $upcomingData['site_logo'] ) && !empty( $upcomingData['site_logo'] )) {
                        echo wp_get_attachment_image($upcomingData['site_logo'], 'full') ?? "";
                    }
                ?> 
            </a>
        </div>

        <div class="menu">
        <div id="toggle">
            <div class="one"></div>
            <div class="two"></div>
            <div class="three"></div>
        </div>
        <?php
                                    wp_nav_menu(
                                        array(
                                            'theme_location'  => 'my-custom-menu',
                                            'container'       => 'nav',
                                            'container_class' => 'main-menu menu-mobile',
                                            'container_id'    => 'menu',
                                            'items_wrap' => '<ul class="menu">%3$s</ul>',
                                            'add_a_class'     => 'menu-link mega-menu-link',

                                        )
                                    );
                                    ?>
        </div>
    </div>

 </div>
 </header>
 <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/2.1.3/jquery.min.js"></script>
 <script>
jQuery("#toggle").click(function() {
  jQuery(this).toggleClass("on");
  jQuery("#menu").slideToggle();
});
 </script>

