var currentYear = new Date().getFullYear();
var targetDate = new Date(currentYear, 10, 15, 0, 0, 0); // Note: Months are 0-based (0 = January, 1 = February, ..., 10 = November)

// Update the count down every 1 second
var x = setInterval(function() {

    // Get today's date and time
    var now = new Date();

    // Calculate the time difference
    var timeDiff = targetDate - now;

    // Calculate days and months
    var days = Math.floor(timeDiff / (1000 * 60 * 60 * 24));
    var months = targetDate.getMonth() - now.getMonth();

    // Output the result in an element with id="demo"
    document.getElementById("demo").innerHTML = "<div class='days'>" + "<p>" + days + "</p>" + "<span>days</span> " + "</div>" + "<div class='days'>" + "<p>" + months + "</p>" + "<span> months </span>" + "</div>";

    // If the count down is over, write some text 
    if (timeDiff <= 0) {
        clearInterval(x);
        document.getElementById("demo").innerHTML = "EXPIRED";
    }
}, 1000);