<?php
/**
 * Banner Section Component
 *
 * This component represents the Banner Section used in the theme.
 * It displays a Page heading, store links to download the app.
 *
 * @package Growthnatives
 */
if (isset($args['banner']['banner_content']) && !empty($args['banner']['banner_content'])) { ?>
<section class="banner-section">
    <div class="container">
        <div class="row">
            <div class="col-sm-6">
                <div class="banner-txt">
                    <?php echo $args['banner']['banner_content'];
                    if (isset($args['banner']['banner_download_link']['url'],$args['banner']['banner_download_link']['title']) && !empty($args['banner']['banner_download_link']['url']) && !empty($args['banner']['banner_download_link']['title'])) { ?>
                    <a href="<?php echo $args['banner']['banner_download_link']['url'] ?>"
                        class="download-btn"><?php echo $args['banner']['banner_download_link']['title'] ?></a>
                        <?php }?>
                        <?php
                        if (isset($args['banner']['banner_store_links']) && !empty($args['banner']['banner_store_links'])) { ?>
                    <ul>
                        <?php foreach ($args['banner']['banner_store_links'] as $bannerStore) : ?>
                        <li><a href="<?php echo $bannerStore['store_links']['url'] ?>"> <img
                                    src="<?php echo $bannerStore['store_image']['url'] ?>"></a></li>
                        <?php endforeach?>
                    </ul>
                    <?php }?>
                </div>
            </div>
            <?php if (isset($args['banner']['banner_images']['url']) && !empty($args['banner']['banner_images']['url'])) { ?>
            <div class="col-sm-6">
                <div class="banner-img">
                    <img src="<?php echo $args['banner']['banner_images']['url']; ?>"
                        alt="<?php echo $args['banner']['banner_images']['alt']; ?>">
                </div>
            </div>
           <?php }?>
        </div>
    </div>
    <?php if (isset($args['banner']['banner_background_image']['url']) && !empty($args['banner']['banner_background_image']['url'])) { ?>
    <img src="<?php echo $args['banner']['banner_background_image']['url']; ?>" class="mask-img">
    <?php }?>
</section>
<?php }?>

