<?php
/**
 *  Download Section Component
 *
 * This component represents the Download Section used in the theme.
 * It displays a heading, content, downlaod store links for app.
 *
 * @package Growthnatives
 */
if (isset($args['download_section']['download_heading'],$args['download_section']['download_app_image']['url']) && !empty($args['download_section']['download_heading']) && !empty($args['download_section']['download_app_image']['url'])) { ?>
<section class="download-sec">
    <div class="container">
        <div class="row">
            <div class="col-sm-12">
                <div class="download">
                        <div class="left">
                            <h3><?php echo $args['download_section']['download_heading'] ?></h3>
                            <?php if (isset($args['download_section']['download_content']) && !empty($args['download_section']['download_content'])) { ?>
                            <ul>
                            <?php foreach ($args['download_section']['download_content'] as $downloadContent) : ?>
                                <li><a href="<?php echo $downloadContent['download_app_link']['url']; ?>"> <img src="<?php echo $downloadContent['download_app_image']['url']; ?>"></a></li>
                                <?php endforeach?>
                            </ul>
                            <?php }?>
                        </div>
                        <?php if (isset($args['download_section']['download_app_image']['url']) && !empty($args['download_section']['download_app_image']['url'])) { ?>
                        <div class="right">
                <img src="<?php echo $args['download_section']['download_app_image']['url']; ?>">
            </div>
            <?php }?>
                </div>
                
            </div>
            
        </div>
    </div>
</section>
<?php }?>