<?php
/**
 * The template for displaying the upcoming footer
 *
 * Contains the closing of the #content div and all content after.
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package Growthnatives
 */
$upcomingData = get_fields( 'option');

?>
<div class="main-footer footer">
    <div class="container">
        <div class="row">
            <div class="col-sm-4">
                <div class="logo">
                    <a href="<?php echo site_url(); ?>">
                        <?php 			
                        if (isset( $upcomingData['site_logo'] ) && !empty( $upcomingData['site_logo'] )) {
                            echo wp_get_attachment_image($upcomingData['site_logo'], 'full') ?? "";
                        }
                    ?>
                    </a>
                </div>
                <div class="social-icons">
                    <h3>Follow Us On</h3>
                    <?php if( isset( $upcomingData['social_media'] ) && !empty( $upcomingData['social_media'] ) ): ?>
                    <ul>
                        <?php 
                            foreach ($upcomingData['social_media'] as $key => $value) {
                                echo '<li><a target="_blank" href="'.$value["social_media_link"].'"><img src="'.$value["social_media_icon"]["url"].'" width="30px"  height="30px" alt="'.$value["social_media_icon"]["alt"].'" /></a></li>';
                            } 
                        ?>
                    </ul>
                    <?php endif; ?>

                </div>
            </div>
            <div class="col-sm-4">
                <div class="quick-links">
                    <?php if (isset($upcomingData['footer_quick_links']['quick_links_heading']) && !empty($upcomingData['footer_quick_links']['quick_links_heading'])) { ?>
                    <h3><?php echo $upcomingData['footer_quick_links']['quick_links_heading']; ?></h3>
                    <?php }?>
                    <?php if (isset($upcomingData['footer_quick_links']['quick_links']) && !empty($upcomingData['footer_quick_links']['quick_links'])) { ?>
                    <ul>
                        <?php foreach ($upcomingData['footer_quick_links']['quick_links'] as $quickLinks) : ?>
                        <li><a
                                href="<?php echo $quickLinks['quick_link_pages']['url']; ?>"><?php echo $quickLinks['quick_link_pages']['title']; ?></a>
                        </li>
                        <?php endforeach ?>
                    </ul>
                    <?php }?>
                </div>
            </div>
            <div class="col-sm-4">
                <div class="download-app">
                <?php if (isset($upcomingData['store_links_heading']) && !empty($upcomingData['store_links_heading'])) { ?>
                    <h3><?php echo $upcomingData['store_links_heading'] ?></h3>
                    <?php }?>
                    <?php if (isset($upcomingData['store_images']) && !empty($upcomingData['store_images'])) { ?>
                    <ul>
                        <?php foreach ($upcomingData['store_images'] as $storeImages) : ?>
                        <li><a href="<?php echo $storeImages['app_links']['url'] ?>"><img
                                    src="<?php echo $storeImages['app_images']['url'] ?>"></a></li>
                        <?php endforeach?>
                    </ul>
                    <?php }?>
                </div>
            </div>

        </div>
    </div>
</div>
<?php if (isset($upcomingData['footer_copyright_section']['footer_pages_links'],$upcomingData['footer_copyright_section']['copyright_content']) && !empty($upcomingData['footer_copyright_section']['footer_pages_links']) && !empty($upcomingData['footer_copyright_section']['copyright_content'])) { ?>
<div class="bottom-footer">
    <div class="container">
        <div class="row">
            <div class="col-sm-8">
                <div class="menu">
                    <ul>
                        <?php foreach ($upcomingData['footer_copyright_section']['footer_pages_links'] as $pageLinks) : ?>
                        <li> <a
                                href="<?php echo $pageLinks['page_links']['url'] ?>"><?php echo $pageLinks['page_links']['title'] ?></a>
                        </li>
                        <?php endforeach ?>
                    </ul>
                </div>
            </div>
            <div class="col-sm-4">
                <div class="copyright">
                    <p><?php echo $upcomingData['footer_copyright_section']['copyright_content'] ?></p>
                </div>
            </div>
        </div>
    </div>
</div>
<?php }?>


<script>
$("nav#menu ul.menu li.menu-item-has-children > a").click(function() {
    $("ul.sub-menu").toggleClass("show");
});
</script>
<?php wp_footer(); ?>
</body>
</html>