<?php 
/*
*
* The template for displaying all single app-features posts
*
*
*/
get_header();
$getData  = array_merge(get_fields(), get_fields('option'));

?>

<!-- Banner Section -->
<?php get_template_part('components/banner', 'section', $getData); ?>
<!-- Banner Section Ends -->
<?php while( have_posts() ): ?>
<?php the_post(); ?>

<section class="professional-brand-sec">
    <div class="container">
        <div class="row">
            <div class="col-sm-12">
                <h2><?php the_title(); ?></h2>
                <p><?php the_content(); ?></p>
            </div>
            <?php
if (isset($getData['app_pages_content']) && !empty($getData['app_pages_content'])) { ?>
            <div class="col-sm-12 outer">
                <?php foreach ($getData['app_pages_content'] as $appContent) : ?>
                <div class="col-section">
                    <div class="left-sec">
                        <img src="<?php echo $appContent['app_page_image']['url']?>">
                    </div>
                    <div class="right-sec">
                        <?php echo $appContent['app_page_description']?>
                    </div>
                </div>
                <?php endforeach;?>
            </div>
            <?php }?>
        </div>
    </div>
</section>
<?php
if (isset($getData['middle_bar_description']) && !empty($getData['middle_bar_description'])) { ?>
<section class="middlebar-section">
    <div class="container">
        <?php echo $getData['middle_bar_description']?>
    </div>
</section>
<?php }
if (isset($getData['workcard_images']) && !empty($getData['workcard_images'])) { ?>
<section class="workcard-section">
    <div class="container">
        <div class="row">
            <?php foreach ($getData['workcard_images'] as $workcardImages) : ?>
            <div class="col-sm-4">
                <div class="card-box">
                    <img src="<?php echo $workcardImages['app_images']['url']?>">
                </div>
            </div>
            <?php endforeach;
            }?>
        </div>
    </div>
</section>
<?php endwhile;
wp_reset_postdata();
get_footer();
?>